/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.util.Collections;
import java.util.List;

public class RJavaPojoInterface
extends JavaClass<RosettaModelObject> {
    private static JavaClass<RosettaModelObject> ROSETTA_MODEL_OBJECT = JavaClass.from(RosettaModelObject.class);
    private final Data data;
    private final DottedPath packageName;
    private final TypeSystem typeSystem;

    public RJavaPojoInterface(Data data, TypeSystem typeSystem) {
        this.data = data;
        this.packageName = DottedPath.splitOnDots((String)data.getModel().getName());
        this.typeSystem = typeSystem;
    }

    public boolean isSubtypeOf(JavaType other) {
        if (other instanceof JavaPrimitiveType) {
            return false;
        }
        if (ROSETTA_MODEL_OBJECT.isSubtypeOf(other)) {
            return true;
        }
        if (other instanceof RJavaPojoInterface) {
            return this.typeSystem.isSubtypeOf(new RDataType(this.data), new RDataType(((RJavaPojoInterface)other).data));
        }
        return false;
    }

    public String getSimpleName() {
        return this.data.getName();
    }

    public JavaClass<? super RosettaModelObject> getSuperclassDeclaration() {
        return JavaClass.OBJECT;
    }

    public JavaClass<? super RosettaModelObject> getSuperclass() {
        return this.getSuperclassDeclaration();
    }

    public List<JavaClass<?>> getInterfaceDeclarations() {
        if (this.data.getSuperType() == null) {
            return List.of(ROSETTA_MODEL_OBJECT);
        }
        return Collections.singletonList(new RJavaPojoInterface(this.data.getSuperType(), this.typeSystem));
    }

    public List<JavaClass<?>> getInterfaces() {
        return this.getInterfaceDeclarations();
    }

    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        if (other instanceof JavaClass) {
            return this.isSubtypeOf((JavaType)((JavaClass)other));
        }
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public Class<? extends RosettaModelObject> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(this.getCanonicalName().toString(), true, classLoader).asSubclass(RosettaModelObject.class);
    }

    public DottedPath getPackageName() {
        return this.packageName;
    }
}

