/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.validator;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.AttributeValidation;
import com.rosetta.model.lib.validation.ConditionValidation;
import com.rosetta.model.lib.validation.ElementValidationResult;
import com.rosetta.model.lib.validation.RosettaModelObjectValidator;
import com.rosetta.model.lib.validation.TypeValidation;
import com.rosetta.model.lib.validation.ValidationUtil;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ValidatorGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private RosettaExtensions _rosettaExtensions;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private RosettaTypeProvider _rosettaTypeProvider;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    @Extension
    private RBuiltinTypeService _rBuiltinTypeService;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, Data data, String version) {
        DottedPath _typeValidation = root.typeValidation();
        JavaScope topScope = new JavaScope(_typeValidation);
        StringConcatenationClient classBody = this.classBody(data, topScope, root);
        String content = this._importManagerExtension.buildClass(root.typeValidation(), classBody, topScope);
        StringConcatenation _builder = new StringConcatenation();
        String _withForwardSlashes = root.typeValidation().withForwardSlashes();
        _builder.append(_withForwardSlashes);
        _builder.append("/");
        String _name = data.getName();
        _builder.append(_name);
        _builder.append("Validator.java");
        fsa.generateFile(_builder.toString(), (CharSequence)content);
    }

    private StringConcatenationClient classBody(final Data data, JavaScope scope, final RosettaJavaPackages.RootPackage root) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaReferenceType modelPojo = this._javaTypeTranslator.toJavaReferenceType(new RDataType(data));
        final RDataType rDataType = new RDataType(data);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                String _name = data.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"Validator implements ");
                _builder.append(RosettaModelObjectValidator.class);
                _builder.append((Object)"<");
                _builder.append((Object)modelPojo);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                EList<Condition> _conditions = data.getConditions();
                for (Condition con : _conditions) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(Inject.class, "\t");
                    _builder.append((Object)" protected ");
                    DottedPath _condition = root.condition();
                    String _conditionJavaType = ValidatorGenerator.this._rosettaExtensions.toConditionJavaType(ValidatorGenerator.this._rosettaExtensions.conditionName(con, data));
                    GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_condition, _conditionJavaType, Object.class);
                    _builder.append((Object)_generatedJavaClass, "\t");
                    _builder.append((Object)" ");
                    String _firstLower = StringExtensions.toFirstLower((String)ValidatorGenerator.this._rosettaExtensions.conditionName(con, data));
                    _builder.append((Object)_firstLower, "\t");
                    _builder.append((Object)" ;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t\t\t\t\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(TypeValidation.class, "\t");
                _builder.append((Object)" validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                JavaReferenceType _javaReferenceType = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(rDataType);
                _builder.append((Object)_javaReferenceType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(DottedPath.class, "\t\t");
                _builder.append((Object)" packageName = ");
                _builder.append(DottedPath.class, "\t\t");
                _builder.append((Object)".of(o.getClass().getPackage().toString());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(String.class, "\t\t");
                _builder.append((Object)" simpleName = o.getClass().getSimpleName();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(ModelSymbolId.class, "\t\t");
                _builder.append((Object)" modelSymbolId = new ");
                _builder.append(ModelSymbolId.class, "\t\t");
                _builder.append((Object)"(packageName, simpleName);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t \t");
                _builder.append(List.class, "\t \t");
                _builder.append((Object)"<");
                _builder.append(AttributeValidation.class, "\t \t");
                _builder.append((Object)"> attributeValidations = new ");
                _builder.append(ArrayList.class, "\t \t");
                _builder.append((Object)"<>();");
                _builder.newLineIfNotEmpty();
                List<Attribute> _allNonOverridesAttributes = ValidatorGenerator.this._rosettaExtensions.allNonOverridesAttributes(data);
                for (Attribute attribute : _allNonOverridesAttributes) {
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"attributeValidations.add(validate");
                    String _firstUpper = StringExtensions.toFirstUpper((String)attribute.getName());
                    _builder.append((Object)_firstUpper, "\t \t");
                    _builder.append((Object)"(");
                    StringConcatenationClient _attributeValue = ValidatorGenerator.this.getAttributeValue(attribute);
                    _builder.append((Object)_attributeValue, "\t \t");
                    _builder.append((Object)", path));");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t \t");
                _builder.newLine();
                _builder.append((Object)"\t \t");
                _builder.append(List.class, "\t \t");
                _builder.append((Object)"<");
                _builder.append(ConditionValidation.class, "\t \t");
                _builder.append((Object)"> conditionValidations = new ");
                _builder.append(ArrayList.class, "\t \t");
                _builder.append((Object)"<>();");
                _builder.newLineIfNotEmpty();
                EList<Condition> _conditions_1 = data.getConditions();
                for (Condition dataCondition : _conditions_1) {
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"conditionValidations.add(validate");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition, data));
                    _builder.append((Object)_firstUpper_1, "\t \t");
                    _builder.append((Object)"(o, path));");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)"\t \t");
                _builder.append((Object)"return new ");
                _builder.append(TypeValidation.class, "\t \t");
                _builder.append((Object)"(modelSymbolId, attributeValidations, conditionValidations);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                List<Attribute> _allNonOverridesAttributes_1 = ValidatorGenerator.this._rosettaExtensions.allNonOverridesAttributes(data);
                for (Attribute attribute_1 : _allNonOverridesAttributes_1) {
                    boolean _not;
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(AttributeValidation.class, "\t");
                    _builder.append((Object)" validate");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)attribute_1.getName());
                    _builder.append((Object)_firstUpper_2, "\t");
                    _builder.append((Object)"(");
                    JavaReferenceType _attributeToJavaType = ValidatorGenerator.this._javaTypeTranslator.attributeToJavaType(ValidatorGenerator.this._rObjectFactory.buildRAttribute(attribute_1));
                    _builder.append((Object)_attributeToJavaType, "\t");
                    _builder.append((Object)" atr, ");
                    _builder.append(RosettaPath.class, "\t");
                    _builder.append((Object)" path) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append(List.class, "\t\t");
                    _builder.append((Object)"<");
                    _builder.append(ElementValidationResult.class, "\t\t");
                    _builder.append((Object)"> validationResults = new ");
                    _builder.append(ArrayList.class, "\t\t");
                    _builder.append((Object)"<>();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    StringConcatenationClient cardinalityCheck = ValidatorGenerator.this.checkCardinality(attribute_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append(ElementValidationResult.class, "\t\t");
                    _builder.append((Object)" cardinalityValidation =");
                    if (cardinalityCheck != null) {
                        _builder.append((Object)cardinalityCheck, "\t\t");
                        _builder.append((Object)";");
                    } else {
                        _builder.append(ElementValidationResult.class, "\t\t");
                        _builder.append((Object)".success(path);");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    boolean _isIsMany = attribute_1.getCard().isIsMany();
                    boolean bl = _not = !_isIsMany;
                    if (_not) {
                        StringConcatenationClient typeFormatCheck = ValidatorGenerator.this.checkTypeFormat(attribute_1, "atr");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"    ");
                        if (typeFormatCheck != null) {
                            _builder.append((Object)"validationResults.add(");
                            _builder.append((Object)typeFormatCheck, "\t\t    ");
                            _builder.append((Object)");");
                        }
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if (atr != null) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"    ");
                        _builder.append((Object)"for (");
                        JavaReferenceType _javaReferenceType_1 = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(ValidatorGenerator.this._rosettaTypeProvider.getRTypeOfSymbol(attribute_1));
                        _builder.append((Object)_javaReferenceType_1, "\t\t    ");
                        _builder.append((Object)" atrb : atr) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        StringConcatenationClient typeFormatCheck_1 = ValidatorGenerator.this.checkTypeFormat(attribute_1, "atrb");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        if (typeFormatCheck_1 != null) {
                            _builder.append((Object)"validationResults.add(");
                            _builder.append((Object)typeFormatCheck_1, "\t\t\t\t");
                            _builder.append((Object)");");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return new ");
                    _builder.append(AttributeValidation.class, "\t\t");
                    _builder.append((Object)"(\"");
                    String _name_1 = attribute_1.getName();
                    _builder.append((Object)_name_1, "\t\t");
                    _builder.append((Object)"\", cardinalityValidation, validationResults);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                EList<Condition> _conditions_2 = data.getConditions();
                for (Condition dataCondition_1 : _conditions_2) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(ConditionValidation.class, "\t");
                    _builder.append((Object)" validate");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
                    _builder.append((Object)_firstUpper_3, "\t");
                    _builder.append((Object)"(");
                    JavaReferenceType _javaReferenceType_2 = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(rDataType);
                    _builder.append((Object)_javaReferenceType_2, "\t");
                    _builder.append((Object)" data, ");
                    _builder.append(RosettaPath.class, "\t");
                    _builder.append((Object)" path) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append(ElementValidationResult.class, "\t\t");
                    _builder.append((Object)" result = ");
                    String _firstLower_1 = StringExtensions.toFirstLower((String)ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
                    _builder.append((Object)_firstLower_1, "\t\t");
                    _builder.append((Object)".validate(path, data);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return new ");
                    _builder.append(ConditionValidation.class, "\t\t");
                    _builder.append((Object)"(");
                    String _firstLower_2 = StringExtensions.toFirstLower((String)ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
                    _builder.append((Object)_firstLower_2, "\t\t");
                    _builder.append((Object)".toString(), result);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient checkCardinality(final Attribute attr) {
        StringConcatenationClient _xifexpression = null;
        if (attr.getCard().getInf() == 0 && attr.getCard().isUnbounded()) {
            _xifexpression = null;
        } else {
            StringConcatenationClient _client_1;
            StringConcatenationClient _client;
            StringConcatenationClient _xifexpression_1 = null;
            boolean _isIsMany = attr.getCard().isIsMany();
            _xifexpression_1 = _isIsMany ? (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkCardinality");
                    _builder.append((Object)_method);
                    _builder.append((Object)"(\"");
                    String _string = attr.getName().toString();
                    _builder.append((Object)_string);
                    _builder.append((Object)"\", atr == null ? 0 : atr.size(), ");
                    int _inf = attr.getCard().getInf();
                    _builder.append((Object)_inf);
                    _builder.append((Object)", ");
                    int _sup = attr.getCard().getSup();
                    _builder.append((Object)_sup);
                    _builder.append((Object)" , path)");
                }
            }) : (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkCardinality");
                    _builder.append((Object)_method);
                    _builder.append((Object)"(\"");
                    String _string = attr.getName().toString();
                    _builder.append((Object)_string);
                    _builder.append((Object)"\", atr != null ? 1 : 0, ");
                    int _inf = attr.getCard().getInf();
                    _builder.append((Object)_inf);
                    _builder.append((Object)", ");
                    int _sup = attr.getCard().getSup();
                    _builder.append((Object)_sup);
                    _builder.append((Object)", path)");
                }
            });
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private StringConcatenationClient checkTypeFormat(final Attribute attr, final String atrVariable) {
        final RType t = this._typeSystem.stripFromTypeAliases(this._rosettaTypeProvider.getRTypeOfSymbol(attr));
        if (t instanceof RStringType) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)t, (Object)this._rBuiltinTypeService.UNCONSTRAINED_STRING);
            if (_notEquals) {
                final int min = ((RStringType)t).getInterval().getMinBound();
                final StringConcatenationClient max = this.optional(((RStringType)t).getInterval().getMax());
                final StringConcatenationClient pattern = this.optionalPattern(((RStringType)t).getPattern());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkString");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        _builder.append((Object)atrVariable);
                        _builder.append((Object)", ");
                        _builder.append((Object)min);
                        _builder.append((Object)", ");
                        _builder.append((Object)max);
                        _builder.append((Object)", ");
                        _builder.append((Object)pattern);
                        _builder.append((Object)", path)");
                    }
                };
                return _client;
            }
        } else if (t instanceof RNumberType) {
            boolean _notEquals_1;
            boolean testintomethod = false;
            boolean bl = _notEquals_1 = !Objects.equal((Object)t, (Object)this._rBuiltinTypeService.UNCONSTRAINED_NUMBER);
            if (_notEquals_1) {
                final StringConcatenationClient digits = this.optional(((RNumberType)t).getDigits());
                final StringConcatenationClient fractionalDigits = this.optional(((RNumberType)t).getFractionalDigits());
                final StringConcatenationClient min_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMin());
                final StringConcatenationClient max_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMax());
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        boolean _not;
                        Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkNumber");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        _builder.append((Object)atrVariable);
                        _builder.append((Object)", ");
                        _builder.append((Object)digits);
                        _builder.append((Object)", ");
                        boolean _isInteger = ((RNumberType)t).isInteger();
                        boolean bl = _not = !_isInteger;
                        if (_not) {
                            _builder.append((Object)fractionalDigits);
                            _builder.append((Object)", ");
                        }
                        _builder.append((Object)min_1);
                        _builder.append((Object)", ");
                        _builder.append((Object)max_1);
                        _builder.append((Object)", path)");
                    }
                };
                return _client_1;
            }
        }
        return null;
    }

    private StringConcatenationClient getAttributeValue(final Attribute attr) {
        StringConcatenationClient _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(this._rosettaExtensions.metaAnnotations(attr));
        if (_isEmpty) {
            StringConcatenationClient _client;
            _xifexpression = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"o.get");
                    String _name = attr.getName();
                    String _firstUpper = null;
                    if (_name != null) {
                        _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    }
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"()");
                }
            };
        } else {
            StringConcatenationClient _xblockexpression = null;
            JavaReferenceType jt = this._javaTypeTranslator.toMultiMetaOrRegularJavaType(RosettaAttributeExtensions.toExpandedAttribute(attr));
            StringConcatenationClient _xifexpression_1 = null;
            boolean _isList = this._javaTypeUtil.isList((JavaType)jt);
            if (_isList) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _xblockexpression_1 = null;
                final JavaType itemType = this._javaTypeUtil.getItemType((JavaType)jt);
                _xifexpression_1 = _xblockexpression_1 = (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"o.get");
                        String _name = attr.getName();
                        String _firstUpper = null;
                        if (_name != null) {
                            _firstUpper = StringExtensions.toFirstUpper((String)_name);
                        }
                        _builder.append((Object)_firstUpper);
                        _builder.append((Object)"().stream().map(");
                        _builder.append((Object)itemType);
                        _builder.append((Object)"::getValue).collect(");
                        _builder.append(Collectors.class);
                        _builder.append((Object)".toList())");
                    }
                });
            } else {
                StringConcatenationClient _client_1;
                _xifexpression_1 = _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"o.get");
                        String _name = attr.getName();
                        String _firstUpper = null;
                        if (_name != null) {
                            _firstUpper = StringExtensions.toFirstUpper((String)_name);
                        }
                        _builder.append((Object)_firstUpper);
                        _builder.append((Object)"().getValue()");
                    }
                };
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private StringConcatenationClient optional(final Optional<?> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                Object _get = v.get();
                _builder.append(_get);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalPattern(final Optional<Pattern> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                _builder.append(Pattern.class);
                _builder.append((Object)".compile(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((Pattern)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalBigDecimal(final Optional<BigDecimal> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(new ");
                _builder.append(BigDecimal.class);
                _builder.append((Object)"(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((BigDecimal)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }
}

