/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.object;

import com.regnosys.rosetta.generator.object.ExpandedSynonym;
import com.regnosys.rosetta.generator.object.ExpandedType;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.TypeCall;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public final class ExpandedAttribute {
    private final String name;
    private final String enclosingType;
    private final ExpandedType type;
    private final TypeCall rosettaType;
    private final boolean overriding;
    private final int inf;
    private final int sup;
    private final boolean isUnbound;
    private final List<ExpandedSynonym> synonyms;
    private final String definition;
    private final List<RosettaDocReference> docReferences;
    private final boolean isEnum;
    private final List<ExpandedAttribute> metas;

    public ExpandedType getType() {
        return this.type;
    }

    public boolean isMultiple() {
        return this.isUnbound() || this.inf > 1 || this.sup != 1;
    }

    public boolean isSingleOptional() {
        return this.inf == 0 && !this.isMultiple();
    }

    public int refIndex() {
        for (int i = 0; i < this.metas.size(); ++i) {
            String _name = this.metas.get(i).getName();
            if (_name == null) continue;
            switch (_name) {
                case "reference": 
                case "address": {
                    return i;
                }
            }
        }
        return -1;
    }

    public boolean hasMetas() {
        boolean _isEmpty = this.metas.isEmpty();
        return !_isEmpty;
    }

    public boolean hasIdAnnotation() {
        Functions.Function1 _function = it -> it.name;
        return ListExtensions.map(this.metas, (Functions.Function1)_function).contains("id");
    }

    public boolean isDataType() {
        return this.getType().isType();
    }

    public boolean builtInType() {
        return this.getType().isBuiltInType();
    }

    public String javaAnnotation() {
        if (this.name == "key" && this.type.getName() == "Key" && this.type.getModel().getName() == "com.rosetta.model.lib.meta") {
            return "location";
        }
        if (this.name == "reference" && this.type.getName() == "Reference" && this.type.getModel().getName() == "com.rosetta.model.lib.meta") {
            return "address";
        }
        return this.name;
    }

    public ExpandedAttribute(String name, String enclosingType, ExpandedType type, TypeCall rosettaType, boolean overriding, int inf, int sup, boolean isUnbound, List<ExpandedSynonym> synonyms, String definition, List<RosettaDocReference> docReferences, boolean isEnum, List<ExpandedAttribute> metas) {
        this.name = name;
        this.enclosingType = enclosingType;
        this.type = type;
        this.rosettaType = rosettaType;
        this.overriding = overriding;
        this.inf = inf;
        this.sup = sup;
        this.isUnbound = isUnbound;
        this.synonyms = synonyms;
        this.definition = definition;
        this.docReferences = docReferences;
        this.isEnum = isEnum;
        this.metas = metas;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.enclosingType == null ? 0 : this.enclosingType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.rosettaType == null ? 0 : this.rosettaType.hashCode());
        result = 31 * result + (this.overriding ? 1231 : 1237);
        result = 31 * result + this.inf;
        result = 31 * result + this.sup;
        result = 31 * result + (this.isUnbound ? 1231 : 1237);
        result = 31 * result + (this.synonyms == null ? 0 : this.synonyms.hashCode());
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.docReferences == null ? 0 : this.docReferences.hashCode());
        result = 31 * result + (this.isEnum ? 1231 : 1237);
        return 31 * result + (this.metas == null ? 0 : this.metas.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpandedAttribute other = (ExpandedAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals(other.enclosingType)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.rosettaType == null ? other.rosettaType != null : !this.rosettaType.equals(other.rosettaType)) {
            return false;
        }
        if (other.overriding != this.overriding) {
            return false;
        }
        if (other.inf != this.inf) {
            return false;
        }
        if (other.sup != this.sup) {
            return false;
        }
        if (other.isUnbound != this.isUnbound) {
            return false;
        }
        if (this.synonyms == null ? other.synonyms != null : !this.synonyms.equals(other.synonyms)) {
            return false;
        }
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.docReferences == null ? other.docReferences != null : !this.docReferences.equals(other.docReferences)) {
            return false;
        }
        if (other.isEnum != this.isEnum) {
            return false;
        }
        return !(this.metas == null ? other.metas != null : !this.metas.equals(other.metas));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.name);
        b.add("enclosingType", (Object)this.enclosingType);
        b.add("type", (Object)this.type);
        b.add("rosettaType", (Object)this.rosettaType);
        b.add("overriding", (Object)this.overriding);
        b.add("inf", (Object)this.inf);
        b.add("sup", (Object)this.sup);
        b.add("isUnbound", (Object)this.isUnbound);
        b.add("synonyms", this.synonyms);
        b.add("definition", (Object)this.definition);
        b.add("docReferences", this.docReferences);
        b.add("isEnum", (Object)this.isEnum);
        b.add("metas", this.metas);
        return b.toString();
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public String getEnclosingType() {
        return this.enclosingType;
    }

    @Pure
    public TypeCall getRosettaType() {
        return this.rosettaType;
    }

    @Pure
    public boolean isOverriding() {
        return this.overriding;
    }

    @Pure
    public int getInf() {
        return this.inf;
    }

    @Pure
    public int getSup() {
        return this.sup;
    }

    @Pure
    public boolean isUnbound() {
        return this.isUnbound;
    }

    @Pure
    public List<ExpandedSynonym> getSynonyms() {
        return this.synonyms;
    }

    @Pure
    public String getDefinition() {
        return this.definition;
    }

    @Pure
    public List<RosettaDocReference> getDocReferences() {
        return this.docReferences;
    }

    @Pure
    public boolean isEnum() {
        return this.isEnum;
    }

    @Pure
    public List<ExpandedAttribute> getMetas() {
        return this.metas;
    }
}

