/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.scoping;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.scoping.ReversedSimpleScope;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    public static final String LIB_NAMESPACE = "com.rosetta.model";
    private static Logger LOGGER = LoggerFactory.getLogger(RosettaScopeProvider.class);
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    @Extension
    private RosettaExtensions _rosettaExtensions;
    @Inject
    @Extension
    private RosettaConfigExtension configs;
    @Inject
    @Extension
    private RosettaFunctionExtensions _rosettaFunctionExtensions;
    @Inject
    @Extension
    private DeepFeatureCallUtil _deepFeatureCallUtil;

    public IScope getScope(EObject context, EReference reference) {
        try {
            boolean _matched = false;
            if (Objects.equal((Object)reference, (Object)RosettaPackage.Literals.TYPE_CALL_ARGUMENT__PARAMETER)) {
                _matched = true;
                if (context instanceof TypeCall) {
                    RosettaType type = ((TypeCall)context).getType();
                    if (type instanceof ParametrizedRosettaType) {
                        return Scopes.scopeFor(((ParametrizedRosettaType)((Object)type)).getParameters());
                    }
                    return IScope.NULLSCOPE;
                }
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE)) {
                _matched = true;
                if (context instanceof RosettaFeatureCall) {
                    return this.createExtendedFeatureScope(((RosettaFeatureCall)context).getReceiver(), this.typeProvider.getRType(((RosettaFeatureCall)context).getReceiver()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_DEEP_FEATURE_CALL__FEATURE)) {
                _matched = true;
                if (context instanceof RosettaDeepFeatureCall) {
                    return this.createDeepFeatureScope(this.typeProvider.getRType(((RosettaDeepFeatureCall)context).getReceiver()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES)) {
                _matched = true;
                if (context instanceof ChoiceOperation) {
                    return this.createExtendedFeatureScope(((ChoiceOperation)context).getArgument(), this.typeProvider.getRType(((ChoiceOperation)context).getArgument()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof RosettaAttributeReference) {
                    return this.createExtendedFeatureScope(((RosettaAttributeReference)context).getReceiver(), this.typeProvider.getRTypeOfAttributeReference(((RosettaAttributeReference)context).getReceiver()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY)) {
                _matched = true;
                if (context instanceof ConstructorKeyValuePair) {
                    EObject _eContainer = ((ConstructorKeyValuePair)context).eContainer();
                    RosettaConstructorExpression constructor = (RosettaConstructorExpression)_eContainer;
                    return Scopes.scopeFor(this._rosettaExtensions.allFeatures(this.typeProvider.getRType(constructor), context));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.OPERATION__ASSIGN_ROOT)) {
                _matched = true;
                if (context instanceof Operation) {
                    ArrayList outAndAliases = CollectionLiterals.newArrayList();
                    Attribute out = this._rosettaFunctionExtensions.getOutput(((Operation)context).getFunction());
                    if (out != null) {
                        outAndAliases.add(out);
                    }
                    outAndAliases.addAll(((Operation)context).getFunction().getShortcuts());
                    return Scopes.scopeFor((Iterable)outAndAliases);
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.SEGMENT__ATTRIBUTE)) {
                _matched = true;
                boolean _matched_1 = false;
                if (context instanceof Operation) {
                    _matched_1 = true;
                    RType receiverType = this.typeProvider.getRTypeOfSymbol(((Operation)context).getAssignRoot());
                    return Scopes.scopeFor(this._rosettaExtensions.allFeatures(receiverType, context));
                }
                if (!_matched_1 && context instanceof Segment) {
                    boolean _isResolved;
                    _matched_1 = true;
                    Segment prev = ((Segment)context).getPrev();
                    if (prev != null && (_isResolved = this._rosettaExtensions.isResolved(prev.getAttribute()))) {
                        RType receiverType = this.typeProvider.getRTypeOfSymbol(prev.getAttribute());
                        return Scopes.scopeFor(this._rosettaExtensions.allFeatures(receiverType, context));
                    }
                    EObject _eContainer_1 = ((Segment)context).eContainer();
                    if (_eContainer_1 instanceof Operation) {
                        return this.getScope(((Segment)context).eContainer(), reference);
                    }
                    return this.defaultScope(context, reference);
                }
                return this.defaultScope(context, reference);
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL)) {
                _matched = true;
                if (context instanceof Operation) {
                    Attribute _output;
                    boolean _tripleNotEquals;
                    boolean _not;
                    Function function = ((Operation)context).getFunction();
                    ArrayList inputsAndOutputs = CollectionLiterals.newArrayList();
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(function.getInputs());
                    boolean bl = _not = !_isNullOrEmpty;
                    if (_not) {
                        inputsAndOutputs.addAll(function.getInputs());
                    }
                    boolean bl2 = _tripleNotEquals = (_output = function.getOutput()) != null;
                    if (_tripleNotEquals) {
                        inputsAndOutputs.add(function.getOutput());
                    }
                    return Scopes.scopeFor((Iterable)inputsAndOutputs);
                }
                Iterable<? extends RosettaFeature> implicitFeatures = this.typeProvider.findFeaturesOfImplicitVariable(context);
                InlineFunction inline = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)context, InlineFunction.class);
                if (inline != null) {
                    IScope ps = this.getSymbolParentScope(context, reference, IScope.NULLSCOPE);
                    return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
                }
                Function container = (Function)EcoreUtil2.getContainerOfType((EObject)context, Function.class);
                if (container != null) {
                    Predicate _function = descr -> {
                        EClass _eClass = descr.getEClass();
                        return _eClass != SimplePackage.Literals.DATA;
                    };
                    IScope ps_1 = this.filteredScope(this.getSymbolParentScope(context, reference, IScope.NULLSCOPE), (Predicate<IEObjectDescription>)_function);
                    return ReversedSimpleScope.scopeFor(implicitFeatures, ps_1);
                }
                IScope ps_2 = this.getSymbolParentScope(context, reference, this.defaultScope(context, reference));
                return ReversedSimpleScope.scopeFor(implicitFeatures, ps_2);
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE)) {
                _matched = true;
                if (context instanceof RosettaEnumValueReference) {
                    return Scopes.scopeFor(this._rosettaExtensions.getAllEnumValues(((RosettaEnumValueReference)context).getEnumeration()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF)) {
                EObject _eContainer_1;
                RosettaType classRef;
                _matched = true;
                if (context instanceof RosettaExternalRegularAttribute && (classRef = ((RosettaExternalClass)(_eContainer_1 = ((RosettaExternalRegularAttribute)context).eContainer())).getTypeRef()) instanceof Data) {
                    return Scopes.scopeFor(this._rosettaExtensions.getAllAttributes((Data)classRef));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF)) {
                EObject _eContainer_2;
                RosettaType enumRef;
                _matched = true;
                if (context instanceof RosettaExternalEnumValue && (enumRef = ((RosettaExternalEnum)(_eContainer_2 = ((RosettaExternalEnumValue)context).eContainer())).getTypeRef()) instanceof RosettaEnumeration) {
                    return Scopes.scopeFor(this._rosettaExtensions.getAllEnumValues((RosettaEnumeration)enumRef));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof AnnotationRef) {
                    Annotation annoRef = ((AnnotationRef)context).getAnnotation();
                    return Scopes.scopeFor(annoRef.getAttributes());
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof FunctionDispatch) {
                    return Scopes.scopeFor(this._rosettaFunctionExtensions.getInputs((Function)context));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES)) {
                _matched = true;
                Predicate _function_1 = it -> {
                    EClass _eClass = it.getEClass();
                    return Objects.equal((Object)_eClass, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE);
                };
                return this.filteredScope(this.defaultScope(context, reference), (Predicate<IEObjectDescription>)_function_1);
            }
            return this.defaultScope(context, reference);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _message = e.getMessage();
                String _plus = "Error scoping rosetta - \"" + _message;
                String _plus_1 = _plus + "\" see debug logging for full trace";
                LOGGER.error(_plus_1);
                LOGGER.debug("Full trace of error ", (Throwable)e);
                return IScope.NULLSCOPE;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        ImportNormalizer _createImportedNamespaceResolver = this.createImportedNamespaceResolver("com.rosetta.model.*", ignoreCase);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ImportNormalizer[]{_createImportedNamespaceResolver}));
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        List _xifexpression = null;
        if (context instanceof RosettaModel) {
            List imports = super.internalGetImportedNamespaceResolvers(context, ignoreCase);
            imports.add(this.doCreateImportNormalizer(this.getQualifiedNameConverter().toQualifiedName(((RosettaModel)context).getName()), true, ignoreCase));
            return imports;
        }
        _xifexpression = CollectionLiterals.emptyList();
        return _xifexpression;
    }

    private IScope defaultScope(EObject object, EReference reference) {
        Predicate _function = it -> {
            EClass _eClass = it.getEClass();
            return _eClass != SimplePackage.Literals.FUNCTION_DISPATCH;
        };
        return this.filteredScope(super.getScope(object, reference), (Predicate<IEObjectDescription>)_function);
    }

    private IScope getSymbolParentScope(EObject object, EReference reference, IScope outer) {
        Predicate _function;
        boolean _tripleEquals;
        IScope _xblockexpression = null;
        EObject _eContainer = object.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            return this.defaultScope(object, reference);
        }
        IScope parentScope = this.getSymbolParentScope(object.eContainer(), reference, outer);
        IScope _switchResult = null;
        boolean _matched = false;
        if (object instanceof InlineFunction) {
            _matched = true;
            return Scopes.scopeFor(((InlineFunction)object).getParameters(), (IScope)parentScope);
        }
        if (!_matched && object instanceof Function) {
            _matched = true;
            ArrayList features = CollectionLiterals.newArrayList();
            features.addAll(this._rosettaFunctionExtensions.getInputs((Function)object));
            Attribute out = this._rosettaFunctionExtensions.getOutput((Function)object);
            if (out != null) {
                features.add(this._rosettaFunctionExtensions.getOutput((Function)object));
            }
            features.addAll(((Function)object).getShortcuts());
            return Scopes.scopeFor((Iterable)features, (IScope)parentScope);
        }
        if (!_matched && object instanceof ShortcutDeclaration) {
            _matched = true;
            _function = descr -> {
                String _name;
                String _string = descr.getQualifiedName().toString();
                return !Objects.equal((Object)_string, (Object)(_name = ((ShortcutDeclaration)object).getName()));
            };
            _switchResult = this.filteredScope(parentScope, (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched && object instanceof RosettaTypeAlias) {
            _matched = true;
            _switchResult = Scopes.scopeFor((Iterable)((RosettaTypeAlias)object).getParameters(), (IScope)parentScope);
        }
        if (!_matched && object instanceof Condition) {
            _matched = true;
            _function = descr -> ((Condition)object).isPostCondition() || descr.getEObjectOrProxy().eContainingFeature() != SimplePackage.Literals.FUNCTION__OUTPUT;
            _switchResult = this.filteredScope(parentScope, (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched && object instanceof RosettaModel) {
            _matched = true;
            _function = descr -> Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[]{SimplePackage.Literals.DATA, RosettaPackage.Literals.ROSETTA_ENUMERATION, SimplePackage.Literals.FUNCTION, RosettaPackage.Literals.ROSETTA_EXTERNAL_FUNCTION, RosettaPackage.Literals.ROSETTA_RULE})).contains(descr.getEClass());
            _switchResult = this.filteredScope(this.defaultScope(object, reference), (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched) {
            _switchResult = parentScope;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private IScope filteredScope(IScope scope, Predicate<IEObjectDescription> filter) {
        return new FilteringScope(scope, filter);
    }

    private IScope createExtendedFeatureScope(EObject receiver, RType receiverType) {
        ArrayList allPosibilities = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            QualifiedName _create = QualifiedName.create((String)it.getName());
            return new EObjectDescription(_create, (EObject)it, null);
        };
        Iterables.addAll((Collection)allPosibilities, (Iterable)IterableExtensions.map(this._rosettaExtensions.allFeatures(receiverType, receiver), (Functions.Function1)_function));
        RosettaFeature _xifexpression = null;
        if (receiver instanceof RosettaFeatureCall) {
            _xifexpression = ((RosettaFeatureCall)receiver).getFeature();
        } else {
            RosettaSymbol _xifexpression_1 = null;
            if (receiver instanceof RosettaSymbolReference) {
                _xifexpression_1 = ((RosettaSymbolReference)receiver).getSymbol();
            }
            _xifexpression = _xifexpression_1;
        }
        RosettaFeature feature = _xifexpression;
        if (feature instanceof Attribute) {
            Functions.Function1 _function_1 = it -> {
                Attribute _attribute = it.getAttribute();
                String _name = null;
                if (_attribute != null) {
                    _name = _attribute.getName();
                }
                return _name;
            };
            List metas = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(this._rosettaExtensions.metaAnnotations((Annotated)((Object)feature)), (Functions.Function1)_function_1)));
            if (metas != null && !metas.isEmpty()) {
                Functions.Function1 _function_2 = it -> metas.contains(it.getName().getLastSegment().toString());
                Functions.Function1 _function_3 = it -> {
                    QualifiedName _create = QualifiedName.create((String)it.getName().getLastSegment());
                    return new AliasedEObjectDescription(_create, it);
                };
                Iterables.addAll((Collection)allPosibilities, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.configs.findMetaTypes(feature), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
            }
        }
        return new SimpleScope((Iterable)allPosibilities);
    }

    private IScope createDeepFeatureScope(RType receiverType) {
        if (receiverType instanceof RDataType) {
            return Scopes.scopeFor(this._deepFeatureCallUtil.findDeepFeatures((RDataType)receiverType));
        }
        return IScope.NULLSCOPE;
    }
}

