/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimpleFactory;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RFunctionOrigin;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.ROperationType;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.DottedPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class RObjectFactory {
    @Inject
    private RosettaTypeProvider rosettaTypeProvider;
    @Inject
    private CardinalityProvider cardinalityProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private RosettaExtensions rosettaExtensions;

    public RFunction buildRFunction(Function function) {
        return new RFunction(new ModelSymbolId(DottedPath.splitOnDots((String)function.getModel().getName()), function.getName()), function.getDefinition(), function.getInputs().stream().map(i -> this.buildRAttribute((Attribute)i)).collect(Collectors.toList()), this.buildRAttribute(function.getOutput()), RFunctionOrigin.FUNCTION, (List<Condition>)function.getConditions(), (List<Condition>)function.getPostConditions(), function.getShortcuts().stream().map(s -> this.buildRShortcut((ShortcutDeclaration)s)).collect(Collectors.toList()), function.getOperations().stream().map(o -> this.buildROperation((Operation)o)).collect(Collectors.toList()), (List<AnnotationRef>)function.getAnnotations());
    }

    public RFunction buildRFunction(RosettaRule rule) {
        RType inputRType = this.typeSystem.typeCallToRType(rule.getInput());
        RType outputRType = this.rosettaTypeProvider.getRType(rule.getExpression());
        boolean outputIsMulti = this.cardinalityProvider.isMulti(rule.getExpression());
        RAttribute outputAttribute = new RAttribute("output", null, outputRType, List.of(), outputIsMulti);
        return new RFunction(new ModelSymbolId(DottedPath.splitOnDots((String)rule.getModel().getName()), rule.getName()), rule.getDefinition(), List.of(new RAttribute("input", null, inputRType, List.of(), false)), outputAttribute, RFunctionOrigin.RULE, List.of(), List.of(), List.of(), List.of(new ROperation(ROperationType.SET, outputAttribute, List.of(), rule.getExpression())), List.of());
    }

    public RFunction buildRFunction(RosettaReport report) {
        String body = report.getRegulatoryBody().getBody().getName();
        String[] corpusList = (String[])report.getRegulatoryBody().getCorpusList().stream().map(c -> c.getName()).toArray(String[]::new);
        String reportDefinition = report.getRegulatoryBody().getBody().getName() + " " + report.getRegulatoryBody().getCorpusList().stream().map(c -> c.getName()).collect(Collectors.joining(" "));
        RDataType outputRtype = new RDataType(report.getReportType());
        RAttribute outputAttribute = new RAttribute("output", null, outputRtype, List.of(), false);
        Attribute inputAttribute = SimpleFactory.eINSTANCE.createAttribute();
        inputAttribute.setName("input");
        inputAttribute.setTypeCall((TypeCall)EcoreUtil2.copy((EObject)report.getInputType()));
        RosettaCardinality cardinality = RosettaFactory.eINSTANCE.createRosettaCardinality();
        cardinality.setInf(0);
        cardinality.setSup(1);
        inputAttribute.setCard(cardinality);
        Map<Attribute, RosettaRule> attributeToRuleMap = this.rosettaExtensions.getAllReportingRules(report).entrySet().stream().collect(Collectors.toMap(e -> ((RosettaExtensions.PathAttribute)e.getKey()).getAttr(), e -> (RosettaRule)e.getValue()));
        List<ROperation> operations = this.generateReportOperations(report.getReportType(), attributeToRuleMap, inputAttribute, List.of(outputAttribute));
        return new RFunction(new ModelReportId(DottedPath.splitOnDots((String)report.getModel().getName()), body, corpusList), reportDefinition, List.of(this.buildRAttribute(inputAttribute)), outputAttribute, RFunctionOrigin.REPORT, List.of(), List.of(), List.of(), operations, List.of());
    }

    private List<ROperation> generateReportOperations(Data reportDataType, Map<Attribute, RosettaRule> attributeToRuleMap, Attribute inputAttribute, List<RAttribute> assignPath) {
        Iterable<Attribute> attributes = this.rosettaExtensions.getAllAttributes(reportDataType);
        ArrayList<ROperation> operations = new ArrayList<ROperation>();
        for (Attribute attribute : attributes) {
            RAttribute rAttribute = this.buildRAttribute(attribute);
            ArrayList<RAttribute> newAssignPath = new ArrayList<RAttribute>(assignPath);
            newAssignPath.add(rAttribute);
            if (attributeToRuleMap.containsKey(attribute)) {
                operations.add(this.generateOperationForRuleReference(inputAttribute, attributeToRuleMap.get(attribute), newAssignPath));
                continue;
            }
            if (!(rAttribute.getRType() instanceof RDataType)) continue;
            RDataType rData = (RDataType)rAttribute.getRType();
            Data data = rData.getData();
            operations.addAll(this.generateReportOperations(data, attributeToRuleMap, inputAttribute, newAssignPath));
        }
        return operations;
    }

    private ROperation generateOperationForRuleReference(Attribute inputAttribute, RosettaRule rule, List<RAttribute> assignPath) {
        RAttribute pathHead = assignPath.get(0);
        List<RAttribute> pathTail = assignPath.subList(1, assignPath.size());
        RosettaSymbolReference inputAttributeSymbolRef = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
        inputAttributeSymbolRef.setSymbol(inputAttribute);
        RosettaSymbolReference symbolRef = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
        symbolRef.setSymbol(rule);
        symbolRef.setExplicitArguments(true);
        symbolRef.getArgs().add((Object)inputAttributeSymbolRef);
        return new ROperation(ROperationType.SET, pathHead, pathTail, symbolRef);
    }

    public RAttribute buildRAttribute(Attribute attribute) {
        RType rType = this.rosettaTypeProvider.getRTypeOfSymbol(attribute);
        List<RAttribute> metaAnnotations = attribute.getAnnotations().stream().filter(a -> a.getAnnotation().getName().equals("metadata")).map(a -> this.buildRAttribute(a.getAttribute())).collect(Collectors.toList());
        return new RAttribute(attribute.getName(), attribute.getDefinition(), rType, metaAnnotations, this.cardinalityProvider.isSymbolMulti(attribute));
    }

    public RShortcut buildRShortcut(ShortcutDeclaration shortcut) {
        return new RShortcut(shortcut.getName(), shortcut.getDefinition(), shortcut.getExpression());
    }

    public ROperation buildROperation(Operation operation) {
        ROperationType operationType = operation.isAdd() ? ROperationType.ADD : ROperationType.SET;
        RAssignedRoot pathHead = operation.getAssignRoot() instanceof Attribute ? this.buildRAttribute((Attribute)operation.getAssignRoot()) : this.buildRShortcut((ShortcutDeclaration)operation.getAssignRoot());
        List<RAttribute> pathTail = operation.pathAsSegmentList().stream().map(s -> this.buildRAttribute(s.getAttribute())).collect(Collectors.toList());
        return new ROperation(operationType, pathHead, pathTail, operation.getExpression());
    }
}

