/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RErrorType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class RosettaOperators {
    public static final List<String> ARITHMETIC_OPS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"+", "-", "*", "/"}));
    public static final List<String> COMPARISON_OPS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"<", "<=", ">", ">="}));
    public static final List<String> EQUALITY_OPS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"=", "<>", "contains", "disjoint"}));
    public static final List<String> LOGICAL_OPS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"and", "or"}));
    public static final String JOIN_OP = "join";
    public static final String DEFAULT_OP = "default";
    @Inject
    @Extension
    private RBuiltinTypeService service;
    @Inject
    @Extension
    private TypeSystem _typeSystem;

    public RType resultType(String op, RType left, RType right) {
        RType _xifexpression = null;
        boolean _equals = Objects.equal((Object)op, (Object)"+");
        if (_equals) {
            RDateTimeType _xifexpression_1 = null;
            if (this._typeSystem.isSubtypeOf(left, this.service.DATE) && this._typeSystem.isSubtypeOf(right, this.service.TIME)) {
                _xifexpression_1 = this.service.DATE_TIME;
            } else {
                RType _xifexpression_2 = null;
                if (this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_STRING) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_STRING)) {
                    BiFunction<RType, RType, RType> _function = (l, r) -> {
                        RStringType _xblockexpression = null;
                        RStringType s1 = (RStringType)l;
                        RStringType s2 = (RStringType)r;
                        PositiveIntegerInterval newInterval = s1.getInterval().add(s2.getInterval());
                        Optional<Pattern> _empty = Optional.empty();
                        _xblockexpression = new RStringType(newInterval, _empty);
                        return _xblockexpression;
                    };
                    _xifexpression_2 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function);
                } else {
                    RType _xifexpression_3 = null;
                    if (this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER)) {
                        BiFunction<RType, RType, RType> _function_1 = (l, r) -> {
                            RNumberType _xblockexpression = null;
                            RNumberType n1 = (RNumberType)l;
                            RNumberType n2 = (RNumberType)r;
                            BiFunction<Integer, Integer, Integer> _function_2 = (a, b) -> Math.max(a, b);
                            Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_2);
                            BigDecimalInterval newInterval = n1.getInterval().add(n2.getInterval());
                            Optional<Integer> _empty = Optional.empty();
                            Optional<BigDecimal> _empty_1 = Optional.empty();
                            _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
                            return _xblockexpression;
                        };
                        _xifexpression_3 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_1);
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            RAliasType _xifexpression_4 = null;
            boolean _equals_1 = Objects.equal((Object)op, (Object)"-");
            if (_equals_1) {
                RAliasType _xifexpression_5 = null;
                if (this._typeSystem.isSubtypeOf(left, this.service.DATE) && this._typeSystem.isSubtypeOf(right, this.service.DATE)) {
                    _xifexpression_5 = this.service.UNCONSTRAINED_INT;
                } else {
                    RType _xifexpression_6 = null;
                    if (this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER)) {
                        BiFunction<RType, RType, RType> _function_2 = (l, r) -> {
                            RNumberType _xblockexpression = null;
                            RNumberType n1 = (RNumberType)l;
                            RNumberType n2 = (RNumberType)r;
                            BiFunction<Integer, Integer, Integer> _function_3 = (a, b) -> Math.max(a, b);
                            Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_3);
                            BigDecimalInterval newInterval = n1.getInterval().subtract(n2.getInterval());
                            Optional<Integer> _empty = Optional.empty();
                            Optional<BigDecimal> _empty_1 = Optional.empty();
                            _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
                            return _xblockexpression;
                        };
                        _xifexpression_6 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_2);
                    }
                    _xifexpression_5 = _xifexpression_6;
                }
                _xifexpression_4 = _xifexpression_5;
            } else {
                RAliasType _xifexpression_7 = null;
                boolean _equals_2 = Objects.equal((Object)op, (Object)"*");
                if (_equals_2) {
                    RType _xifexpression_8 = null;
                    if (this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER)) {
                        BiFunction<RType, RType, RType> _function_3 = (l, r) -> {
                            RNumberType _xblockexpression = null;
                            RNumberType n1 = (RNumberType)l;
                            RNumberType n2 = (RNumberType)r;
                            BiFunction<Integer, Integer, Integer> _function_4 = (a, b) -> a + b;
                            Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_4);
                            BigDecimalInterval newInterval = n1.getInterval().multiply(n2.getInterval());
                            Optional<Integer> _empty = Optional.empty();
                            Optional<BigDecimal> _empty_1 = Optional.empty();
                            _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
                            return _xblockexpression;
                        };
                        _xifexpression_8 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_3);
                    }
                    _xifexpression_7 = _xifexpression_8;
                } else {
                    RBasicType _xifexpression_9 = null;
                    boolean _equals_3 = Objects.equal((Object)op, (Object)"/");
                    if (_equals_3) {
                        RBasicType _xifexpression_10 = null;
                        if (this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER)) {
                            _xifexpression_10 = this.service.UNCONSTRAINED_NUMBER;
                        }
                        _xifexpression_9 = _xifexpression_10;
                    } else {
                        RBasicType _xifexpression_11 = null;
                        if (COMPARISON_OPS.contains(op) || EQUALITY_OPS.contains(op)) {
                            RBasicType _xifexpression_12 = null;
                            if (left == null || right == null || this._typeSystem.isComparable(left, right)) {
                                _xifexpression_12 = this.service.BOOLEAN;
                            }
                            _xifexpression_11 = _xifexpression_12;
                        } else {
                            RType _xifexpression_13 = null;
                            boolean _equals_4 = Objects.equal((Object)op, (Object)JOIN_OP);
                            if (_equals_4) {
                                return this.bothString(left, right, op);
                            }
                            RType _xifexpression_14 = null;
                            boolean _contains = LOGICAL_OPS.contains(op);
                            if (_contains) {
                                return this.bothBoolean(left, right, op);
                            }
                            RType _xifexpression_15 = null;
                            boolean _equals_5 = Objects.equal((Object)op, (Object)DEFAULT_OP);
                            if (_equals_5) {
                                boolean _notEquals;
                                RType _xblockexpression = null;
                                RType result = this._typeSystem.join(left, right);
                                RType _xifexpression_16 = null;
                                boolean bl = _notEquals = !Objects.equal((Object)result, (Object)this.service.ANY);
                                if (_notEquals) {
                                    _xifexpression_16 = result;
                                }
                                _xifexpression_15 = _xblockexpression = _xifexpression_16;
                            }
                            _xifexpression_13 = _xifexpression_14 = _xifexpression_15;
                            _xifexpression_11 = _xifexpression_13;
                        }
                        _xifexpression_9 = _xifexpression_11;
                    }
                    _xifexpression_7 = _xifexpression_9;
                }
                _xifexpression_4 = _xifexpression_7;
            }
            _xifexpression = _xifexpression_4;
        }
        RDateTimeType resultType = _xifexpression;
        if (resultType == null) {
            String _name = left.getName();
            String _plus = "Incompatible types: cannot use operator '" + op + "' with " + _name;
            String _plus_1 = _plus + " and ";
            String _name_1 = right.getName();
            String _plus_2 = _plus_1 + _name_1;
            String _plus_3 = _plus_2 + ".";
            return new RErrorType(_plus_3);
        }
        return resultType;
    }

    private RType bothBoolean(RType left, RType right, String op) {
        boolean _not_1;
        boolean _not;
        boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(left, this.service.BOOLEAN);
        boolean bl = _not = !_isSubtypeOf;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Left hand side of '");
            _builder.append(op);
            _builder.append("' expression must be boolean");
            return new RErrorType(_builder.toString());
        }
        boolean _isSubtypeOf_1 = this._typeSystem.isSubtypeOf(right, this.service.BOOLEAN);
        boolean bl2 = _not_1 = !_isSubtypeOf_1;
        if (_not_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Right hand side of '");
            _builder_1.append(op);
            _builder_1.append("' expression must be boolean");
            return new RErrorType(_builder_1.toString());
        }
        return this.service.BOOLEAN;
    }

    private RType bothString(RType left, RType right, String op) {
        boolean _not_1;
        boolean _not;
        boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_STRING);
        boolean bl = _not = !_isSubtypeOf;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Left hand side of '");
            _builder.append(op);
            _builder.append("' expression must be string");
            return new RErrorType(_builder.toString());
        }
        boolean _isSubtypeOf_1 = this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_STRING);
        boolean bl2 = _not_1 = !_isSubtypeOf_1;
        if (_not_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Right hand side of '");
            _builder_1.append(op);
            _builder_1.append("' expression must be string");
            return new RErrorType(_builder_1.toString());
        }
        return this.service.UNCONSTRAINED_STRING;
    }
}

