/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaDataReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.RAnnotateType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RErrorType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaOperators;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class RosettaTypeProvider
extends RosettaExpressionSwitch<RType, Map<EObject, RType>> {
    public static String EXPRESSION_RTYPE_CACHE_KEY = RosettaTypeProvider.class.getCanonicalName() + ".EXPRESSION_RTYPE";
    public static boolean EXPRESSION_RTYPE_CACHE_KEY_ENABLED = Boolean.getBoolean("EXPRESSION_RTYPE_CACHE_KEY_ENABLED");
    @Inject
    @Extension
    private RosettaOperators _rosettaOperators;
    @Inject
    private IQualifiedNameProvider qNames;
    @Inject
    private RosettaExtensions extensions;
    @Inject
    @Extension
    private ImplicitVariableUtil _implicitVariableUtil;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    @Extension
    private TypeFactory _typeFactory;
    @Inject
    @Extension
    private RBuiltinTypeService _rBuiltinTypeService;

    public RType getRType(RosettaExpression expression) {
        return this.safeRType(expression, (Map<EObject, RType>)CollectionLiterals.newHashMap());
    }

    public RType getRTypeOfFeature(RosettaFeature feature) {
        return this.safeRType(feature, (Map<EObject, RType>)CollectionLiterals.newHashMap());
    }

    public RType getRTypeOfSymbol(RosettaSymbol feature) {
        return this.safeRType(feature, (Map<EObject, RType>)CollectionLiterals.newHashMap());
    }

    public RType getRTypeOfAttributeReference(RosettaAttributeReferenceSegment seg) {
        RType _switchResult = null;
        boolean _matched = false;
        if (seg instanceof RosettaAttributeReference) {
            _matched = true;
            _switchResult = this._typeSystem.typeCallToRType(((RosettaAttributeReference)seg).getAttribute().getTypeCall());
        }
        if (!_matched && seg instanceof RosettaDataReference) {
            _matched = true;
            RBasicType _xifexpression = null;
            boolean _isResolved = this.extensions.isResolved(((RosettaDataReference)seg).getData());
            if (_isResolved) {
                Data _data = ((RosettaDataReference)seg).getData();
                return new RDataType(_data);
            }
            _xifexpression = this._rBuiltinTypeService.NOTHING;
            _switchResult = _xifexpression;
        }
        return _switchResult;
    }

    public Iterable<? extends RosettaFeature> findFeaturesOfImplicitVariable(EObject context) {
        return this.extensions.allFeatures(this.typeOfImplicitVariable(context), context);
    }

    private RType safeRType(RosettaSymbol symbol, Map<EObject, RType> cycleTracker) {
        RType _xifexpression;
        RType _xblockexpression;
        RType _switchResult = null;
        boolean _matched = false;
        if (symbol instanceof RosettaFeature) {
            _matched = true;
            _switchResult = this.safeRType((RosettaFeature)((Object)symbol), cycleTracker);
        }
        if (!_matched && symbol instanceof ClosureParameter) {
            _matched = true;
            _xblockexpression = null;
            EObject _eContainer = ((ClosureParameter)symbol).getFunction().eContainer();
            RosettaFunctionalOperation setOp = (RosettaFunctionalOperation)_eContainer;
            RType _xifexpression2 = null;
            _xifexpression2 = setOp != null ? this.safeRType(setOp.getArgument(), cycleTracker) : this._rBuiltinTypeService.MISSING;
            _xblockexpression = _xifexpression2;
            _switchResult = _xblockexpression;
        }
        if (!_matched && symbol instanceof RosettaEnumeration) {
            _matched = true;
            _switchResult = new REnumType((RosettaEnumeration)symbol);
        }
        if (!_matched && symbol instanceof com.regnosys.rosetta.rosetta.simple.Function) {
            boolean _tripleNotEquals;
            _matched = true;
            _xifexpression = null;
            Attribute _output = ((com.regnosys.rosetta.rosetta.simple.Function)symbol).getOutput();
            boolean bl = _tripleNotEquals = _output != null;
            if (_tripleNotEquals) {
                Attribute _output_1 = ((com.regnosys.rosetta.rosetta.simple.Function)symbol).getOutput();
                _xifexpression = this.safeRType(_output_1, cycleTracker);
            } else {
                _xifexpression = this._rBuiltinTypeService.MISSING;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && symbol instanceof RosettaRule) {
            _matched = true;
            _xifexpression = null;
            RosettaExpression _expression = ((RosettaRule)symbol).getExpression();
            boolean _tripleNotEquals = _expression != null;
            _xifexpression = _tripleNotEquals ? this.safeRType(((RosettaRule)symbol).getExpression(), cycleTracker) : this._rBuiltinTypeService.MISSING;
            _switchResult = _xifexpression;
        }
        if (!_matched && symbol instanceof RosettaExternalFunction) {
            _matched = true;
            _switchResult = this._typeSystem.typeCallToRType(((RosettaExternalFunction)symbol).getTypeCall());
        }
        if (!_matched && symbol instanceof ShortcutDeclaration) {
            _matched = true;
            _xblockexpression = null;
            cycleTracker.put(symbol, null);
            RType type = this.safeRType(((ShortcutDeclaration)symbol).getExpression(), cycleTracker);
            cycleTracker.put(symbol, type);
            _xblockexpression = type;
            _switchResult = _xblockexpression;
        }
        return _switchResult;
    }

    private RType safeRType(RosettaFeature feature, Map<EObject, RType> cycleTracker) {
        RType _switchResult = null;
        boolean _matched = false;
        if (feature instanceof RosettaTypedFeature) {
            _matched = true;
            RErrorType _xblockexpression = null;
            RType _xifexpression = null;
            boolean _isIsTypeInferred = ((RosettaTypedFeature)feature).isIsTypeInferred();
            _xifexpression = _isIsTypeInferred ? new RErrorType("Cannot infer type of feature.") : this._typeSystem.typeCallToRType(((RosettaTypedFeature)feature).getTypeCall());
            RErrorType featureType = _xifexpression;
            if (feature instanceof Annotated && featureType instanceof RAnnotateType) {
                ((RAnnotateType)((Object)featureType)).setWithMeta(this.extensions.hasMetaDataAnnotations((Annotated)((Object)feature)));
            }
            _switchResult = _xblockexpression = featureType;
        }
        if (!_matched && feature instanceof RosettaEnumValue) {
            _matched = true;
            RosettaEnumeration _enumeration = ((RosettaEnumValue)feature).getEnumeration();
            _switchResult = new REnumType(_enumeration);
        }
        if (!_matched) {
            _switchResult = new RErrorType("Cannot infer type of feature.");
        }
        return _switchResult;
    }

    private RType safeRType(RosettaExpression expression, Map<EObject, RType> cycleTracker) {
        Provider _function = () -> {
            boolean _not;
            RType _xblockexpression = null;
            boolean _containsKey = cycleTracker.containsKey(expression);
            if (_containsKey) {
                RType computed = (RType)cycleTracker.get(expression);
                if (computed == null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Can't infer type due to a cyclic reference of ");
                    QualifiedName _fullyQualifiedName = this.qNames.getFullyQualifiedName((EObject)expression);
                    _builder.append((Object)_fullyQualifiedName);
                    return new RErrorType(_builder.toString());
                }
                return computed;
            }
            boolean _isResolved = this.extensions.isResolved(expression);
            boolean bl = _not = !_isResolved;
            if (_not) {
                return null;
            }
            _xblockexpression = (RType)this.doSwitch(expression, cycleTracker);
            return _xblockexpression;
        };
        return this.getRTypeFromCache(EXPRESSION_RTYPE_CACHE_KEY, expression, (Provider<RType>)_function);
    }

    private RType getRTypeFromCache(String cacheKey, EObject object, Provider<RType> typeProvider) {
        RType _xblockexpression = null;
        if (!EXPRESSION_RTYPE_CACHE_KEY_ENABLED) {
            return (RType)typeProvider.get();
        }
        if (object == null) {
            return (RType)typeProvider.get();
        }
        Resource resource = object.eResource();
        RType _xifexpression = null;
        if (resource instanceof XtextResource) {
            IResourceScopeCache _cache = ((XtextResource)resource).getCache();
            Pair _mappedTo = Pair.of((Object)cacheKey, (Object)object);
            com.google.inject.Provider _function = () -> (RType)typeProvider.get();
            _xifexpression = (RType)_cache.get((Object)_mappedTo, resource, _function);
        } else {
            _xifexpression = (RType)typeProvider.get();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public RType typeOfImplicitVariable(EObject context) {
        return this.safeTypeOfImplicitVariable(context, CollectionLiterals.newHashMap());
    }

    private RType safeTypeOfImplicitVariable(EObject context, Map<EObject, RType> cycleTracker) {
        RType _xblockexpression = null;
        Optional<EObject> definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(context);
        Function<EObject, RType> _function = it -> {
            RType _xifexpression = null;
            if (it instanceof Data) {
                _xifexpression = new RDataType((Data)it);
            } else {
                RType _xifexpression_1 = null;
                if (it instanceof RosettaFunctionalOperation) {
                    _xifexpression_1 = this.safeRType(((RosettaFunctionalOperation)it).getArgument(), cycleTracker);
                } else {
                    RType _xifexpression_2 = null;
                    if (it instanceof RosettaRule) {
                        RType _elvis = null;
                        TypeCall _input = ((RosettaRule)it).getInput();
                        RType _typeCallToRType = null;
                        if (_input != null) {
                            _typeCallToRType = this._typeSystem.typeCallToRType(_input);
                        }
                        _elvis = _typeCallToRType != null ? _typeCallToRType : this._rBuiltinTypeService.MISSING;
                        _xifexpression_2 = _elvis;
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        };
        _xblockexpression = definingContainer.map(_function).orElse(this._rBuiltinTypeService.MISSING);
        return _xblockexpression;
    }

    private RType caseBinaryOperation(RosettaBinaryOperation expr, Map<EObject, RType> context) {
        RType _xblockexpression = null;
        RosettaExpression left = expr.getLeft();
        RType leftType = this.safeRType(left, context);
        if (leftType == null || leftType instanceof RErrorType) {
            return leftType;
        }
        RosettaExpression right = expr.getRight();
        RType rightType = this.safeRType(right, context);
        if (rightType == null || rightType instanceof RErrorType) {
            return rightType;
        }
        _xblockexpression = this._rosettaOperators.resultType(expr.getOperator(), leftType, rightType);
        return _xblockexpression;
    }

    @Override
    protected RType caseAbsentOperation(RosettaAbsentExpression expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseAddOperation(ArithmeticOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseAndOperation(LogicalOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseAsKeyOperation(AsKeyOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseBooleanLiteral(RosettaBooleanLiteral expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseChoiceOperation(ChoiceOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseConditionalExpression(RosettaConditionalExpression expr, Map<EObject, RType> context) {
        RType _xblockexpression = null;
        RType ifT = this.safeRType(expr.getIfthen(), context);
        RType elseT = this.safeRType(expr.getElsethen(), context);
        RType _xifexpression = null;
        if (ifT == null || ifT instanceof RErrorType) {
            _xifexpression = elseT;
        } else {
            RType _xifexpression_1 = null;
            if (elseT == null || elseT instanceof RErrorType) {
                _xifexpression_1 = ifT;
            } else {
                RType _xblockexpression_1 = null;
                RType joined = this._typeSystem.join(ifT, elseT);
                RType _xifexpression_2 = null;
                boolean _equals = Objects.equal((Object)joined, (Object)this._rBuiltinTypeService.ANY);
                if (_equals) {
                    String _name = ifT.getName();
                    String _plus = "Can not infer common type for '" + _name;
                    String _plus_1 = _plus + "' and ";
                    String _name_1 = elseT.getName();
                    String _plus_2 = _plus_1 + _name_1;
                    String _plus_3 = _plus_2 + "'.";
                    _xifexpression_2 = new RErrorType(_plus_3);
                } else {
                    _xifexpression_2 = joined;
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected RType caseContainsOperation(RosettaContainsExpression expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseDefaultOperation(DefaultOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseCountOperation(RosettaCountOperation expr, Map<EObject, RType> context) {
        return this._typeFactory.constrainedInt(Optional.empty(), Optional.of(BigInteger.ZERO), Optional.empty());
    }

    @Override
    protected RType caseDisjointOperation(RosettaDisjointExpression expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseDistinctOperation(DistinctOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseDivideOperation(ArithmeticOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseEqualsOperation(EqualityOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseExistsOperation(RosettaExistsExpression expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseFeatureCall(RosettaFeatureCall expr, Map<EObject, RType> context) {
        boolean _not;
        RType _xblockexpression = null;
        RosettaFeature feature = expr.getFeature();
        boolean _isResolved = this.extensions.isResolved(feature);
        boolean bl = _not = !_isResolved;
        if (_not) {
            return null;
        }
        RType _xifexpression = null;
        _xifexpression = feature instanceof RosettaEnumValue ? this.safeRType(expr.getReceiver(), context) : this.safeRType(feature, context);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected RType caseDeepFeatureCall(RosettaDeepFeatureCall expr, Map<EObject, RType> context) {
        boolean _not;
        RType _xblockexpression = null;
        Attribute feature = expr.getFeature();
        boolean _isResolved = this.extensions.isResolved(feature);
        boolean bl = _not = !_isResolved;
        if (_not) {
            return null;
        }
        _xblockexpression = this.safeRType(feature, context);
        return _xblockexpression;
    }

    @Override
    protected RType caseFilterOperation(FilterOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseFirstOperation(FirstOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseFlattenOperation(FlattenOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseGreaterThanOperation(ComparisonOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseGreaterThanOrEqualOperation(ComparisonOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseImplicitVariable(RosettaImplicitVariable expr, Map<EObject, RType> context) {
        return this.safeTypeOfImplicitVariable(expr, context);
    }

    @Override
    protected RType caseIntLiteral(RosettaIntLiteral expr, Map<EObject, RType> context) {
        boolean _greaterEqualsThan;
        int _xifexpression = 0;
        int _signum = expr.getValue().signum();
        boolean bl = _greaterEqualsThan = _signum >= 0;
        if (_greaterEqualsThan) {
            _xifexpression = expr.getValue().toString().length();
        } else {
            int _length = expr.getValue().toString().length();
            _xifexpression = _length - 1;
        }
        return this._typeFactory.constrainedInt(_xifexpression, expr.getValue(), expr.getValue());
    }

    @Override
    protected RType caseJoinOperation(JoinOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.UNCONSTRAINED_STRING;
    }

    @Override
    protected RType caseLastOperation(LastOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseLessThanOperation(ComparisonOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseLessThanOrEqualOperation(ComparisonOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseListLiteral(ListLiteral expr, Map<EObject, RType> context) {
        RType _xblockexpression = null;
        Functions.Function1 _function = it -> this.getRType((RosettaExpression)it);
        Functions.Function1 _function_1 = it -> it != null;
        Iterable types = IterableExtensions.filter((Iterable)ListExtensions.map(expr.getElements(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        RType joined = this._typeSystem.join(types);
        RType _xifexpression = null;
        boolean _equals = Objects.equal((Object)joined, (Object)this._rBuiltinTypeService.ANY);
        if (_equals) {
            Functions.Function1 _function_2 = it -> it.getName();
            String _join = IterableExtensions.join(IterableExtensions.groupBy((Iterable)types, (Functions.Function1)_function_2).keySet(), (CharSequence)", ");
            _xifexpression = new RErrorType(_join);
        } else {
            _xifexpression = joined;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected RType caseMapOperation(MapOperation expr, Map<EObject, RType> context) {
        InlineFunction _function = expr.getFunction();
        RosettaExpression _body = null;
        if (_function != null) {
            _body = _function.getBody();
        }
        RType _safeRType = null;
        if (_body != null) {
            _safeRType = this.safeRType(_body, context);
        }
        return _safeRType;
    }

    @Override
    protected RType caseMaxOperation(MaxOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseMinOperation(MinOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseMultiplyOperation(ArithmeticOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseNotEqualsOperation(EqualityOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseNumberLiteral(RosettaNumberLiteral expr, Map<EObject, RType> context) {
        return this._typeFactory.constrainedNumber(expr.getValue().toPlainString().replaceAll("\\.|\\-", "").length(), Math.max(0, expr.getValue().scale()), expr.getValue(), expr.getValue());
    }

    @Override
    protected RType caseOneOfOperation(OneOfOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseOnlyElementOperation(RosettaOnlyElement expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseOnlyExists(RosettaOnlyExistsExpression expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.BOOLEAN;
    }

    @Override
    protected RType caseOrOperation(LogicalOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseReduceOperation(ReduceOperation expr, Map<EObject, RType> context) {
        InlineFunction _function = expr.getFunction();
        RosettaExpression _body = null;
        if (_function != null) {
            _body = _function.getBody();
        }
        RType _safeRType = null;
        if (_body != null) {
            _safeRType = this.safeRType(_body, context);
        }
        return _safeRType;
    }

    @Override
    protected RType caseReverseOperation(ReverseOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseSortOperation(SortOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseStringLiteral(RosettaStringLiteral expr, Map<EObject, RType> context) {
        return this._typeFactory.constrainedString(expr.getValue().length(), expr.getValue().length());
    }

    @Override
    protected RType caseSubtractOperation(ArithmeticOperation expr, Map<EObject, RType> context) {
        return this.caseBinaryOperation(expr, context);
    }

    @Override
    protected RType caseSumOperation(SumOperation expr, Map<EObject, RType> context) {
        return this.safeRType(expr.getArgument(), context);
    }

    @Override
    protected RType caseSymbolReference(RosettaSymbolReference expr, Map<EObject, RType> context) {
        RType _xifexpression = null;
        RosettaSymbol _symbol = expr.getSymbol();
        if (_symbol instanceof RosettaExternalFunction) {
            RType _xblockexpression = null;
            RosettaSymbol _symbol_1 = expr.getSymbol();
            RosettaExternalFunction fun = (RosettaExternalFunction)_symbol_1;
            RType returnType = this.safeRType(fun, context);
            Functions.Function1 _function = it -> this.safeRType((RosettaExpression)it, context);
            List argTypes = ListExtensions.map(expr.getArgs(), (Functions.Function1)_function);
            RType _xifexpression_1 = null;
            Functions.Function1 _function_1 = it -> this._typeSystem.isSubtypeOf((RType)it, returnType);
            boolean _forall = IterableExtensions.forall((Iterable)argTypes, (Functions.Function1)_function_1);
            _xifexpression_1 = _forall ? this._typeSystem.join(argTypes) : returnType;
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = this.safeRType(expr.getSymbol(), context);
        }
        return _xifexpression;
    }

    @Override
    protected RType caseThenOperation(ThenOperation expr, Map<EObject, RType> context) {
        InlineFunction _function = expr.getFunction();
        RosettaExpression _body = null;
        if (_function != null) {
            _body = _function.getBody();
        }
        RType _safeRType = null;
        if (_body != null) {
            _safeRType = this.safeRType(_body, context);
        }
        return _safeRType;
    }

    @Override
    protected RType caseToEnumOperation(ToEnumOperation expr, Map<EObject, RType> context) {
        RosettaEnumeration _enumeration = expr.getEnumeration();
        return new REnumType(_enumeration);
    }

    @Override
    protected RType caseToIntOperation(ToIntOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.UNCONSTRAINED_INT;
    }

    @Override
    protected RType caseToNumberOperation(ToNumberOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.UNCONSTRAINED_NUMBER;
    }

    @Override
    protected RType caseToStringOperation(ToStringOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.UNCONSTRAINED_STRING;
    }

    @Override
    protected RType caseToTimeOperation(ToTimeOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.TIME;
    }

    @Override
    protected RType caseConstructorExpression(RosettaConstructorExpression expr, Map<EObject, RType> context) {
        return this._typeSystem.typeCallToRType(expr.getTypeCall());
    }

    @Override
    protected RType caseToDateOperation(ToDateOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.DATE;
    }

    @Override
    protected RType caseToDateTimeOperation(ToDateTimeOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.DATE_TIME;
    }

    @Override
    protected RType caseToZonedDateTimeOperation(ToZonedDateTimeOperation expr, Map<EObject, RType> context) {
        return this._rBuiltinTypeService.ZONED_DATE_TIME;
    }
}

