/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class TypeFactory {
    private final RBuiltinTypeService builtinTypes;
    public final RosettaCardinality single;
    public final RosettaCardinality empty;
    public final RListType singleBoolean;
    public final RListType singleDate;
    public final RListType singleTime;
    public final RListType singlePattern;
    public final RListType singleUnconstrainedInt;
    public final RListType singleUnconstrainedNumber;
    public final RListType singleUnconstrainedString;
    public final RListType singleDateTime;
    public final RListType singleZonedDateTime;
    public final RListType emptyNothing;

    @Inject
    public TypeFactory(RBuiltinTypeService builtinTypes) {
        this.builtinTypes = builtinTypes;
        this.single = this.createConstraint(1, 1);
        this.empty = this.createConstraint(0, 0);
        this.singleBoolean = this.createListType((RType)builtinTypes.BOOLEAN, this.single);
        this.singleDate = this.createListType((RType)builtinTypes.DATE, this.single);
        this.singleTime = this.createListType((RType)builtinTypes.TIME, this.single);
        this.singlePattern = this.createListType((RType)builtinTypes.PATTERN, this.single);
        this.singleUnconstrainedInt = this.createListType((RType)builtinTypes.UNCONSTRAINED_INT, this.single);
        this.singleUnconstrainedNumber = this.createListType((RType)builtinTypes.UNCONSTRAINED_NUMBER, this.single);
        this.singleUnconstrainedString = this.createListType((RType)builtinTypes.UNCONSTRAINED_STRING, this.single);
        this.singleDateTime = this.createListType((RType)builtinTypes.DATE_TIME, this.single);
        this.singleZonedDateTime = this.createListType((RType)builtinTypes.ZONED_DATE_TIME, this.single);
        this.emptyNothing = this.createListType((RType)builtinTypes.NOTHING, this.empty);
    }

    public RListType singleInt(Optional<Integer> digits, Optional<BigInteger> min, Optional<BigInteger> max) {
        return this.createListType((RType)this.constrainedInt(digits, min, max), this.single);
    }

    public RListType singleInt(int digits, BigInteger min, BigInteger max) {
        return this.createListType((RType)this.constrainedInt(digits, min, max), this.single);
    }

    public RListType singleInt(int digits, String min, String max) {
        return this.createListType((RType)this.constrainedInt(digits, min, max), this.single);
    }

    public RAliasType constrainedInt(Optional<Integer> digits, Optional<BigInteger> min, Optional<BigInteger> max) {
        RNumberType refersTo = this.constrainedNumber(digits, Optional.of(0), min.map(BigDecimal::new), max.map(BigDecimal::new), Optional.empty());
        LinkedHashMap<String, RosettaValue> args = new LinkedHashMap<String, RosettaValue>(refersTo.getArguments());
        args.remove("fractionalDigits");
        args.remove("scale");
        return new RAliasType(this.builtinTypes.INT_FUNCTION, args, refersTo);
    }

    public RAliasType constrainedInt(int digits, BigInteger min, BigInteger max) {
        return this.constrainedInt(Optional.of(digits), Optional.of(min), Optional.of(max));
    }

    public RAliasType constrainedInt(int digits, String min, String max) {
        return this.constrainedInt(Optional.of(digits), Optional.of(new BigInteger(min)), Optional.of(new BigInteger(max)));
    }

    public RListType singleNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> scale) {
        return this.createListType((RType)this.constrainedNumber(digits, fractionalDigits, min, max, scale), this.single);
    }

    public RListType singleNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        return this.createListType((RType)this.constrainedNumber(digits, fractionalDigits, interval, scale), this.single);
    }

    public RListType singleNumber(int digits, int fractionalDigits, BigDecimal min, BigDecimal max) {
        return this.createListType((RType)this.constrainedNumber(digits, fractionalDigits, min, max), this.single);
    }

    public RListType singleNumber(int digits, int fractionalDigits, String min, String max) {
        return this.createListType((RType)this.constrainedNumber(digits, fractionalDigits, min, max), this.single);
    }

    public RNumberType constrainedNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> scale) {
        return new RNumberType(digits, fractionalDigits, min, max, scale);
    }

    public RNumberType constrainedNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        return new RNumberType(digits, fractionalDigits, interval, scale);
    }

    public RNumberType constrainedNumber(int digits, int fractionalDigits, BigDecimal min, BigDecimal max) {
        return this.constrainedNumber(Optional.of(digits), Optional.of(fractionalDigits), Optional.of(min), Optional.of(max), Optional.empty());
    }

    public RNumberType constrainedNumber(int digits, int fractionalDigits, String min, String max) {
        return this.constrainedNumber(Optional.of(digits), Optional.of(fractionalDigits), Optional.of(new BigDecimal(min)), Optional.of(new BigDecimal(max)), Optional.empty());
    }

    public RListType singleString(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        return this.createListType((RType)this.constrainedString(minLength, maxLength, pattern), this.single);
    }

    public RListType singleString(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        return this.createListType((RType)this.constrainedString(interval, pattern), this.single);
    }

    public RListType singleString(int minLength, int maxLength) {
        return this.createListType((RType)this.constrainedString(minLength, maxLength), this.single);
    }

    public RStringType constrainedString(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        return new RStringType(minLength, maxLength, pattern);
    }

    public RStringType constrainedString(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        return new RStringType(interval, pattern);
    }

    public RStringType constrainedString(int minLength, int maxLength) {
        return new RStringType(Optional.of(minLength), Optional.of(maxLength), Optional.empty());
    }

    public RosettaCardinality createConstraint(int inf, int sup) {
        RosettaCardinality c = RosettaFactory.eINSTANCE.createRosettaCardinality();
        c.setInf(inf);
        c.setSup(sup);
        return c;
    }

    public RosettaCardinality createConstraint(int inf) {
        RosettaCardinality c = RosettaFactory.eINSTANCE.createRosettaCardinality();
        c.setInf(inf);
        c.setUnbounded(true);
        return c;
    }

    public RListType createListType(RType itemType, RosettaCardinality constraint) {
        return new RListType(itemType, constraint);
    }

    public RListType createListType(RType itemType, int inf, int sup) {
        return this.createListType(itemType, this.createConstraint(inf, sup));
    }

    public RListType createListType(RType itemType, int inf) {
        return this.createListType(itemType, this.createConstraint(inf));
    }
}

