/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.typing.RosettaTyping;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.Validate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Pair;

public class TypeSystem {
    @Inject
    private RosettaTyping typing;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private ExternalAnnotationUtil annotationUtil;

    public RListType inferType(RosettaExpression expr) {
        Objects.requireNonNull(expr);
        return (RListType)this.typing.inferType(expr).getValue();
    }

    public RType getRulesInputType(Data data, Optional<RosettaExternalRuleSource> source) {
        return this.getRulesInputType(data, source, new HashSet<Data>());
    }

    private RType getRulesInputType(Data data, Optional<RosettaExternalRuleSource> source, Set<Data> visited) {
        Objects.requireNonNull(data);
        return this.getRulesInputTypeFromCache(data, source, (Provider<RType>)((Provider)() -> {
            if (!visited.add(data)) {
                return this.builtins.ANY;
            }
            Map<RosettaFeature, RosettaRuleReference> ruleReferences = this.annotationUtil.getAllRuleReferencesForType(source, data);
            RType result = this.builtins.ANY;
            for (Attribute attr : data.getAttributes()) {
                RosettaRuleReference ref = ruleReferences.get(attr);
                if (ref != null) {
                    RType inputType = this.typeCallToRType(ref.getReportingRule().getInput());
                    result = this.meet(result, inputType);
                    continue;
                }
                RType attrType = this.stripFromTypeAliases(this.typeCallToRType(attr.getTypeCall()));
                if (!(attrType instanceof RDataType)) continue;
                Data attrData = ((RDataType)attrType).getData();
                RType inputType = this.getRulesInputType(attrData, source, visited);
                result = this.meet(result, inputType);
            }
            return result;
        }));
    }

    private RType getRulesInputTypeFromCache(Data data, Optional<RosettaExternalRuleSource> source, Provider<RType> typeProvider) {
        Resource resource = source.map(EObject::eResource).orElse(data.eResource());
        if (resource instanceof XtextResource) {
            return (RType)((XtextResource)resource).getCache().get((Object)new Pair((Object)data, source), resource, () -> typeProvider.get());
        }
        return (RType)typeProvider.get();
    }

    public RType join(RType t1, RType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return Objects.requireNonNull(this.typing.join(t1, t2));
    }

    public RType join(Iterable<RType> types) {
        Objects.requireNonNull(types);
        Validate.noNullElements(types);
        RType acc = this.builtins.NOTHING;
        for (RType t : types) {
            if (!(acc = this.join(acc, t)).equals(this.builtins.ANY)) continue;
            return acc;
        }
        return acc;
    }

    public RListType listJoin(RListType t1, RListType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return Objects.requireNonNull(this.typing.listJoin(t1, t2));
    }

    public RType meet(RType t1, RType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        if (this.isSubtypeOf(t1, t2)) {
            return t1;
        }
        if (this.isSubtypeOf(t2, t1)) {
            return t2;
        }
        return this.builtins.NOTHING;
    }

    public RType meet(Iterable<RType> types) {
        Objects.requireNonNull(types);
        Validate.noNullElements(types);
        RType acc = this.builtins.ANY;
        for (RType t : types) {
            if (!(acc = this.meet(acc, t)).equals(this.builtins.NOTHING)) continue;
            return acc;
        }
        return acc;
    }

    public boolean isSubtypeOf(RType sub, RType sup) {
        Objects.requireNonNull(sub);
        Objects.requireNonNull(sup);
        return this.typing.subtypeSucceeded(sub, sup);
    }

    public boolean isListSubtypeOf(RListType sub, RListType sup) {
        Objects.requireNonNull(sub);
        Objects.requireNonNull(sup);
        return this.typing.listSubtypeSucceeded(sub, sup);
    }

    public boolean isComparable(RType t1, RType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return this.typing.comparable(t1, t2);
    }

    public boolean isListComparable(RListType t1, RListType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return this.typing.listComparable(t1, t2);
    }

    public RType typeCallToRType(TypeCall typeCall) {
        return this.typeCallToRType(typeCall, new RosettaInterpreterContext());
    }

    public RType typeCallToRType(TypeCall typeCall, RosettaInterpreterContext context) {
        Objects.requireNonNull(typeCall);
        Objects.requireNonNull(context);
        return this.typing.typeCallToRType(typeCall, context);
    }

    public RType keepTypeAliasIfPossible(RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        Objects.requireNonNull(combineUnderlyingTypes);
        return this.typing.keepTypeAliasIfPossible(t1, t2, combineUnderlyingTypes);
    }

    public RType stripFromTypeAliases(RType t) {
        if (t instanceof RAliasType) {
            return this.stripFromTypeAliases(((RAliasType)t).getRefersTo());
        }
        return t;
    }
}

