/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import javax.inject.Inject;

public class TypeValidationUtil {
    @Inject
    TypeSystem typing;
    @Inject
    TypeFactory fac;
    @Inject
    RBuiltinTypeService service;

    public String notAListSubtypeMessage(RListType expected, RListType actual) {
        if (!this.typing.isSubtypeOf(actual.getItemType(), expected.getItemType())) {
            if (!(actual.getConstraint().isSubconstraintOf(expected.getConstraint()) || expected.isPlural() && actual.isPlural())) {
                return "Expected " + this.toCompleteDescription(expected, actual.getItemType()) + ", but got " + this.toCompleteDescription(actual, expected.getItemType()) + " instead.";
            }
            return this.notASubtypeMessage(expected.getItemType(), actual.getItemType());
        }
        return this.notLooserConstraintMessage(expected.getConstraint(), actual);
    }

    public String notASubtypeMessage(RType expected, RType actual) {
        return "Expected type `" + this.relevantItemTypeDescription(expected, actual) + "`, but got `" + this.relevantItemTypeDescription(actual, expected) + "` instead.";
    }

    public String notListComparableMessage(RListType left, RListType right) {
        if (!this.typing.isComparable(left.getItemType(), right.getItemType())) {
            return this.notComparableMessage(left.getItemType(), right.getItemType());
        }
        StringBuilder b = new StringBuilder().append("Cannot compare ").append(this.toConstraintDescription(left.getConstraint())).append(" to ").append(this.toConstraintDescription(right.getConstraint())).append(", as they cannot be of the same length.");
        if (left.isSingular() || right.isSingular()) {
            b.append(" Perhaps you forgot to write `all` or `any` in front of the operator?");
        }
        return b.toString();
    }

    public String notComparableMessage(RType left, RType right) {
        return "Types `" + this.relevantItemTypeDescription(left, right) + "` and `" + this.relevantItemTypeDescription(right, left) + "` are not comparable.";
    }

    public String bothAreSingularMessage(ModifiableBinaryOperation op) {
        return "The cardinality operator `" + (Object)((Object)op.getCardMod()) + "` is redundant when comparing two single values.";
    }

    public String notRightIsSingularButLeftIsMessage(RListType actual) {
        return "Expected " + this.toConstraintDescription(this.fac.single) + ", but got " + this.toConstraintDescription(actual.getConstraint()) + " instead. Perhaps you meant to swap the left and right operands?";
    }

    public String notConstraintMessage(RosettaCardinality expected, RListType actual) {
        return "Expected " + this.toConstraintDescription(expected) + ", but got " + this.toConstraintDescription(actual.getConstraint()) + " instead.";
    }

    public String wrongConstraintMessage(RosettaCardinality wrong, RListType actual) {
        return "May not be " + this.toConstraintDescription(wrong) + ".";
    }

    public String notLooserConstraintMessage(RosettaCardinality expected, RListType actual) {
        return "Expected " + this.toConstraintDescription(expected) + ", but got " + this.toConstraintDescription(actual.getConstraint()) + " instead.";
    }

    public CharSequence relevantItemTypeDescription(RType t, RType context) {
        if (t.getName().equals(context.getName())) {
            return t.toString();
        }
        return t.getName();
    }

    public CharSequence relevantItemTypeDescription(RListType t, RType context) {
        return this.relevantItemTypeDescription(t.getItemType(), context);
    }

    public CharSequence relevantItemTypeDescription(RListType t, RListType context) {
        return this.relevantItemTypeDescription(t.getItemType(), context.getItemType());
    }

    public CharSequence toShortDescription(RListType t, RType context) {
        StringBuilder b = new StringBuilder();
        if (t.isEmpty()) {
            if (t.getItemType().equals(this.service.NOTHING)) {
                return "an empty value";
            }
            b.append("an empty value of type");
        } else if (t.isOptional()) {
            b.append("an optional");
        } else if (t.isSingular()) {
            b.append("a single");
        } else {
            return b.append("a list of `").append(t.getItemType()).append("`s").toString();
        }
        return b.append(" `").append(this.relevantItemTypeDescription(t, context)).append("`").toString();
    }

    public CharSequence toConstraintDescription(RosettaCardinality c) {
        if (c.isEmpty()) {
            return "an empty value";
        }
        if (c.isOptional()) {
            return "an optional value";
        }
        if (c.isSingular()) {
            return "a single value";
        }
        StringBuilder b = new StringBuilder();
        if (c.isUnbounded()) {
            if (c.getInf() == 0) {
                b.append("an unbounded list of any length");
            } else {
                b.append("an unbounded list with at least ").append(c.getInf()).append(" item").append(this.pluralS(c.getInf()));
            }
        } else {
            b.append("a list with ");
            if (c.getInf() == c.getSup()) {
                b.append(c.getSup());
            } else {
                b.append(c.getInf()).append(" to ").append(c.getSup());
            }
            b.append(" item").append(this.pluralS(c.getSup()));
        }
        return b.toString();
    }

    public CharSequence toCompleteDescription(RListType t, RType context) {
        if (t.isPlural()) {
            StringBuilder b = new StringBuilder();
            RosettaCardinality c = t.getConstraint();
            if (c.isUnbounded()) {
                b.append("an unbounded list of `").append(this.relevantItemTypeDescription(t, context)).append("`s ");
                if (c.getInf() == 0) {
                    b.append("of any length");
                } else {
                    b.append("with at least ").append(c.getInf()).append(" item").append(this.pluralS(c.getInf()));
                }
            } else {
                b.append("a list of `").append(this.relevantItemTypeDescription(t, context)).append("`s with ");
                if (c.getInf() == c.getSup()) {
                    b.append(c.getSup());
                } else {
                    b.append(c.getInf()).append(" to ").append(c.getSup());
                }
                b.append(" item").append(this.pluralS(c.getSup()));
            }
            return b.toString();
        }
        return this.toShortDescription(t, context);
    }

    private String pluralS(int count) {
        return count == 1 ? "" : "s";
    }
}

