/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaBuiltinType;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.TypeCallArgument;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RParametrizedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.typing.RosettaTypingAuxiliary;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import com.rosetta.util.DottedPath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.XsemanticsProvider;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RosettaTyping
extends RosettaTypingAuxiliary {
    public static final String COMPARABLE = "com.regnosys.rosetta.typing.Comparable";
    public static final String LISTCOMPARABLE = "com.regnosys.rosetta.typing.ListComparable";
    public static final String SYMBOLLISTTYPE = "com.regnosys.rosetta.typing.SymbolListType";
    public static final String FUNCTIONALOPERATIONITEMTYPE = "com.regnosys.rosetta.typing.FunctionalOperationItemType";
    public static final String TYPEOFIMPLICITVARIABLE = "com.regnosys.rosetta.typing.TypeOfImplicitVariable";
    public static final String TYPEFUNCTIONOFTYPEALIAS = "com.regnosys.rosetta.typing.TypeFunctionOfTypeAlias";
    public static final String TYPECALLTORTYPE = "com.regnosys.rosetta.typing.TypeCallToRType";
    public static final String ATTRIBUTELISTTYPE = "com.regnosys.rosetta.typing.AttributeListType";
    public static final String SDATA = "com.regnosys.rosetta.typing.SData";
    public static final String SNUMBER = "com.regnosys.rosetta.typing.SNumber";
    public static final String SSTRING = "com.regnosys.rosetta.typing.SString";
    public static final String SBASIC = "com.regnosys.rosetta.typing.SBasic";
    public static final String SNOTHING = "com.regnosys.rosetta.typing.SNothing";
    public static final String SANY = "com.regnosys.rosetta.typing.SAny";
    public static final String SALIASBOTH = "com.regnosys.rosetta.typing.SAliasBoth";
    public static final String SALIASLEFT = "com.regnosys.rosetta.typing.SAliasLeft";
    public static final String SALIASRIGHT = "com.regnosys.rosetta.typing.SAliasRight";
    public static final String SALIASBASIC = "com.regnosys.rosetta.typing.SAliasBasic";
    public static final String SBASICALIAS = "com.regnosys.rosetta.typing.SBasicAlias";
    public static final String SREFL = "com.regnosys.rosetta.typing.SRefl";
    public static final String SLIST = "com.regnosys.rosetta.typing.SList";
    public static final String TBOOLEAN = "com.regnosys.rosetta.typing.TBoolean";
    public static final String TSTRING = "com.regnosys.rosetta.typing.TString";
    public static final String TNUMBER = "com.regnosys.rosetta.typing.TNumber";
    public static final String TINT = "com.regnosys.rosetta.typing.TInt";
    public static final String TPATTERN = "com.regnosys.rosetta.typing.TPattern";
    public static final String TVAR = "com.regnosys.rosetta.typing.TVar";
    public static final String TIT = "com.regnosys.rosetta.typing.TIt";
    public static final String TARITHMETIC = "com.regnosys.rosetta.typing.TArithmetic";
    public static final String TEQUALITY = "com.regnosys.rosetta.typing.TEquality";
    public static final String TLOGICAL = "com.regnosys.rosetta.typing.TLogical";
    public static final String TCOMPARISON = "com.regnosys.rosetta.typing.TComparison";
    public static final String TIF = "com.regnosys.rosetta.typing.TIf";
    public static final String TLIST = "com.regnosys.rosetta.typing.TList";
    public static final String TPROJECT = "com.regnosys.rosetta.typing.TProject";
    public static final String TEXISTS = "com.regnosys.rosetta.typing.TExists";
    public static final String TABSENT = "com.regnosys.rosetta.typing.TAbsent";
    public static final String TONLYEXISTS = "com.regnosys.rosetta.typing.TOnlyExists";
    public static final String TCOUNT = "com.regnosys.rosetta.typing.TCount";
    public static final String TONLYELEMENT = "com.regnosys.rosetta.typing.TOnlyElement";
    public static final String TASKEY = "com.regnosys.rosetta.typing.TAsKey";
    public static final String TONEOF = "com.regnosys.rosetta.typing.TOneOf";
    public static final String TCHOICE = "com.regnosys.rosetta.typing.TChoice";
    @Extension
    @Inject
    private TypeFactory typeFactory;
    @Extension
    @Inject
    private TypeValidationUtil util;
    @Extension
    @Inject
    private ExpressionHelper exprHelper;
    @Extension
    @Inject
    private ImplicitVariableUtil implicitVarUtil;
    @Extension
    @Inject
    private RBuiltinTypeService builtinTypes;
    @Inject
    private RosettaInterpreter interpreter;
    @Inject
    private RosettaSimpleSystemSolver systemSolver;
    private PolymorphicDispatcher<Boolean> comparableDispatcher;
    private PolymorphicDispatcher<Boolean> listComparableDispatcher;
    private PolymorphicDispatcher<RListType> symbolListTypeDispatcher;
    private PolymorphicDispatcher<RListType> functionalOperationItemTypeDispatcher;
    private PolymorphicDispatcher<Optional<RListType>> typeOfImplicitVariableDispatcher;
    private PolymorphicDispatcher<RTypeFunction> typeFunctionOfTypeAliasDispatcher;
    private PolymorphicDispatcher<RType> typeCallToRTypeDispatcher;
    private PolymorphicDispatcher<RListType> attributeListTypeDispatcher;
    private PolymorphicDispatcher<Result<RListType>> inferTypeDispatcher;
    private PolymorphicDispatcher<Result<Boolean>> subtypeDispatcher;
    private PolymorphicDispatcher<Result<Boolean>> listSubtypeDispatcher;

    public RosettaTyping() {
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.inferTypeDispatcher = this.buildPolymorphicDispatcher1("inferTypeImpl", 3, "|-", new String[]{":"});
        this.subtypeDispatcher = this.buildPolymorphicDispatcher1("subtypeImpl", 4, "|-", new String[]{"<:"});
        this.listSubtypeDispatcher = this.buildPolymorphicDispatcher1("listSubtypeImpl", 4, "|-", new String[]{"<|"});
        this.comparableDispatcher = this.buildPolymorphicDispatcher("comparableImpl", 3);
        this.listComparableDispatcher = this.buildPolymorphicDispatcher("listComparableImpl", 3);
        this.symbolListTypeDispatcher = this.buildPolymorphicDispatcher("symbolListTypeImpl", 2);
        this.functionalOperationItemTypeDispatcher = this.buildPolymorphicDispatcher("functionalOperationItemTypeImpl", 2);
        this.typeOfImplicitVariableDispatcher = this.buildPolymorphicDispatcher("typeOfImplicitVariableImpl", 2);
        this.typeFunctionOfTypeAliasDispatcher = this.buildPolymorphicDispatcher("typeFunctionOfTypeAliasImpl", 2);
        this.typeCallToRTypeDispatcher = this.buildPolymorphicDispatcher("typeCallToRTypeImpl", 3);
        this.attributeListTypeDispatcher = this.buildPolymorphicDispatcher("attributeListTypeImpl", 2);
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void setTypeFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public TypeValidationUtil getUtil() {
        return this.util;
    }

    @Override
    public void setUtil(TypeValidationUtil util) {
        this.util = util;
    }

    @Override
    public ExpressionHelper getExprHelper() {
        return this.exprHelper;
    }

    @Override
    public void setExprHelper(ExpressionHelper exprHelper) {
        this.exprHelper = exprHelper;
    }

    @Override
    public ImplicitVariableUtil getImplicitVarUtil() {
        return this.implicitVarUtil;
    }

    @Override
    public void setImplicitVarUtil(ImplicitVariableUtil implicitVarUtil) {
        this.implicitVarUtil = implicitVarUtil;
    }

    @Override
    public RBuiltinTypeService getBuiltinTypes() {
        return this.builtinTypes;
    }

    @Override
    public void setBuiltinTypes(RBuiltinTypeService builtinTypes) {
        this.builtinTypes = builtinTypes;
    }

    @Override
    public RosettaInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public void setInterpreter(RosettaInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public RosettaSimpleSystemSolver getSystemSolver() {
        return this.systemSolver;
    }

    @Override
    public void setSystemSolver(RosettaSimpleSystemSolver systemSolver) {
        this.systemSolver = systemSolver;
    }

    public Boolean comparable(RType t1, RType t2) throws RuleFailedException {
        return this.comparable(null, t1, t2);
    }

    public Boolean comparable(RuleApplicationTrace _trace_, RType t1, RType t2) throws RuleFailedException {
        try {
            return this.comparableInternal(_trace_, t1, t2);
        }
        catch (Exception _e_comparable) {
            throw this.extractRuleFailedException(_e_comparable);
        }
    }

    public Boolean listComparable(RListType t1, RListType t2) throws RuleFailedException {
        return this.listComparable(null, t1, t2);
    }

    public Boolean listComparable(RuleApplicationTrace _trace_, RListType t1, RListType t2) throws RuleFailedException {
        try {
            return this.listComparableInternal(_trace_, t1, t2);
        }
        catch (Exception _e_listComparable) {
            throw this.extractRuleFailedException(_e_listComparable);
        }
    }

    public RListType symbolListType(RosettaSymbol c) throws RuleFailedException {
        return this.symbolListType(null, c);
    }

    public RListType symbolListType(RuleApplicationTrace _trace_, RosettaSymbol c) throws RuleFailedException {
        try {
            return this.symbolListTypeInternal(_trace_, c);
        }
        catch (Exception _e_symbolListType) {
            throw this.extractRuleFailedException(_e_symbolListType);
        }
    }

    public RListType functionalOperationItemType(RosettaFunctionalOperation op) throws RuleFailedException {
        return this.functionalOperationItemType(null, op);
    }

    public RListType functionalOperationItemType(RuleApplicationTrace _trace_, RosettaFunctionalOperation op) throws RuleFailedException {
        try {
            return this.functionalOperationItemTypeInternal(_trace_, op);
        }
        catch (Exception _e_functionalOperationItemType) {
            throw this.extractRuleFailedException(_e_functionalOperationItemType);
        }
    }

    public Optional<RListType> typeOfImplicitVariable(EObject context) throws RuleFailedException {
        return this.typeOfImplicitVariable(null, context);
    }

    public Optional<RListType> typeOfImplicitVariable(RuleApplicationTrace _trace_, EObject context) throws RuleFailedException {
        try {
            return this.typeOfImplicitVariableInternal(_trace_, context);
        }
        catch (Exception _e_typeOfImplicitVariable) {
            throw this.extractRuleFailedException(_e_typeOfImplicitVariable);
        }
    }

    public RTypeFunction typeFunctionOfTypeAlias(RosettaTypeAlias typeAlias) throws RuleFailedException {
        return this.typeFunctionOfTypeAlias(null, typeAlias);
    }

    public RTypeFunction typeFunctionOfTypeAlias(RuleApplicationTrace _trace_, RosettaTypeAlias typeAlias) throws RuleFailedException {
        try {
            return this.typeFunctionOfTypeAliasInternal(_trace_, typeAlias);
        }
        catch (Exception _e_typeFunctionOfTypeAlias) {
            throw this.extractRuleFailedException(_e_typeFunctionOfTypeAlias);
        }
    }

    public RType typeCallToRType(TypeCall rt, RosettaInterpreterContext context) throws RuleFailedException {
        return this.typeCallToRType(null, rt, context);
    }

    public RType typeCallToRType(RuleApplicationTrace _trace_, TypeCall rt, RosettaInterpreterContext context) throws RuleFailedException {
        try {
            return this.typeCallToRTypeInternal(_trace_, rt, context);
        }
        catch (Exception _e_typeCallToRType) {
            throw this.extractRuleFailedException(_e_typeCallToRType);
        }
    }

    public RListType attributeListType(Attribute a) throws RuleFailedException {
        return this.attributeListType(null, a);
    }

    public RListType attributeListType(RuleApplicationTrace _trace_, Attribute a) throws RuleFailedException {
        try {
            return this.attributeListTypeInternal(_trace_, a);
        }
        catch (Exception _e_attributeListType) {
            throw this.extractRuleFailedException(_e_attributeListType);
        }
    }

    public Result<RListType> inferType(RosettaExpression expression) {
        return this.inferType(new RuleEnvironment(), null, expression);
    }

    public Result<RListType> inferType(RuleEnvironment _environment_, RosettaExpression expression) {
        return this.inferType(_environment_, null, expression);
    }

    public Result<RListType> inferType(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RosettaExpression expression) {
        return (Result)this.getFromCache("inferType", _environment_, _trace_, (XsemanticsProvider)new XsemanticsProvider<Result<RListType>>(_environment_, _trace_){

            public Result<RListType> doGet() {
                try {
                    return RosettaTyping.this.inferTypeInternal(_environment_, _trace_, expression);
                }
                catch (Exception _e_inferType) {
                    return RosettaTyping.this.resultForFailure(_e_inferType);
                }
            }
        }, new Object[]{expression});
    }

    public Result<Boolean> subtype(RType subtype, RType supertype) {
        return this.subtype(new RuleEnvironment(), null, subtype, supertype);
    }

    public Result<Boolean> subtype(RuleEnvironment _environment_, RType subtype, RType supertype) {
        return this.subtype(_environment_, null, subtype, supertype);
    }

    public Result<Boolean> subtype(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RType subtype, RType supertype) {
        try {
            return this.subtypeInternal(_environment_, _trace_, subtype, supertype);
        }
        catch (Exception _e_subtype) {
            return this.resultForFailure(_e_subtype);
        }
    }

    public Boolean subtypeSucceeded(RType subtype, RType supertype) {
        return this.subtypeSucceeded(new RuleEnvironment(), null, subtype, supertype);
    }

    public Boolean subtypeSucceeded(RuleEnvironment _environment_, RType subtype, RType supertype) {
        return this.subtypeSucceeded(_environment_, null, subtype, supertype);
    }

    public Boolean subtypeSucceeded(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RType subtype, RType supertype) {
        try {
            this.subtypeInternal(_environment_, _trace_, subtype, supertype);
            return true;
        }
        catch (Exception _e_subtype) {
            return false;
        }
    }

    public Result<Boolean> listSubtype(RListType subtype, RListType supertype) {
        return this.listSubtype(new RuleEnvironment(), null, subtype, supertype);
    }

    public Result<Boolean> listSubtype(RuleEnvironment _environment_, RListType subtype, RListType supertype) {
        return this.listSubtype(_environment_, null, subtype, supertype);
    }

    public Result<Boolean> listSubtype(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RListType subtype, RListType supertype) {
        try {
            return this.listSubtypeInternal(_environment_, _trace_, subtype, supertype);
        }
        catch (Exception _e_listSubtype) {
            return this.resultForFailure(_e_listSubtype);
        }
    }

    public Boolean listSubtypeSucceeded(RListType subtype, RListType supertype) {
        return this.listSubtypeSucceeded(new RuleEnvironment(), null, subtype, supertype);
    }

    public Boolean listSubtypeSucceeded(RuleEnvironment _environment_, RListType subtype, RListType supertype) {
        return this.listSubtypeSucceeded(_environment_, null, subtype, supertype);
    }

    public Boolean listSubtypeSucceeded(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RListType subtype, RListType supertype) {
        try {
            this.listSubtypeInternal(_environment_, _trace_, subtype, supertype);
            return true;
        }
        catch (Exception _e_listSubtype) {
            return false;
        }
    }

    protected Boolean comparableInternal(RuleApplicationTrace _trace_, RType t1, RType t2) {
        try {
            this.checkParamsNotNull(new Object[]{t1, t2});
            return (Boolean)this.comparableDispatcher.invoke(new Object[]{_trace_, t1, t2});
        }
        catch (Exception _e_comparable) {
            this.sneakyThrowRuleFailedException(_e_comparable);
            return false;
        }
    }

    protected void comparableThrowException(String _error, String _issue, Exception _ex, RType t1, RType t2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean listComparableInternal(RuleApplicationTrace _trace_, RListType t1, RListType t2) {
        try {
            this.checkParamsNotNull(new Object[]{t1, t2});
            return (Boolean)this.listComparableDispatcher.invoke(new Object[]{_trace_, t1, t2});
        }
        catch (Exception _e_listComparable) {
            this.sneakyThrowRuleFailedException(_e_listComparable);
            return false;
        }
    }

    protected void listComparableThrowException(String _error, String _issue, Exception _ex, RListType t1, RListType t2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RListType symbolListTypeInternal(RuleApplicationTrace _trace_, RosettaSymbol c) {
        try {
            this.checkParamsNotNull(new Object[]{c});
            return (RListType)this.symbolListTypeDispatcher.invoke(new Object[]{_trace_, c});
        }
        catch (Exception _e_symbolListType) {
            this.sneakyThrowRuleFailedException(_e_symbolListType);
            return null;
        }
    }

    protected void symbolListTypeThrowException(String _error, String _issue, Exception _ex, RosettaSymbol c, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RListType functionalOperationItemTypeInternal(RuleApplicationTrace _trace_, RosettaFunctionalOperation op) {
        try {
            this.checkParamsNotNull(new Object[]{op});
            return (RListType)this.functionalOperationItemTypeDispatcher.invoke(new Object[]{_trace_, op});
        }
        catch (Exception _e_functionalOperationItemType) {
            this.sneakyThrowRuleFailedException(_e_functionalOperationItemType);
            return null;
        }
    }

    protected void functionalOperationItemTypeThrowException(String _error, String _issue, Exception _ex, RosettaFunctionalOperation op, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Optional<RListType> typeOfImplicitVariableInternal(RuleApplicationTrace _trace_, EObject context) {
        try {
            this.checkParamsNotNull(new Object[]{context});
            return (Optional)this.typeOfImplicitVariableDispatcher.invoke(new Object[]{_trace_, context});
        }
        catch (Exception _e_typeOfImplicitVariable) {
            this.sneakyThrowRuleFailedException(_e_typeOfImplicitVariable);
            return null;
        }
    }

    protected void typeOfImplicitVariableThrowException(String _error, String _issue, Exception _ex, EObject context, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RTypeFunction typeFunctionOfTypeAliasInternal(final RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) {
        return (RTypeFunction)((Object)this.getFromCache("typeFunctionOfTypeAliasInternal", null, _trace_, (XsemanticsProvider)new XsemanticsProvider<RTypeFunction>(null, _trace_){

            public RTypeFunction doGet() {
                try {
                    RosettaTyping.this.checkParamsNotNull(new Object[]{typeAlias});
                    return (RTypeFunction)((Object)RosettaTyping.this.typeFunctionOfTypeAliasDispatcher.invoke(new Object[]{_trace_, typeAlias}));
                }
                catch (Exception _e_typeFunctionOfTypeAlias) {
                    RosettaTyping.this.sneakyThrowRuleFailedException(_e_typeFunctionOfTypeAlias);
                    return null;
                }
            }
        }, new Object[]{typeAlias}));
    }

    protected void typeFunctionOfTypeAliasThrowException(String _error, String _issue, Exception _ex, RosettaTypeAlias typeAlias, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RType typeCallToRTypeInternal(RuleApplicationTrace _trace_, TypeCall rt, RosettaInterpreterContext context) {
        try {
            this.checkParamsNotNull(new Object[]{rt, context});
            return (RType)this.typeCallToRTypeDispatcher.invoke(new Object[]{_trace_, rt, context});
        }
        catch (Exception _e_typeCallToRType) {
            this.sneakyThrowRuleFailedException(_e_typeCallToRType);
            return null;
        }
    }

    protected void typeCallToRTypeThrowException(String _error, String _issue, Exception _ex, TypeCall rt, RosettaInterpreterContext context, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RListType attributeListTypeInternal(RuleApplicationTrace _trace_, Attribute a) {
        try {
            this.checkParamsNotNull(new Object[]{a});
            return (RListType)this.attributeListTypeDispatcher.invoke(new Object[]{_trace_, a});
        }
        catch (Exception _e_attributeListType) {
            this.sneakyThrowRuleFailedException(_e_attributeListType);
            return null;
        }
    }

    protected void attributeListTypeThrowException(String _error, String _issue, Exception _ex, Attribute a, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Result<RListType> inferTypeInternal(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RosettaExpression expression) {
        return (Result)this.getFromCache("inferTypeInternal", _environment_, _trace_, (XsemanticsProvider)new XsemanticsProvider<Result<RListType>>(_environment_, _trace_){

            public Result<RListType> doGet() {
                try {
                    RosettaTyping.this.checkParamsNotNull(new Object[]{expression});
                    return (Result)RosettaTyping.this.inferTypeDispatcher.invoke(new Object[]{_environment_, _trace_, expression});
                }
                catch (Exception _e_inferType) {
                    RosettaTyping.this.sneakyThrowRuleFailedException(_e_inferType);
                    return null;
                }
            }
        }, new Object[]{expression});
    }

    protected void inferTypeThrowException(String _error, String _issue, Exception _ex, RosettaExpression expression, ErrorInformation[] _errorInformations) throws RuleFailedException {
        String _plus_1;
        String _stringRep = this.stringRep(expression);
        String _plus = "Cannot type " + _stringRep;
        String error = _plus_1 = _plus + ".";
        RosettaExpression source = expression;
        this.throwRuleFailedException(error, _issue, _ex, new ErrorInformation[]{new ErrorInformation((EObject)source, null)});
    }

    protected Result<Boolean> subtypeInternal(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RType subtype, RType supertype) {
        try {
            this.checkParamsNotNull(new Object[]{subtype, supertype});
            return (Result)this.subtypeDispatcher.invoke(new Object[]{_environment_, _trace_, subtype, supertype});
        }
        catch (Exception _e_subtype) {
            this.sneakyThrowRuleFailedException(_e_subtype);
            return null;
        }
    }

    protected void subtypeThrowException(String _error, String _issue, Exception _ex, RType subtype, RType supertype, ErrorInformation[] _errorInformations) throws RuleFailedException {
        String _plus_1;
        String _plus = subtype + " is not a subtype of ";
        String error = _plus_1 = _plus + supertype;
        this.throwRuleFailedException(error, _issue, _ex, new ErrorInformation[]{new ErrorInformation(null, null)});
    }

    protected Result<Boolean> listSubtypeInternal(RuleEnvironment _environment_, RuleApplicationTrace _trace_, RListType subtype, RListType supertype) {
        try {
            this.checkParamsNotNull(new Object[]{subtype, supertype});
            return (Result)this.listSubtypeDispatcher.invoke(new Object[]{_environment_, _trace_, subtype, supertype});
        }
        catch (Exception _e_listSubtype) {
            this.sneakyThrowRuleFailedException(_e_listSubtype);
            return null;
        }
    }

    protected void listSubtypeThrowException(String _error, String _issue, Exception _ex, RListType subtype, RListType supertype, ErrorInformation[] _errorInformations) throws RuleFailedException {
        String _plus_1;
        String _plus = subtype + " is not a list subtype of ";
        String error = _plus_1 = _plus + supertype;
        this.throwRuleFailedException(error, _issue, _ex, new ErrorInformation[]{new ErrorInformation(null, null)});
    }

    protected Boolean comparableImpl(RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunComparable(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("comparable") + "(" + RosettaTyping.this.stringRep(t1) + ", " + RosettaTyping.this.stringRep(t2) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunComparable) {
            this.comparableThrowException(this.auxFunName("comparable") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", COMPARABLE, e_applyAuxFunComparable, t1, t2, new ErrorInformation[0]);
            return false;
        }
    }

    protected Boolean applyAuxFunComparable(RuleApplicationTrace _trace_, RType t1, RType t2) throws RuleFailedException {
        RuleFailedException previousFailure = null;
        try {
            this.subtypeInternal(this.emptyEnvironment(), _trace_, t1, t2);
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            try {
                this.subtypeInternal(this.emptyEnvironment(), _trace_, t2, t1);
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                return false;
            }
        }
        return true;
    }

    protected Boolean listComparableImpl(RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunListComparable(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("listComparable") + "(" + RosettaTyping.this.stringRep(t1) + ", " + RosettaTyping.this.stringRep(t2) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunListComparable) {
            this.listComparableThrowException(this.auxFunName("listComparable") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", LISTCOMPARABLE, e_applyAuxFunListComparable, t1, t2, new ErrorInformation[0]);
            return false;
        }
    }

    protected Boolean applyAuxFunListComparable(RuleApplicationTrace _trace_, RListType t1, RListType t2) throws RuleFailedException {
        Boolean _overlap;
        Boolean _comparable = this.comparableInternal(_trace_, t1.getItemType(), t2.getItemType());
        if (!_comparable.booleanValue()) {
            this.sneakyThrowRuleFailedException("comparable(t1.itemType, t2.itemType)");
        }
        if (!(_overlap = this.overlapInternal(_trace_, t1.getConstraint(), t2.getConstraint())).booleanValue()) {
            this.sneakyThrowRuleFailedException("overlap(t1.constraint, t2.constraint)");
        }
        return true;
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final Attribute c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, Attribute c) throws RuleFailedException {
        return this.attributeListTypeInternal(_trace_, c);
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final ClosureParameter c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, ClosureParameter c) throws RuleFailedException {
        InlineFunction f = c.getFunction();
        EObject _eContainer = f.eContainer();
        RosettaFunctionalOperation op = (RosettaFunctionalOperation)_eContainer;
        return this.functionalOperationItemTypeInternal(_trace_, op);
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final RosettaEnumeration c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, RosettaEnumeration c) throws RuleFailedException {
        REnumType _rEnumType = new REnumType(c);
        return this.typeFactory.createListType((RType)_rEnumType, this.typeFactory.single);
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final ShortcutDeclaration c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, ShortcutDeclaration c) throws RuleFailedException {
        RosettaExpression _expression = c.getExpression();
        RListType t = null;
        Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _expression);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        t = (RListType)result.getFirst();
        return t;
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final RosettaExternalFunction c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, RosettaExternalFunction c) throws RuleFailedException {
        TypeCall _typeCall = c.getTypeCall();
        RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
        return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), 1, 1);
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final com.regnosys.rosetta.rosetta.simple.Function c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, com.regnosys.rosetta.rosetta.simple.Function c) throws RuleFailedException {
        TypeCall _typeCall = c.getOutput().getTypeCall();
        RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
        return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), c.getOutput().getCard());
    }

    protected RListType symbolListTypeImpl(RuleApplicationTrace _trace_, final RosettaRule c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunSymbolListType(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("symbolListType") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSymbolListType) {
            this.symbolListTypeThrowException(this.auxFunName("symbolListType") + "(" + this.stringRep(c) + ")", SYMBOLLISTTYPE, e_applyAuxFunSymbolListType, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected RListType applyAuxFunSymbolListType(RuleApplicationTrace _trace_, RosettaRule c) throws RuleFailedException {
        RosettaExpression _expression = c.getExpression();
        RListType t = null;
        Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _expression);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        t = (RListType)result.getFirst();
        return t;
    }

    protected RListType functionalOperationItemTypeImpl(RuleApplicationTrace _trace_, final RosettaFunctionalOperation op) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunFunctionalOperationItemType(_subtrace_, op);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("functionalOperationItemType") + "(" + RosettaTyping.this.stringRep(op) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunFunctionalOperationItemType) {
            this.functionalOperationItemTypeThrowException(this.auxFunName("functionalOperationItemType") + "(" + this.stringRep(op) + ")", FUNCTIONALOPERATIONITEMTYPE, e_applyAuxFunFunctionalOperationItemType, op, new ErrorInformation[]{new ErrorInformation((EObject)op)});
            return null;
        }
    }

    protected RListType applyAuxFunFunctionalOperationItemType(RuleApplicationTrace _trace_, RosettaFunctionalOperation op) throws RuleFailedException {
        RListType receiverType = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _argument = op.getArgument();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _argument);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            receiverType = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            receiverType = null;
        }
        if (receiverType != null) {
            if (op instanceof ThenOperation) {
                return receiverType;
            }
            return this.typeFactory.createListType(receiverType.getItemType(), this.typeFactory.single);
        }
        return null;
    }

    protected Optional<RListType> typeOfImplicitVariableImpl(RuleApplicationTrace _trace_, final EObject c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Optional<RListType> _result_ = this.applyAuxFunTypeOfImplicitVariable(_subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("typeOfImplicitVariable") + "(" + RosettaTyping.this.stringRep(c) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunTypeOfImplicitVariable) {
            this.typeOfImplicitVariableThrowException(this.auxFunName("typeOfImplicitVariable") + "(" + this.stringRep(c) + ")", TYPEOFIMPLICITVARIABLE, e_applyAuxFunTypeOfImplicitVariable, c, new ErrorInformation[]{new ErrorInformation(c)});
            return null;
        }
    }

    protected Optional<RListType> applyAuxFunTypeOfImplicitVariable(RuleApplicationTrace _trace_, EObject c) throws RuleFailedException {
        Optional<RListType> _xblockexpression = null;
        Optional<EObject> definingContainer = this.implicitVarUtil.findContainerDefiningImplicitVariable(c);
        Function<EObject, RListType> _function = it -> {
            RListType _xifexpression = null;
            if (it instanceof Data) {
                RDataType _rDataType = new RDataType((Data)it);
                _xifexpression = this.typeFactory.createListType((RType)_rDataType, this.typeFactory.single);
            } else {
                RListType _xifexpression_1 = null;
                if (it instanceof RosettaFunctionalOperation) {
                    _xifexpression_1 = this.functionalOperationItemTypeInternal(_trace_, (RosettaFunctionalOperation)it);
                } else {
                    RListType _xifexpression_2 = null;
                    if (it instanceof RosettaRule) {
                        TypeCall _input = ((RosettaRule)it).getInput();
                        RType _typeCallToRType = null;
                        if (_input != null) {
                            RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
                            _typeCallToRType = this.typeCallToRTypeInternal(_trace_, _input, _rosettaInterpreterContext);
                        }
                        RListType _createListType = null;
                        if (_typeCallToRType != null) {
                            _createListType = this.typeFactory.createListType(_typeCallToRType, this.typeFactory.single);
                        }
                        _xifexpression_2 = _createListType;
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        };
        _xblockexpression = definingContainer.map(_function);
        return _xblockexpression;
    }

    protected RTypeFunction typeFunctionOfTypeAliasImpl(RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RTypeFunction _result_ = this.applyAuxFunTypeFunctionOfTypeAlias(_subtrace_, typeAlias);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("typeFunctionOfTypeAlias") + "(" + RosettaTyping.this.stringRep(typeAlias) + ") = " + RosettaTyping.this.stringRep((Object)_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunTypeFunctionOfTypeAlias) {
            this.typeFunctionOfTypeAliasThrowException(this.auxFunName("typeFunctionOfTypeAlias") + "(" + this.stringRep(typeAlias) + ")", TYPEFUNCTIONOFTYPEALIAS, e_applyAuxFunTypeFunctionOfTypeAlias, typeAlias, new ErrorInformation[]{new ErrorInformation((EObject)typeAlias)});
            return null;
        }
    }

    protected RTypeFunction applyAuxFunTypeFunctionOfTypeAlias(RuleApplicationTrace _trace_, RosettaTypeAlias typeAlias) throws RuleFailedException {
        String _name = typeAlias.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)this.builtinTypes.INT_NAME);
        if (_equals) {
            return this.builtinTypes.INT_FUNCTION;
        }
        EList parameters = typeAlias.getParameters();
        DottedPath namespace = DottedPath.splitOnDots((String)typeAlias.getModel().getName());
        Functions.Function1 _function = arg -> {
            RosettaSymbolReference ref = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
            ref.setGenerated(true);
            ref.setSymbol(arg.getParameter());
            RosettaExpression _value = arg.getValue();
            return new RosettaSimpleSystemSolver.Equation(ref, _value);
        };
        List equations = IterableExtensions.toList((Iterable)ListExtensions.map(typeAlias.getTypeCall().getArguments(), (Functions.Function1)_function));
        Function<RosettaSimpleSystemSolver.SolutionSet, RTypeFunction> _function_1 = solutionSet -> {
            Function<Map<String, RosettaValue>, RType> _function_2 = arguments -> this.typeCallToRTypeInternal(_trace_, typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
            Function<RType, Optional<LinkedHashMap<String, RosettaValue>>> _function_3 = type -> {
                if (!(type instanceof RParametrizedType)) {
                    return Optional.empty();
                }
                RosettaInterpreterContext context = RosettaInterpreterContext.of(((RParametrizedType)type).getArguments());
                Function<Map, LinkedHashMap> _function_4 = solution -> {
                    LinkedHashMap newArgs = CollectionLiterals.newLinkedHashMap();
                    Consumer<TypeParameter> _function_5 = p -> newArgs.put(p.getName(), (RosettaValue)solution.get(p));
                    parameters.forEach(_function_5);
                    return newArgs;
                };
                return solutionSet.getSolution(context).map(_function_4);
            };
            return RTypeFunction.create(namespace, typeAlias.getName(), _function_2, _function_3);
        };
        Supplier<RTypeFunction> _function_2 = () -> {
            Function<Map<String, RosettaValue>, RType> _function_3 = arguments -> this.typeCallToRTypeInternal(_trace_, typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
            Function<RType, Optional<LinkedHashMap<String, RosettaValue>>> _function_4 = it -> Optional.empty();
            return RTypeFunction.create(namespace, typeAlias.getName(), _function_3, _function_4);
        };
        return this.systemSolver.solve(equations, IterableExtensions.toSet((Iterable)parameters)).map(_function_1).orElseGet(_function_2);
    }

    protected RType typeCallToRTypeImpl(RuleApplicationTrace _trace_, final TypeCall call, final RosettaInterpreterContext context) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunTypeCallToRType(_subtrace_, call, context);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("typeCallToRType") + "(" + RosettaTyping.this.stringRep(call) + ", " + RosettaTyping.this.stringRep(context) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunTypeCallToRType) {
            this.typeCallToRTypeThrowException(this.auxFunName("typeCallToRType") + "(" + this.stringRep(call) + ", " + this.stringRep(context) + ")", TYPECALLTORTYPE, e_applyAuxFunTypeCallToRType, call, context, new ErrorInformation[]{new ErrorInformation((EObject)call)});
            return null;
        }
    }

    protected RType applyAuxFunTypeCallToRType(RuleApplicationTrace _trace_, TypeCall call, RosettaInterpreterContext context) throws RuleFailedException {
        Map argMap;
        Functions.Function1 _function_1;
        Functions.Function1 _function;
        RType _xblockexpression_1;
        RDataType _xblockexpression = null;
        RosettaType t = call.getType();
        RType _switchResult = null;
        boolean _matched = false;
        if (t instanceof Data) {
            _matched = true;
            _switchResult = new RDataType((Data)t);
        }
        if (!_matched && t instanceof RosettaBuiltinType) {
            _matched = true;
            _xblockexpression_1 = null;
            _function = it -> it.getParameter().getName();
            _function_1 = it -> this.interpreter.interpret(it.getValue(), context);
            argMap = IterableExtensions.toMap(call.getArguments(), (Functions.Function1)_function, (Functions.Function1)_function_1);
            _xblockexpression_1 = this.builtinTypes.getType(((RosettaBuiltinType)t).getName(), (Map<String, RosettaValue>)argMap).orElse(null);
            _switchResult = _xblockexpression_1;
        }
        if (!_matched && t instanceof RosettaEnumeration) {
            _matched = true;
            _switchResult = new REnumType((RosettaEnumeration)t);
        }
        if (!_matched && t instanceof RosettaMetaType) {
            _matched = true;
            _xblockexpression_1 = null;
            _function = it -> it.getParameter().getName();
            _function_1 = it -> this.interpreter.interpret(it.getValue(), context);
            argMap = IterableExtensions.toMap(call.getArguments(), (Functions.Function1)_function, (Functions.Function1)_function_1);
            Optional<RType> builtinResult = this.builtinTypes.getType(((RosettaMetaType)t).getName(), (Map<String, RosettaValue>)argMap);
            RType _xifexpression = null;
            boolean _isPresent = builtinResult.isPresent();
            _xifexpression = _isPresent ? builtinResult.get() : this.typeCallToRTypeInternal(_trace_, ((RosettaMetaType)t).getTypeCall(), context);
            _xblockexpression_1 = _xifexpression;
            _switchResult = _xblockexpression_1;
        }
        if (!_matched && t instanceof RosettaTypeAlias) {
            _matched = true;
            _xblockexpression_1 = null;
            LinkedHashMap args = CollectionLiterals.newLinkedHashMap();
            Set absentParameters = IterableExtensions.toSet((Iterable)((RosettaTypeAlias)t).getParameters());
            Consumer<TypeCallArgument> _function2 = arg -> {
                RosettaValue eval = this.interpreter.interpret(arg.getValue(), context);
                args.put(arg.getParameter().getName(), eval);
                absentParameters.remove(arg.getParameter());
            };
            call.getArguments().forEach(_function2);
            Consumer<TypeParameter> _function_12 = it -> args.put(it.getName(), RosettaValue.empty());
            absentParameters.forEach(_function_12);
            RType refersTo = this.typeCallToRTypeInternal(_trace_, ((RosettaTypeAlias)t).getTypeCall(), RosettaInterpreterContext.of(args));
            RTypeFunction _typeFunctionOfTypeAlias = this.typeFunctionOfTypeAliasInternal(_trace_, (RosettaTypeAlias)t);
            _xblockexpression_1 = new RAliasType(_typeFunctionOfTypeAlias, args, refersTo);
            _switchResult = _xblockexpression_1;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected RListType attributeListTypeImpl(RuleApplicationTrace _trace_, final Attribute a) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunAttributeListType(_subtrace_, a);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.auxFunName("attributeListType") + "(" + RosettaTyping.this.stringRep(a) + ") = " + RosettaTyping.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAttributeListType) {
            this.attributeListTypeThrowException(this.auxFunName("attributeListType") + "(" + this.stringRep(a) + ")", ATTRIBUTELISTTYPE, e_applyAuxFunAttributeListType, a, new ErrorInformation[]{new ErrorInformation((EObject)a)});
            return null;
        }
    }

    protected RListType applyAuxFunAttributeListType(RuleApplicationTrace _trace_, Attribute a) throws RuleFailedException {
        TypeCall _typeCall = a.getTypeCall();
        RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
        return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), a.getCard());
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSData(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SData") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSData) {
            this.subtypeThrowException(this.ruleName("SData") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SDATA, e_applyRuleSData, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSData(RuleEnvironment G, RuleApplicationTrace _trace_, RDataType t1, RDataType t2) throws RuleFailedException {
        block3: {
            RuleFailedException previousFailure = null;
            try {
                if (!Objects.equal((Object)t1, (Object)t2)) {
                    this.sneakyThrowRuleFailedException("t1 == t2");
                }
            }
            catch (Exception e) {
                previousFailure = this.extractRuleFailedException(e);
                if (this.ancestorsInternal(_trace_, t1.getData()).contains(t2.getData())) break block3;
                this.sneakyThrowRuleFailedException("ancestors(t1.^data).contains(t2.^data)");
            }
        }
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSNumber(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SNumber") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSNumber) {
            this.subtypeThrowException(this.ruleName("SNumber") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SNUMBER, e_applyRuleSNumber, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSNumber(RuleEnvironment G, RuleApplicationTrace _trace_, RNumberType t1, RNumberType t2) throws RuleFailedException {
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSString(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SString") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSString) {
            this.subtypeThrowException(this.ruleName("SString") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SSTRING, e_applyRuleSString, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSString(RuleEnvironment G, RuleApplicationTrace _trace_, RStringType t1, RStringType t2) throws RuleFailedException {
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSBasic(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SBasic") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSBasic) {
            this.subtypeThrowException(this.ruleName("SBasic") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SBASIC, e_applyRuleSBasic, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSBasic(RuleEnvironment G, RuleApplicationTrace _trace_, RBasicType t1, RBasicType t2) throws RuleFailedException {
        block6: {
            RuleFailedException previousFailure = null;
            try {
                if (!Objects.equal((Object)t1, (Object)t2)) {
                    this.sneakyThrowRuleFailedException("t1 == t2");
                }
            }
            catch (Exception e) {
                previousFailure = this.extractRuleFailedException(e);
                try {
                    if (!Objects.equal((Object)t1, (Object)this.builtinTypes.NOTHING)) {
                        this.sneakyThrowRuleFailedException("t1 == NOTHING");
                    }
                }
                catch (Exception e_1) {
                    previousFailure = this.extractRuleFailedException(e_1);
                    if (Objects.equal((Object)t2, (Object)this.builtinTypes.ANY)) break block6;
                    this.sneakyThrowRuleFailedException("t2 == ANY");
                }
            }
        }
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSNothing(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SNothing") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSNothing) {
            this.subtypeThrowException(this.ruleName("SNothing") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SNOTHING, e_applyRuleSNothing, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSNothing(RuleEnvironment G, RuleApplicationTrace _trace_, RBasicType t1, RType t2) throws RuleFailedException {
        block3: {
            RuleFailedException previousFailure = null;
            try {
                if (!Objects.equal((Object)t1, (Object)t2)) {
                    this.sneakyThrowRuleFailedException("t1 == t2");
                }
            }
            catch (Exception e) {
                previousFailure = this.extractRuleFailedException(e);
                if (Objects.equal((Object)t1, (Object)this.builtinTypes.NOTHING)) break block3;
                this.sneakyThrowRuleFailedException("t1 == NOTHING");
            }
        }
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSAny(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SAny") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSAny) {
            this.subtypeThrowException(this.ruleName("SAny") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SANY, e_applyRuleSAny, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSAny(RuleEnvironment G, RuleApplicationTrace _trace_, RType t1, RBasicType t2) throws RuleFailedException {
        block3: {
            RuleFailedException previousFailure = null;
            try {
                if (!Objects.equal((Object)t1, (Object)t2)) {
                    this.sneakyThrowRuleFailedException("t1 == t2");
                }
            }
            catch (Exception e) {
                previousFailure = this.extractRuleFailedException(e);
                if (Objects.equal((Object)t2, (Object)this.builtinTypes.ANY)) break block3;
                this.sneakyThrowRuleFailedException("t2 == ANY");
            }
        }
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSAliasBoth(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SAliasBoth") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSAliasBoth) {
            this.subtypeThrowException(this.ruleName("SAliasBoth") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SALIASBOTH, e_applyRuleSAliasBoth, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSAliasBoth(RuleEnvironment G, RuleApplicationTrace _trace_, RAliasType t1, RAliasType t2) throws RuleFailedException {
        RType _refersTo = t1.getRefersTo();
        RType _refersTo_1 = t2.getRefersTo();
        this.subtypeInternal(G, _trace_, _refersTo, _refersTo_1);
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSAliasLeft(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SAliasLeft") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSAliasLeft) {
            this.subtypeThrowException(this.ruleName("SAliasLeft") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SALIASLEFT, e_applyRuleSAliasLeft, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSAliasLeft(RuleEnvironment G, RuleApplicationTrace _trace_, RAliasType t1, RType t2) throws RuleFailedException {
        RType _refersTo = t1.getRefersTo();
        this.subtypeInternal(G, _trace_, _refersTo, t2);
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSAliasRight(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SAliasRight") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSAliasRight) {
            this.subtypeThrowException(this.ruleName("SAliasRight") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SALIASRIGHT, e_applyRuleSAliasRight, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSAliasRight(RuleEnvironment G, RuleApplicationTrace _trace_, RType t1, RAliasType t2) throws RuleFailedException {
        RType _refersTo = t2.getRefersTo();
        this.subtypeInternal(G, _trace_, t1, _refersTo);
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSAliasBasic(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SAliasBasic") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSAliasBasic) {
            this.subtypeThrowException(this.ruleName("SAliasBasic") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SALIASBASIC, e_applyRuleSAliasBasic, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSAliasBasic(RuleEnvironment G, RuleApplicationTrace _trace_, RAliasType t1, RBasicType t2) throws RuleFailedException {
        RType _refersTo = t1.getRefersTo();
        this.subtypeInternal(G, _trace_, _refersTo, t2);
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSBasicAlias(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SBasicAlias") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSBasicAlias) {
            this.subtypeThrowException(this.ruleName("SBasicAlias") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SBASICALIAS, e_applyRuleSBasicAlias, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSBasicAlias(RuleEnvironment G, RuleApplicationTrace _trace_, RBasicType t1, RAliasType t2) throws RuleFailedException {
        RType _refersTo = t2.getRefersTo();
        this.subtypeInternal(G, _trace_, t1, _refersTo);
        return new Result((Object)true);
    }

    protected Result<Boolean> subtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSRefl(G, _subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SRefl") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(t1) + " <: " + RosettaTyping.this.stringRep(t2);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSRefl) {
            this.subtypeThrowException(this.ruleName("SRefl") + this.stringRepForEnv(G) + " |- " + this.stringRep(t1) + " <: " + this.stringRep(t2), SREFL, e_applyRuleSRefl, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSRefl(RuleEnvironment G, RuleApplicationTrace _trace_, RType t1, RType t2) throws RuleFailedException {
        if (!Objects.equal((Object)t1, (Object)t2)) {
            this.sneakyThrowRuleFailedException("t1 == t2");
        }
        return new Result((Object)true);
    }

    protected Result<Boolean> listSubtypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RListType s, final RListType t) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            Result<Boolean> _result_ = this.applyRuleSList(G, _subtrace_, s, t);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("SList") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(s) + " <| " + RosettaTyping.this.stringRep(t);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleSList) {
            this.listSubtypeThrowException(this.ruleName("SList") + this.stringRepForEnv(G) + " |- " + this.stringRep(s) + " <| " + this.stringRep(t), SLIST, e_applyRuleSList, s, t, new ErrorInformation[0]);
            return null;
        }
    }

    protected Result<Boolean> applyRuleSList(RuleEnvironment G, RuleApplicationTrace _trace_, RListType s, RListType t) throws RuleFailedException {
        RType _itemType = s.getItemType();
        RType _itemType_1 = t.getItemType();
        this.subtypeInternal(G, _trace_, _itemType, _itemType_1);
        if (!s.getConstraint().isSubconstraintOf(t.getConstraint())) {
            this.sneakyThrowRuleFailedException("s.constraint.isSubconstraintOf(t.constraint)");
        }
        return new Result((Object)true);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaBooleanLiteral bool) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTBoolean(G, _subtrace_, bool);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TBoolean") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(bool) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTBoolean) {
            this.inferTypeThrowException(this.ruleName("TBoolean") + this.stringRepForEnv(G) + " |- " + this.stringRep(bool) + " : RListType", TBOOLEAN, e_applyRuleTBoolean, bool, new ErrorInformation[]{new ErrorInformation((EObject)bool)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTBoolean(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaBooleanLiteral bool) throws RuleFailedException {
        return new Result((Object)this._applyRuleTBoolean_1(G, bool));
    }

    private RListType _applyRuleTBoolean_1(RuleEnvironment G, RosettaBooleanLiteral bool) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaStringLiteral str) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTString(G, _subtrace_, str);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TString") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(str) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTString) {
            this.inferTypeThrowException(this.ruleName("TString") + this.stringRepForEnv(G) + " |- " + this.stringRep(str) + " : RListType", TSTRING, e_applyRuleTString, str, new ErrorInformation[]{new ErrorInformation((EObject)str)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTString(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaStringLiteral str) throws RuleFailedException {
        return new Result((Object)this._applyRuleTString_1(G, str));
    }

    private RListType _applyRuleTString_1(RuleEnvironment G, RosettaStringLiteral str) throws RuleFailedException {
        RListType _singleString = this.typeFactory.singleString(str.getValue().length(), str.getValue().length());
        return _singleString;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaNumberLiteral num) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTNumber(G, _subtrace_, num);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TNumber") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(num) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTNumber) {
            this.inferTypeThrowException(this.ruleName("TNumber") + this.stringRepForEnv(G) + " |- " + this.stringRep(num) + " : RListType", TNUMBER, e_applyRuleTNumber, num, new ErrorInformation[]{new ErrorInformation((EObject)num)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTNumber(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaNumberLiteral num) throws RuleFailedException {
        return new Result((Object)this._applyRuleTNumber_1(G, num));
    }

    private RListType _applyRuleTNumber_1(RuleEnvironment G, RosettaNumberLiteral num) throws RuleFailedException {
        RListType _singleNumber = this.typeFactory.singleNumber(num.getValue().toPlainString().replaceAll("\\.|\\-", "").length(), Math.max(0, num.getValue().scale()), num.getValue(), num.getValue());
        return _singleNumber;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaIntLiteral i) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTInt(G, _subtrace_, i);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TInt") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(i) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTInt) {
            this.inferTypeThrowException(this.ruleName("TInt") + this.stringRepForEnv(G) + " |- " + this.stringRep(i) + " : RListType", TINT, e_applyRuleTInt, i, new ErrorInformation[]{new ErrorInformation((EObject)i)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTInt(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaIntLiteral i) throws RuleFailedException {
        return new Result((Object)this._applyRuleTInt_1(G, i));
    }

    private RListType _applyRuleTInt_1(RuleEnvironment G, RosettaIntLiteral i) throws RuleFailedException {
        boolean _greaterEqualsThan;
        int _xifexpression = 0;
        int _signum = i.getValue().signum();
        boolean bl = _greaterEqualsThan = _signum >= 0;
        if (_greaterEqualsThan) {
            _xifexpression = i.getValue().toString().length();
        } else {
            int _length = i.getValue().toString().length();
            _xifexpression = _length - 1;
        }
        RListType _singleInt = this.typeFactory.singleInt(_xifexpression, i.getValue(), i.getValue());
        return _singleInt;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaPatternLiteral p) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTPattern(G, _subtrace_, p);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TPattern") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(p) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTPattern) {
            this.inferTypeThrowException(this.ruleName("TPattern") + this.stringRepForEnv(G) + " |- " + this.stringRep(p) + " : RListType", TPATTERN, e_applyRuleTPattern, p, new ErrorInformation[]{new ErrorInformation((EObject)p)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTPattern(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaPatternLiteral p) throws RuleFailedException {
        return new Result((Object)this._applyRuleTPattern_1(G, p));
    }

    private RListType _applyRuleTPattern_1(RuleEnvironment G, RosettaPatternLiteral p) throws RuleFailedException {
        return this.typeFactory.singlePattern;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaSymbolReference ref) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTVar(G, _subtrace_, ref);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TVar") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(ref) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTVar) {
            this.inferTypeThrowException(this.ruleName("TVar") + this.stringRepForEnv(G) + " |- " + this.stringRep(ref) + " : RListType", TVAR, e_applyRuleTVar, ref, new ErrorInformation[]{new ErrorInformation((EObject)ref)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTVar(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaSymbolReference ref) throws RuleFailedException {
        RListType t = null;
        t = this.symbolListTypeInternal(_trace_, ref.getSymbol());
        Optional<RListType> itType = this.typeOfImplicitVariableInternal(_trace_, ref);
        boolean _isPresent = itType.isPresent();
        if (_isPresent) {
            boolean _contains;
            RType _itemType = itType.get().getItemType();
            Resource _eResource = ref.eResource();
            ResourceSet _resourceSet = null;
            if (_eResource != null) {
                _resourceSet = _eResource.getResourceSet();
            }
            if (_contains = IterableExtensions.contains(this.allFeaturesInternal(_trace_, _itemType, _resourceSet), (Object)ref.getSymbol())) {
                RType _itemType_1 = t.getItemType();
                RosettaCardinality _constraint = t.getConstraint();
                RosettaCardinality _constraint_1 = itType.get().getConstraint();
                RosettaCardinality _multiply = _constraint.operator_multiply(_constraint_1);
                t = this.typeFactory.createListType(_itemType_1, _multiply);
            }
        }
        return new Result((Object)t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaImplicitVariable c) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTIt(G, _subtrace_, c);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TIt") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(c) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTIt) {
            this.inferTypeThrowException(this.ruleName("TIt") + this.stringRepForEnv(G) + " |- " + this.stringRep(c) + " : RListType", TIT, e_applyRuleTIt, c, new ErrorInformation[]{new ErrorInformation((EObject)c)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTIt(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaImplicitVariable c) throws RuleFailedException {
        RListType t = null;
        t = this.typeOfImplicitVariableInternal(_trace_, c).orElse(null);
        return new Result((Object)t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTArithmetic(G, _subtrace_, op);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TArithmetic") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(op) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTArithmetic) {
            this.inferTypeThrowException(this.ruleName("TArithmetic") + this.stringRepForEnv(G) + " |- " + this.stringRep(op) + " : RListType", TARITHMETIC, e_applyRuleTArithmetic, op, new ErrorInformation[]{new ErrorInformation((EObject)op)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTArithmetic(RuleEnvironment G, RuleApplicationTrace _trace_, ArithmeticOperation op) throws RuleFailedException {
        RListType lt = null;
        RosettaExpression _left = op.getLeft();
        RListType t1 = null;
        Result<RListType> result = this.inferTypeInternal(G, _trace_, _left);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        t1 = (RListType)result.getFirst();
        RosettaExpression _right = op.getRight();
        RListType t2 = null;
        Result<RListType> result_1 = this.inferTypeInternal(G, _trace_, _right);
        this.checkAssignableTo(result_1.getFirst(), RListType.class);
        t2 = (RListType)result_1.getFirst();
        if (t1 != null && t2 != null) {
            RType item1 = t1.getItemType();
            RType item2 = t2.getItemType();
            String _operator = op.getOperator();
            boolean _equals = Objects.equal((Object)_operator, (Object)"+");
            if (_equals) {
                boolean _ruleinvocation = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.DATE);
                if (_ruleinvocation) {
                    lt = this.typeFactory.singleDateTime;
                } else {
                    boolean _ruleinvocation_2;
                    boolean _and = false;
                    boolean _ruleinvocation_1 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_STRING);
                    _and = !_ruleinvocation_1 ? false : (_ruleinvocation_2 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_STRING).booleanValue());
                    if (_and) {
                        BiFunction<RType, RType, RType> _function = (l, r) -> {
                            RStringType _xblockexpression = null;
                            RStringType s1 = (RStringType)l;
                            RStringType s2 = (RStringType)r;
                            PositiveIntegerInterval newInterval = s1.getInterval().add(s2.getInterval());
                            _xblockexpression = this.typeFactory.constrainedString(newInterval, Optional.empty());
                            return _xblockexpression;
                        };
                        lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function), this.typeFactory.single);
                    } else {
                        boolean _ruleinvocation_4;
                        boolean _and_1 = false;
                        boolean _ruleinvocation_3 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        _and_1 = !_ruleinvocation_3 ? false : (_ruleinvocation_4 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue());
                        if (_and_1) {
                            BiFunction<RType, RType, RType> _function_1 = (l, r) -> {
                                RNumberType _xblockexpression = null;
                                RNumberType n1 = (RNumberType)l;
                                RNumberType n2 = (RNumberType)r;
                                BiFunction<Integer, Integer, Integer> _function_2 = (a, b) -> Math.max(a, b);
                                Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_2);
                                BigDecimalInterval newInterval = n1.getInterval().add(n2.getInterval());
                                _xblockexpression = this.typeFactory.constrainedNumber(Optional.empty(), newFractionalDigits, newInterval, Optional.empty());
                                return _xblockexpression;
                            };
                            lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_1), this.typeFactory.single);
                        }
                    }
                }
            } else {
                String _operator_1 = op.getOperator();
                boolean _equals_1 = Objects.equal((Object)_operator_1, (Object)"-");
                if (_equals_1) {
                    boolean _ruleinvocation_6;
                    boolean _or = false;
                    boolean _ruleinvocation_5 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.DATE);
                    _or = _ruleinvocation_5 ? true : (_ruleinvocation_6 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.DATE).booleanValue());
                    if (_or) {
                        lt = this.typeFactory.singleUnconstrainedInt;
                    } else {
                        boolean _ruleinvocation_8;
                        boolean _and_2 = false;
                        boolean _ruleinvocation_7 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        _and_2 = !_ruleinvocation_7 ? false : (_ruleinvocation_8 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue());
                        if (_and_2) {
                            BiFunction<RType, RType, RType> _function_2 = (l, r) -> {
                                RNumberType _xblockexpression = null;
                                RNumberType n1 = (RNumberType)l;
                                RNumberType n2 = (RNumberType)r;
                                BiFunction<Integer, Integer, Integer> _function_3 = (a, b) -> Math.max(a, b);
                                Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_3);
                                BigDecimalInterval newInterval = n1.getInterval().subtract(n2.getInterval());
                                _xblockexpression = this.typeFactory.constrainedNumber(Optional.empty(), newFractionalDigits, newInterval, Optional.empty());
                                return _xblockexpression;
                            };
                            lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_2), this.typeFactory.single);
                        }
                    }
                } else {
                    String _operator_2 = op.getOperator();
                    boolean _equals_2 = Objects.equal((Object)_operator_2, (Object)"*");
                    if (_equals_2) {
                        boolean _ruleinvocation_10;
                        boolean _and_3 = false;
                        boolean _ruleinvocation_9 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        _and_3 = !_ruleinvocation_9 ? false : (_ruleinvocation_10 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue());
                        if (_and_3) {
                            BiFunction<RType, RType, RType> _function_3 = (l, r) -> {
                                RNumberType _xblockexpression = null;
                                RNumberType n1 = (RNumberType)l;
                                RNumberType n2 = (RNumberType)r;
                                BiFunction<Integer, Integer, Integer> _function_4 = (a, b) -> a + b;
                                Optional<Integer> newFractionalDigits = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_4);
                                BigDecimalInterval newInterval = n1.getInterval().multiply(n2.getInterval());
                                _xblockexpression = this.typeFactory.constrainedNumber(Optional.empty(), newFractionalDigits, newInterval, Optional.empty());
                                return _xblockexpression;
                            };
                            lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_3), this.typeFactory.single);
                        }
                    } else {
                        String _operator_3 = op.getOperator();
                        boolean _equals_3 = Objects.equal((Object)_operator_3, (Object)"/");
                        if (_equals_3) {
                            boolean _ruleinvocation_12;
                            boolean _and_4 = false;
                            boolean _ruleinvocation_11 = this.subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
                            _and_4 = !_ruleinvocation_11 ? false : (_ruleinvocation_12 = this.subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue());
                            if (_and_4) {
                                lt = this.typeFactory.singleUnconstrainedNumber;
                            }
                        }
                    }
                }
            }
        }
        return new Result(lt);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final EqualityOperation op) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTEquality(G, _subtrace_, op);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TEquality") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(op) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTEquality) {
            this.inferTypeThrowException(this.ruleName("TEquality") + this.stringRepForEnv(G) + " |- " + this.stringRep(op) + " : RListType", TEQUALITY, e_applyRuleTEquality, op, new ErrorInformation[]{new ErrorInformation((EObject)op)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTEquality(RuleEnvironment G, RuleApplicationTrace _trace_, EqualityOperation op) throws RuleFailedException {
        return new Result((Object)this._applyRuleTEquality_1(G, op));
    }

    private RListType _applyRuleTEquality_1(RuleEnvironment G, EqualityOperation op) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final LogicalOperation op) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTLogical(G, _subtrace_, op);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TLogical") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(op) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTLogical) {
            this.inferTypeThrowException(this.ruleName("TLogical") + this.stringRepForEnv(G) + " |- " + this.stringRep(op) + " : RListType", TLOGICAL, e_applyRuleTLogical, op, new ErrorInformation[]{new ErrorInformation((EObject)op)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTLogical(RuleEnvironment G, RuleApplicationTrace _trace_, LogicalOperation op) throws RuleFailedException {
        return new Result((Object)this._applyRuleTLogical_1(G, op));
    }

    private RListType _applyRuleTLogical_1(RuleEnvironment G, LogicalOperation op) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTComparison(G, _subtrace_, op);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TComparison") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(op) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTComparison) {
            this.inferTypeThrowException(this.ruleName("TComparison") + this.stringRepForEnv(G) + " |- " + this.stringRep(op) + " : RListType", TCOMPARISON, e_applyRuleTComparison, op, new ErrorInformation[]{new ErrorInformation((EObject)op)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTComparison(RuleEnvironment G, RuleApplicationTrace _trace_, ComparisonOperation op) throws RuleFailedException {
        return new Result((Object)this._applyRuleTComparison_1(G, op));
    }

    private RListType _applyRuleTComparison_1(RuleEnvironment G, ComparisonOperation op) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaConditionalExpression e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTIf(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TIf") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTIf) {
            this.inferTypeThrowException(this.ruleName("TIf") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TIF, e_applyRuleTIf, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTIf(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaConditionalExpression e) throws RuleFailedException {
        RListType t = null;
        RListType tthen = null;
        RListType telse = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _ifthen = e.getIfthen();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _ifthen);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tthen = (RListType)result.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tthen = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _elsethen = e.getElsethen();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _elsethen);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            telse = (RListType)result_1.getFirst();
        }
        catch (Exception e_2) {
            previousFailure = this.extractRuleFailedException(e_2);
            telse = null;
        }
        if (tthen != null && telse != null) {
            t = this.listJoinInternal(_trace_, tthen, telse);
        }
        return new Result(t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final ListLiteral e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTList(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TList") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTList) {
            this.inferTypeThrowException(this.ruleName("TList") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TLIST, e_applyRuleTList, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTList(RuleEnvironment G, RuleApplicationTrace _trace_, ListLiteral e) throws RuleFailedException {
        RListType t = null;
        ArrayList telems = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            RListType telem = null;
            RuleFailedException previousFailure = null;
            try {
                Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, (RosettaExpression)it);
                this.checkAssignableTo(result.getFirst(), RListType.class);
                telem = (RListType)result.getFirst();
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                telem = null;
            }
            boolean _xifexpression = false;
            if (telem == null) {
                if (!Boolean.valueOf(false).booleanValue()) {
                    this.sneakyThrowRuleFailedException("false");
                }
                _xifexpression = false;
            } else {
                boolean _xblockexpression_1 = false;
                boolean _add = telems.add(telem);
                if (!_add) {
                    this.sneakyThrowRuleFailedException("telems.add(telem)");
                }
                if (!Boolean.valueOf(true).booleanValue()) {
                    this.sneakyThrowRuleFailedException("true");
                }
                _xifexpression = _xblockexpression_1 = true;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        boolean _forall = IterableExtensions.forall(e.getElements(), (Functions.Function1)_function);
        if (_forall) {
            Functions.Function2 _function_1 = (acc, telem) -> {
                RListType _xifexpression = null;
                if (acc == null) {
                    _xifexpression = null;
                } else {
                    RListType _xblockexpression = null;
                    RType sup = this.joinInternal(_trace_, telem.getItemType(), acc.getItemType());
                    RListType _xifexpression_1 = null;
                    boolean _ruleinvocation = this.subtypeSucceeded(G, _trace_, this.builtinTypes.ANY, sup);
                    if (_ruleinvocation) {
                        _xifexpression_1 = null;
                    } else {
                        RosettaCardinality _constraint = telem.getConstraint();
                        RosettaCardinality _constraint_1 = acc.getConstraint();
                        RosettaCardinality _plus = _constraint.operator_plus(_constraint_1);
                        _xifexpression_1 = this.typeFactory.createListType(sup, _plus);
                    }
                    _xifexpression = _xblockexpression = _xifexpression_1;
                }
                return _xifexpression;
            };
            t = (RListType)IterableExtensions.fold((Iterable)telems, (Object)this.typeFactory.emptyNothing, (Functions.Function2)_function_1);
        }
        return new Result(t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaFeatureCall e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTProject(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TProject") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTProject) {
            this.inferTypeThrowException(this.ruleName("TProject") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TPROJECT, e_applyRuleTProject, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTProject(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaFeatureCall e) throws RuleFailedException {
        RListType t = null;
        RosettaExpression _receiver = e.getReceiver();
        RListType dt = null;
        Result<RListType> result = this.inferTypeInternal(G, _trace_, _receiver);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        dt = (RListType)result.getFirst();
        if (dt != null) {
            RosettaFeature a = e.getFeature();
            boolean _matched = false;
            if (a instanceof Attribute) {
                _matched = true;
                RListType at = this.attributeListTypeInternal(_trace_, (Attribute)a);
                RType _itemType = at.getItemType();
                RosettaCardinality _constraint = dt.getConstraint();
                RosettaCardinality _constraint_1 = at.getConstraint();
                RosettaCardinality _multiply = _constraint.operator_multiply(_constraint_1);
                t = this.typeFactory.createListType(_itemType, _multiply);
            }
            if (!_matched && a instanceof RosettaTypedFeature) {
                boolean _tripleEquals;
                _matched = true;
                TypeCall _typeCall = ((RosettaTypedFeature)a).getTypeCall();
                boolean bl = _tripleEquals = _typeCall == null;
                if (_tripleEquals) {
                    String error = "Unsupported by the type system.";
                    this.throwForExplicitFail(error, new ErrorInformation(null, null));
                } else {
                    TypeCall _typeCall_1 = ((RosettaTypedFeature)a).getTypeCall();
                    RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
                    t = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall_1, _rosettaInterpreterContext), dt.getConstraint());
                }
            }
            if (!_matched && a instanceof RosettaEnumValue) {
                _matched = true;
                t = dt;
            }
        }
        return new Result(t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaExistsExpression e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTExists(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TExists") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTExists) {
            this.inferTypeThrowException(this.ruleName("TExists") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TEXISTS, e_applyRuleTExists, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTExists(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaExistsExpression e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTExists_1(G, e));
    }

    private RListType _applyRuleTExists_1(RuleEnvironment G, RosettaExistsExpression e) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaAbsentExpression e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTAbsent(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TAbsent") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTAbsent) {
            this.inferTypeThrowException(this.ruleName("TAbsent") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TABSENT, e_applyRuleTAbsent, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTAbsent(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaAbsentExpression e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTAbsent_1(G, e));
    }

    private RListType _applyRuleTAbsent_1(RuleEnvironment G, RosettaAbsentExpression e) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaOnlyExistsExpression e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTOnlyExists(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TOnlyExists") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTOnlyExists) {
            this.inferTypeThrowException(this.ruleName("TOnlyExists") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TONLYEXISTS, e_applyRuleTOnlyExists, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTOnlyExists(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaOnlyExistsExpression e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTOnlyExists_1(G, e));
    }

    private RListType _applyRuleTOnlyExists_1(RuleEnvironment G, RosettaOnlyExistsExpression e) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaCountOperation e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTCount(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TCount") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTCount) {
            this.inferTypeThrowException(this.ruleName("TCount") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TCOUNT, e_applyRuleTCount, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTCount(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaCountOperation e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTCount_1(G, e));
    }

    private RListType _applyRuleTCount_1(RuleEnvironment G, RosettaCountOperation e) throws RuleFailedException {
        RListType _singleInt = this.typeFactory.singleInt(Optional.empty(), Optional.of(BigInteger.ZERO), Optional.empty());
        return _singleInt;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final RosettaOnlyElement e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTOnlyElement(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TOnlyElement") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTOnlyElement) {
            this.inferTypeThrowException(this.ruleName("TOnlyElement") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TONLYELEMENT, e_applyRuleTOnlyElement, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTOnlyElement(RuleEnvironment G, RuleApplicationTrace _trace_, RosettaOnlyElement e) throws RuleFailedException {
        RListType t = null;
        RosettaExpression _argument = e.getArgument();
        RListType targ = null;
        Result<RListType> result = this.inferTypeInternal(G, _trace_, _argument);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        targ = (RListType)result.getFirst();
        if (targ != null) {
            t = this.typeFactory.createListType(targ.getItemType(), 0, 1);
        }
        return new Result(t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final AsKeyOperation e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTAsKey(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TAsKey") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTAsKey) {
            this.inferTypeThrowException(this.ruleName("TAsKey") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TASKEY, e_applyRuleTAsKey, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTAsKey(RuleEnvironment G, RuleApplicationTrace _trace_, AsKeyOperation e) throws RuleFailedException {
        RListType t = null;
        RosettaExpression _argument = e.getArgument();
        Result<RListType> result = this.inferTypeInternal(G, _trace_, _argument);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        t = (RListType)result.getFirst();
        return new Result((Object)t);
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final OneOfOperation e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTOneOf(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TOneOf") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTOneOf) {
            this.inferTypeThrowException(this.ruleName("TOneOf") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TONEOF, e_applyRuleTOneOf, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTOneOf(RuleEnvironment G, RuleApplicationTrace _trace_, OneOfOperation e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTOneOf_1(G, e));
    }

    private RListType _applyRuleTOneOf_1(RuleEnvironment G, OneOfOperation e) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }

    protected Result<RListType> inferTypeImpl(final RuleEnvironment G, RuleApplicationTrace _trace_, final ChoiceOperation e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Result<RListType> _result_ = this.applyRuleTChoice(G, _subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTyping.this.ruleName("TChoice") + RosettaTyping.this.stringRepForEnv(G) + " |- " + RosettaTyping.this.stringRep(e) + " : " + RosettaTyping.this.stringRep(_result_.getFirst());
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyRuleTChoice) {
            this.inferTypeThrowException(this.ruleName("TChoice") + this.stringRepForEnv(G) + " |- " + this.stringRep(e) + " : RListType", TCHOICE, e_applyRuleTChoice, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Result<RListType> applyRuleTChoice(RuleEnvironment G, RuleApplicationTrace _trace_, ChoiceOperation e) throws RuleFailedException {
        return new Result((Object)this._applyRuleTChoice_1(G, e));
    }

    private RListType _applyRuleTChoice_1(RuleEnvironment G, ChoiceOperation e) throws RuleFailedException {
        return this.typeFactory.singleBoolean;
    }
}

