/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.XsemanticsRuntimeSystem;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RosettaTypingAuxiliary
extends XsemanticsRuntimeSystem {
    public static final String ANCESTORS = "com.regnosys.rosetta.typing.Ancestors";
    public static final String ANCESTORENUMS = "com.regnosys.rosetta.typing.AncestorEnums";
    public static final String OVERLAP = "com.regnosys.rosetta.typing.Overlap";
    public static final String JOIN = "com.regnosys.rosetta.typing.Join";
    public static final String UNION = "com.regnosys.rosetta.typing.Union";
    public static final String LISTJOIN = "com.regnosys.rosetta.typing.ListJoin";
    public static final String ALLATTRIBUTES = "com.regnosys.rosetta.typing.AllAttributes";
    public static final String ALLENUMVALUES = "com.regnosys.rosetta.typing.AllEnumValues";
    public static final String MAYBEEMPTY = "com.regnosys.rosetta.typing.MayBeEmpty";
    public static final String KEEPTYPEALIASIFPOSSIBLE = "com.regnosys.rosetta.typing.KeepTypeAliasIfPossible";
    public static final String ALLFEATURES = "com.regnosys.rosetta.typing.AllFeatures";
    @Extension
    @Inject
    private TypeFactory typeFactory;
    @Extension
    @Inject
    private TypeValidationUtil util;
    @Extension
    @Inject
    private ExpressionHelper exprHelper;
    @Extension
    @Inject
    private ImplicitVariableUtil implicitVarUtil;
    @Extension
    @Inject
    private RBuiltinTypeService builtinTypes;
    @Inject
    private RosettaInterpreter interpreter;
    @Inject
    private RosettaSimpleSystemSolver systemSolver;
    private PolymorphicDispatcher<List<Data>> ancestorsDispatcher;
    private PolymorphicDispatcher<List<RosettaEnumeration>> ancestorEnumsDispatcher;
    private PolymorphicDispatcher<Boolean> overlapDispatcher;
    private PolymorphicDispatcher<RType> joinDispatcher;
    private PolymorphicDispatcher<RosettaCardinality> unionDispatcher;
    private PolymorphicDispatcher<RListType> listJoinDispatcher;
    private PolymorphicDispatcher<Iterable<Attribute>> allAttributesDispatcher;
    private PolymorphicDispatcher<Iterable<RosettaEnumValue>> allEnumValuesDispatcher;
    private PolymorphicDispatcher<Boolean> mayBeEmptyDispatcher;
    private PolymorphicDispatcher<RType> keepTypeAliasIfPossibleDispatcher;
    private PolymorphicDispatcher<Iterable<? extends RosettaFeature>> allFeaturesDispatcher;

    public RosettaTypingAuxiliary() {
        this.init();
    }

    public void init() {
        this.ancestorsDispatcher = this.buildPolymorphicDispatcher("ancestorsImpl", 2);
        this.ancestorEnumsDispatcher = this.buildPolymorphicDispatcher("ancestorEnumsImpl", 2);
        this.overlapDispatcher = this.buildPolymorphicDispatcher("overlapImpl", 3);
        this.joinDispatcher = this.buildPolymorphicDispatcher("joinImpl", 3);
        this.unionDispatcher = this.buildPolymorphicDispatcher("unionImpl", 3);
        this.listJoinDispatcher = this.buildPolymorphicDispatcher("listJoinImpl", 3);
        this.allAttributesDispatcher = this.buildPolymorphicDispatcher("allAttributesImpl", 2);
        this.allEnumValuesDispatcher = this.buildPolymorphicDispatcher("allEnumValuesImpl", 2);
        this.mayBeEmptyDispatcher = this.buildPolymorphicDispatcher("mayBeEmptyImpl", 2);
        this.keepTypeAliasIfPossibleDispatcher = this.buildPolymorphicDispatcher("keepTypeAliasIfPossibleImpl", 4);
        this.allFeaturesDispatcher = this.buildPolymorphicDispatcher("allFeaturesImpl", 3);
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public TypeValidationUtil getUtil() {
        return this.util;
    }

    public void setUtil(TypeValidationUtil util) {
        this.util = util;
    }

    public ExpressionHelper getExprHelper() {
        return this.exprHelper;
    }

    public void setExprHelper(ExpressionHelper exprHelper) {
        this.exprHelper = exprHelper;
    }

    public ImplicitVariableUtil getImplicitVarUtil() {
        return this.implicitVarUtil;
    }

    public void setImplicitVarUtil(ImplicitVariableUtil implicitVarUtil) {
        this.implicitVarUtil = implicitVarUtil;
    }

    public RBuiltinTypeService getBuiltinTypes() {
        return this.builtinTypes;
    }

    public void setBuiltinTypes(RBuiltinTypeService builtinTypes) {
        this.builtinTypes = builtinTypes;
    }

    public RosettaInterpreter getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(RosettaInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public RosettaSimpleSystemSolver getSystemSolver() {
        return this.systemSolver;
    }

    public void setSystemSolver(RosettaSimpleSystemSolver systemSolver) {
        this.systemSolver = systemSolver;
    }

    public List<Data> ancestors(Data t) throws RuleFailedException {
        return this.ancestors(null, t);
    }

    public List<Data> ancestors(RuleApplicationTrace _trace_, Data t) throws RuleFailedException {
        try {
            return this.ancestorsInternal(_trace_, t);
        }
        catch (Exception _e_ancestors) {
            throw this.extractRuleFailedException(_e_ancestors);
        }
    }

    public List<RosettaEnumeration> ancestorEnums(RosettaEnumeration t) throws RuleFailedException {
        return this.ancestorEnums(null, t);
    }

    public List<RosettaEnumeration> ancestorEnums(RuleApplicationTrace _trace_, RosettaEnumeration t) throws RuleFailedException {
        try {
            return this.ancestorEnumsInternal(_trace_, t);
        }
        catch (Exception _e_ancestorEnums) {
            throw this.extractRuleFailedException(_e_ancestorEnums);
        }
    }

    public Boolean overlap(RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        return this.overlap(null, c1, c2);
    }

    public Boolean overlap(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        try {
            return this.overlapInternal(_trace_, c1, c2);
        }
        catch (Exception _e_overlap) {
            throw this.extractRuleFailedException(_e_overlap);
        }
    }

    public RType join(RType t1, RType t2) throws RuleFailedException {
        return this.join(null, t1, t2);
    }

    public RType join(RuleApplicationTrace _trace_, RType t1, RType t2) throws RuleFailedException {
        try {
            return this.joinInternal(_trace_, t1, t2);
        }
        catch (Exception _e_join) {
            throw this.extractRuleFailedException(_e_join);
        }
    }

    public RosettaCardinality union(RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        return this.union(null, c1, c2);
    }

    public RosettaCardinality union(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        try {
            return this.unionInternal(_trace_, c1, c2);
        }
        catch (Exception _e_union) {
            throw this.extractRuleFailedException(_e_union);
        }
    }

    public RListType listJoin(RListType t1, RListType t2) throws RuleFailedException {
        return this.listJoin(null, t1, t2);
    }

    public RListType listJoin(RuleApplicationTrace _trace_, RListType t1, RListType t2) throws RuleFailedException {
        try {
            return this.listJoinInternal(_trace_, t1, t2);
        }
        catch (Exception _e_listJoin) {
            throw this.extractRuleFailedException(_e_listJoin);
        }
    }

    public Iterable<Attribute> allAttributes(Data d) throws RuleFailedException {
        return this.allAttributes(null, d);
    }

    public Iterable<Attribute> allAttributes(RuleApplicationTrace _trace_, Data d) throws RuleFailedException {
        try {
            return this.allAttributesInternal(_trace_, d);
        }
        catch (Exception _e_allAttributes) {
            throw this.extractRuleFailedException(_e_allAttributes);
        }
    }

    public Iterable<RosettaEnumValue> allEnumValues(RosettaEnumeration d) throws RuleFailedException {
        return this.allEnumValues(null, d);
    }

    public Iterable<RosettaEnumValue> allEnumValues(RuleApplicationTrace _trace_, RosettaEnumeration d) throws RuleFailedException {
        try {
            return this.allEnumValuesInternal(_trace_, d);
        }
        catch (Exception _e_allEnumValues) {
            throw this.extractRuleFailedException(_e_allEnumValues);
        }
    }

    public Boolean mayBeEmpty(Data d) throws RuleFailedException {
        return this.mayBeEmpty(null, d);
    }

    public Boolean mayBeEmpty(RuleApplicationTrace _trace_, Data d) throws RuleFailedException {
        try {
            return this.mayBeEmptyInternal(_trace_, d);
        }
        catch (Exception _e_mayBeEmpty) {
            throw this.extractRuleFailedException(_e_mayBeEmpty);
        }
    }

    public RType keepTypeAliasIfPossible(RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        return this.keepTypeAliasIfPossible(null, t1, t2, combineUnderlyingTypes);
    }

    public RType keepTypeAliasIfPossible(RuleApplicationTrace _trace_, RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        try {
            return this.keepTypeAliasIfPossibleInternal(_trace_, t1, t2, combineUnderlyingTypes);
        }
        catch (Exception _e_keepTypeAliasIfPossible) {
            throw this.extractRuleFailedException(_e_keepTypeAliasIfPossible);
        }
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, ResourceSet resourceSet) throws RuleFailedException {
        return this.allFeatures(null, t, resourceSet);
    }

    public Iterable<? extends RosettaFeature> allFeatures(RuleApplicationTrace _trace_, RType t, ResourceSet resourceSet) throws RuleFailedException {
        try {
            return this.allFeaturesInternal(_trace_, t, resourceSet);
        }
        catch (Exception _e_allFeatures) {
            throw this.extractRuleFailedException(_e_allFeatures);
        }
    }

    protected List<Data> ancestorsInternal(RuleApplicationTrace _trace_, Data t) {
        try {
            this.checkParamsNotNull(new Object[]{t});
            return (List)this.ancestorsDispatcher.invoke(new Object[]{_trace_, t});
        }
        catch (Exception _e_ancestors) {
            this.sneakyThrowRuleFailedException(_e_ancestors);
            return null;
        }
    }

    protected void ancestorsThrowException(String _error, String _issue, Exception _ex, Data t, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected List<RosettaEnumeration> ancestorEnumsInternal(RuleApplicationTrace _trace_, RosettaEnumeration t) {
        try {
            this.checkParamsNotNull(new Object[]{t});
            return (List)this.ancestorEnumsDispatcher.invoke(new Object[]{_trace_, t});
        }
        catch (Exception _e_ancestorEnums) {
            this.sneakyThrowRuleFailedException(_e_ancestorEnums);
            return null;
        }
    }

    protected void ancestorEnumsThrowException(String _error, String _issue, Exception _ex, RosettaEnumeration t, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean overlapInternal(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) {
        try {
            this.checkParamsNotNull(new Object[]{c1, c2});
            return (Boolean)this.overlapDispatcher.invoke(new Object[]{_trace_, c1, c2});
        }
        catch (Exception _e_overlap) {
            this.sneakyThrowRuleFailedException(_e_overlap);
            return false;
        }
    }

    protected void overlapThrowException(String _error, String _issue, Exception _ex, RosettaCardinality c1, RosettaCardinality c2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RType joinInternal(RuleApplicationTrace _trace_, RType t1, RType t2) {
        try {
            this.checkParamsNotNull(new Object[]{t1, t2});
            return (RType)this.joinDispatcher.invoke(new Object[]{_trace_, t1, t2});
        }
        catch (Exception _e_join) {
            this.sneakyThrowRuleFailedException(_e_join);
            return null;
        }
    }

    protected void joinThrowException(String _error, String _issue, Exception _ex, RType t1, RType t2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RosettaCardinality unionInternal(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) {
        try {
            this.checkParamsNotNull(new Object[]{c1, c2});
            return (RosettaCardinality)this.unionDispatcher.invoke(new Object[]{_trace_, c1, c2});
        }
        catch (Exception _e_union) {
            this.sneakyThrowRuleFailedException(_e_union);
            return null;
        }
    }

    protected void unionThrowException(String _error, String _issue, Exception _ex, RosettaCardinality c1, RosettaCardinality c2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RListType listJoinInternal(RuleApplicationTrace _trace_, RListType t1, RListType t2) {
        try {
            this.checkParamsNotNull(new Object[]{t1, t2});
            return (RListType)this.listJoinDispatcher.invoke(new Object[]{_trace_, t1, t2});
        }
        catch (Exception _e_listJoin) {
            this.sneakyThrowRuleFailedException(_e_listJoin);
            return null;
        }
    }

    protected void listJoinThrowException(String _error, String _issue, Exception _ex, RListType t1, RListType t2, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Iterable<Attribute> allAttributesInternal(RuleApplicationTrace _trace_, Data d) {
        try {
            this.checkParamsNotNull(new Object[]{d});
            return (Iterable)this.allAttributesDispatcher.invoke(new Object[]{_trace_, d});
        }
        catch (Exception _e_allAttributes) {
            this.sneakyThrowRuleFailedException(_e_allAttributes);
            return null;
        }
    }

    protected void allAttributesThrowException(String _error, String _issue, Exception _ex, Data d, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Iterable<RosettaEnumValue> allEnumValuesInternal(RuleApplicationTrace _trace_, RosettaEnumeration d) {
        try {
            this.checkParamsNotNull(new Object[]{d});
            return (Iterable)this.allEnumValuesDispatcher.invoke(new Object[]{_trace_, d});
        }
        catch (Exception _e_allEnumValues) {
            this.sneakyThrowRuleFailedException(_e_allEnumValues);
            return null;
        }
    }

    protected void allEnumValuesThrowException(String _error, String _issue, Exception _ex, RosettaEnumeration d, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean mayBeEmptyInternal(RuleApplicationTrace _trace_, Data d) {
        try {
            this.checkParamsNotNull(new Object[]{d});
            return (Boolean)this.mayBeEmptyDispatcher.invoke(new Object[]{_trace_, d});
        }
        catch (Exception _e_mayBeEmpty) {
            this.sneakyThrowRuleFailedException(_e_mayBeEmpty);
            return false;
        }
    }

    protected void mayBeEmptyThrowException(String _error, String _issue, Exception _ex, Data d, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected RType keepTypeAliasIfPossibleInternal(RuleApplicationTrace _trace_, RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) {
        try {
            this.checkParamsNotNull(new Object[]{t1, t2, combineUnderlyingTypes});
            return (RType)this.keepTypeAliasIfPossibleDispatcher.invoke(new Object[]{_trace_, t1, t2, combineUnderlyingTypes});
        }
        catch (Exception _e_keepTypeAliasIfPossible) {
            this.sneakyThrowRuleFailedException(_e_keepTypeAliasIfPossible);
            return null;
        }
    }

    protected void keepTypeAliasIfPossibleThrowException(String _error, String _issue, Exception _ex, RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Iterable<? extends RosettaFeature> allFeaturesInternal(RuleApplicationTrace _trace_, RType t, ResourceSet resourceSet) {
        try {
            this.checkParamsNotNull(new Object[]{t, resourceSet});
            return (Iterable)this.allFeaturesDispatcher.invoke(new Object[]{_trace_, t, resourceSet});
        }
        catch (Exception _e_allFeatures) {
            this.sneakyThrowRuleFailedException(_e_allFeatures);
            return null;
        }
    }

    protected void allFeaturesThrowException(String _error, String _issue, Exception _ex, RType t, ResourceSet resourceSet, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected List<Data> ancestorsImpl(RuleApplicationTrace _trace_, final Data t) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final List<Data> _result_ = this.applyAuxFunAncestors(_subtrace_, t);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("ancestors") + "(" + RosettaTypingAuxiliary.this.stringRep(t) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAncestors) {
            this.ancestorsThrowException(this.auxFunName("ancestors") + "(" + this.stringRep(t) + ")", ANCESTORS, e_applyAuxFunAncestors, t, new ErrorInformation[]{new ErrorInformation((EObject)t)});
            return null;
        }
    }

    protected List<Data> applyAuxFunAncestors(RuleApplicationTrace _trace_, Data t) throws RuleFailedException {
        return this.getAll(t, (EStructuralFeature)SimplePackage.eINSTANCE.getData_SuperType(), (EStructuralFeature)SimplePackage.eINSTANCE.getData_SuperType(), Data.class);
    }

    protected List<RosettaEnumeration> ancestorEnumsImpl(RuleApplicationTrace _trace_, final RosettaEnumeration t) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final List<RosettaEnumeration> _result_ = this.applyAuxFunAncestorEnums(_subtrace_, t);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("ancestorEnums") + "(" + RosettaTypingAuxiliary.this.stringRep(t) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAncestorEnums) {
            this.ancestorEnumsThrowException(this.auxFunName("ancestorEnums") + "(" + this.stringRep(t) + ")", ANCESTORENUMS, e_applyAuxFunAncestorEnums, t, new ErrorInformation[]{new ErrorInformation((EObject)t)});
            return null;
        }
    }

    protected List<RosettaEnumeration> applyAuxFunAncestorEnums(RuleApplicationTrace _trace_, RosettaEnumeration t) throws RuleFailedException {
        return this.getAll(t, (EStructuralFeature)RosettaPackage.eINSTANCE.getRosettaEnumeration_SuperType(), (EStructuralFeature)RosettaPackage.eINSTANCE.getRosettaEnumeration_SuperType(), RosettaEnumeration.class);
    }

    protected Boolean overlapImpl(RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunOverlap(_subtrace_, c1, c2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("overlap") + "(" + RosettaTypingAuxiliary.this.stringRep(c1) + ", " + RosettaTypingAuxiliary.this.stringRep(c2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunOverlap) {
            this.overlapThrowException(this.auxFunName("overlap") + "(" + this.stringRep(c1) + ", " + this.stringRep(c2) + ")", OVERLAP, e_applyAuxFunOverlap, c1, c2, new ErrorInformation[]{new ErrorInformation((EObject)c1), new ErrorInformation((EObject)c2)});
            return false;
        }
    }

    protected Boolean applyAuxFunOverlap(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        RuleFailedException previousFailure = null;
        try {
            if (!c1.isUnbounded() && c1.getSup() < c2.getInf() || !c2.isUnbounded() && c2.getSup() < c1.getInf()) {
                this.sneakyThrowRuleFailedException("(c1.unbounded || c1.sup >= c2.inf) && (c2.unbounded || c2.sup >= c1.inf)");
            }
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            return false;
        }
        return true;
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RDataType t1, RDataType t2) throws RuleFailedException {
        List<Data> st1 = this.ancestorsInternal(_trace_, t1.getData());
        st1.add(0, t1.getData());
        List<Data> st2 = this.ancestorsInternal(_trace_, t2.getData());
        st2.add(0, t2.getData());
        Functions.Function1 _function = it -> st1.contains(it);
        Data result = (Data)IterableExtensions.findFirst(st2, (Functions.Function1)_function);
        if (result == null) {
            return this.builtinTypes.ANY;
        }
        return new RDataType(result);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final REnumType t1, final REnumType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, REnumType t1, REnumType t2) throws RuleFailedException {
        List<RosettaEnumeration> st1 = this.ancestorEnumsInternal(_trace_, t1.getEnumeration());
        st1.add(0, t1.getEnumeration());
        List<RosettaEnumeration> st2 = this.ancestorEnumsInternal(_trace_, t2.getEnumeration());
        st2.add(0, t2.getEnumeration());
        Functions.Function1 _function = it -> st1.contains(it);
        RosettaEnumeration result = (RosettaEnumeration)IterableExtensions.findFirst(st2, (Functions.Function1)_function);
        if (result == null) {
            return this.builtinTypes.ANY;
        }
        return new REnumType(result);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RNumberType t1, RNumberType t2) throws RuleFailedException {
        return t1.join(t2);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RStringType t1, RStringType t2) throws RuleFailedException {
        return t1.join(t2);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RBasicType t1, RBasicType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            return t1;
        }
        boolean _equals_1 = Objects.equal((Object)t1, (Object)this.builtinTypes.NOTHING);
        if (_equals_1) {
            return t2;
        }
        boolean _equals_2 = Objects.equal((Object)t2, (Object)this.builtinTypes.NOTHING);
        if (_equals_2) {
            return t1;
        }
        return this.builtinTypes.ANY;
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RBasicType t1, RType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            return t1;
        }
        boolean _equals_1 = Objects.equal((Object)t1, (Object)this.builtinTypes.NOTHING);
        if (_equals_1) {
            return t2;
        }
        return this.builtinTypes.ANY;
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RType t1, RBasicType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            return t1;
        }
        boolean _equals_1 = Objects.equal((Object)t2, (Object)this.builtinTypes.NOTHING);
        if (_equals_1) {
            return t1;
        }
        return this.builtinTypes.ANY;
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RAliasType t1, RAliasType t2) throws RuleFailedException {
        RTypeFunction _typeFunction_1;
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            return t1;
        }
        RTypeFunction _typeFunction = t1.getTypeFunction();
        boolean _equals_1 = Objects.equal((Object)((Object)_typeFunction), (Object)((Object)(_typeFunction_1 = t2.getTypeFunction())));
        if (_equals_1) {
            RTypeFunction typeFunc = t1.getTypeFunction();
            RType underlyingJoin = this.joinInternal(_trace_, t1.getRefersTo(), t2.getRefersTo());
            Optional<LinkedHashMap<String, RosettaValue>> aliasParams = typeFunc.reverse(underlyingJoin);
            Function<LinkedHashMap, RType> _function = it -> new RAliasType(typeFunc, (LinkedHashMap<String, RosettaValue>)it, underlyingJoin);
            return aliasParams.map(_function).orElse(underlyingJoin);
        }
        ArrayList superAliases = CollectionLiterals.newArrayList();
        RType curr = t1;
        while (curr instanceof RAliasType) {
            boolean _add = superAliases.add(curr);
            if (!_add) {
                this.sneakyThrowRuleFailedException("superAliases.add(curr)");
            }
            curr = ((RAliasType)curr).getRefersTo();
        }
        curr = t2;
        while (curr instanceof RAliasType) {
            RTypeFunction tf = ((RAliasType)curr).getTypeFunction();
            Functions.Function1 _function_1 = it -> {
                RTypeFunction _typeFunction_2 = it.getTypeFunction();
                return Objects.equal((Object)((Object)tf), (Object)((Object)_typeFunction_2));
            };
            RAliasType match = (RAliasType)IterableExtensions.findFirst((Iterable)superAliases, (Functions.Function1)_function_1);
            if (match != null) {
                return this.joinInternal(_trace_, match, curr);
            }
            curr = ((RAliasType)curr).getRefersTo();
        }
        return this.joinInternal(_trace_, t1.getRefersTo(), t2.getRefersTo());
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RAliasType t1, RType t2) throws RuleFailedException {
        return this.joinInternal(_trace_, t1.getRefersTo(), t2);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RType t1, RAliasType t2) throws RuleFailedException {
        return this.joinInternal(_trace_, t1, t2.getRefersTo());
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RAliasType t1, RBasicType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t2, (Object)this.builtinTypes.NOTHING);
        if (_equals) {
            return t1;
        }
        return this.joinInternal(_trace_, t1.getRefersTo(), t2);
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RBasicType t1, RAliasType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t1, (Object)this.builtinTypes.NOTHING);
        if (_equals) {
            return t2;
        }
        return this.joinInternal(_trace_, t1, t2.getRefersTo());
    }

    protected RType joinImpl(RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("join") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunJoin) {
            this.joinThrowException(this.auxFunName("join") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", JOIN, e_applyAuxFunJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunJoin(RuleApplicationTrace _trace_, RType t1, RType t2) throws RuleFailedException {
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            return t1;
        }
        return this.builtinTypes.ANY;
    }

    protected RosettaCardinality unionImpl(RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RosettaCardinality _result_ = this.applyAuxFunUnion(_subtrace_, c1, c2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("union") + "(" + RosettaTypingAuxiliary.this.stringRep(c1) + ", " + RosettaTypingAuxiliary.this.stringRep(c2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunUnion) {
            this.unionThrowException(this.auxFunName("union") + "(" + this.stringRep(c1) + ", " + this.stringRep(c2) + ")", UNION, e_applyAuxFunUnion, c1, c2, new ErrorInformation[]{new ErrorInformation((EObject)c1), new ErrorInformation((EObject)c2)});
            return null;
        }
    }

    protected RosettaCardinality applyAuxFunUnion(RuleApplicationTrace _trace_, RosettaCardinality c1, RosettaCardinality c2) throws RuleFailedException {
        if (c1.isUnbounded() || c2.isUnbounded()) {
            return this.typeFactory.createConstraint(Math.min(c1.getInf(), c2.getInf()));
        }
        return this.typeFactory.createConstraint(Math.min(c1.getInf(), c2.getInf()), Math.max(c1.getSup(), c2.getSup()));
    }

    protected RListType listJoinImpl(RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RListType _result_ = this.applyAuxFunListJoin(_subtrace_, t1, t2);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("listJoin") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunListJoin) {
            this.listJoinThrowException(this.auxFunName("listJoin") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ")", LISTJOIN, e_applyAuxFunListJoin, t1, t2, new ErrorInformation[0]);
            return null;
        }
    }

    protected RListType applyAuxFunListJoin(RuleApplicationTrace _trace_, RListType t1, RListType t2) throws RuleFailedException {
        RType sup = this.joinInternal(_trace_, t1.getItemType(), t2.getItemType());
        return this.typeFactory.createListType(sup, this.unionInternal(_trace_, t1.getConstraint(), t2.getConstraint()));
    }

    protected Iterable<Attribute> allAttributesImpl(RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Iterable<Attribute> _result_ = this.applyAuxFunAllAttributes(_subtrace_, d);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("allAttributes") + "(" + RosettaTypingAuxiliary.this.stringRep(d) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAllAttributes) {
            this.allAttributesThrowException(this.auxFunName("allAttributes") + "(" + this.stringRep(d) + ")", ALLATTRIBUTES, e_applyAuxFunAllAttributes, d, new ErrorInformation[]{new ErrorInformation((EObject)d)});
            return null;
        }
    }

    protected Iterable<Attribute> applyAuxFunAllAttributes(RuleApplicationTrace _trace_, Data d) throws RuleFailedException {
        boolean _tripleEquals;
        Data _superType = d.getSuperType();
        boolean bl = _tripleEquals = _superType == null;
        if (_tripleEquals) {
            return d.getAttributes();
        }
        Iterable<Attribute> _allAttributes = this.allAttributesInternal(_trace_, d.getSuperType());
        EList<Attribute> _attributes = d.getAttributes();
        return Iterables.concat(_allAttributes, _attributes);
    }

    protected Iterable<RosettaEnumValue> allEnumValuesImpl(RuleApplicationTrace _trace_, final RosettaEnumeration e) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Iterable<RosettaEnumValue> _result_ = this.applyAuxFunAllEnumValues(_subtrace_, e);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("allEnumValues") + "(" + RosettaTypingAuxiliary.this.stringRep(e) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAllEnumValues) {
            this.allEnumValuesThrowException(this.auxFunName("allEnumValues") + "(" + this.stringRep(e) + ")", ALLENUMVALUES, e_applyAuxFunAllEnumValues, e, new ErrorInformation[]{new ErrorInformation((EObject)e)});
            return null;
        }
    }

    protected Iterable<RosettaEnumValue> applyAuxFunAllEnumValues(RuleApplicationTrace _trace_, RosettaEnumeration e) throws RuleFailedException {
        boolean _tripleEquals;
        RosettaEnumeration _superType = e.getSuperType();
        boolean bl = _tripleEquals = _superType == null;
        if (_tripleEquals) {
            return e.getEnumValues();
        }
        Iterable<RosettaEnumValue> _allEnumValues = this.allEnumValuesInternal(_trace_, e.getSuperType());
        EList<RosettaEnumValue> _enumValues = e.getEnumValues();
        return Iterables.concat(_allEnumValues, _enumValues);
    }

    protected Boolean mayBeEmptyImpl(RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunMayBeEmpty(_subtrace_, d);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("mayBeEmpty") + "(" + RosettaTypingAuxiliary.this.stringRep(d) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunMayBeEmpty) {
            this.mayBeEmptyThrowException(this.auxFunName("mayBeEmpty") + "(" + this.stringRep(d) + ")", MAYBEEMPTY, e_applyAuxFunMayBeEmpty, d, new ErrorInformation[]{new ErrorInformation((EObject)d)});
            return false;
        }
    }

    protected Boolean applyAuxFunMayBeEmpty(RuleApplicationTrace _trace_, Data d) throws RuleFailedException {
        Functions.Function1 _function = it -> {
            int _inf = it.getCard().getInf();
            return _inf == 0;
        };
        boolean _forall = IterableExtensions.forall(this.allAttributesInternal(_trace_, d), (Functions.Function1)_function);
        if (!_forall) {
            this.sneakyThrowRuleFailedException("d.allAttributes.forall[ card.inf === 0 ]");
        }
        return true;
    }

    protected RType keepTypeAliasIfPossibleImpl(RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("keepTypeAliasIfPossible") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ", " + RosettaTypingAuxiliary.this.stringRep(combineUnderlyingTypes) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
            this.keepTypeAliasIfPossibleThrowException(this.auxFunName("keepTypeAliasIfPossible") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ", " + this.stringRep(combineUnderlyingTypes) + ")", KEEPTYPEALIASIFPOSSIBLE, e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunKeepTypeAliasIfPossible(RuleApplicationTrace _trace_, RAliasType t1, RAliasType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        RTypeFunction _typeFunction_1;
        RTypeFunction _typeFunction = t1.getTypeFunction();
        boolean _equals = Objects.equal((Object)((Object)_typeFunction), (Object)((Object)(_typeFunction_1 = t2.getTypeFunction())));
        if (_equals) {
            RTypeFunction typeFunc = t1.getTypeFunction();
            RType underlier = this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2.getRefersTo(), combineUnderlyingTypes);
            Function<LinkedHashMap, RType> _function = args -> new RAliasType(typeFunc, (LinkedHashMap<String, RosettaValue>)args, underlier);
            return typeFunc.reverse(underlier).map(_function).orElse(underlier);
        }
        ArrayList superAliases = CollectionLiterals.newArrayList();
        RType curr = t1;
        while (curr instanceof RAliasType) {
            boolean _add = superAliases.add(curr);
            if (!_add) {
                this.sneakyThrowRuleFailedException("superAliases.add(curr)");
            }
            curr = ((RAliasType)curr).getRefersTo();
        }
        curr = t2;
        while (curr instanceof RAliasType) {
            RTypeFunction tf = ((RAliasType)curr).getTypeFunction();
            Functions.Function1 _function_1 = it -> {
                RTypeFunction _typeFunction_2 = it.getTypeFunction();
                return Objects.equal((Object)((Object)tf), (Object)((Object)_typeFunction_2));
            };
            RAliasType match = (RAliasType)IterableExtensions.findFirst((Iterable)superAliases, (Functions.Function1)_function_1);
            if (match != null) {
                return this.keepTypeAliasIfPossibleInternal(_trace_, match, curr, combineUnderlyingTypes);
            }
            curr = ((RAliasType)curr).getRefersTo();
        }
        return this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2.getRefersTo(), combineUnderlyingTypes);
    }

    protected RType keepTypeAliasIfPossibleImpl(RuleApplicationTrace _trace_, final RAliasType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("keepTypeAliasIfPossible") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ", " + RosettaTypingAuxiliary.this.stringRep(combineUnderlyingTypes) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
            this.keepTypeAliasIfPossibleThrowException(this.auxFunName("keepTypeAliasIfPossible") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ", " + this.stringRep(combineUnderlyingTypes) + ")", KEEPTYPEALIASIFPOSSIBLE, e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunKeepTypeAliasIfPossible(RuleApplicationTrace _trace_, RAliasType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        return this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2, combineUnderlyingTypes);
    }

    protected RType keepTypeAliasIfPossibleImpl(RuleApplicationTrace _trace_, final RType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("keepTypeAliasIfPossible") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ", " + RosettaTypingAuxiliary.this.stringRep(combineUnderlyingTypes) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
            this.keepTypeAliasIfPossibleThrowException(this.auxFunName("keepTypeAliasIfPossible") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ", " + this.stringRep(combineUnderlyingTypes) + ")", KEEPTYPEALIASIFPOSSIBLE, e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunKeepTypeAliasIfPossible(RuleApplicationTrace _trace_, RType t1, RAliasType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        return this.keepTypeAliasIfPossibleInternal(_trace_, t1, t2.getRefersTo(), combineUnderlyingTypes);
    }

    protected RType keepTypeAliasIfPossibleImpl(RuleApplicationTrace _trace_, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final RType _result_ = this.applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("keepTypeAliasIfPossible") + "(" + RosettaTypingAuxiliary.this.stringRep(t1) + ", " + RosettaTypingAuxiliary.this.stringRep(t2) + ", " + RosettaTypingAuxiliary.this.stringRep(combineUnderlyingTypes) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
            this.keepTypeAliasIfPossibleThrowException(this.auxFunName("keepTypeAliasIfPossible") + "(" + this.stringRep(t1) + ", " + this.stringRep(t2) + ", " + this.stringRep(combineUnderlyingTypes) + ")", KEEPTYPEALIASIFPOSSIBLE, e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[0]);
            return null;
        }
    }

    protected RType applyAuxFunKeepTypeAliasIfPossible(RuleApplicationTrace _trace_, RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
        return combineUnderlyingTypes.apply(t1, t2);
    }

    protected Iterable<? extends RosettaFeature> allFeaturesImpl(RuleApplicationTrace _trace_, final RType t, final ResourceSet resourceSet) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Iterable<? extends RosettaFeature> _result_ = this.applyAuxFunAllFeatures(_subtrace_, t, resourceSet);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingAuxiliary.this.auxFunName("allFeatures") + "(" + RosettaTypingAuxiliary.this.stringRep(t) + ", " + RosettaTypingAuxiliary.this.stringRep(resourceSet) + ") = " + RosettaTypingAuxiliary.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunAllFeatures) {
            this.allFeaturesThrowException(this.auxFunName("allFeatures") + "(" + this.stringRep(t) + ", " + this.stringRep(resourceSet) + ")", ALLFEATURES, e_applyAuxFunAllFeatures, t, resourceSet, new ErrorInformation[0]);
            return null;
        }
    }

    protected Iterable<? extends RosettaFeature> applyAuxFunAllFeatures(RuleApplicationTrace _trace_, RType t, ResourceSet resourceSet) throws RuleFailedException {
        Iterable<RosettaDefinable> _switchResult = null;
        boolean _matched = false;
        if (t instanceof RDataType) {
            _matched = true;
            _switchResult = this.allAttributesInternal(_trace_, ((RDataType)t).getData());
        }
        if (!_matched && t instanceof REnumType) {
            _matched = true;
            _switchResult = this.allEnumValuesInternal(_trace_, ((REnumType)t).getEnumeration());
        }
        if (!_matched && t instanceof RRecordType) {
            _matched = true;
            List<Object> _xifexpression = null;
            _xifexpression = resourceSet != null ? this.builtinTypes.toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures() : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }
}

