/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.typing.RosettaTyping;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RosettaTypingChecking
extends RosettaTyping {
    public static final String LISTSUBTYPECHECK = "com.regnosys.rosetta.typing.ListSubtypeCheck";
    public static final String LOOSELISTSUBTYPECHECK = "com.regnosys.rosetta.typing.LooseListSubtypeCheck";
    public static final String SUBTYPECHECK = "com.regnosys.rosetta.typing.SubtypeCheck";
    public static final String COMPARABLELISTTYPECHECK = "com.regnosys.rosetta.typing.ComparableListTypeCheck";
    public static final String COMPARABLETYPECHECK = "com.regnosys.rosetta.typing.ComparableTypeCheck";
    public static final String ONLYRIGHTISSINGULARCHECK = "com.regnosys.rosetta.typing.OnlyRightIsSingularCheck";
    public static final String LOOSEONLYRIGHTISSINGULARCHECK = "com.regnosys.rosetta.typing.LooseOnlyRightIsSingularCheck";
    public static final String CONSTRAINTCHECK = "com.regnosys.rosetta.typing.ConstraintCheck";
    public static final String LOOSECONSTRAINTCHECK = "com.regnosys.rosetta.typing.LooseConstraintCheck";
    public static final String NOTCONSTRAINTCHECK = "com.regnosys.rosetta.typing.NotConstraintCheck";
    public static final String ISLOOSERCONSTRAINTCHECK = "com.regnosys.rosetta.typing.IsLooserConstraintCheck";
    @Extension
    @Inject
    private TypeFactory typeFactory;
    @Extension
    @Inject
    private TypeValidationUtil util;
    @Extension
    @Inject
    private ExpressionHelper exprHelper;
    @Extension
    @Inject
    private ImplicitVariableUtil implicitVarUtil;
    @Extension
    @Inject
    private RBuiltinTypeService builtinTypes;
    @Inject
    private RosettaInterpreter interpreter;
    @Inject
    private RosettaSimpleSystemSolver systemSolver;
    private PolymorphicDispatcher<Boolean> listSubtypeCheckDispatcher;
    private PolymorphicDispatcher<Boolean> looseListSubtypeCheckDispatcher;
    private PolymorphicDispatcher<Boolean> subtypeCheckDispatcher;
    private PolymorphicDispatcher<Boolean> comparableListTypeCheckDispatcher;
    private PolymorphicDispatcher<Boolean> comparableTypeCheckDispatcher;
    private PolymorphicDispatcher<Boolean> onlyRightIsSingularCheckDispatcher;
    private PolymorphicDispatcher<Boolean> looseOnlyRightIsSingularCheckDispatcher;
    private PolymorphicDispatcher<Boolean> constraintCheckDispatcher;
    private PolymorphicDispatcher<Boolean> looseConstraintCheckDispatcher;
    private PolymorphicDispatcher<Boolean> notConstraintCheckDispatcher;
    private PolymorphicDispatcher<Boolean> isLooserConstraintCheckDispatcher;

    public RosettaTypingChecking() {
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.listSubtypeCheckDispatcher = this.buildPolymorphicDispatcher("listSubtypeCheckImpl", 3);
        this.looseListSubtypeCheckDispatcher = this.buildPolymorphicDispatcher("looseListSubtypeCheckImpl", 3);
        this.subtypeCheckDispatcher = this.buildPolymorphicDispatcher("subtypeCheckImpl", 3);
        this.comparableListTypeCheckDispatcher = this.buildPolymorphicDispatcher("comparableListTypeCheckImpl", 2);
        this.comparableTypeCheckDispatcher = this.buildPolymorphicDispatcher("comparableTypeCheckImpl", 2);
        this.onlyRightIsSingularCheckDispatcher = this.buildPolymorphicDispatcher("onlyRightIsSingularCheckImpl", 2);
        this.looseOnlyRightIsSingularCheckDispatcher = this.buildPolymorphicDispatcher("looseOnlyRightIsSingularCheckImpl", 2);
        this.constraintCheckDispatcher = this.buildPolymorphicDispatcher("constraintCheckImpl", 3);
        this.looseConstraintCheckDispatcher = this.buildPolymorphicDispatcher("looseConstraintCheckImpl", 3);
        this.notConstraintCheckDispatcher = this.buildPolymorphicDispatcher("notConstraintCheckImpl", 3);
        this.isLooserConstraintCheckDispatcher = this.buildPolymorphicDispatcher("isLooserConstraintCheckImpl", 3);
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void setTypeFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public TypeValidationUtil getUtil() {
        return this.util;
    }

    @Override
    public void setUtil(TypeValidationUtil util) {
        this.util = util;
    }

    @Override
    public ExpressionHelper getExprHelper() {
        return this.exprHelper;
    }

    @Override
    public void setExprHelper(ExpressionHelper exprHelper) {
        this.exprHelper = exprHelper;
    }

    @Override
    public ImplicitVariableUtil getImplicitVarUtil() {
        return this.implicitVarUtil;
    }

    @Override
    public void setImplicitVarUtil(ImplicitVariableUtil implicitVarUtil) {
        this.implicitVarUtil = implicitVarUtil;
    }

    @Override
    public RBuiltinTypeService getBuiltinTypes() {
        return this.builtinTypes;
    }

    @Override
    public void setBuiltinTypes(RBuiltinTypeService builtinTypes) {
        this.builtinTypes = builtinTypes;
    }

    @Override
    public RosettaInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public void setInterpreter(RosettaInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public RosettaSimpleSystemSolver getSystemSolver() {
        return this.systemSolver;
    }

    @Override
    public void setSystemSolver(RosettaSimpleSystemSolver systemSolver) {
        this.systemSolver = systemSolver;
    }

    public Boolean listSubtypeCheck(RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        return this.listSubtypeCheck(null, sourceObject, expected);
    }

    public Boolean listSubtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        try {
            return this.listSubtypeCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_listSubtypeCheck) {
            throw this.extractRuleFailedException(_e_listSubtypeCheck);
        }
    }

    public Boolean looseListSubtypeCheck(RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        return this.looseListSubtypeCheck(null, sourceObject, expected);
    }

    public Boolean looseListSubtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        try {
            return this.looseListSubtypeCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_looseListSubtypeCheck) {
            throw this.extractRuleFailedException(_e_looseListSubtypeCheck);
        }
    }

    public Boolean subtypeCheck(RosettaExpression sourceObject, RType expected) throws RuleFailedException {
        return this.subtypeCheck(null, sourceObject, expected);
    }

    public Boolean subtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RType expected) throws RuleFailedException {
        try {
            return this.subtypeCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_subtypeCheck) {
            throw this.extractRuleFailedException(_e_subtypeCheck);
        }
    }

    public Boolean comparableListTypeCheck(RosettaBinaryOperation sourceObject) throws RuleFailedException {
        return this.comparableListTypeCheck(null, sourceObject);
    }

    public Boolean comparableListTypeCheck(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) throws RuleFailedException {
        try {
            return this.comparableListTypeCheckInternal(_trace_, sourceObject);
        }
        catch (Exception _e_comparableListTypeCheck) {
            throw this.extractRuleFailedException(_e_comparableListTypeCheck);
        }
    }

    public Boolean comparableTypeCheck(RosettaBinaryOperation sourceObject) throws RuleFailedException {
        return this.comparableTypeCheck(null, sourceObject);
    }

    public Boolean comparableTypeCheck(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) throws RuleFailedException {
        try {
            return this.comparableTypeCheckInternal(_trace_, sourceObject);
        }
        catch (Exception _e_comparableTypeCheck) {
            throw this.extractRuleFailedException(_e_comparableTypeCheck);
        }
    }

    public Boolean onlyRightIsSingularCheck(ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        return this.onlyRightIsSingularCheck(null, sourceObject);
    }

    public Boolean onlyRightIsSingularCheck(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        try {
            return this.onlyRightIsSingularCheckInternal(_trace_, sourceObject);
        }
        catch (Exception _e_onlyRightIsSingularCheck) {
            throw this.extractRuleFailedException(_e_onlyRightIsSingularCheck);
        }
    }

    public Boolean looseOnlyRightIsSingularCheck(ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        return this.looseOnlyRightIsSingularCheck(null, sourceObject);
    }

    public Boolean looseOnlyRightIsSingularCheck(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        try {
            return this.looseOnlyRightIsSingularCheckInternal(_trace_, sourceObject);
        }
        catch (Exception _e_looseOnlyRightIsSingularCheck) {
            throw this.extractRuleFailedException(_e_looseOnlyRightIsSingularCheck);
        }
    }

    public Boolean constraintCheck(RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        return this.constraintCheck(null, sourceObject, expected);
    }

    public Boolean constraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        try {
            return this.constraintCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_constraintCheck) {
            throw this.extractRuleFailedException(_e_constraintCheck);
        }
    }

    public Boolean looseConstraintCheck(RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        return this.looseConstraintCheck(null, sourceObject, expected);
    }

    public Boolean looseConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        try {
            return this.looseConstraintCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_looseConstraintCheck) {
            throw this.extractRuleFailedException(_e_looseConstraintCheck);
        }
    }

    public Boolean notConstraintCheck(RosettaExpression sourceObject, RosettaCardinality notExpected) throws RuleFailedException {
        return this.notConstraintCheck(null, sourceObject, notExpected);
    }

    public Boolean notConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality notExpected) throws RuleFailedException {
        try {
            return this.notConstraintCheckInternal(_trace_, sourceObject, notExpected);
        }
        catch (Exception _e_notConstraintCheck) {
            throw this.extractRuleFailedException(_e_notConstraintCheck);
        }
    }

    public Boolean isLooserConstraintCheck(RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        return this.isLooserConstraintCheck(null, sourceObject, expected);
    }

    public Boolean isLooserConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        try {
            return this.isLooserConstraintCheckInternal(_trace_, sourceObject, expected);
        }
        catch (Exception _e_isLooserConstraintCheck) {
            throw this.extractRuleFailedException(_e_isLooserConstraintCheck);
        }
    }

    public Result<Boolean> checkLeftArithmetic(ArithmeticOperation op) {
        return this.checkLeftArithmetic(null, op);
    }

    public Result<Boolean> checkLeftArithmetic(RuleApplicationTrace _trace_, ArithmeticOperation op) {
        try {
            return this.checkLeftArithmeticInternal(_trace_, op);
        }
        catch (Exception _e_CheckLeftArithmetic) {
            return this.resultForFailure(_e_CheckLeftArithmetic);
        }
    }

    protected Result<Boolean> checkLeftArithmeticInternal(RuleApplicationTrace _trace_, ArithmeticOperation op) throws RuleFailedException {
        block14: {
            String _operator = op.getOperator();
            boolean _equals = Objects.equal((Object)_operator, (Object)"+");
            if (_equals) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
                    }
                    break block14;
                }
                catch (Exception e) {
                    previousFailure = this.extractRuleFailedException(e);
                    try {
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedString).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedString)");
                        }
                        break block14;
                    }
                    catch (Exception e_1) {
                        previousFailure = this.extractRuleFailedException(e_1);
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
                        }
                        break block14;
                    }
                }
            }
            String _operator_1 = op.getOperator();
            boolean _equals_1 = Objects.equal((Object)_operator_1, (Object)"-");
            if (_equals_1) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
                    }
                    break block14;
                }
                catch (Exception e_2) {
                    previousFailure = this.extractRuleFailedException(e_2);
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
                    }
                    break block14;
                }
            }
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkRightArithmetic(ArithmeticOperation op) {
        return this.checkRightArithmetic(null, op);
    }

    public Result<Boolean> checkRightArithmetic(RuleApplicationTrace _trace_, ArithmeticOperation op) {
        try {
            return this.checkRightArithmeticInternal(_trace_, op);
        }
        catch (Exception _e_CheckRightArithmetic) {
            return this.resultForFailure(_e_CheckRightArithmetic);
        }
    }

    protected Result<Boolean> checkRightArithmeticInternal(RuleApplicationTrace _trace_, ArithmeticOperation op) throws RuleFailedException {
        block14: {
            String _operator = op.getOperator();
            boolean _equals = Objects.equal((Object)_operator, (Object)"+");
            if (_equals) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleTime).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleTime)");
                    }
                    break block14;
                }
                catch (Exception e) {
                    previousFailure = this.extractRuleFailedException(e);
                    try {
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedString).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedString)");
                        }
                        break block14;
                    }
                    catch (Exception e_1) {
                        previousFailure = this.extractRuleFailedException(e_1);
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
                        }
                        break block14;
                    }
                }
            }
            String _operator_1 = op.getOperator();
            boolean _equals_1 = Objects.equal((Object)_operator_1, (Object)"-");
            if (_equals_1) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleDate).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleDate)");
                    }
                    break block14;
                }
                catch (Exception e_2) {
                    previousFailure = this.extractRuleFailedException(e_2);
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
                    }
                    break block14;
                }
            }
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkAddition(ArithmeticOperation op) {
        return this.checkAddition(null, op);
    }

    public Result<Boolean> checkAddition(RuleApplicationTrace _trace_, ArithmeticOperation op) {
        try {
            return this.checkAdditionInternal(_trace_, op);
        }
        catch (Exception _e_CheckAddition) {
            return this.resultForFailure(_e_CheckAddition);
        }
    }

    protected Result<Boolean> checkAdditionInternal(RuleApplicationTrace _trace_, ArithmeticOperation op) throws RuleFailedException {
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = op.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = op.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            String _operator = op.getOperator();
            boolean _equals = Objects.equal((Object)_operator, (Object)"+");
            if (_equals) {
                RuleFailedException previousFailure2 = null;
                try {
                    RType _itemType = tl.getItemType();
                    this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType, this.builtinTypes.DATE);
                    RType _itemType_1 = tr.getItemType();
                    this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_1, this.builtinTypes.TIME);
                }
                catch (Exception e_2) {
                    previousFailure2 = this.extractRuleFailedException(e_2);
                    try {
                        RType _itemType_2 = tl.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_2, this.builtinTypes.UNCONSTRAINED_STRING);
                        RType _itemType_3 = tr.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_3, this.builtinTypes.UNCONSTRAINED_STRING);
                    }
                    catch (Exception e_3) {
                        previousFailure2 = this.extractRuleFailedException(e_3);
                        try {
                            RType _itemType_4 = tl.getItemType();
                            this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_4, this.builtinTypes.UNCONSTRAINED_NUMBER);
                            RType _itemType_5 = tr.getItemType();
                            this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_5, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        }
                        catch (Exception e_4) {
                            String _plus_3;
                            previousFailure2 = this.extractRuleFailedException(e_4);
                            CharSequence _relevantItemTypeDescription = this.util.relevantItemTypeDescription(tl, tr);
                            String _plus = "Expected arguments to be either both a `string` or both a `number`, but got `" + _relevantItemTypeDescription;
                            String _plus_1 = _plus + "` and `";
                            CharSequence _relevantItemTypeDescription_1 = this.util.relevantItemTypeDescription(tr, tl);
                            String _plus_2 = _plus_1 + _relevantItemTypeDescription_1;
                            String error = _plus_3 = _plus_2 + "` instead.";
                            ArithmeticOperation source = op;
                            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
                        }
                    }
                }
            } else {
                String _operator_1 = op.getOperator();
                boolean _equals_1 = Objects.equal((Object)_operator_1, (Object)"-");
                if (_equals_1) {
                    RuleFailedException previousFailure3 = null;
                    try {
                        RType _itemType_6 = tl.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_6, this.builtinTypes.DATE);
                        RType _itemType_7 = tr.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_7, this.builtinTypes.DATE);
                    }
                    catch (Exception e_5) {
                        previousFailure3 = this.extractRuleFailedException(e_5);
                        try {
                            RType _itemType_8 = tl.getItemType();
                            this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_8, this.builtinTypes.UNCONSTRAINED_NUMBER);
                            RType _itemType_9 = tr.getItemType();
                            this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_9, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        }
                        catch (Exception e_6) {
                            String _plus_7;
                            previousFailure3 = this.extractRuleFailedException(e_6);
                            String _string = tl.getItemType().toString();
                            String _plus_4 = "Expected arguments to be either both a `date` or both a `number`, but got `" + _string;
                            String _plus_5 = _plus_4 + "` and `";
                            String _string_1 = tr.getItemType().toString();
                            String _plus_6 = _plus_5 + _string_1;
                            String error_1 = _plus_7 = _plus_6 + "` instead.";
                            ArithmeticOperation source_1 = op;
                            this.throwForExplicitFail(error_1, new ErrorInformation((EObject)source_1, null));
                        }
                    }
                }
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkEqualityOperation(EqualityOperation op) {
        return this.checkEqualityOperation(null, op);
    }

    public Result<Boolean> checkEqualityOperation(RuleApplicationTrace _trace_, EqualityOperation op) {
        try {
            return this.checkEqualityOperationInternal(_trace_, op);
        }
        catch (Exception _e_CheckEqualityOperation) {
            return this.resultForFailure(_e_CheckEqualityOperation);
        }
    }

    protected Result<Boolean> checkEqualityOperationInternal(RuleApplicationTrace _trace_, EqualityOperation op) throws RuleFailedException {
        boolean _tripleEquals;
        CardinalityModifier _cardMod = op.getCardMod();
        boolean bl = _tripleEquals = _cardMod == CardinalityModifier.NONE;
        if (_tripleEquals) {
            if (!this.comparableListTypeCheckInternal(_trace_, op).booleanValue()) {
                this.sneakyThrowRuleFailedException("comparableListTypeCheck(op)");
            }
        } else {
            Boolean _looseOnlyRightIsSingularCheck = this.looseOnlyRightIsSingularCheckInternal(_trace_, op);
            if (!_looseOnlyRightIsSingularCheck.booleanValue()) {
                this.sneakyThrowRuleFailedException("looseOnlyRightIsSingularCheck(op)");
            }
            if (!this.comparableTypeCheckInternal(_trace_, op).booleanValue()) {
                this.sneakyThrowRuleFailedException("comparableTypeCheck(op)");
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkLeftLogical(LogicalOperation op) {
        return this.checkLeftLogical(null, op);
    }

    public Result<Boolean> checkLeftLogical(RuleApplicationTrace _trace_, LogicalOperation op) {
        try {
            return this.checkLeftLogicalInternal(_trace_, op);
        }
        catch (Exception _e_CheckLeftLogical) {
            return this.resultForFailure(_e_CheckLeftLogical);
        }
    }

    protected Result<Boolean> checkLeftLogicalInternal(RuleApplicationTrace _trace_, LogicalOperation op) throws RuleFailedException {
        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleBoolean).booleanValue()) {
            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleBoolean)");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkRightLogical(LogicalOperation op) {
        return this.checkRightLogical(null, op);
    }

    public Result<Boolean> checkRightLogical(RuleApplicationTrace _trace_, LogicalOperation op) {
        try {
            return this.checkRightLogicalInternal(_trace_, op);
        }
        catch (Exception _e_CheckRightLogical) {
            return this.resultForFailure(_e_CheckRightLogical);
        }
    }

    protected Result<Boolean> checkRightLogicalInternal(RuleApplicationTrace _trace_, LogicalOperation op) throws RuleFailedException {
        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleBoolean).booleanValue()) {
            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleBoolean)");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkLeftComparison(ComparisonOperation op) {
        return this.checkLeftComparison(null, op);
    }

    public Result<Boolean> checkLeftComparison(RuleApplicationTrace _trace_, ComparisonOperation op) {
        try {
            return this.checkLeftComparisonInternal(_trace_, op);
        }
        catch (Exception _e_CheckLeftComparison) {
            return this.resultForFailure(_e_CheckLeftComparison);
        }
    }

    protected Result<Boolean> checkLeftComparisonInternal(RuleApplicationTrace _trace_, ComparisonOperation op) throws RuleFailedException {
        block14: {
            boolean _tripleEquals;
            CardinalityModifier _cardMod = op.getCardMod();
            boolean bl = _tripleEquals = _cardMod == CardinalityModifier.NONE;
            if (_tripleEquals) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleZonedDateTime).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleZonedDateTime)");
                    }
                    break block14;
                }
                catch (Exception e) {
                    previousFailure = this.extractRuleFailedException(e);
                    try {
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
                        }
                        break block14;
                    }
                    catch (Exception e_1) {
                        previousFailure = this.extractRuleFailedException(e_1);
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
                        }
                        break block14;
                    }
                }
            }
            RuleFailedException previousFailure = null;
            try {
                if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.ZONED_DATE_TIME).booleanValue()) {
                    this.sneakyThrowRuleFailedException("subtypeCheck(op.left, ZONED_DATE_TIME)");
                }
            }
            catch (Exception e_2) {
                previousFailure = this.extractRuleFailedException(e_2);
                try {
                    if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.DATE).booleanValue()) {
                        this.sneakyThrowRuleFailedException("subtypeCheck(op.left, DATE)");
                    }
                }
                catch (Exception e_3) {
                    previousFailure = this.extractRuleFailedException(e_3);
                    if (this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue()) break block14;
                    this.sneakyThrowRuleFailedException("subtypeCheck(op.left, UNCONSTRAINED_NUMBER)");
                }
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkRightComparison(ComparisonOperation op) {
        return this.checkRightComparison(null, op);
    }

    public Result<Boolean> checkRightComparison(RuleApplicationTrace _trace_, ComparisonOperation op) {
        try {
            return this.checkRightComparisonInternal(_trace_, op);
        }
        catch (Exception _e_CheckRightComparison) {
            return this.resultForFailure(_e_CheckRightComparison);
        }
    }

    protected Result<Boolean> checkRightComparisonInternal(RuleApplicationTrace _trace_, ComparisonOperation op) throws RuleFailedException {
        block14: {
            boolean _tripleEquals;
            CardinalityModifier _cardMod = op.getCardMod();
            boolean bl = _tripleEquals = _cardMod == CardinalityModifier.NONE;
            if (_tripleEquals) {
                RuleFailedException previousFailure = null;
                try {
                    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleZonedDateTime).booleanValue()) {
                        this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleZonedDateTime)");
                    }
                    break block14;
                }
                catch (Exception e) {
                    previousFailure = this.extractRuleFailedException(e);
                    try {
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleDate).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleDate)");
                        }
                        break block14;
                    }
                    catch (Exception e_1) {
                        previousFailure = this.extractRuleFailedException(e_1);
                        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber).booleanValue()) {
                            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
                        }
                        break block14;
                    }
                }
            }
            RuleFailedException previousFailure = null;
            try {
                if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.ZONED_DATE_TIME).booleanValue()) {
                    this.sneakyThrowRuleFailedException("subtypeCheck(op.left, ZONED_DATE_TIME)");
                }
            }
            catch (Exception e_2) {
                previousFailure = this.extractRuleFailedException(e_2);
                try {
                    if (!this.subtypeCheckInternal(_trace_, op.getRight(), this.builtinTypes.DATE).booleanValue()) {
                        this.sneakyThrowRuleFailedException("subtypeCheck(op.right, DATE)");
                    }
                }
                catch (Exception e_3) {
                    previousFailure = this.extractRuleFailedException(e_3);
                    if (this.subtypeCheckInternal(_trace_, op.getRight(), this.builtinTypes.UNCONSTRAINED_NUMBER).booleanValue()) break block14;
                    this.sneakyThrowRuleFailedException("subtypeCheck(op.right, UNCONSTRAINED_NUMBER)");
                }
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkComparison(ComparisonOperation op) {
        return this.checkComparison(null, op);
    }

    public Result<Boolean> checkComparison(RuleApplicationTrace _trace_, ComparisonOperation op) {
        try {
            return this.checkComparisonInternal(_trace_, op);
        }
        catch (Exception _e_CheckComparison) {
            return this.resultForFailure(_e_CheckComparison);
        }
    }

    protected Result<Boolean> checkComparisonInternal(RuleApplicationTrace _trace_, ComparisonOperation op) throws RuleFailedException {
        CardinalityModifier _cardMod;
        boolean _tripleNotEquals;
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = op.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = op.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            previousFailure = null;
            try {
                RType _itemType = tl.getItemType();
                this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType, this.builtinTypes.ZONED_DATE_TIME);
                RType _itemType_1 = tr.getItemType();
                this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_1, this.builtinTypes.ZONED_DATE_TIME);
            }
            catch (Exception e_2) {
                previousFailure = this.extractRuleFailedException(e_2);
                try {
                    RType _itemType_2 = tl.getItemType();
                    this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_2, this.builtinTypes.DATE);
                    RType _itemType_3 = tr.getItemType();
                    this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_3, this.builtinTypes.DATE);
                }
                catch (Exception e_3) {
                    previousFailure = this.extractRuleFailedException(e_3);
                    try {
                        RType _itemType_4 = tl.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_4, this.builtinTypes.UNCONSTRAINED_NUMBER);
                        RType _itemType_5 = tr.getItemType();
                        this.subtypeInternal(this.emptyEnvironment(), _trace_, _itemType_5, this.builtinTypes.UNCONSTRAINED_NUMBER);
                    }
                    catch (Exception e_4) {
                        String _plus_3;
                        previousFailure = this.extractRuleFailedException(e_4);
                        String _string = tl.getItemType().toString();
                        String _plus = "Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + _string;
                        String _plus_1 = _plus + "` and `";
                        String _string_1 = tr.getItemType().toString();
                        String _plus_2 = _plus_1 + _string_1;
                        String error = _plus_3 = _plus_2 + "` instead.";
                        ComparisonOperation source = op;
                        this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
                    }
                }
            }
        }
        boolean bl = _tripleNotEquals = (_cardMod = op.getCardMod()) != CardinalityModifier.NONE;
        if (_tripleNotEquals && !this.looseOnlyRightIsSingularCheckInternal(_trace_, op).booleanValue()) {
            this.sneakyThrowRuleFailedException("looseOnlyRightIsSingularCheck(op)");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkIfConditionalExpression(RosettaConditionalExpression e) {
        return this.checkIfConditionalExpression(null, e);
    }

    public Result<Boolean> checkIfConditionalExpression(RuleApplicationTrace _trace_, RosettaConditionalExpression e) {
        try {
            return this.checkIfConditionalExpressionInternal(_trace_, e);
        }
        catch (Exception _e_CheckIfConditionalExpression) {
            return this.resultForFailure(_e_CheckIfConditionalExpression);
        }
    }

    protected Result<Boolean> checkIfConditionalExpressionInternal(RuleApplicationTrace _trace_, RosettaConditionalExpression e) throws RuleFailedException {
        if (!this.looseListSubtypeCheckInternal(_trace_, e.getIf(), this.typeFactory.singleBoolean).booleanValue()) {
            this.sneakyThrowRuleFailedException("looseListSubtypeCheck(e.^if, singleBoolean)");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkBodyConditionalExpression(RosettaConditionalExpression e) {
        return this.checkBodyConditionalExpression(null, e);
    }

    public Result<Boolean> checkBodyConditionalExpression(RuleApplicationTrace _trace_, RosettaConditionalExpression e) {
        try {
            return this.checkBodyConditionalExpressionInternal(_trace_, e);
        }
        catch (Exception _e_CheckBodyConditionalExpression) {
            return this.resultForFailure(_e_CheckBodyConditionalExpression);
        }
    }

    protected Result<Boolean> checkBodyConditionalExpressionInternal(RuleApplicationTrace _trace_, RosettaConditionalExpression e) throws RuleFailedException {
        RListType tthen = null;
        RListType telse = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _ifthen = e.getIfthen();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _ifthen);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tthen = (RListType)result.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tthen = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _elsethen = e.getElsethen();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _elsethen);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            telse = (RListType)result_1.getFirst();
        }
        catch (Exception e_2) {
            previousFailure = this.extractRuleFailedException(e_2);
            telse = null;
        }
        if (tthen != null && telse != null) {
            RListType joined = this.listJoinInternal(_trace_, tthen, telse);
            RType _itemType = joined.getItemType();
            boolean _ruleinvocation = this.subtypeSucceeded(this.emptyEnvironment(), _trace_, this.builtinTypes.ANY, _itemType);
            if (_ruleinvocation) {
                String _plus_3;
                String _name = tthen.getItemType().getName();
                String _plus = "Types `" + _name;
                String _plus_1 = _plus + "` and `";
                String _name_1 = telse.getItemType().getName();
                String _plus_2 = _plus_1 + _name_1;
                String error = _plus_3 = _plus_2 + "` do not have a common supertype.";
                this.throwForExplicitFail(error, new ErrorInformation(null, null));
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkListLiteral(ListLiteral e) {
        return this.checkListLiteral(null, e);
    }

    public Result<Boolean> checkListLiteral(RuleApplicationTrace _trace_, ListLiteral e) {
        try {
            return this.checkListLiteralInternal(_trace_, e);
        }
        catch (Exception _e_CheckListLiteral) {
            return this.resultForFailure(_e_CheckListLiteral);
        }
    }

    protected Result<Boolean> checkListLiteralInternal(final RuleApplicationTrace _trace_, ListLiteral e) throws RuleFailedException {
        ArrayList telems = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            RListType telem = null;
            RuleFailedException previousFailure = null;
            try {
                Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, (RosettaExpression)it);
                this.checkAssignableTo(result.getFirst(), RListType.class);
                telem = (RListType)result.getFirst();
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                telem = null;
            }
            if (telem != null && !telems.add(telem)) {
                this.sneakyThrowRuleFailedException("telems.add(telem)");
            }
            _xblockexpression = telem != null;
            return _xblockexpression;
        };
        boolean _forall = IterableExtensions.forall(e.getElements(), (Functions.Function1)_function);
        if (_forall) {
            RuleFailedException previousFailure = null;
            try {
                boolean _tripleNotEquals;
                Functions.Function2<RListType, RListType, RListType> _function_1 = new Functions.Function2<RListType, RListType, RListType>(){

                    public RListType apply(RListType acc, RListType telem) {
                        RListType _xifexpression = null;
                        if (acc == null) {
                            _xifexpression = null;
                        } else {
                            RListType _xblockexpression = null;
                            RType sup = RosettaTypingChecking.this.joinInternal(_trace_, telem.getItemType(), acc.getItemType());
                            RListType _xifexpression_1 = null;
                            boolean _ruleinvocation = RosettaTypingChecking.this.subtypeSucceeded(RosettaTypingChecking.this.emptyEnvironment(), _trace_, RosettaTypingChecking.this.builtinTypes.ANY, sup);
                            if (_ruleinvocation) {
                                _xifexpression_1 = null;
                            } else {
                                RosettaCardinality _constraint = telem.getConstraint();
                                RosettaCardinality _constraint_1 = acc.getConstraint();
                                RosettaCardinality _plus = _constraint.operator_plus(_constraint_1);
                                _xifexpression_1 = RosettaTypingChecking.this.typeFactory.createListType(sup, _plus);
                            }
                            _xifexpression = _xblockexpression = _xifexpression_1;
                        }
                        return _xifexpression;
                    }
                };
                RListType _fold = (RListType)IterableExtensions.fold((Iterable)telems, (Object)this.typeFactory.emptyNothing, (Functions.Function2)_function_1);
                boolean bl = _tripleNotEquals = _fold != null;
                if (!_tripleNotEquals) {
                    this.sneakyThrowRuleFailedException("telems.fold(emptyNothing, [ RListType acc, RListType telem | if (acc === null) { null } else { val sup = join(telem.itemType, acc.itemType); if ({empty |- ANY <: sup}) { null } else { createListType(sup, telem.constraint + acc.constraint) } } ]) !== null");
                }
            }
            catch (Exception e_1) {
                String _plus_1;
                previousFailure = this.extractRuleFailedException(e_1);
                Functions.Function1<RListType, CharSequence> _function_2 = new Functions.Function1<RListType, CharSequence>(){

                    public CharSequence apply(RListType it) {
                        String _name = it.getItemType().getName();
                        String _plus = "`" + _name;
                        return _plus + "`";
                    }
                };
                String _join = IterableExtensions.join((Iterable)telems, (CharSequence)", ", (Functions.Function1)_function_2);
                String _plus = "Elements do not have a common supertype: " + _join;
                String error = _plus_1 = _plus + ".";
                this.throwForExplicitFail(error, new ErrorInformation(null, null));
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkRosettaSymbolReference(RosettaSymbolReference e) {
        return this.checkRosettaSymbolReference(null, e);
    }

    public Result<Boolean> checkRosettaSymbolReference(RuleApplicationTrace _trace_, RosettaSymbolReference e) {
        try {
            return this.checkRosettaSymbolReferenceInternal(_trace_, e);
        }
        catch (Exception _e_CheckRosettaSymbolReference) {
            return this.resultForFailure(_e_CheckRosettaSymbolReference);
        }
    }

    protected Result<Boolean> checkRosettaSymbolReferenceInternal(RuleApplicationTrace _trace_, RosettaSymbolReference e) throws RuleFailedException {
        Functions.Function1 _function;
        int _size_5;
        String error;
        String _plus_5;
        String _plus_4;
        int _size_4;
        String _plus_3;
        String _plus_2;
        boolean _tripleEquals;
        int _size_3;
        String _xifexpression;
        String _plus_1;
        int _size_2;
        boolean _equals;
        int _size_1;
        RosettaSymbol f = e.getSymbol();
        boolean _matched = false;
        if (f instanceof RosettaExternalFunction) {
            _matched = true;
            RuleFailedException previousFailure = null;
            try {
                int _size = ((RosettaExternalFunction)f).getParameters().size();
                _size_1 = e.getArgs().size();
                boolean bl = _equals = _size == _size_1;
                if (!_equals) {
                    this.sneakyThrowRuleFailedException("f.parameters.size() == e.args.size()");
                }
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                _size_2 = ((RosettaExternalFunction)f).getParameters().size();
                String _plus = "Expected " + Integer.valueOf(_size_2);
                _plus_1 = _plus + " argument";
                _xifexpression = null;
                _size_3 = ((RosettaExternalFunction)f).getParameters().size();
                _tripleEquals = _size_3 == 1;
                _xifexpression = _tripleEquals ? "" : "s";
                _plus_2 = _plus_1 + _xifexpression;
                _plus_3 = _plus_2 + ", but got ";
                _size_4 = e.getArgs().size();
                _plus_4 = _plus_3 + Integer.valueOf(_size_4);
                error = _plus_5 = _plus_4 + " instead.";
                this.throwForExplicitFail(error, new ErrorInformation(null, null));
            }
            _size_5 = e.getArgs().size();
            _function = idx -> {
                Boolean _xblockexpression = null;
                RosettaParameter param = (RosettaParameter)((RosettaExternalFunction)f).getParameters().get(idx.intValue());
                RListType _xifexpression_1 = null;
                boolean _isIsArray = param.isIsArray();
                if (_isIsArray) {
                    TypeCall _typeCall = param.getTypeCall();
                    RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
                    _xifexpression_1 = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), 0);
                } else {
                    TypeCall _typeCall_1 = param.getTypeCall();
                    RosettaInterpreterContext _rosettaInterpreterContext_1 = new RosettaInterpreterContext();
                    _xifexpression_1 = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall_1, _rosettaInterpreterContext_1), 1, 1);
                }
                RListType paramType = _xifexpression_1;
                _xblockexpression = this.looseListSubtypeCheckInternal(_trace_, (RosettaExpression)e.getArgs().get(idx.intValue()), paramType);
                return _xblockexpression;
            };
            if (!IterableExtensions.forall((Iterable)new ExclusiveRange(0, _size_5, true), (Functions.Function1)_function)) {
                this.sneakyThrowRuleFailedException("(0..<e.args.size).forall[idx | val param = f.parameters.get(idx) val paramType = if (param.isArray) createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 0) else createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 1, 1) looseListSubtypeCheck(e.args.get(idx), paramType) ]");
            }
        }
        if (!_matched && f instanceof Function) {
            _matched = true;
            RuleFailedException previousFailure = null;
            try {
                int _size = ((Function)f).getInputs().size();
                _size_1 = e.getArgs().size();
                boolean bl = _equals = _size == _size_1;
                if (!_equals) {
                    this.sneakyThrowRuleFailedException("f.inputs.size() == e.args.size()");
                }
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                _size_2 = ((Function)f).getInputs().size();
                String _plus = "Expected " + Integer.valueOf(_size_2);
                _plus_1 = _plus + " argument";
                _xifexpression = null;
                _size_3 = ((Function)f).getInputs().size();
                _tripleEquals = _size_3 == 1;
                _xifexpression = _tripleEquals ? "" : "s";
                _plus_2 = _plus_1 + _xifexpression;
                _plus_3 = _plus_2 + ", but got ";
                _size_4 = e.getArgs().size();
                _plus_4 = _plus_3 + Integer.valueOf(_size_4);
                error = _plus_5 = _plus_4 + " instead.";
                this.throwForExplicitFail(error, new ErrorInformation(null, null));
            }
            _size_5 = e.getArgs().size();
            _function = idx -> this.looseListSubtypeCheckInternal(_trace_, (RosettaExpression)e.getArgs().get(idx.intValue()), this.attributeListTypeInternal(_trace_, (Attribute)((Function)f).getInputs().get(idx.intValue())));
            if (!IterableExtensions.forall((Iterable)new ExclusiveRange(0, _size_5, true), (Functions.Function1)_function)) {
                this.sneakyThrowRuleFailedException("(0..<e.args.size).forall[idx | looseListSubtypeCheck(e.args.get(idx), f.inputs.get(idx).attributeListType) ]");
            }
        }
        if (!_matched && f instanceof RosettaRule) {
            RListType paramType;
            _matched = true;
            RuleFailedException previousFailure = null;
            try {
                boolean _equals2;
                int _size = e.getArgs().size();
                boolean bl = _equals2 = 1 == _size;
                if (!_equals2) {
                    this.sneakyThrowRuleFailedException("1 == e.args.size()");
                }
            }
            catch (Exception e_1) {
                previousFailure = this.extractRuleFailedException(e_1);
                _size_1 = e.getArgs().size();
                String _plus = "Expected 1 argument, but got " + Integer.valueOf(_size_1);
                String error2 = _plus_1 = _plus + " instead.";
                this.throwForExplicitFail(error2, new ErrorInformation(null, null));
            }
            TypeCall _input = ((RosettaRule)f).getInput();
            RType _typeCallToRType = null;
            if (_input != null) {
                RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
                _typeCallToRType = this.typeCallToRTypeInternal(_trace_, _input, _rosettaInterpreterContext);
            }
            RListType _createListType = null;
            if (_typeCallToRType != null) {
                _createListType = this.typeFactory.createListType(_typeCallToRType, this.typeFactory.single);
            }
            if ((paramType = _createListType) != null && !this.looseListSubtypeCheckInternal(_trace_, (RosettaExpression)IterableExtensions.head(e.getArgs()), paramType).booleanValue()) {
                this.sneakyThrowRuleFailedException("looseListSubtypeCheck(e.args.head, paramType)");
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkExistsExpression(RosettaExistsExpression e) {
        return this.checkExistsExpression(null, e);
    }

    public Result<Boolean> checkExistsExpression(RuleApplicationTrace _trace_, RosettaExistsExpression e) {
        try {
            return this.checkExistsExpressionInternal(_trace_, e);
        }
        catch (Exception _e_CheckExistsExpression) {
            return this.resultForFailure(_e_CheckExistsExpression);
        }
    }

    protected Result<Boolean> checkExistsExpressionInternal(RuleApplicationTrace _trace_, RosettaExistsExpression e) throws RuleFailedException {
        if (!this.isLooserConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.createConstraint(0, 1)).booleanValue()) {
            this.sneakyThrowRuleFailedException("isLooserConstraintCheck(e.argument, createConstraint(0, 1))");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkAbsentExpression(RosettaAbsentExpression e) {
        return this.checkAbsentExpression(null, e);
    }

    public Result<Boolean> checkAbsentExpression(RuleApplicationTrace _trace_, RosettaAbsentExpression e) {
        try {
            return this.checkAbsentExpressionInternal(_trace_, e);
        }
        catch (Exception _e_CheckAbsentExpression) {
            return this.resultForFailure(_e_CheckAbsentExpression);
        }
    }

    protected Result<Boolean> checkAbsentExpressionInternal(RuleApplicationTrace _trace_, RosettaAbsentExpression e) throws RuleFailedException {
        if (!this.isLooserConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.createConstraint(0, 1)).booleanValue()) {
            this.sneakyThrowRuleFailedException("isLooserConstraintCheck(e.argument, createConstraint(0, 1))");
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkOnlyExistsExpression(RosettaOnlyExistsExpression e) {
        return this.checkOnlyExistsExpression(null, e);
    }

    public Result<Boolean> checkOnlyExistsExpression(RuleApplicationTrace _trace_, RosettaOnlyExistsExpression e) {
        try {
            return this.checkOnlyExistsExpressionInternal(_trace_, e);
        }
        catch (Exception _e_CheckOnlyExistsExpression) {
            return this.resultForFailure(_e_CheckOnlyExistsExpression);
        }
    }

    protected Result<Boolean> checkOnlyExistsExpressionInternal(RuleApplicationTrace _trace_, RosettaOnlyExistsExpression e) throws RuleFailedException {
        RType _itemType;
        Data parentData;
        RosettaExpression first = (RosettaExpression)IterableExtensions.head(e.getArgs());
        RosettaExpression parent = this.exprHelper.getParentExpression(first);
        for (int i = 1; i < e.getArgs().size(); ++i) {
            RosettaExpression other = (RosettaExpression)e.getArgs().get(i);
            for (int j = 0; j < i; ++j) {
                boolean _equals = EcoreUtil2.equals((EObject)((EObject)e.getArgs().get(j)), (EObject)other);
                if (!_equals) continue;
                String error = "Duplicate attribute.";
                RosettaExpression source = other;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
            RosettaExpression otherParent = this.exprHelper.getParentExpression(other);
            if (Boolean.valueOf(parent == null) == Boolean.valueOf(otherParent == null) && (parent == null || otherParent == null || EcoreUtil2.equals((EObject)parent, (EObject)otherParent))) continue;
            if (otherParent != null) {
                String error = "All parent paths must be equal.";
                RosettaExpression source = otherParent;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
                continue;
            }
            String error_1 = "All parent paths must be equal.";
            RosettaExpression source_1 = other;
            this.throwForExplicitFail(error_1, new ErrorInformation((EObject)source_1, null));
        }
        if (parent == null && !this.implicitVarUtil.implicitVariableExistsInContext(e)) {
            RosettaExpression _head;
            String error = "Object must have a parent object.";
            RosettaExpression source = _head = (RosettaExpression)IterableExtensions.head(e.getArgs());
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        RListType parentType = null;
        if (parent != null) {
            Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, parent, this.typeFactory.single);
            if (!_looseConstraintCheck.booleanValue()) {
                this.sneakyThrowRuleFailedException("looseConstraintCheck(parent, single)");
            }
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, parent);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            parentType = (RListType)result.getFirst();
        } else {
            parentType = this.typeOfImplicitVariableInternal(_trace_, e).orElse(null);
            if (parentType != null) {
                RuleFailedException previousFailure = null;
                try {
                    boolean _isSubconstraintOf = this.typeFactory.single.isSubconstraintOf(parentType.getConstraint());
                    if (!_isSubconstraintOf) {
                        this.sneakyThrowRuleFailedException("single.isSubconstraintOf(parentType.constraint)");
                    }
                }
                catch (Exception e_1) {
                    String _notConstraintMessage;
                    previousFailure = this.extractRuleFailedException(e_1);
                    String error_1 = _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, parentType);
                    RosettaOnlyExistsExpression source_1 = e;
                    this.throwForExplicitFail(error_1, new ErrorInformation((EObject)source_1, null));
                }
            }
        }
        if (parentType != null && (parentData = ((RDataType)(_itemType = parentType.getItemType())).getData()) != null) {
            RuleFailedException previousFailure = null;
            try {
                Boolean _mayBeEmpty = this.mayBeEmptyInternal(_trace_, parentData);
                if (!_mayBeEmpty.booleanValue()) {
                    this.sneakyThrowRuleFailedException("mayBeEmpty(parentData)");
                }
            }
            catch (Exception e_2) {
                String _plus_1;
                previousFailure = this.extractRuleFailedException(e_2);
                String _name = parentData.getName();
                String _plus = "The `only exists` operator is not applicable to instances of `" + _name;
                String error_2 = _plus_1 = _plus + "`.";
                RosettaExpression source_2 = parent;
                this.throwForExplicitFail(error_2, new ErrorInformation((EObject)source_2, null));
            }
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkOneOfOperation(OneOfOperation e) {
        return this.checkOneOfOperation(null, e);
    }

    public Result<Boolean> checkOneOfOperation(RuleApplicationTrace _trace_, OneOfOperation e) {
        try {
            return this.checkOneOfOperationInternal(_trace_, e);
        }
        catch (Exception _e_CheckOneOfOperation) {
            return this.resultForFailure(_e_CheckOneOfOperation);
        }
    }

    protected Result<Boolean> checkOneOfOperationInternal(RuleApplicationTrace _trace_, OneOfOperation e) throws RuleFailedException {
        RType itemType;
        Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.single);
        if (!_looseConstraintCheck.booleanValue()) {
            this.sneakyThrowRuleFailedException("looseConstraintCheck(e.argument, single)");
        }
        RosettaExpression _argument = e.getArgument();
        RListType pt = null;
        Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _argument);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        pt = (RListType)result.getFirst();
        if (pt != null && !((itemType = pt.getItemType()) instanceof RDataType)) {
            RosettaExpression _argument_1;
            String _plus_3;
            String _operator = e.getOperator();
            String _plus = "The `" + _operator;
            String _plus_1 = _plus + "` operator is not applicable to instances of `";
            String _plus_2 = _plus_1 + itemType;
            String error = _plus_3 = _plus_2 + "`.";
            RosettaExpression source = _argument_1 = e.getArgument();
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        return new Result((Object)true);
    }

    public Result<Boolean> checkChoiceOperation(ChoiceOperation e) {
        return this.checkChoiceOperation(null, e);
    }

    public Result<Boolean> checkChoiceOperation(RuleApplicationTrace _trace_, ChoiceOperation e) {
        try {
            return this.checkChoiceOperationInternal(_trace_, e);
        }
        catch (Exception _e_CheckChoiceOperation) {
            return this.resultForFailure(_e_CheckChoiceOperation);
        }
    }

    protected Result<Boolean> checkChoiceOperationInternal(RuleApplicationTrace _trace_, ChoiceOperation e) throws RuleFailedException {
        int _size;
        boolean _lessThan;
        RType itemType;
        Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.single);
        if (!_looseConstraintCheck.booleanValue()) {
            this.sneakyThrowRuleFailedException("looseConstraintCheck(e.argument, single)");
        }
        RosettaExpression _argument = e.getArgument();
        RListType pt = null;
        Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _argument);
        this.checkAssignableTo(result.getFirst(), RListType.class);
        pt = (RListType)result.getFirst();
        if (pt != null && !((itemType = pt.getItemType()) instanceof RDataType)) {
            RosettaExpression _argument_1;
            String _plus_3;
            String _operator = e.getOperator();
            String _plus = "The `" + _operator;
            String _plus_1 = _plus + "` operator is not applicable to instances of `";
            String _plus_2 = _plus_1 + itemType;
            String error = _plus_3 = _plus_2 + "`.";
            RosettaExpression source = _argument_1 = e.getArgument();
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        boolean bl = _lessThan = (_size = e.getAttributes().size()) < 2;
        if (_lessThan) {
            String error_1 = "At least two attributes must be passed to a choice rule.";
            EReference feature = ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES;
            this.throwForExplicitFail(error_1, new ErrorInformation(null, (EStructuralFeature)feature));
        }
        return new Result((Object)true);
    }

    protected Boolean listSubtypeCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.listSubtypeCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_listSubtypeCheck) {
            this.sneakyThrowRuleFailedException(_e_listSubtypeCheck);
            return false;
        }
    }

    protected void listSubtypeCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RListType expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean looseListSubtypeCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.looseListSubtypeCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_looseListSubtypeCheck) {
            this.sneakyThrowRuleFailedException(_e_looseListSubtypeCheck);
            return false;
        }
    }

    protected void looseListSubtypeCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RListType expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean subtypeCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RType expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.subtypeCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_subtypeCheck) {
            this.sneakyThrowRuleFailedException(_e_subtypeCheck);
            return false;
        }
    }

    protected void subtypeCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RType expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean comparableListTypeCheckInternal(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject});
            return (Boolean)this.comparableListTypeCheckDispatcher.invoke(new Object[]{_trace_, sourceObject});
        }
        catch (Exception _e_comparableListTypeCheck) {
            this.sneakyThrowRuleFailedException(_e_comparableListTypeCheck);
            return false;
        }
    }

    protected void comparableListTypeCheckThrowException(String _error, String _issue, Exception _ex, RosettaBinaryOperation sourceObject, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean comparableTypeCheckInternal(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject});
            return (Boolean)this.comparableTypeCheckDispatcher.invoke(new Object[]{_trace_, sourceObject});
        }
        catch (Exception _e_comparableTypeCheck) {
            this.sneakyThrowRuleFailedException(_e_comparableTypeCheck);
            return false;
        }
    }

    protected void comparableTypeCheckThrowException(String _error, String _issue, Exception _ex, RosettaBinaryOperation sourceObject, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean onlyRightIsSingularCheckInternal(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject});
            return (Boolean)this.onlyRightIsSingularCheckDispatcher.invoke(new Object[]{_trace_, sourceObject});
        }
        catch (Exception _e_onlyRightIsSingularCheck) {
            this.sneakyThrowRuleFailedException(_e_onlyRightIsSingularCheck);
            return false;
        }
    }

    protected void onlyRightIsSingularCheckThrowException(String _error, String _issue, Exception _ex, ModifiableBinaryOperation sourceObject, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean looseOnlyRightIsSingularCheckInternal(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject});
            return (Boolean)this.looseOnlyRightIsSingularCheckDispatcher.invoke(new Object[]{_trace_, sourceObject});
        }
        catch (Exception _e_looseOnlyRightIsSingularCheck) {
            this.sneakyThrowRuleFailedException(_e_looseOnlyRightIsSingularCheck);
            return false;
        }
    }

    protected void looseOnlyRightIsSingularCheckThrowException(String _error, String _issue, Exception _ex, ModifiableBinaryOperation sourceObject, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean constraintCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.constraintCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_constraintCheck) {
            this.sneakyThrowRuleFailedException(_e_constraintCheck);
            return false;
        }
    }

    protected void constraintCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RosettaCardinality expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean looseConstraintCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.looseConstraintCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_looseConstraintCheck) {
            this.sneakyThrowRuleFailedException(_e_looseConstraintCheck);
            return false;
        }
    }

    protected void looseConstraintCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RosettaCardinality expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean notConstraintCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality notExpected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, notExpected});
            return (Boolean)this.notConstraintCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, notExpected});
        }
        catch (Exception _e_notConstraintCheck) {
            this.sneakyThrowRuleFailedException(_e_notConstraintCheck);
            return false;
        }
    }

    protected void notConstraintCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RosettaCardinality notExpected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean isLooserConstraintCheckInternal(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) {
        try {
            this.checkParamsNotNull(new Object[]{sourceObject, expected});
            return (Boolean)this.isLooserConstraintCheckDispatcher.invoke(new Object[]{_trace_, sourceObject, expected});
        }
        catch (Exception _e_isLooserConstraintCheck) {
            this.sneakyThrowRuleFailedException(_e_isLooserConstraintCheck);
            return false;
        }
    }

    protected void isLooserConstraintCheckThrowException(String _error, String _issue, Exception _ex, RosettaExpression sourceObject, RosettaCardinality expected, ErrorInformation[] _errorInformations) throws RuleFailedException {
        this.throwRuleFailedException(_error, _issue, _ex, _errorInformations);
    }

    protected Boolean listSubtypeCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunListSubtypeCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("listSubtypeCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunListSubtypeCheck) {
            this.listSubtypeCheckThrowException(this.auxFunName("listSubtypeCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", LISTSUBTYPECHECK, e_applyAuxFunListSubtypeCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunListSubtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        boolean _ruleinvocation;
        boolean _not;
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        boolean _and = false;
        _and = expected == null || actual == null ? false : (_not = !(_ruleinvocation = this.listSubtypeSucceeded(this.emptyEnvironment(), _trace_, actual, expected).booleanValue()));
        if (_and) {
            String _notAListSubtypeMessage;
            String error = _notAListSubtypeMessage = this.util.notAListSubtypeMessage(expected, actual);
            RosettaExpression source = sourceObject;
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        return true;
    }

    protected Boolean looseListSubtypeCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunLooseListSubtypeCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("looseListSubtypeCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunLooseListSubtypeCheck) {
            this.looseListSubtypeCheckThrowException(this.auxFunName("looseListSubtypeCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", LOOSELISTSUBTYPECHECK, e_applyAuxFunLooseListSubtypeCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunLooseListSubtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RListType expected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        boolean _and = false;
        if (expected == null || actual == null) {
            _and = false;
        } else {
            boolean _not;
            boolean _and_1 = false;
            RType _itemType = actual.getItemType();
            RType _itemType_1 = expected.getItemType();
            boolean _ruleinvocation = this.subtypeSucceeded(this.emptyEnvironment(), _trace_, _itemType, _itemType_1);
            if (!_ruleinvocation) {
                _and_1 = false;
            } else {
                Boolean _overlap = this.overlapInternal(_trace_, expected.getConstraint(), actual.getConstraint());
                _and_1 = _overlap;
            }
            _and = _not = !_and_1;
        }
        if (_and) {
            String _notAListSubtypeMessage;
            String error = _notAListSubtypeMessage = this.util.notAListSubtypeMessage(expected, actual);
            RosettaExpression source = sourceObject;
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        return true;
    }

    protected Boolean subtypeCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RType expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunSubtypeCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("subtypeCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunSubtypeCheck) {
            this.subtypeCheckThrowException(this.auxFunName("subtypeCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", SUBTYPECHECK, e_applyAuxFunSubtypeCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunSubtypeCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RType expected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        boolean _and = false;
        if (expected == null || actual == null) {
            _and = false;
        } else {
            boolean _not;
            RType _itemType = actual.getItemType();
            boolean _ruleinvocation = this.subtypeSucceeded(this.emptyEnvironment(), _trace_, _itemType, expected);
            _and = _not = !_ruleinvocation;
        }
        if (_and) {
            String _notASubtypeMessage;
            String error = _notASubtypeMessage = this.util.notASubtypeMessage(expected, actual.getItemType());
            RosettaExpression source = sourceObject;
            this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
        }
        return true;
    }

    protected Boolean comparableListTypeCheckImpl(RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunComparableListTypeCheck(_subtrace_, sourceObject);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("comparableListTypeCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunComparableListTypeCheck) {
            this.comparableListTypeCheckThrowException(this.auxFunName("comparableListTypeCheck") + "(" + this.stringRep(sourceObject) + ")", COMPARABLELISTTYPECHECK, e_applyAuxFunComparableListTypeCheck, sourceObject, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunComparableListTypeCheck(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) throws RuleFailedException {
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = sourceObject.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = sourceObject.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            previousFailure = null;
            try {
                Boolean _listComparable = this.listComparableInternal(_trace_, tl, tr);
                if (!_listComparable.booleanValue()) {
                    this.sneakyThrowRuleFailedException("tl.listComparable(tr)");
                }
            }
            catch (Exception e_2) {
                String _notListComparableMessage;
                previousFailure = this.extractRuleFailedException(e_2);
                String error = _notListComparableMessage = this.util.notListComparableMessage(tl, tr);
                RosettaBinaryOperation source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }

    protected Boolean comparableTypeCheckImpl(RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunComparableTypeCheck(_subtrace_, sourceObject);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("comparableTypeCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunComparableTypeCheck) {
            this.comparableTypeCheckThrowException(this.auxFunName("comparableTypeCheck") + "(" + this.stringRep(sourceObject) + ")", COMPARABLETYPECHECK, e_applyAuxFunComparableTypeCheck, sourceObject, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunComparableTypeCheck(RuleApplicationTrace _trace_, RosettaBinaryOperation sourceObject) throws RuleFailedException {
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = sourceObject.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = sourceObject.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            previousFailure = null;
            try {
                Boolean _comparable = this.comparableInternal(_trace_, tl.getItemType(), tr.getItemType());
                if (!_comparable.booleanValue()) {
                    this.sneakyThrowRuleFailedException("tl.itemType.comparable(tr.itemType)");
                }
            }
            catch (Exception e_2) {
                String _notComparableMessage;
                previousFailure = this.extractRuleFailedException(e_2);
                String error = _notComparableMessage = this.util.notComparableMessage(tl.getItemType(), tr.getItemType());
                RosettaBinaryOperation source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }

    protected Boolean onlyRightIsSingularCheckImpl(RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunOnlyRightIsSingularCheck(_subtrace_, sourceObject);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("onlyRightIsSingularCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunOnlyRightIsSingularCheck) {
            this.onlyRightIsSingularCheckThrowException(this.auxFunName("onlyRightIsSingularCheck") + "(" + this.stringRep(sourceObject) + ")", ONLYRIGHTISSINGULARCHECK, e_applyAuxFunOnlyRightIsSingularCheck, sourceObject, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunOnlyRightIsSingularCheck(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = sourceObject.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = sourceObject.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            previousFailure = null;
            try {
                if (tl.getConstraint().constraintEquals(this.typeFactory.single) || !tr.getConstraint().constraintEquals(this.typeFactory.single)) {
                    this.sneakyThrowRuleFailedException("!tl.constraint.constraintEquals(single) && tr.constraint.constraintEquals(single)");
                }
            }
            catch (Exception e_2) {
                RosettaExpression _right_2;
                String _notConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_2);
                boolean _constraintEquals = tl.getConstraint().constraintEquals(this.typeFactory.single);
                if (_constraintEquals) {
                    boolean _constraintEquals_1 = tr.getConstraint().constraintEquals(this.typeFactory.single);
                    if (_constraintEquals_1) {
                        String _bothAreSingularMessage;
                        String error = _bothAreSingularMessage = this.util.bothAreSingularMessage(sourceObject);
                        ModifiableBinaryOperation source = sourceObject;
                        EAttribute feature = ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD;
                        this.throwForExplicitFail(error, new ErrorInformation((EObject)source, (EStructuralFeature)feature));
                    } else {
                        RosettaExpression _right_1;
                        String _notRightIsSingularButLeftIsMessage;
                        String error_1 = _notRightIsSingularButLeftIsMessage = this.util.notRightIsSingularButLeftIsMessage(tr);
                        RosettaExpression source_1 = _right_1 = sourceObject.getRight();
                        this.throwForExplicitFail(error_1, new ErrorInformation((EObject)source_1, null));
                    }
                }
                String error_2 = _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, tr);
                RosettaExpression source_2 = _right_2 = sourceObject.getRight();
                this.throwForExplicitFail(error_2, new ErrorInformation((EObject)source_2, null));
            }
        }
        return true;
    }

    protected Boolean looseOnlyRightIsSingularCheckImpl(RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunLooseOnlyRightIsSingularCheck(_subtrace_, sourceObject);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("looseOnlyRightIsSingularCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunLooseOnlyRightIsSingularCheck) {
            this.looseOnlyRightIsSingularCheckThrowException(this.auxFunName("looseOnlyRightIsSingularCheck") + "(" + this.stringRep(sourceObject) + ")", LOOSEONLYRIGHTISSINGULARCHECK, e_applyAuxFunLooseOnlyRightIsSingularCheck, sourceObject, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject)});
            return false;
        }
    }

    protected Boolean applyAuxFunLooseOnlyRightIsSingularCheck(RuleApplicationTrace _trace_, ModifiableBinaryOperation sourceObject) throws RuleFailedException {
        RListType tl = null;
        RListType tr = null;
        RuleFailedException previousFailure = null;
        try {
            RosettaExpression _left = sourceObject.getLeft();
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _left);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            tl = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            tl = null;
        }
        previousFailure = null;
        try {
            RosettaExpression _right = sourceObject.getRight();
            Result<RListType> result_1 = this.inferTypeInternal(this.emptyEnvironment(), _trace_, _right);
            this.checkAssignableTo(result_1.getFirst(), RListType.class);
            tr = (RListType)result_1.getFirst();
        }
        catch (Exception e_1) {
            previousFailure = this.extractRuleFailedException(e_1);
            tr = null;
        }
        if (tl != null && tr != null) {
            previousFailure = null;
            try {
                if (tl.getConstraint().constraintEquals(this.typeFactory.single) || !this.typeFactory.single.isSubconstraintOf(tr.getConstraint())) {
                    this.sneakyThrowRuleFailedException("!tl.constraint.constraintEquals(single) && single.isSubconstraintOf(tr.constraint)");
                }
            }
            catch (Exception e_2) {
                RosettaExpression _right_2;
                String _notConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_2);
                boolean _constraintEquals = tl.getConstraint().constraintEquals(this.typeFactory.single);
                if (_constraintEquals) {
                    boolean _constraintEquals_1 = tr.getConstraint().constraintEquals(this.typeFactory.single);
                    if (_constraintEquals_1) {
                        String _bothAreSingularMessage;
                        String error = _bothAreSingularMessage = this.util.bothAreSingularMessage(sourceObject);
                        ModifiableBinaryOperation source = sourceObject;
                        EAttribute feature = ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD;
                        this.throwForExplicitFail(error, new ErrorInformation((EObject)source, (EStructuralFeature)feature));
                    } else {
                        RosettaExpression _right_1;
                        String _notRightIsSingularButLeftIsMessage;
                        String error_1 = _notRightIsSingularButLeftIsMessage = this.util.notRightIsSingularButLeftIsMessage(tr);
                        RosettaExpression source_1 = _right_1 = sourceObject.getRight();
                        this.throwForExplicitFail(error_1, new ErrorInformation((EObject)source_1, null));
                    }
                }
                String error_2 = _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, tr);
                RosettaExpression source_2 = _right_2 = sourceObject.getRight();
                this.throwForExplicitFail(error_2, new ErrorInformation((EObject)source_2, null));
            }
        }
        return true;
    }

    protected Boolean constraintCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunConstraintCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("constraintCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunConstraintCheck) {
            this.constraintCheckThrowException(this.auxFunName("constraintCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", CONSTRAINTCHECK, e_applyAuxFunConstraintCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject), new ErrorInformation((EObject)expected)});
            return false;
        }
    }

    protected Boolean applyAuxFunConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        if (expected != null && actual != null) {
            previousFailure = null;
            try {
                boolean _constraintEquals = expected.constraintEquals(actual.getConstraint());
                if (!_constraintEquals) {
                    this.sneakyThrowRuleFailedException("expected.constraintEquals(actual.constraint)");
                }
            }
            catch (Exception e_1) {
                String _notConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_1);
                String error = _notConstraintMessage = this.util.notConstraintMessage(expected, actual);
                RosettaExpression source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }

    protected Boolean looseConstraintCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunLooseConstraintCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("looseConstraintCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunLooseConstraintCheck) {
            this.looseConstraintCheckThrowException(this.auxFunName("looseConstraintCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", LOOSECONSTRAINTCHECK, e_applyAuxFunLooseConstraintCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject), new ErrorInformation((EObject)expected)});
            return false;
        }
    }

    protected Boolean applyAuxFunLooseConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        if (expected != null && actual != null) {
            previousFailure = null;
            try {
                boolean _isSubconstraintOf = expected.isSubconstraintOf(actual.getConstraint());
                if (!_isSubconstraintOf) {
                    this.sneakyThrowRuleFailedException("expected.isSubconstraintOf(actual.constraint)");
                }
            }
            catch (Exception e_1) {
                String _notConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_1);
                String error = _notConstraintMessage = this.util.notConstraintMessage(expected, actual);
                RosettaExpression source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }

    protected Boolean notConstraintCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality notExpected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunNotConstraintCheck(_subtrace_, sourceObject, notExpected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("notConstraintCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(notExpected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunNotConstraintCheck) {
            this.notConstraintCheckThrowException(this.auxFunName("notConstraintCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(notExpected) + ")", NOTCONSTRAINTCHECK, e_applyAuxFunNotConstraintCheck, sourceObject, notExpected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject), new ErrorInformation((EObject)notExpected)});
            return false;
        }
    }

    protected Boolean applyAuxFunNotConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality notExpected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        if (notExpected != null && actual != null) {
            previousFailure = null;
            try {
                boolean _not;
                boolean _constraintEquals = notExpected.constraintEquals(actual.getConstraint());
                boolean bl = _not = !_constraintEquals;
                if (!_not) {
                    this.sneakyThrowRuleFailedException("!notExpected.constraintEquals(actual.constraint)");
                }
            }
            catch (Exception e_1) {
                String _wrongConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_1);
                String error = _wrongConstraintMessage = this.util.wrongConstraintMessage(notExpected, actual);
                RosettaExpression source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }

    protected Boolean isLooserConstraintCheckImpl(RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
        try {
            RuleApplicationTrace _subtrace_ = this.newTrace(_trace_);
            final Boolean _result_ = this.applyAuxFunIsLooserConstraintCheck(_subtrace_, sourceObject, expected);
            this.addToTrace(_trace_, (Provider)new Provider<Object>(){

                public Object get() {
                    return RosettaTypingChecking.this.auxFunName("isLooserConstraintCheck") + "(" + RosettaTypingChecking.this.stringRep(sourceObject) + ", " + RosettaTypingChecking.this.stringRep(expected) + ") = " + RosettaTypingChecking.this.stringRep(_result_);
                }
            });
            this.addAsSubtrace(_trace_, _subtrace_);
            return _result_;
        }
        catch (Exception e_applyAuxFunIsLooserConstraintCheck) {
            this.isLooserConstraintCheckThrowException(this.auxFunName("isLooserConstraintCheck") + "(" + this.stringRep(sourceObject) + ", " + this.stringRep(expected) + ")", ISLOOSERCONSTRAINTCHECK, e_applyAuxFunIsLooserConstraintCheck, sourceObject, expected, new ErrorInformation[]{new ErrorInformation((EObject)sourceObject), new ErrorInformation((EObject)expected)});
            return false;
        }
    }

    protected Boolean applyAuxFunIsLooserConstraintCheck(RuleApplicationTrace _trace_, RosettaExpression sourceObject, RosettaCardinality expected) throws RuleFailedException {
        RListType actual = null;
        RuleFailedException previousFailure = null;
        try {
            Result<RListType> result = this.inferTypeInternal(this.emptyEnvironment(), _trace_, sourceObject);
            this.checkAssignableTo(result.getFirst(), RListType.class);
            actual = (RListType)result.getFirst();
        }
        catch (Exception e) {
            previousFailure = this.extractRuleFailedException(e);
            actual = null;
        }
        if (expected != null && actual != null) {
            previousFailure = null;
            try {
                boolean _isSubconstraintOf = expected.isSubconstraintOf(actual.getConstraint());
                if (!_isSubconstraintOf) {
                    this.sneakyThrowRuleFailedException("expected.isSubconstraintOf(actual.constraint)");
                }
            }
            catch (Exception e_1) {
                String _notLooserConstraintMessage;
                previousFailure = this.extractRuleFailedException(e_1);
                String error = _notLooserConstraintMessage = this.util.notLooserConstraintMessage(expected, actual);
                RosettaExpression source = sourceObject;
                this.throwForExplicitFail(error, new ErrorInformation((EObject)source, null));
            }
        }
        return true;
    }
}

