/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class DeepFeatureCallUtil {
    private final RosettaTypeProvider typeProvider;
    private final CardinalityProvider cardinalityProvider;
    private final RosettaExtensions ext;

    @Inject
    public DeepFeatureCallUtil(RosettaTypeProvider typeProvider, CardinalityProvider cardinalityProvider, RosettaExtensions ext) {
        this.typeProvider = typeProvider;
        this.cardinalityProvider = cardinalityProvider;
        this.ext = ext;
    }

    public Collection<Attribute> findDeepFeatures(RDataType type) {
        return this.findDeepFeatureMap(type).values();
    }

    public Map<String, Attribute> findDeepFeatureMap(RDataType type) {
        if (!this.isEligibleForDeepFeatureCall(type)) {
            return new HashMap<String, Attribute>();
        }
        HashMap<String, Attribute> deepIntersection = null;
        HashMap<String, Attribute> result = new HashMap<String, Attribute>();
        for (Attribute attr : this.ext.allNonOverridesAttributes(type.getData())) {
            result.put(attr.getName(), attr);
        }
        for (Attribute attr : this.ext.allNonOverridesAttributes(type.getData())) {
            HashMap<String, Attribute> attrDeepFeatureMap;
            RType attrType = this.typeProvider.getRTypeOfSymbol(attr);
            if (attrType instanceof RDataType) {
                RDataType attrDataType = (RDataType)attrType;
                attrDeepFeatureMap = this.findDeepFeatureMap(attrDataType);
                for (Attribute attrFeature : this.ext.allNonOverridesAttributes(attrDataType.getData())) {
                    attrDeepFeatureMap.put(attrFeature.getName(), attrFeature);
                }
            } else {
                attrDeepFeatureMap = new HashMap();
            }
            if (deepIntersection == null) {
                deepIntersection = attrDeepFeatureMap;
            } else {
                this.intersect(deepIntersection, attrDeepFeatureMap);
            }
            this.intersectButRetainAttribute(result, attrDeepFeatureMap, attr);
        }
        if (deepIntersection != null) {
            this.merge(result, deepIntersection);
        }
        return result;
    }

    private void intersect(Map<String, Attribute> featuresMapToModify, Map<String, Attribute> otherFeatureMap) {
        featuresMapToModify.entrySet().removeIf(entry -> {
            Attribute attr;
            String attrName = (String)entry.getKey();
            Attribute otherAttr = (Attribute)otherFeatureMap.get(attrName);
            return otherAttr == null || !this.match(attr = (Attribute)entry.getValue(), otherAttr);
        });
    }

    private void intersectButRetainAttribute(Map<String, Attribute> featuresMapToModify, Map<String, Attribute> otherFeatureMap, Attribute attributeToRetain) {
        featuresMapToModify.entrySet().removeIf(entry -> {
            String attrName = (String)entry.getKey();
            Attribute attr = (Attribute)entry.getValue();
            if (attributeToRetain.equals(attr)) {
                return false;
            }
            Attribute otherAttr = (Attribute)otherFeatureMap.get(attrName);
            return otherAttr == null || !this.match(attr, otherAttr);
        });
    }

    private void merge(Map<String, Attribute> featuresMapToModify, Map<String, Attribute> otherFeatureMap) {
        otherFeatureMap.forEach((name, attr) -> {
            Attribute candidate = (Attribute)featuresMapToModify.get(name);
            if (candidate != null) {
                if (!this.match(candidate, (Attribute)attr)) {
                    featuresMapToModify.remove(name);
                }
            } else {
                featuresMapToModify.put((String)name, (Attribute)attr);
            }
        });
    }

    public boolean match(Attribute a, Attribute b) {
        if (!this.typeProvider.getRTypeOfFeature(a).equals(this.typeProvider.getRTypeOfFeature(b))) {
            return false;
        }
        return this.cardinalityProvider.isFeatureMulti(a) == this.cardinalityProvider.isFeatureMulti(b);
    }

    public boolean isEligibleForDeepFeatureCall(RDataType type) {
        Data data = type.getData();
        return data.getConditions().stream().anyMatch(cond -> this.isOneOfItem(cond.getExpression())) && data.getAttributes().stream().allMatch(a -> this.isSingularOptional(a.getCard())) && !data.getAttributes().isEmpty();
    }

    private boolean isOneOfItem(RosettaExpression expr) {
        return expr instanceof OneOfOperation && ((OneOfOperation)expr).getArgument() instanceof RosettaImplicitVariable;
    }

    private boolean isSingularOptional(RosettaCardinality card) {
        return !card.isUnbounded() && card.getInf() == 0 && card.getSup() == 1;
    }
}

