/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ExternalAnnotationUtil {
    @Inject
    private RosettaExtensions rosettaExtensions;

    public List<ExternalAnnotationSource> getSuperSources(ExternalAnnotationSource source) {
        if (source instanceof RosettaExternalSynonymSource) {
            RosettaExternalSynonymSource synSource = (RosettaExternalSynonymSource)source;
            return synSource.getSuperSources().stream().filter(s -> s instanceof ExternalAnnotationSource).map(s -> (ExternalAnnotationSource)((Object)s)).collect(Collectors.toList());
        }
        if (source instanceof RosettaExternalRuleSource) {
            RosettaExternalRuleSource ruleSource = (RosettaExternalRuleSource)source;
            return ruleSource.getSuperSources();
        }
        return Collections.emptyList();
    }

    public Optional<RosettaExternalClass> getExternalType(ExternalAnnotationSource source, Data type) {
        for (RosettaExternalClass extT : source.getExternalClasses()) {
            if (!extT.getTypeRef().equals(type)) continue;
            return Optional.of(extT);
        }
        return Optional.empty();
    }

    public Optional<RosettaExternalEnum> getExternalEnum(ExternalAnnotationSource source, RosettaEnumeration type) {
        for (RosettaExternalEnum extT : source.getExternalEnums()) {
            if (!extT.getTypeRef().equals(type)) continue;
            return Optional.of(extT);
        }
        return Optional.empty();
    }

    public Set<RosettaExternalClass> getAllExternalTypes(ExternalAnnotationSource source, Data type) {
        HashSet<RosettaExternalClass> result = new HashSet<RosettaExternalClass>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalTypes((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalClass>)s));
        this.getExternalType(source, type).ifPresent(extT -> result.add((RosettaExternalClass)extT));
        return result;
    }

    public Set<RosettaExternalEnum> getAllExternalEnums(ExternalAnnotationSource source, RosettaEnumeration type) {
        HashSet<RosettaExternalEnum> result = new HashSet<RosettaExternalEnum>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalEnums((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalEnum>)s));
        this.getExternalEnum(source, type).ifPresent(extT -> result.add((RosettaExternalEnum)extT));
        return result;
    }

    public Set<RosettaExternalRegularAttribute> getAllExternalAttributesForType(ExternalAnnotationSource source, Data type) {
        HashSet<RosettaExternalRegularAttribute> result = new HashSet<RosettaExternalRegularAttribute>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalAttributesForType((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalRegularAttribute>)s));
        this.getExternalType(source, type).ifPresent(extT -> {
            for (RosettaExternalRegularAttribute attr : extT.getRegularAttributes()) {
                if (attr.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    result.removeIf(a -> a.getAttributeRef().equals(attr.getAttributeRef()));
                    continue;
                }
                result.add(attr);
            }
        });
        return result;
    }

    public Set<RosettaExternalEnumValue> getAllExternalEnumValuesForType(ExternalAnnotationSource source, RosettaEnumeration type) {
        HashSet<RosettaExternalEnumValue> result = new HashSet<RosettaExternalEnumValue>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalEnumValuesForType((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalEnumValue>)s));
        this.getExternalEnum(source, type).ifPresent(extT -> {
            for (RosettaExternalEnumValue val : extT.getRegularValues()) {
                if (val.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    result.removeIf(a -> a.getEnumRef().equals(val.getEnumRef()));
                    continue;
                }
                result.add(val);
            }
        });
        return result;
    }

    public Map<RosettaFeature, RosettaRuleReference> getAllRuleReferencesForType(Optional<? extends ExternalAnnotationSource> maybeSource, Data type) {
        CollectRuleVisitor.Default visitor = new CollectRuleVisitor.Default();
        this.collectAllRuleReferencesForType(maybeSource, type, visitor);
        return visitor.getMap();
    }

    public <T extends CollectRuleVisitor> T collectAllRuleReferencesForType(Optional<? extends ExternalAnnotationSource> maybeSource, Data type, T visitor) {
        this.rosettaExtensions.getAllAttributes(type).forEach(attr -> Optional.ofNullable(attr.getRuleReference()).ifPresent(rule -> visitor.add((RosettaFeature)attr, (RosettaRuleReference)rule)));
        maybeSource.ifPresent(source -> {
            List<ExternalAnnotationSource> superSources = this.getSuperSources((ExternalAnnotationSource)source);
            Collections.reverse(superSources);
            superSources.forEach(s -> this.collectExternalRuleReferencesForType((ExternalAnnotationSource)s, type, visitor));
            this.collectExternalRuleReferencesForType((ExternalAnnotationSource)source, type, visitor);
        });
        return visitor;
    }

    private void collectExternalRuleReferencesForType(ExternalAnnotationSource source, Data type, CollectRuleVisitor visitor) {
        this.getExternalType(source, type).ifPresent(extT -> {
            for (RosettaExternalRegularAttribute extAttr : extT.getRegularAttributes()) {
                if (extAttr.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    visitor.remove(extAttr);
                    continue;
                }
                if (extAttr.getExternalRuleReference() == null) continue;
                visitor.add(extAttr, extAttr.getExternalRuleReference());
            }
        });
    }

    public static interface CollectRuleVisitor {
        public void add(RosettaFeature var1, RosettaRuleReference var2);

        public void add(RosettaExternalRegularAttribute var1, RosettaRuleReference var2);

        public void remove(RosettaExternalRegularAttribute var1);

        public static class Default
        implements CollectRuleVisitor {
            private final Map<RosettaFeature, RosettaRuleReference> map = new HashMap<RosettaFeature, RosettaRuleReference>();

            @Override
            public void add(RosettaFeature attr, RosettaRuleReference rule) {
                this.map.put(attr, rule);
            }

            @Override
            public void add(RosettaExternalRegularAttribute extAttr, RosettaRuleReference rule) {
                this.map.put(extAttr.getAttributeRef(), rule);
            }

            @Override
            public void remove(RosettaExternalRegularAttribute extAttr) {
                this.map.remove(extAttr.getAttributeRef());
            }

            public Map<RosettaFeature, RosettaRuleReference> getMap() {
                return this.map;
            }
        }
    }
}

