/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class Interval<T extends Number> {
    private final Optional<T> min;
    private final Optional<T> max;

    public Interval(Optional<T> min, Optional<T> max) {
        if (min.isPresent() && max.isPresent()) {
            Validate.isTrue((((Comparable)((Object)((Number)min.get()))).compareTo(max.get()) <= 0 ? 1 : 0) != 0);
        }
        this.min = min;
        this.max = max;
    }

    public Optional<T> getMin() {
        return this.min;
    }

    public Optional<T> getMax() {
        return this.max;
    }

    public boolean isUnbounded() {
        return this.min.isEmpty() && this.max.isEmpty();
    }

    public boolean includes(T x) {
        if (this.min.map(b -> ((Comparable)((Object)b)).compareTo(x) >= 0).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> ((Comparable)((Object)b)).compareTo(x) <= 0).orElse(false) == false;
    }

    public boolean strictlyIncludes(T x) {
        if (this.min.map(b -> ((Comparable)((Object)b)).compareTo(x) > 0).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> ((Comparable)((Object)b)).compareTo(x) < 0).orElse(false) == false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.min.ifPresentOrElse(b -> builder.append("[").append(b), () -> builder.append("]-inf"));
        builder.append(", ");
        this.max.ifPresentOrElse(b -> builder.append(b).append("]"), () -> builder.append("+inf["));
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Interval other = (Interval)object;
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }
}

