/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAnnotateType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RErrorType;
import com.regnosys.rosetta.types.RParametrizedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;

public abstract class RosettaTypeSwitch<Return, Context> {
    private final RBuiltinTypeService builtins;

    public RosettaTypeSwitch(RBuiltinTypeService builtins) {
        this.builtins = builtins;
    }

    private UnsupportedOperationException errorMissedCase(RType type) {
        String className = type == null ? "null" : type.getClass().getCanonicalName();
        return new UnsupportedOperationException("Unexpected type " + className);
    }

    protected Return doSwitch(RType type, Context context) {
        if (type instanceof RAnnotateType) {
            return this.doSwitch((RAnnotateType)type, context);
        }
        if (type instanceof RErrorType) {
            return this.caseErrorType((RErrorType)type, context);
        }
        if (type instanceof RParametrizedType) {
            return this.doSwitch((RParametrizedType)type, context);
        }
        if (type instanceof RRecordType) {
            return this.doSwitch((RRecordType)type, context);
        }
        throw this.errorMissedCase(type);
    }

    protected Return doSwitch(RAnnotateType type, Context context) {
        if (type instanceof RDataType) {
            return this.caseDataType((RDataType)type, context);
        }
        if (type instanceof REnumType) {
            return this.caseEnumType((REnumType)type, context);
        }
        throw this.errorMissedCase(type);
    }

    protected Return doSwitch(RParametrizedType type, Context context) {
        if (type instanceof RAliasType) {
            return this.caseAliasType((RAliasType)type, context);
        }
        if (type instanceof RBasicType) {
            return this.doSwitch((RBasicType)type, context);
        }
        throw this.errorMissedCase(type);
    }

    protected Return doSwitch(RBasicType type, Context context) {
        if (type instanceof RNumberType) {
            return this.caseNumberType((RNumberType)type, context);
        }
        if (type instanceof RStringType) {
            return this.caseStringType((RStringType)type, context);
        }
        if (type.equals(this.builtins.BOOLEAN)) {
            return this.caseBooleanType(type, context);
        }
        if (type.equals(this.builtins.TIME)) {
            return this.caseTimeType(type, context);
        }
        if (type.equals(this.builtins.MISSING)) {
            return this.caseMissingType(type, context);
        }
        if (type.equals(this.builtins.NOTHING)) {
            return this.caseNothingType(type, context);
        }
        if (type.equals(this.builtins.ANY)) {
            return this.caseAnyType(type, context);
        }
        throw this.errorMissedCase(type);
    }

    protected Return doSwitch(RRecordType type, Context context) {
        if (type instanceof RDateType) {
            return this.caseDateType((RDateType)type, context);
        }
        if (type instanceof RDateTimeType) {
            return this.caseDateTimeType((RDateTimeType)type, context);
        }
        if (type instanceof RZonedDateTimeType) {
            return this.caseZonedDateTimeType((RZonedDateTimeType)type, context);
        }
        throw this.errorMissedCase(type);
    }

    protected abstract Return caseErrorType(RErrorType var1, Context var2);

    protected abstract Return caseDataType(RDataType var1, Context var2);

    protected abstract Return caseEnumType(REnumType var1, Context var2);

    protected abstract Return caseAliasType(RAliasType var1, Context var2);

    protected abstract Return caseNumberType(RNumberType var1, Context var2);

    protected abstract Return caseStringType(RStringType var1, Context var2);

    protected abstract Return caseBooleanType(RBasicType var1, Context var2);

    protected abstract Return caseTimeType(RBasicType var1, Context var2);

    protected abstract Return caseMissingType(RBasicType var1, Context var2);

    protected abstract Return caseNothingType(RBasicType var1, Context var2);

    protected abstract Return caseAnyType(RBasicType var1, Context var2);

    protected abstract Return caseDateType(RDateType var1, Context var2);

    protected abstract Return caseDateTimeType(RDateTimeType var1, Context var2);

    protected abstract Return caseZonedDateTimeType(RZonedDateTimeType var1, Context var2);
}

