/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.Import;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalRef;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaFeatureOwner;
import com.regnosys.rosetta.rosetta.RosettaMapPathValue;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaMapping;
import com.regnosys.rosetta.rosetta.RosettaMappingInstance;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaSynonymBody;
import com.regnosys.rosetta.rosetta.RosettaSynonymValueBase;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.HasGeneratedInput;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.ListOperation;
import com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.ParseOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationQualifier;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RErrorType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaExpectedTypeProvider;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import java.lang.reflect.Method;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaSimpleValidator
extends AbstractDeclarativeValidator {
    @Inject
    @Extension
    private RosettaExtensions _rosettaExtensions;
    @Inject
    @Extension
    private RosettaExpectedTypeProvider _rosettaExpectedTypeProvider;
    @Inject
    @Extension
    private RosettaTypeProvider _rosettaTypeProvider;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ResourceDescriptionsProvider _resourceDescriptionsProvider;
    @Inject
    @Extension
    private RosettaFunctionExtensions _rosettaFunctionExtensions;
    @Inject
    private ExpressionHelper exprHelper;
    @Inject
    @Extension
    private CardinalityProvider cardinality;
    @Inject
    private RosettaConfigExtension confExtensions;
    @Inject
    @Extension
    private ImplicitVariableUtil _implicitVariableUtil;
    @Inject
    private RosettaScopeProvider scopeProvider;
    @Inject
    private ExternalAnnotationUtil externalAnn;
    @Inject
    @Extension
    private RBuiltinTypeService _rBuiltinTypeService;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    @Extension
    private RosettaGrammarAccess _rosettaGrammarAccess;
    private static final Logger log = LoggerFactory.getLogger(RosettaSimpleValidator.class);

    protected List<EPackage> getEPackages() {
        ArrayList result = CollectionLiterals.newArrayList();
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/Rosetta"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaSimple"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaExpression"));
        return result;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected void handleExceptionDuringValidation(Throwable targetException) throws RuntimeException {
        super.handleExceptionDuringValidation(targetException);
        log.error(targetException.getMessage(), targetException);
    }

    protected AbstractDeclarativeValidator.MethodWrapper createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        return new RosettaMethodWrapper(instanceToUse, method);
    }

    private void errorKeyword(String message, EObject o, Keyword keyword) {
        INode k = this.findDirectKeyword(o, keyword);
        if (k != null) {
            this.getMessageAcceptor().acceptError(message, o, k.getOffset(), k.getLength(), null, new String[0]);
        }
    }

    private INode findDirectKeyword(EObject o, Keyword keyword) {
        return this.findDirectKeyword(o, keyword.getValue());
    }

    private INode findDirectKeyword(EObject o, String keyword) {
        INode _xblockexpression = null;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)o);
        _xblockexpression = this.findDirectKeyword(node, keyword);
        return _xblockexpression;
    }

    private INode findDirectKeyword(ICompositeNode node, String keyword) {
        BidiIterable _children = node.getChildren();
        for (INode n : _children) {
            INode keywordInFragment;
            EObject ge = n.getGrammarElement();
            if (ge instanceof Keyword && Objects.equal((Object)((Keyword)ge).getValue(), (Object)keyword)) {
                return n;
            }
            if (!(ge instanceof RuleCall) && !(ge instanceof Action) || !(n instanceof ICompositeNode) || ge.eContainer() instanceof Assignment || (keywordInFragment = this.findDirectKeyword((ICompositeNode)n, keyword)) == null) continue;
            return keywordInFragment;
        }
        return null;
    }

    @Check
    public void ruleMustHaveInputTypeDeclared(RosettaRule rule) {
        boolean _isOutputListOfLists;
        boolean _tripleEquals;
        TypeCall _input = rule.getInput();
        boolean bl = _tripleEquals = _input == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("A rule must declare its input type: `rule ");
            String _name = rule.getName();
            _builder.append(_name);
            _builder.append(" from <input type>: ...`");
            this.error(_builder.toString(), rule, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
        if (_isOutputListOfLists = this.cardinality.isOutputListOfLists(rule.getExpression())) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Assign expression contains a list of lists, use flatten to create a list.");
            this.error(_builder_1.toString(), rule.getExpression(), null);
        }
    }

    @Check
    public void deprecatedMap(MapOperation op) {
        String _operator = op.getOperator();
        boolean _equals = Objects.equal((Object)_operator, (Object)"map");
        if (_equals) {
            this.warning("The `map` operator is deprecated. Use `extract` instead.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR, "RosettaIssueCodes.deprecatedMap", new String[0]);
        }
    }

    @Check
    public void unnecesarrySquareBracketsCheck(RosettaFunctionalOperation op) {
        boolean _hasSquareBrackets = this.hasSquareBrackets(op);
        if (_hasSquareBrackets) {
            boolean _not;
            boolean _areSquareBracketsMandatory = this.areSquareBracketsMandatory(op);
            boolean bl = _not = !_areSquareBracketsMandatory;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Usage of brackets is unnecessary.");
                this.warning(_builder.toString(), op.getFunction(), null, "RosettaIssueCodes.redundantSquareBrackets", new String[0]);
            }
        }
    }

    public boolean hasSquareBrackets(RosettaFunctionalOperation op) {
        return op.getFunction() != null && this.findDirectKeyword((EObject)op.getFunction(), this._rosettaGrammarAccess.getInlineFunctionAccess().getLeftSquareBracketKeyword_0_0_1()) != null;
    }

    public boolean areSquareBracketsMandatory(RosettaFunctionalOperation op) {
        return !(op instanceof ThenOperation) && op.getFunction() != null && (!(op instanceof MandatoryFunctionalOperation) || !op.getFunction().getParameters().isEmpty() || this.containsNestedFunctionalOperation(op) || op.eContainer() instanceof RosettaOperation && !(op.eContainer() instanceof ThenOperation));
    }

    @Check
    public void mandatoryThenCheck(RosettaUnaryOperation op) {
        boolean _isThenMandatory = this.isThenMandatory(op);
        if (_isThenMandatory) {
            boolean previousOperationIsThen;
            boolean bl = previousOperationIsThen = op.getArgument().isGenerated() && op.eContainer() instanceof InlineFunction && op.eContainer().eContainer() instanceof ThenOperation;
            if (!previousOperationIsThen) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Usage of `then` is mandatory.");
                this.error(_builder.toString(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR, "RosettaIssueCodes.mandatoryThen", new String[0]);
            }
        }
    }

    public boolean isThenMandatory(RosettaUnaryOperation op) {
        if (op instanceof ThenOperation) {
            return false;
        }
        return op.getArgument() instanceof MandatoryFunctionalOperation || op.getArgument() instanceof RosettaUnaryOperation && this.isThenMandatory((RosettaUnaryOperation)op.getArgument());
    }

    @Check
    public void ambiguousFunctionalOperation(RosettaFunctionalOperation op) {
        boolean _isNestedFunctionalOperation;
        boolean _tripleNotEquals;
        InlineFunction _function = op.getFunction();
        boolean bl = _tripleNotEquals = _function != null;
        if (_tripleNotEquals && (_isNestedFunctionalOperation = this.isNestedFunctionalOperation(op))) {
            boolean _not;
            EObject _eContainer = ((InlineFunction)EcoreUtil2.getContainerOfType((EObject)op, InlineFunction.class)).eContainer();
            RosettaFunctionalOperation enclosingFunctionalOperation = (RosettaFunctionalOperation)_eContainer;
            boolean _hasSquareBrackets = this.hasSquareBrackets(enclosingFunctionalOperation);
            boolean bl2 = _not = !_hasSquareBrackets;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Ambiguous operation. Either use `then` or surround with square brackets to define a nested operation.");
                this.error(_builder.toString(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }

    public boolean isNestedFunctionalOperation(RosettaFunctionalOperation op) {
        InlineFunction enclosingInlineFunction = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)op, InlineFunction.class);
        if (enclosingInlineFunction != null && !(enclosingInlineFunction.eContainer() instanceof ThenOperation)) {
            EObject _enclosingCodeBlock_1;
            boolean _tripleEquals;
            EObject _enclosingCodeBlock = this.getEnclosingCodeBlock(op);
            boolean bl = _tripleEquals = _enclosingCodeBlock == (_enclosingCodeBlock_1 = this.getEnclosingCodeBlock(enclosingInlineFunction));
            if (_tripleEquals) {
                return true;
            }
        }
        return false;
    }

    public boolean containsNestedFunctionalOperation(RosettaFunctionalOperation op) {
        boolean _tripleEquals;
        InlineFunction _function = op.getFunction();
        boolean bl = _tripleEquals = _function == null;
        if (_tripleEquals) {
            return false;
        }
        EObject codeBlock = this.getEnclosingCodeBlock(op.getFunction());
        Functions.Function1 _function_1 = it -> {
            EObject _enclosingCodeBlock = this.getEnclosingCodeBlock((EObject)it);
            return _enclosingCodeBlock == codeBlock;
        };
        RosettaFunctionalOperation _head = (RosettaFunctionalOperation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.eAllOfType((EObject)op.getFunction(), RosettaFunctionalOperation.class), (Functions.Function1)_function_1));
        return _head != null;
    }

    public EObject getEnclosingCodeBlock(EObject obj) {
        return this.getEnclosingCodeBlock((INode)NodeModelUtils.findActualNodeFor((EObject)obj), obj);
    }

    private EObject getEnclosingCodeBlock(INode node, EObject potentialCodeBlock) {
        if (potentialCodeBlock instanceof RosettaRootElement) {
            return potentialCodeBlock;
        }
        Pair _mappedTo = Pair.of((Object)"(", (Object)")");
        Pair _mappedTo_1 = Pair.of((Object)"[", (Object)"]");
        Pair _mappedTo_2 = Pair.of((Object)"{", (Object)"}");
        Map pairs = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2}));
        Function<String, INode> _function = it -> this.findDirectKeyword(potentialCodeBlock, (String)it);
        Predicate<INode> _function_1 = it -> it != null;
        INode left = pairs.keySet().stream().map(_function).filter(_function_1).findFirst().orElse(null);
        if (left != null) {
            INode right = this.findDirectKeyword(potentialCodeBlock, (String)pairs.get(left.getText()));
            if (left.getOffset() <= node.getOffset() && (right == null || right.getOffset() >= node.getOffset())) {
                return potentialCodeBlock;
            }
        }
        return this.getEnclosingCodeBlock(node, potentialCodeBlock.eContainer());
    }

    @Check
    public void checkParametrizedType(ParametrizedRosettaType type) {
        HashSet visited = CollectionLiterals.newHashSet();
        EList<TypeParameter> _parameters = type.getParameters();
        for (TypeParameter param : _parameters) {
            boolean _add = visited.add(param.getName());
            boolean _not = !_add;
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate parameter name `");
            String _name = param.getName();
            _builder.append(_name);
            _builder.append("`.");
            this.error(_builder.toString(), param, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }

    @Check
    public void checkAnnotationSource(ExternalAnnotationSource source) {
        HashSet visited = CollectionLiterals.newHashSet();
        EList<RosettaExternalRef> _externalRefs = source.getExternalRefs();
        for (RosettaExternalRef t : _externalRefs) {
            boolean _add = visited.add(t.getTypeRef());
            boolean _not = !_add;
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate type `");
            String _name = t.getTypeRef().getName();
            _builder.append(_name);
            _builder.append("`.");
            this.warning(_builder.toString(), t, null);
        }
    }

    @Check
    public void checkSynonymSource(RosettaExternalSynonymSource source) {
        EList<RosettaExternalClass> _externalClasses = source.getExternalClasses();
        for (RosettaExternalClass t : _externalClasses) {
            EList<RosettaExternalRegularAttribute> _regularAttributes = t.getRegularAttributes();
            for (RosettaExternalRegularAttribute attr : _regularAttributes) {
                RosettaRuleReference _externalRuleReference = attr.getExternalRuleReference();
                boolean _tripleNotEquals = _externalRuleReference != null;
                if (!_tripleNotEquals) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("You may not define rule references in a synonym source.");
                this.error(_builder.toString(), attr.getExternalRuleReference(), null);
            }
        }
    }

    @Check
    public void checkRuleSource(RosettaReport report) {
        CollectRuleErrorVisitor visitor = new CollectRuleErrorVisitor();
        this.collectRuleErrors(report.getReportType(), Optional.ofNullable(report.getRuleSource()), visitor);
        Consumer<Map.Entry> _function = it -> this.error((String)it.getValue(), (EObject)it.getKey(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF);
        visitor.errorMap.entrySet().forEach(_function);
    }

    private void collectRuleErrors(Data type, Optional<RosettaExternalRuleSource> source, CollectRuleErrorVisitor visitor) {
        this.externalAnn.collectAllRuleReferencesForType(source, type, visitor);
        Consumer<Attribute> _function = attr -> {
            RosettaType attrType = attr.getTypeCall().getType();
            if (attrType instanceof Data) {
                boolean _not;
                boolean _contains = visitor.collectedTypes.contains(attrType);
                boolean bl = _not = !_contains;
                if (_not) {
                    visitor.collectedTypes.add((Data)attrType);
                    this.collectRuleErrors((Data)attrType, source, visitor);
                }
            }
        };
        this._rosettaExtensions.getAllAttributes(type).forEach(_function);
    }

    @Check
    public void checkRuleSource(RosettaExternalRuleSource source) {
        boolean _greaterThan;
        int _size = source.getSuperSources().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.error("A rule source may not extend more than one other rule source.", source, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES, 1);
        }
        EList<RosettaExternalClass> _externalClasses = source.getExternalClasses();
        for (RosettaExternalClass t : _externalClasses) {
            Consumer<RosettaExternalClassSynonym> _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("You may not define synonyms in a rule source.");
                this.error(_builder.toString(), (EObject)it, null);
            };
            t.getExternalClassSynonyms().forEach(_function);
            EList<RosettaExternalRegularAttribute> _regularAttributes = t.getRegularAttributes();
            for (RosettaExternalRegularAttribute attr : _regularAttributes) {
                Consumer<RosettaExternalSynonym> _function_1 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("You may not define synonyms in a rule source.");
                    this.error(_builder.toString(), (EObject)it, null);
                };
                attr.getExternalSynonyms().forEach(_function_1);
            }
        }
        this.errorKeyword("A rule source cannot define annotations for enums.", source, this._rosettaGrammarAccess.getExternalAnnotationSourceAccess().getEnumsKeyword_2_0());
    }

    @Check
    public void deprecatedExtraneousSegment(RosettaDocReference docRef) {
        EList<RosettaSegmentRef> _extraneousSegments = docRef.getExtraneousSegments();
        for (RosettaSegmentRef seg : _extraneousSegments) {
            this.warning("Placing document segments after `rationale` is deprecated.", seg, null);
        }
    }

    @Check
    public void checkGeneratedInputInContextWithImplicitVariable(HasGeneratedInput e) {
        if (e.needsGeneratedInput() && !this._implicitVariableUtil.implicitVariableExistsInContext(e)) {
            this.error("There is no implicit variable in this context. This operator needs an explicit input in this context.", e, null);
        }
    }

    @Check
    public void checkImplicitVariableReferenceInContextWithoutImplicitVariable(RosettaImplicitVariable e) {
        boolean _not;
        boolean _implicitVariableExistsInContext = this._implicitVariableUtil.implicitVariableExistsInContext(e);
        boolean bl = _not = !_implicitVariableExistsInContext;
        if (_not) {
            this.error("There is no implicit variable in this context.", e, null);
        }
    }

    @Check
    public void checkClassNameStartsWithCapital(Data classe) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(classe.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("Type name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkConditionName(Condition condition) {
        if (condition.getName() == null && !this._rosettaExtensions.isConstraintCondition(condition)) {
            this.warning("Condition name should be specified", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidName", new String[0]);
        } else if (condition.getName() != null && !Character.isUpperCase(condition.getName().charAt(0))) {
            this.warning("Condition name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkFeatureCallFeature(RosettaFeatureCall fCall) {
        boolean _tripleEquals;
        RosettaFeature _feature = fCall.getFeature();
        boolean bl = _tripleEquals = _feature == null;
        if (_tripleEquals) {
            this.error("Attribute is missing after '->'", fCall, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE);
            return;
        }
    }

    @Check
    public void checkFunctionNameStartsWithCapital(com.regnosys.rosetta.rosetta.simple.Function enumeration) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(enumeration.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("Function name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkEnumerationNameStartsWithCapital(RosettaEnumeration enumeration) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(enumeration.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("Enumeration name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkAttributeNameStartsWithLowerCase(Attribute attribute) {
        EObject _eContainer = attribute.eContainer();
        boolean annotationAttribute = _eContainer instanceof Annotation;
        boolean choiceOption = attribute instanceof ChoiceOption;
        if (!(choiceOption || annotationAttribute || Character.isLowerCase(attribute.getName().charAt(0)))) {
            this.warning("Attribute name should start with a lower case", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkTypeExpectation(EObject owner) {
        boolean _not;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)owner.eResource().getErrors(), XtextSyntaxDiagnostic.class));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return;
        }
        Functions.Function1 _function = it -> ExpressionPackage.Literals.ROSETTA_EXPRESSION.isSuperTypeOf(it.getEReferenceType());
        Functions.Function1 _function_1 = it -> owner.eIsSet((EStructuralFeature)it);
        Consumer<EReference> _function_2 = ref -> {
            Object referenceValue = owner.eGet((EStructuralFeature)ref);
            boolean _isMany = ref.isMany();
            if (_isMany) {
                Procedures.Procedure2 _function_3 = (it, i) -> {
                    RType expectedType = this._rosettaExpectedTypeProvider.getExpectedType(owner, (EReference)ref, (int)i);
                    this.checkType(expectedType, (RosettaExpression)it, owner, (EReference)ref, (int)i);
                };
                IterableExtensions.forEach((Iterable)((List)referenceValue), (Procedures.Procedure2)_function_3);
            } else {
                RType expectedType = this._rosettaExpectedTypeProvider.getExpectedType(owner, (EReference)ref);
                this.checkType(expectedType, (RosettaExpression)referenceValue, owner, (EReference)ref, -1);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)owner.eClass().getEAllReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    private void checkType(RType expectedType, RosettaExpression expression, EObject owner, EReference ref, int index) {
        RType actualType = this._rosettaTypeProvider.getRType(expression);
        if (actualType == null) {
            return;
        }
        if (actualType instanceof RErrorType) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = ((RErrorType)actualType).getName();
            _builder.append(_name);
            this.error(_builder.toString(), owner, (EStructuralFeature)ref, index, "RosettaIssueCodes.typeError", new String[0]);
        } else {
            boolean _equals = Objects.equal((Object)actualType, (Object)this._rBuiltinTypeService.MISSING);
            if (_equals) {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)expression);
                if (node != null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Couldn't infer actual type for '");
                    String _tokenText = NodeModelUtils.getTokenText((INode)node);
                    _builder_1.append(_tokenText);
                    _builder_1.append("'");
                    this.error(_builder_1.toString(), owner, (EStructuralFeature)ref, index, "RosettaIssueCodes.typeError", new String[0]);
                }
            } else if (expectedType instanceof RErrorType) {
                StringConcatenation _builder_2 = new StringConcatenation();
                String _name_1 = ((RErrorType)expectedType).getName();
                _builder_2.append(_name_1);
                this.error(_builder_2.toString(), owner, (EStructuralFeature)ref, index, "RosettaIssueCodes.typeError", new String[0]);
            } else if (expectedType != null && !Objects.equal((Object)expectedType, (Object)this._rBuiltinTypeService.MISSING)) {
                boolean _not;
                boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(actualType, expectedType);
                boolean bl = _not = !_isSubtypeOf;
                if (_not) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Expected type '");
                    String _name_2 = expectedType.getName();
                    _builder_3.append(_name_2);
                    _builder_3.append("' but was '");
                    String _elvis = null;
                    String _name_3 = null;
                    if (actualType != null) {
                        _name_3 = actualType.getName();
                    }
                    _elvis = _name_3 != null ? _name_3 : "null";
                    _builder_3.append(_elvis);
                    _builder_3.append("'");
                    this.error(_builder_3.toString(), owner, (EStructuralFeature)ref, index, "RosettaIssueCodes.typeError", new String[0]);
                }
            }
        }
    }

    @Check
    public void checkAttributes(Data clazz) {
        HashMultimap name2attr = HashMultimap.create();
        Consumer<Attribute> _function = it -> name2attr.put((Object)it.getName(), it);
        this._rosettaExtensions.getAllAttributes(clazz).forEach(_function);
        Functions.Function1 _function_1 = it -> it.getName();
        List _map = ListExtensions.map(clazz.getAttributes(), (Functions.Function1)_function_1);
        for (String name : _map) {
            Set attrByName = name2attr.get((Object)name);
            int _size = attrByName.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Functions.Function1 _function_2 = it -> {
                EObject _eContainer = it.eContainer();
                return Objects.equal((Object)_eContainer, (Object)clazz);
            };
            Iterable attrFromClazzes = IterableExtensions.filter((Iterable)attrByName, (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> {
                EObject _eContainer = it.eContainer();
                return !Objects.equal((Object)_eContainer, (Object)clazz);
            };
            Iterable attrFromSuperClasses = IterableExtensions.filter((Iterable)attrByName, (Functions.Function1)_function_3);
            this.checkOverridingTypeAttributeMustHaveSameOrExtendedTypeAsParent(attrFromClazzes, attrFromSuperClasses, name);
            this.checkTypeAttributeMustHaveSameTypeAsParent(attrFromClazzes, attrFromSuperClasses, name);
            this.checkAttributeCardinalityMatchSuper(attrFromClazzes, attrFromSuperClasses, name);
        }
    }

    protected void checkTypeAttributeMustHaveSameTypeAsParent(Iterable<Attribute> attrFromClazzes, Iterable<Attribute> attrFromSuperClasses, String name) {
        Functions.Function1 _function = it -> {
            boolean _isOverride = it.isOverride();
            return !_isOverride;
        };
        Consumer<Attribute> _function_1 = childAttr -> {
            RType childAttrType = this._rosettaTypeProvider.getRTypeOfSymbol((RosettaSymbol)childAttr);
            Consumer<Attribute> _function_2 = parentAttr -> {
                boolean _notEquals;
                RType parentAttrType = this._rosettaTypeProvider.getRTypeOfSymbol((RosettaSymbol)parentAttr);
                boolean bl = _notEquals = !Objects.equal((Object)childAttrType, (Object)parentAttrType);
                if (_notEquals) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Overriding attribute '");
                    _builder.append(name);
                    _builder.append("' with type ");
                    _builder.append((Object)childAttrType);
                    _builder.append(" must match the type of the attribute it overrides (");
                    _builder.append((Object)parentAttrType);
                    _builder.append(")");
                    this.error(_builder.toString(), (EObject)childAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateAttribute", new String[0]);
                }
            };
            attrFromSuperClasses.forEach(_function_2);
        };
        IterableExtensions.filter(attrFromClazzes, (Functions.Function1)_function).forEach(_function_1);
    }

    protected void checkOverridingTypeAttributeMustHaveSameOrExtendedTypeAsParent(Iterable<Attribute> attrFromClazzes, Iterable<Attribute> attrFromSuperClasses, String name) {
        Functions.Function1 _function = it -> it.isOverride();
        Consumer<Attribute> _function_1 = childAttr -> {
            Consumer<Attribute> _function_2 = parentAttr -> {
                if (childAttr.getTypeCall().getType() instanceof Data && !this.isChildOf((Data)childAttr.getTypeCall().getType(), parentAttr.getTypeCall().getType()) || !(childAttr.getTypeCall().getType() instanceof Data) || childAttr.getTypeCall().getType() == parentAttr.getTypeCall().getType()) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Overriding attribute '");
                    _builder.append(name);
                    _builder.append("' must have a type that overrides its parent attribute type of ");
                    String _name = parentAttr.getTypeCall().getType().getName();
                    _builder.append(_name);
                    this.error(_builder.toString(), (EObject)childAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateAttribute", new String[0]);
                }
            };
            attrFromSuperClasses.forEach(_function_2);
        };
        IterableExtensions.filter(attrFromClazzes, (Functions.Function1)_function).forEach(_function_1);
    }

    protected void checkAttributeCardinalityMatchSuper(Iterable<Attribute> attrFromClazzes, Iterable<Attribute> attrFromSuperClasses, String name) {
        Consumer<Attribute> _function = childAttr -> {
            Consumer<Attribute> _function_1 = parentAttr -> {
                if (childAttr.getCard().getInf() != parentAttr.getCard().getInf() || childAttr.getCard().getSup() != parentAttr.getCard().getSup() || Boolean.valueOf(childAttr.getCard().isIsMany()) != Boolean.valueOf(parentAttr.getCard().isIsMany())) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Overriding attribute '");
                    _builder.append(name);
                    _builder.append("' with cardinality (");
                    CharSequence _cardinality = this.cardinality((Attribute)childAttr);
                    _builder.append((Object)_cardinality);
                    _builder.append(") must match the cardinality of the attribute it overrides (");
                    CharSequence _cardinality_1 = this.cardinality((Attribute)parentAttr);
                    _builder.append((Object)_cardinality_1);
                    _builder.append(")");
                    this.error(_builder.toString(), (EObject)childAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.cardinalityError", new String[0]);
                }
            };
            attrFromSuperClasses.forEach(_function_1);
        };
        attrFromClazzes.forEach(_function);
    }

    protected CharSequence cardinality(Attribute attr) {
        StringConcatenation _builder = new StringConcatenation();
        int _inf = attr.getCard().getInf();
        _builder.append((Object)_inf);
        _builder.append("..");
        boolean _isIsMany = attr.getCard().isIsMany();
        if (_isIsMany) {
            _builder.append("*");
        } else {
            int _sup = attr.getCard().getSup();
            _builder.append((Object)_sup);
        }
        return _builder;
    }

    private boolean isChildOf(Data child, RosettaType parent) {
        return this._rosettaExtensions.getAllSuperTypes(child).contains(parent);
    }

    @Check
    public void checkEnumValuesAreUnique(RosettaEnumeration enumeration) {
        HashMultimap name2attr = HashMultimap.create();
        Consumer<RosettaEnumValue> _function = it -> name2attr.put((Object)it.getName(), it);
        this._rosettaExtensions.getAllEnumValues(enumeration).forEach(_function);
        EList<RosettaEnumValue> _enumValues = enumeration.getEnumValues();
        for (RosettaEnumValue value : _enumValues) {
            Set valuesByName = name2attr.get((Object)value.getName());
            int _size = valuesByName.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate enum value '");
            String _name = value.getName();
            _builder.append(_name);
            _builder.append("'");
            this.error(_builder.toString(), value, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateEnumValue", new String[0]);
        }
    }

    @Check
    public void checkFeatureNamesAreUnique(RosettaFeatureOwner ele) {
        Functions.Function1 _function = it -> it.getName();
        BiConsumer<String, List> _function_1 = (k, v) -> {
            boolean _greaterThan;
            int _size = v.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                Consumer<RosettaTypedFeature> _function_2 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Duplicate feature \"");
                    _builder.append(k);
                    _builder.append("\"");
                    this.error(_builder.toString(), (EObject)it, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
                };
                v.forEach(_function_2);
            }
        };
        IterableExtensions.groupBy(ele.getFeatures(), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check
    public void checkFunctionElementNamesAreUnique(com.regnosys.rosetta.rosetta.simple.Function ele) {
        EList<Attribute> _inputs = ele.getInputs();
        EList<ShortcutDeclaration> _shortcuts = ele.getShortcuts();
        Iterable _plus = Iterables.concat(_inputs, _shortcuts);
        Attribute _output = ele.getOutput();
        Functions.Function1 _function = it -> ((AssignPathRoot)it).getName();
        BiConsumer<String, List> _function_1 = (k, v) -> {
            boolean _greaterThan;
            int _size = v.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                Consumer<EObject> _function_2 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Duplicate feature \"");
                    _builder.append(k);
                    _builder.append("\"");
                    this.error(_builder.toString(), (EObject)it, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
                };
                v.forEach(_function_2);
            }
        };
        IterableExtensions.groupBy((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_plus, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{_output})))), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check
    public void checkClosureParameterNamesAreUnique(ClosureParameter param) {
        IScope scope = this.scopeProvider.getScope(param.getFunction().eContainer(), ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
        IEObjectDescription sameNamedElement = scope.getSingleElement(QualifiedName.create((String)param.getName()));
        if (sameNamedElement != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate name.");
            this.error(_builder.toString(), param, null);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkTypeNamesAreUnique(RosettaModel model) {
        HashMultimap name2attr = HashMultimap.create();
        Functions.Function1 _function = it -> !(it instanceof FunctionDispatch);
        Consumer<RosettaNamed> _function_1 = it -> name2attr.put((Object)it.getName(), it);
        IterableExtensions.filter((Iterable)Iterables.filter(model.getElements(), RosettaNamed.class), (Functions.Function1)_function).forEach(_function_1);
        IResourceDescriptions resourceDescription = this._resourceDescriptionsProvider.getResourceDescriptions(model.eResource());
        Set _keySet = name2attr.keySet();
        for (String name : _keySet) {
            boolean _greaterThan;
            Set valuesByName = name2attr.get((Object)name);
            int _size = valuesByName.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                Consumer<RosettaNamed> _function_2 = it -> {
                    boolean _tripleNotEquals;
                    String _name = it.getName();
                    boolean bl = _tripleNotEquals = _name != null;
                    if (_tripleNotEquals) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Duplicate element named '");
                        _builder.append(name);
                        _builder.append("'");
                        this.error(_builder.toString(), (EObject)it, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateName", new String[0]);
                    }
                };
                valuesByName.forEach(_function_2);
                continue;
            }
            if (valuesByName.size() != 1 || !model.eResource().getURI().isPlatformResource()) continue;
            EObject toCheck = ((EObject[])Conversions.unwrapArray((Object)valuesByName, EObject.class))[0];
            QualifiedName qName = this._iQualifiedNameProvider.getFullyQualifiedName(toCheck);
            Functions.Function1 _function_3 = it -> this._rosettaExtensions.isProjectLocal(model.eResource().getURI(), it.getEObjectURI()) && it.getEClass() != SimplePackage.Literals.FUNCTION_DISPATCH;
            Functions.Function1 _function_4 = it -> it.getEObjectURI();
            Iterable sameNamed = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resourceDescription.getExportedObjects(toCheck.eClass(), qName, false), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            int _size_1 = IterableExtensions.size((Iterable)sameNamed);
            boolean _greaterThan_1 = _size_1 > 1;
            if (!_greaterThan_1) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate element named '");
            _builder.append((Object)qName);
            _builder.append("' in ");
            Functions.Function1 _function_5 = it -> {
                URI _uRI = EcoreUtil.getURI((EObject)toCheck);
                return !Objects.equal((Object)_uRI, (Object)it);
            };
            Functions.Function1 _function_6 = it -> it.lastSegment();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.filter((Iterable)sameNamed, (Functions.Function1)_function_5), (CharSequence)", ", (Functions.Function1)_function_6);
            _builder.append(_join);
            this.error(_builder.toString(), toCheck, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateName", new String[0]);
        }
    }

    @Check
    public void checkMappingSetToCase(RosettaMapping element) {
        RosettaType type;
        boolean _equals;
        boolean _greaterThan;
        Functions.Function1 _function = it -> it.getSet() != null && it.getWhen() == null;
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(element.getInstances(), (Functions.Function1)_function));
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one set to with no when clause allowed.");
            this.error(_builder.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
        }
        Functions.Function1 _function_1 = it -> it.getSet() != null && it.getWhen() == null;
        int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter(element.getInstances(), (Functions.Function1)_function_1));
        boolean bl2 = _equals = _size_1 == 1;
        if (_equals) {
            RosettaMappingInstance lastInstance;
            Functions.Function1 _function_2 = it -> it.getSet() != null && it.getWhen() == null;
            RosettaMappingInstance defaultInstance = (RosettaMappingInstance)IterableExtensions.findFirst(element.getInstances(), (Functions.Function1)_function_2);
            if (defaultInstance != (lastInstance = (RosettaMappingInstance)IterableExtensions.last(element.getInstances()))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Set to without when case must be ordered last.");
                this.error(_builder_1.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            }
        }
        if ((type = this.getContainerType(element)) != null) {
            if (type instanceof Data && !IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(element.getInstances(), it -> {
                RosettaMapTestExpression _set = it.getSet();
                return _set != null;
            }))) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Set to constant type does not match type of field.");
                this.error(_builder_2.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            } else if (type instanceof RosettaEnumeration) {
                Functions.Function1 _function_3 = it -> {
                    RosettaMapTestExpression _set = it.getSet();
                    return _set != null;
                };
                Iterable _filter = IterableExtensions.filter(element.getInstances(), (Functions.Function1)_function_3);
                for (RosettaMappingInstance inst : _filter) {
                    String _name_1;
                    boolean _not;
                    RosettaMapTestExpression _set = inst.getSet();
                    boolean bl3 = _not = !(_set instanceof RosettaEnumValueReference);
                    if (_not) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("Set to constant type does not match type of field.");
                        this.error(_builder_3.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
                        continue;
                    }
                    RosettaMapTestExpression _set_1 = inst.getSet();
                    RosettaEnumValueReference setEnum = (RosettaEnumValueReference)_set_1;
                    String _name = ((RosettaEnumeration)type).getName();
                    boolean _notEquals = !Objects.equal((Object)_name, (Object)(_name_1 = setEnum.getEnumeration().getName()));
                    if (!_notEquals) continue;
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("Set to constant type does not match type of field.");
                    this.error(_builder_4.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
                }
            }
        }
    }

    public RosettaType getContainerType(RosettaMapping element) {
        EObject container = element.eContainer().eContainer().eContainer();
        if (container instanceof RosettaExternalRegularAttribute) {
            RosettaFeature attributeRef = ((RosettaExternalRegularAttribute)container).getAttributeRef();
            if (attributeRef instanceof RosettaTyped) {
                return ((RosettaTyped)((Object)attributeRef)).getTypeCall().getType();
            }
        } else if (container instanceof RosettaTyped) {
            return ((RosettaTyped)container).getTypeCall().getType();
        }
        return null;
    }

    @Check
    public void checkMappingDefaultCase(RosettaMapping element) {
        boolean _equals;
        boolean _greaterThan;
        Functions.Function1 _function = it -> it.isDefault();
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(element.getInstances(), (Functions.Function1)_function));
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one default case allowed.");
            this.error(_builder.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
        }
        Functions.Function1 _function_1 = it -> it.isDefault();
        int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter(element.getInstances(), (Functions.Function1)_function_1));
        boolean bl2 = _equals = _size_1 == 1;
        if (_equals) {
            RosettaMappingInstance lastInstance;
            Functions.Function1 _function_2 = it -> it.isDefault();
            RosettaMappingInstance defaultInstance = (RosettaMappingInstance)IterableExtensions.findFirst(element.getInstances(), (Functions.Function1)_function_2);
            if (defaultInstance != (lastInstance = (RosettaMappingInstance)IterableExtensions.last(element.getInstances()))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Default case must be ordered last.");
                this.error(_builder_1.toString(), element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            }
        }
    }

    @Check
    public void checkSymbolReference(RosettaSymbolReference element) {
        RosettaSymbol callable = element.getSymbol();
        boolean _isResolved = this._rosettaExtensions.isResolved(callable);
        if (_isResolved) {
            if (callable instanceof RosettaCallableWithArgs) {
                int callableSize;
                int callerSize = element.getArgs().size();
                if (callerSize != (callableSize = ((RosettaCallableWithArgs)callable).numberOfParameters())) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Invalid number of arguments. Expecting ");
                    _builder.append((Object)callableSize);
                    _builder.append(" but passed ");
                    _builder.append((Object)callerSize);
                    _builder.append(".");
                    this.error(_builder.toString(), element, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
                } else if (callable instanceof com.regnosys.rosetta.rosetta.simple.Function) {
                    Consumer<Pair> _function = indexed -> {
                        RosettaExpression callerArg = (RosettaExpression)indexed.getValue();
                        Integer callerIdx = (Integer)indexed.getKey();
                        Attribute param = (Attribute)((com.regnosys.rosetta.rosetta.simple.Function)callable).getInputs().get(callerIdx.intValue());
                        this.checkType(this._typeSystem.typeCallToRType(param.getTypeCall()), callerArg, element, ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, callerIdx);
                        if (!param.getCard().isIsMany() && this.cardinality.isMulti(callerArg)) {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("Expecting single cardinality for parameter '");
                            String _name = param.getName();
                            _builder_1.append(_name);
                            _builder_1.append("'.");
                            this.error(_builder_1.toString(), element, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, callerIdx);
                        }
                    };
                    IterableExtensions.indexed(element.getArgs()).forEach(_function);
                } else if (callable instanceof RosettaRule) {
                    boolean _tripleNotEquals;
                    TypeCall _input = ((RosettaRule)callable).getInput();
                    boolean bl = _tripleNotEquals = _input != null;
                    if (_tripleNotEquals) {
                        this.checkType(this._typeSystem.typeCallToRType(((RosettaRule)callable).getInput()), (RosettaExpression)IterableExtensions.head(element.getArgs()), element, ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, 0);
                        boolean _isMulti = this.cardinality.isMulti((RosettaExpression)IterableExtensions.head(element.getArgs()));
                        if (_isMulti) {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("Expecting single cardinality for input to rule.");
                            this.error(_builder_1.toString(), element, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, 0);
                        }
                    }
                }
            } else {
                boolean _isExplicitArguments;
                Functions.Function1 _function_1;
                RType implicitType;
                Iterable<? extends RosettaFeature> implicitFeatures;
                boolean _exists;
                boolean _isOutput;
                if (callable instanceof Attribute && (_isOutput = this._rosettaFunctionExtensions.isOutput((Attribute)callable)) && (_exists = IterableExtensions.exists(implicitFeatures = this._rosettaExtensions.allFeatures(implicitType = this._rosettaTypeProvider.typeOfImplicitVariable(element), callable), (Functions.Function1)(_function_1 = it -> {
                    String _name = it.getName();
                    String _name_1 = ((Attribute)callable).getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                })))) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Ambiguous reference. `");
                    String _name = ((Attribute)callable).getName();
                    _builder_2.append(_name);
                    _builder_2.append("` may either refer to `");
                    String _name_1 = this._implicitVariableUtil.getDefaultImplicitVariable().getName();
                    _builder_2.append(_name_1);
                    _builder_2.append(" -> ");
                    String _name_2 = ((Attribute)callable).getName();
                    _builder_2.append(_name_2);
                    _builder_2.append("` or to the output variable.");
                    this.error(_builder_2.toString(), element, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
                }
                if (_isExplicitArguments = element.isExplicitArguments()) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("A variable may not be called.");
                    this.error(_builder_3.toString(), element, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS);
                }
            }
        }
    }

    @Check
    public void checkMergeSynonymAttributeCardinality(Attribute attribute) {
        EList<RosettaSynonym> _synonyms = attribute.getSynonyms();
        for (RosettaSynonym syn : _synonyms) {
            boolean _tripleNotEquals;
            boolean multi = attribute.getCard().isIsMany();
            boolean _and = false;
            RosettaSynonymBody _body = syn.getBody();
            RosettaMergeSynonymValue _merge = null;
            if (_body != null) {
                _merge = _body.getMerge();
            }
            boolean bl = _tripleNotEquals = _merge != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = !multi;
            }
            if (!_and) continue;
            this.error("Merge synonym can only be specified on an attribute with multiple cardinality.", syn.getBody(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__MERGE);
        }
    }

    @Check
    public void checkMergeSynonymAttributeCardinality(RosettaExternalRegularAttribute attribute) {
        RosettaFeature att = attribute.getAttributeRef();
        if (att instanceof Attribute) {
            EList<RosettaExternalSynonym> _externalSynonyms = attribute.getExternalSynonyms();
            for (RosettaExternalSynonym syn : _externalSynonyms) {
                boolean _tripleNotEquals;
                boolean multi = ((Attribute)att).getCard().isIsMany();
                boolean _and = false;
                RosettaSynonymBody _body = syn.getBody();
                RosettaMergeSynonymValue _merge = null;
                if (_body != null) {
                    _merge = _body.getMerge();
                }
                boolean bl = _tripleNotEquals = _merge != null;
                if (!_tripleNotEquals) {
                    _and = false;
                } else {
                    boolean bl2 = _and = !multi;
                }
                if (!_and) continue;
                this.error("Merge synonym can only be specified on an attribute with multiple cardinality.", syn.getBody(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__MERGE);
            }
        }
    }

    @Check
    public void checkPatternAndFormat(RosettaExternalRegularAttribute attribute) {
        boolean _not;
        boolean _isDateTime = this.isDateTime(this._rosettaTypeProvider.getRTypeOfFeature(attribute.getAttributeRef()));
        boolean bl = _not = !_isDateTime;
        if (_not) {
            EList<RosettaExternalSynonym> _externalSynonyms = attribute.getExternalSynonyms();
            for (RosettaExternalSynonym s : _externalSynonyms) {
                this.checkFormatNull(s.getBody());
                this.checkPatternValid(s.getBody());
            }
        } else {
            EList<RosettaExternalSynonym> _externalSynonyms_1 = attribute.getExternalSynonyms();
            for (RosettaExternalSynonym s_1 : _externalSynonyms_1) {
                this.checkFormatValid(s_1.getBody());
                this.checkPatternNull(s_1.getBody());
            }
        }
    }

    @Check
    public void checkPatternAndFormat(Attribute attribute) {
        boolean _not;
        boolean _isDateTime = this.isDateTime(this._rosettaTypeProvider.getRTypeOfSymbol(attribute));
        boolean bl = _not = !_isDateTime;
        if (_not) {
            EList<RosettaSynonym> _synonyms = attribute.getSynonyms();
            for (RosettaSynonym s : _synonyms) {
                this.checkFormatNull(s.getBody());
                this.checkPatternValid(s.getBody());
            }
        } else {
            EList<RosettaSynonym> _synonyms_1 = attribute.getSynonyms();
            for (RosettaSynonym s_1 : _synonyms_1) {
                this.checkFormatValid(s_1.getBody());
                this.checkPatternNull(s_1.getBody());
            }
        }
    }

    public void checkFormatNull(RosettaSynonymBody body) {
        boolean _tripleNotEquals;
        String _format = body.getFormat();
        boolean bl = _tripleNotEquals = _format != null;
        if (_tripleNotEquals) {
            this.error("Format can only be applied to date/time types", body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__FORMAT);
        }
    }

    public DateTimeFormatter checkFormatValid(RosettaSynonymBody body) {
        boolean _tripleNotEquals;
        DateTimeFormatter _xifexpression = null;
        String _format = body.getFormat();
        boolean bl = _tripleNotEquals = _format != null;
        if (_tripleNotEquals) {
            DateTimeFormatter _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = DateTimeFormatter.ofPattern(body.getFormat());
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    IllegalArgumentException e = (IllegalArgumentException)_t;
                    String _message = e.getMessage();
                    String _plus = "Format must be a valid date/time format - " + _message;
                    this.error(_plus, body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__FORMAT);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        return _xifexpression;
    }

    public void checkPatternNull(RosettaSynonymBody body) {
        boolean _tripleNotEquals;
        String _patternMatch = body.getPatternMatch();
        boolean bl = _tripleNotEquals = _patternMatch != null;
        if (_tripleNotEquals) {
            this.error("Pattern cannot be applied to date/time types", body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__PATTERN_MATCH);
        }
    }

    public Pattern checkPatternValid(RosettaSynonymBody body) {
        boolean _tripleNotEquals;
        Pattern _xifexpression = null;
        String _patternMatch = body.getPatternMatch();
        boolean bl = _tripleNotEquals = _patternMatch != null;
        if (_tripleNotEquals) {
            Pattern _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = Pattern.compile(body.getPatternMatch());
            }
            catch (Throwable _t) {
                if (_t instanceof PatternSyntaxException) {
                    PatternSyntaxException e = (PatternSyntaxException)_t;
                    String _message = e.getMessage();
                    String _plus = "Pattern to match must be a valid regular expression - " + _message;
                    this.error(_plus, body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__PATTERN_MATCH);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        return _xifexpression;
    }

    private boolean isDateTime(RType rType) {
        String _name = null;
        if (rType != null) {
            _name = rType.getName();
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"date", "time", "zonedDateTime"})).contains(_name);
    }

    @Check
    public void checkPatternOnEnum(RosettaEnumSynonym synonym) {
        boolean _tripleNotEquals;
        String _patternMatch = synonym.getPatternMatch();
        boolean bl = _tripleNotEquals = _patternMatch != null;
        if (_tripleNotEquals) {
            try {
                Pattern.compile(synonym.getPatternMatch());
            }
            catch (Throwable _t) {
                if (_t instanceof PatternSyntaxException) {
                    PatternSyntaxException e = (PatternSyntaxException)_t;
                    String _message = e.getMessage();
                    String _plus = "Pattern to match must be a valid regular expression - " + _message;
                    this.error(_plus, synonym, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_SYNONYM__PATTERN_MATCH);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkAttributeRuleReference(Attribute attr) {
        RosettaRuleReference ruleRef = attr.getRuleReference();
        if (ruleRef != null) {
            boolean ruleSingle;
            RosettaRule rule = ruleRef.getReportingRule();
            ExpandedAttribute attrExt = RosettaAttributeExtensions.toExpandedAttribute(attr);
            boolean attrSingle = RosettaAttributeExtensions.cardinalityIsSingleValue(attrExt);
            RType attrType = this._typeSystem.typeCallToRType(attr.getTypeCall());
            boolean _isMulti = this.cardinality.isMulti(rule.getExpression());
            boolean bl = ruleSingle = !_isMulti;
            if (attrSingle && !ruleSingle) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cardinality mismatch - report field ");
                String _name = attr.getName();
                _builder.append(_name);
                _builder.append(" has single cardinality ");
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("whereas the reporting rule ");
                String _name_1 = rule.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" has multiple cardinality.");
                String cardWarning = _builder.toString() + _builder_1;
                this.error(cardWarning, ruleRef, (EStructuralFeature)SimplePackage.Literals.ROSETTA_RULE_REFERENCE__REPORTING_RULE);
            } else if (!attrSingle && ruleSingle) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Cardinality mismatch - report field ");
                String _name_2 = attr.getName();
                _builder_2.append(_name_2);
                _builder_2.append(" has multiple cardinality ");
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("whereas the reporting rule ");
                String _name_3 = rule.getName();
                _builder_3.append(_name_3);
                _builder_3.append(" has single cardinality.");
                String cardWarning_1 = _builder_2.toString() + _builder_3;
                this.warning(cardWarning_1, ruleRef, (EStructuralFeature)SimplePackage.Literals.ROSETTA_RULE_REFERENCE__REPORTING_RULE);
            }
            RType ruleType = this._rosettaTypeProvider.getRType(rule.getExpression());
            if (!(ruleType == null || Objects.equal((Object)ruleType, (Object)this._rBuiltinTypeService.MISSING) || attrType == null || Objects.equal((Object)attrType, (Object)this._rBuiltinTypeService.MISSING) || this._typeSystem.isSubtypeOf(ruleType, attrType))) {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("Type mismatch - report field ");
                String _name_4 = attr.getName();
                _builder_4.append(_name_4);
                _builder_4.append(" has type ");
                String _name_5 = attrType.getName();
                _builder_4.append(_name_5);
                _builder_4.append(" ");
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("whereas the reporting rule ");
                String _name_6 = rule.getName();
                _builder_5.append(_name_6);
                _builder_5.append(" has type ");
                _builder_5.append((Object)ruleType);
                _builder_5.append(".");
                String typeError = _builder_4.toString() + _builder_5;
                this.error(typeError, ruleRef, (EStructuralFeature)SimplePackage.Literals.ROSETTA_RULE_REFERENCE__REPORTING_RULE);
            }
        }
    }

    @Check
    public void checkExpressionCardinality(ModifiableBinaryOperation binOp) {
        boolean rightCard;
        boolean leftCard = this.cardinality.isMulti(binOp.getLeft());
        if (leftCard != (rightCard = this.cardinality.isMulti(binOp.getRight()))) {
            boolean _tripleEquals;
            CardinalityModifier _cardMod = binOp.getCardMod();
            boolean bl = _tripleEquals = _cardMod == CardinalityModifier.NONE;
            if (_tripleEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Comparison operator ");
                String _operator = binOp.getOperator();
                _builder.append(_operator);
                _builder.append(" should specify 'all' or 'any' when comparing a list to a single value");
                this.warning(_builder.toString(), binOp, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        } else {
            boolean _tripleNotEquals;
            CardinalityModifier _cardMod_1 = binOp.getCardMod();
            boolean bl = _tripleNotEquals = _cardMod_1 != CardinalityModifier.NONE;
            if (_tripleNotEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                CardinalityModifier _cardMod_2 = binOp.getCardMod();
                _builder_1.append((Object)_cardMod_2);
                _builder_1.append(" is only aplicable when the sides have differing cardinality");
                this.warning(_builder_1.toString(), binOp, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }

    @Check
    public void checkBinaryParamsRightTypes(RosettaBinaryOperation binOp) {
        RType resultType = this._rosettaTypeProvider.getRType(binOp);
        if (resultType instanceof RErrorType) {
            this.error(((RErrorType)resultType).getMessage(), binOp, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkDefaultOperationMatchingCardinality(DefaultOperation defOp) {
        boolean rightCard;
        boolean leftCard = this.cardinality.isMulti(defOp.getLeft());
        if (leftCard != (rightCard = this.cardinality.isMulti(defOp.getRight()))) {
            String typeError = "Cardinality mismatch - default operator requires both sides to have matching cardinality";
            this.error("Cardinality mismatch - default operator requires both sides to have matching cardinality", defOp, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkFuncDispatchAttr(FunctionDispatch ele) {
        if (this._rosettaExtensions.isResolved(ele.getAttribute()) && this._rosettaExtensions.isResolved(ele.getAttribute().getTypeCall())) {
            boolean _not;
            RosettaType _type = ele.getAttribute().getTypeCall().getType();
            boolean bl = _not = !(_type instanceof RosettaEnumeration);
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Dispatching function may refer to an enumeration typed attributes only. Current type is ");
                String _name = ele.getAttribute().getTypeCall().getType().getName();
                _builder.append(_name);
                this.error(_builder.toString(), ele, (EStructuralFeature)SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE);
            }
        }
    }

    @Check
    public void checkAttribute(Attribute ele) {
        boolean _and = false;
        RosettaType _type = ele.getTypeCall().getType();
        if (!(_type instanceof Data)) {
            _and = false;
        } else {
            boolean _isResolved;
            TypeCall _typeCall = ele.getTypeCall();
            RosettaType _type_1 = null;
            if (_typeCall != null) {
                _type_1 = _typeCall.getType();
            }
            _and = _isResolved = this._rosettaExtensions.isResolved(_type_1);
        }
        if (_and && this._rosettaExtensions.hasReferenceAnnotation(ele) && !this._rosettaExtensions.hasKeyedAnnotation((Annotated)((Object)ele.getTypeCall().getType())) && !IterableExtensions.exists(this._rosettaExtensions.getAllSuperTypes((Data)ele.getTypeCall().getType()), it -> this._rosettaExtensions.hasKeyedAnnotation((Annotated)it))) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = ele.getTypeCall().getType().getName();
            _builder.append(_name);
            _builder.append(" must be annotated with [metadata key] as reference annotation is used");
            this.warning(_builder.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
        }
    }

    @Check
    public void checkDispatch(com.regnosys.rosetta.rosetta.simple.Function ele) {
        boolean _not;
        if (ele instanceof FunctionDispatch) {
            return;
        }
        List dispath = IterableExtensions.toList(this._rosettaFunctionExtensions.getDispatchingFunctions(ele));
        boolean _isEmpty = dispath.isEmpty();
        if (_isEmpty) {
            return;
        }
        LinkedHashMultimap enumsUsed = LinkedHashMultimap.create();
        Consumer<FunctionDispatch> _function = it -> {
            RosettaEnumValueReference enumRef = it.getValue();
            if (enumRef != null && enumRef.getEnumeration() != null && enumRef.getValue() != null) {
                RosettaEnumeration _enumeration = enumRef.getEnumeration();
                String _name = enumRef.getValue().getName();
                Pair _mappedTo = Pair.of((Object)_name, (Object)it);
                enumsUsed.put((Object)_enumeration, (Object)_mappedTo);
            }
        };
        dispath.forEach(_function);
        Functions.Function1 _function_1 = it -> {
            Set _get = enumsUsed.get(it);
            return Pair.of((Object)it, (Object)_get);
        };
        Functions.Function1 _function_2 = it -> it == null || it.getValue() == null;
        Iterable structured = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)enumsUsed.keys(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)structured);
        if (_isNullOrEmpty) {
            return;
        }
        Comparator _function_3 = ($0, $1) -> {
            int _size = ((Set)$0.getValue()).size();
            int _size_1 = ((Set)$1.getValue()).size();
            return Integer.valueOf(_size).compareTo(_size_1);
        };
        RosettaEnumeration mostUsedEnum = (RosettaEnumeration)((Pair)IterableExtensions.max((Iterable)structured, (Comparator)_function_3)).getKey();
        Functions.Function1 _function_4 = it -> it.getName();
        Set toImplement = IterableExtensions.toSet((Iterable)IterableExtensions.map(this._rosettaExtensions.getAllEnumValues(mostUsedEnum), (Functions.Function1)_function_4));
        Consumer<Pair> _function_5 = it -> toImplement.remove(it.getKey());
        enumsUsed.get((Object)mostUsedEnum).forEach(_function_5);
        boolean _isEmpty_1 = toImplement.isEmpty();
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Missing implementation for ");
            String _name = mostUsedEnum.getName();
            _builder.append(_name);
            _builder.append(": ");
            String _join = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)toImplement), (CharSequence)", ");
            _builder.append(_join);
            this.warning(_builder.toString(), ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
        Consumer<Pair> _function_6 = it -> {
            boolean _notEquals;
            RosettaEnumeration _key = (RosettaEnumeration)it.getKey();
            boolean bl = _notEquals = !Objects.equal((Object)_key, (Object)mostUsedEnum);
            if (_notEquals) {
                Consumer<Pair> _function_7 = entry -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Wrong ");
                    String _name_1 = ((RosettaEnumeration)it.getKey()).getName();
                    _builder_1.append(_name_1);
                    _builder_1.append(" enumeration used. Expecting ");
                    String _name_2 = mostUsedEnum.getName();
                    _builder_1.append(_name_2);
                    _builder_1.append(".");
                    this.error(_builder_1.toString(), ((FunctionDispatch)entry.getValue()).getValue(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__ENUMERATION);
                };
                ((Set)it.getValue()).forEach(_function_7);
            } else {
                Functions.Function1 _function_8 = it_1 -> (String)it_1.getKey();
                Functions.Function2 _function_9 = (enumVal, entries) -> {
                    int _size = entries.size();
                    return _size > 1;
                };
                BiConsumer<String, List> _function_10 = (enumVal, entries) -> {
                    Consumer<Pair> _function_11 = it_1 -> {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Dupplicate usage of ");
                        String _key_1 = (String)it_1.getKey();
                        _builder_1.append(_key_1);
                        _builder_1.append(" enumeration value.");
                        this.error(_builder_1.toString(), ((FunctionDispatch)it_1.getValue()).getValue(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE);
                    };
                    entries.forEach(_function_11);
                };
                MapExtensions.filter((Map)IterableExtensions.groupBy((Iterable)((Iterable)it.getValue()), (Functions.Function1)_function_8), (Functions.Function2)_function_9).forEach(_function_10);
            }
        };
        structured.forEach(_function_6);
    }

    @Check
    public void checkConditionDontUseOutput(com.regnosys.rosetta.rosetta.simple.Function ele) {
        Functions.Function1 _function = it -> {
            boolean _isPostCondition = it.isPostCondition();
            return !_isPostCondition;
        };
        Consumer<Condition> _function_1 = cond -> {
            RosettaExpression expr = cond.getExpression();
            if (expr != null) {
                boolean _not;
                Stack<String> trace = new Stack<String>();
                List<RosettaSymbol> outRef = this.exprHelper.findOutputRef(expr, trace);
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(outRef);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    boolean _not_1;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("output '");
                    String _name = ((RosettaSymbol)IterableExtensions.head(outRef)).getName();
                    _builder.append(_name);
                    _builder.append("' or alias on output '");
                    String _name_1 = ((RosettaSymbol)IterableExtensions.head(outRef)).getName();
                    _builder.append(_name_1);
                    _builder.append("' not allowed in condition blocks.");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = trace.isEmpty();
                    boolean bl2 = _not_1 = !_isEmpty;
                    if (_not_1) {
                        String _join = IterableExtensions.join(trace, (CharSequence)" > ");
                        _builder.append(_join);
                        _builder.append(" > ");
                        String _name_2 = ((RosettaSymbol)IterableExtensions.head(outRef)).getName();
                        _builder.append(_name_2);
                    }
                    this.error(_builder.toString(), expr, null);
                }
            }
        };
        IterableExtensions.filter(ele.getConditions(), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check
    public void checkAssignAnAlias(Operation ele) {
        if (ele.getPath() == null && ele.getAssignRoot() instanceof ShortcutDeclaration) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("An alias can not be assigned. Assign target must be an attribute.");
            this.error(_builder.toString(), ele, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
    }

    @Check
    public void checkConstructorExpression(RosettaConstructorExpression ele) {
        RType rType = this._rosettaTypeProvider.getRType(ele);
        if (rType != null) {
            RType baseRType = this._typeSystem.stripFromTypeAliases(rType);
            if (!(baseRType instanceof RDataType) && !(baseRType instanceof RRecordType)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot construct an instance of type `");
                String _name = rType.getName();
                _builder.append(_name);
                _builder.append("`.");
                this.error(_builder.toString(), ele.getTypeCall(), null);
            }
            HashSet seenFeatures = CollectionLiterals.newHashSet();
            EList<ConstructorKeyValuePair> _values = ele.getValues();
            for (ConstructorKeyValuePair pair : _values) {
                boolean _not;
                RosettaFeature feature = pair.getKey();
                RosettaExpression expr = pair.getValue();
                boolean _add = seenFeatures.add(feature);
                boolean bl = _not = !_add;
                if (_not) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Duplicate attribute `");
                    String _name_1 = feature.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("`.");
                    this.error(_builder_1.toString(), pair, (EStructuralFeature)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY);
                }
                this.checkType(this._rosettaTypeProvider.getRTypeOfFeature(feature), expr, pair, ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__VALUE, -1);
                if (this.cardinality.isFeatureMulti(feature) || !this.cardinality.isMulti(expr)) continue;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Expecting single cardinality for attribute `");
                String _name_2 = feature.getName();
                _builder_2.append(_name_2);
                _builder_2.append("`.");
                this.error(_builder_2.toString(), pair, (EStructuralFeature)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__VALUE);
            }
            Functions.Function1 _function = it -> {
                boolean _contains = seenFeatures.contains(it);
                return !_contains;
            };
            Iterable absentAttributes = IterableExtensions.filter(this._rosettaExtensions.allFeatures(rType, ele), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> !(it instanceof Attribute) || ((Attribute)it).getCard().getInf() != 0;
            Iterable requiredAbsentAttributes = IterableExtensions.filter((Iterable)absentAttributes, (Functions.Function1)_function_1);
            boolean _isImplicitEmpty = ele.isImplicitEmpty();
            if (_isImplicitEmpty) {
                int _size_1;
                int _size;
                boolean _tripleEquals;
                boolean _not;
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)requiredAbsentAttributes);
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Missing attributes ");
                    boolean _hasElements = false;
                    for (RosettaFeature attr : requiredAbsentAttributes) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_1.appendImmediate((Object)", ", "");
                        }
                        _builder_1.append("`");
                        String _name_1 = attr.getName();
                        _builder_1.append(_name_1);
                        _builder_1.append("`");
                    }
                    _builder_1.append(".");
                    this.error(_builder_1.toString(), ele.getTypeCall(), null);
                }
                boolean bl2 = _tripleEquals = (_size = IterableExtensions.size((Iterable)absentAttributes)) == (_size_1 = IterableExtensions.size((Iterable)requiredAbsentAttributes));
                if (_tripleEquals) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("There are no optional attributes left.");
                    this.error(_builder_2.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY);
                }
            } else {
                boolean _not_1;
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)absentAttributes);
                boolean bl = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Missing attributes ");
                    boolean _hasElements_1 = false;
                    for (RosettaFeature attr_1 : absentAttributes) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder_3.appendImmediate((Object)", ", "");
                        }
                        _builder_3.append("`");
                        String _name_2 = attr_1.getName();
                        _builder_3.append(_name_2);
                        _builder_3.append("`");
                    }
                    _builder_3.append(".");
                    boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)requiredAbsentAttributes);
                    if (_isEmpty_2) {
                        _builder_3.append(" Perhaps you forgot a `...` at the end of the constructor?");
                    }
                    this.error(_builder_3.toString(), ele.getTypeCall(), null);
                }
            }
        }
    }

    @Check
    public void checkListLiteral(ListLiteral ele) {
        RType type = this._rosettaTypeProvider.getRType(ele);
        if (type instanceof RErrorType) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("All collection elements must have the same super type but types were ");
            String _message = ((RErrorType)type).getMessage();
            _builder.append(_message);
            this.error(_builder.toString(), ele, null);
        }
    }

    @Check
    public void checkSynonyMapPath(RosettaMapPathValue ele) {
        Pair<Character, Boolean> invalidChar;
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)ele.getPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not && (invalidChar = this.checkPathChars(ele.getPath())) != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Character '");
            Character _key = (Character)invalidChar.getKey();
            _builder.append((Object)_key);
            _builder.append("' is not allowed ");
            Boolean _value = (Boolean)invalidChar.getValue();
            if (_value.booleanValue()) {
                _builder.append("as first symbol in a path segment.");
            } else {
                _builder.append("in paths. Use '->' to separate path segments.");
            }
            this.error(_builder.toString(), ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAP_PATH_VALUE__PATH);
        }
    }

    @Check
    public void checkSynonyValuePath(RosettaSynonymValueBase ele) {
        Pair<Character, Boolean> invalidChar;
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)ele.getPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not && (invalidChar = this.checkPathChars(ele.getPath())) != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Character '");
            Character _key = (Character)invalidChar.getKey();
            _builder.append((Object)_key);
            _builder.append("' is not allowed ");
            Boolean _value = (Boolean)invalidChar.getValue();
            if (_value.booleanValue()) {
                _builder.append("as first symbol in a path segment.");
            } else {
                _builder.append("in paths. Use '->' to separate path segments.");
            }
            this.error(_builder.toString(), ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_VALUE_BASE__PATH);
        }
    }

    @Check
    public void checkCountOpArgument(RosettaCountOperation ele) {
        boolean _isResolved = this._rosettaExtensions.isResolved(ele.getArgument());
        if (_isResolved) {
            boolean _not;
            boolean _isMulti = this.cardinality.isMulti(ele.getArgument());
            boolean bl = _not = !_isMulti;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Count operation multiple cardinality argument.");
                this.error(_builder.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
        }
    }

    @Check
    public void checkParseOpArgument(ParseOperation ele) {
        RosettaExpression arg = ele.getArgument();
        boolean _isResolved = this._rosettaExtensions.isResolved(arg);
        if (_isResolved) {
            boolean _isSubtypeOf;
            boolean _not;
            boolean _isMulti = this.cardinality.isMulti(arg);
            if (_isMulti) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The argument of ");
                String _operator = ele.getOperator();
                _builder.append(_operator);
                _builder.append(" should be of singular cardinality.");
                this.error(_builder.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
            boolean bl = _not = !(_isSubtypeOf = this._typeSystem.isSubtypeOf(this._rosettaTypeProvider.getRType(arg), this._rBuiltinTypeService.UNCONSTRAINED_STRING));
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("The argument of ");
                String _operator_1 = ele.getOperator();
                _builder_1.append(_operator_1);
                _builder_1.append(" should be a string.");
                this.error(_builder_1.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
        }
    }

    @Check
    public void checkToStringOpArgument(ToStringOperation ele) {
        RosettaExpression arg = ele.getArgument();
        boolean _isResolved = this._rosettaExtensions.isResolved(arg);
        if (_isResolved) {
            RType type;
            boolean _isMulti = this.cardinality.isMulti(arg);
            if (_isMulti) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The argument of ");
                String _operator = ele.getOperator();
                _builder.append(_operator);
                _builder.append(" should be of singular cardinality.");
                this.error(_builder.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
            if (!((type = this._typeSystem.stripFromTypeAliases(this._rosettaTypeProvider.getRType(arg))) instanceof RBasicType || type instanceof RRecordType || type instanceof REnumType)) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("The argument of ");
                String _operator_1 = ele.getOperator();
                _builder_1.append(_operator_1);
                _builder_1.append(" should be of a builtin type or an enum.");
                this.error(_builder_1.toString(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
        }
    }

    @Check
    public void checkFunctionPrefix(com.regnosys.rosetta.rosetta.simple.Function ele) {
        Consumer<AnnotationRef> _function = a -> {
            String prefix = a.getAnnotation().getPrefix();
            if (prefix != null && !ele.getName().startsWith(prefix + "_")) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Function name ");
                String _name = ele.getName();
                _builder.append(_name);
                _builder.append(" must have prefix '");
                _builder.append(prefix);
                _builder.append("' followed by an underscore.");
                this.warning(_builder.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            }
        };
        ele.getAnnotations().forEach(_function);
    }

    @Check
    public void checkMetadataAnnotation(Annotated ele) {
        List<AnnotationRef> metadatas = this._rosettaFunctionExtensions.getMetadataAnnotations(ele);
        Consumer<AnnotationRef> _function = it -> {
            Attribute _attribute = it.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            if (_name != null) {
                switch (_name) {
                    case "key": {
                        if (ele instanceof Data) break;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("[metadata key] annotation only allowed on a type.");
                        this.error(_builder.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "id": {
                        if (ele instanceof Attribute) break;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("[metadata id] annotation only allowed on an attribute.");
                        this.error(_builder_1.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "reference": {
                        if (ele instanceof Attribute) break;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("[metadata reference] annotation only allowed on an attribute.");
                        this.error(_builder_2.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "scheme": {
                        if (ele instanceof Attribute || ele instanceof Data) break;
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("[metadata scheme] annotation only allowed on an attribute or a type.");
                        this.error(_builder_3.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "template": {
                        boolean _not;
                        if (!(ele instanceof Data)) {
                            StringConcatenation _builder_4 = new StringConcatenation();
                            _builder_4.append("[metadata template] annotation only allowed on a type.");
                            this.error(_builder_4.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                            break;
                        }
                        Functions.Function1 _function_1 = it_1 -> {
                            Attribute _attribute_1 = it_1.getAttribute();
                            String _name_1 = null;
                            if (_attribute_1 != null) {
                                _name_1 = _attribute_1.getName();
                            }
                            return _name_1;
                        };
                        boolean _contains = ListExtensions.map((List)metadatas, (Functions.Function1)_function_1).contains("key");
                        boolean bl = _not = !_contains;
                        if (!_not) break;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append("Types with [metadata template] annotation must also specify the [metadata key] annotation.");
                        this.error(_builder_5.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "location": {
                        if (ele instanceof Attribute) {
                            Functions.Function1 _function_2 = it_1 -> {
                                String _qualName = it_1.getQualName();
                                return Objects.equal((Object)_qualName, (Object)"pointsTo");
                            };
                            boolean _exists = IterableExtensions.exists(it.getQualifiers(), (Functions.Function1)_function_2);
                            if (!_exists) break;
                            StringConcatenation _builder_6 = new StringConcatenation();
                            _builder_6.append("pointsTo qualifier belongs on the address not the location.");
                            this.error(_builder_6.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                            break;
                        }
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append("[metadata location] annotation only allowed on an attribute.");
                        this.error(_builder_7.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    case "address": {
                        if (ele instanceof Attribute) {
                            Consumer<AnnotationQualifier> _function_3 = it_1 -> {
                                String _qualName = it_1.getQualName();
                                boolean _equals = Objects.equal((Object)_qualName, (Object)"pointsTo");
                                if (_equals) {
                                    RosettaAttributeReferenceSegment _qualPath = it_1.getQualPath();
                                    boolean _matched = false;
                                    if (_qualPath instanceof RosettaAttributeReference) {
                                        _matched = true;
                                        RosettaAttributeReferenceSegment _qualPath_1 = it_1.getQualPath();
                                        RosettaAttributeReference attrRef = (RosettaAttributeReference)_qualPath_1;
                                        boolean _isResolved = this._rosettaExtensions.isResolved(attrRef.getAttribute());
                                        if (_isResolved) {
                                            boolean _not_1;
                                            this.checkForLocation(attrRef.getAttribute(), (AnnotationQualifier)it_1);
                                            RType targetType = this._typeSystem.typeCallToRType(attrRef.getAttribute().getTypeCall());
                                            RType thisType = this._rosettaTypeProvider.getRTypeOfSymbol((RosettaSymbol)((Object)ele));
                                            boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(targetType, thisType);
                                            boolean bl = _not_1 = !_isSubtypeOf;
                                            if (_not_1) {
                                                StringConcatenation _builder_8 = new StringConcatenation();
                                                _builder_8.append("Expected address target type of '");
                                                String _name_1 = thisType.getName();
                                                _builder_8.append(_name_1);
                                                _builder_8.append("' but was '");
                                                String _elvis = null;
                                                String _name_2 = null;
                                                if (targetType != null) {
                                                    _name_2 = targetType.getName();
                                                }
                                                _elvis = _name_2 != null ? _name_2 : "null";
                                                _builder_8.append(_elvis);
                                                _builder_8.append("'");
                                                this.error(_builder_8.toString(), (EObject)it_1, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH, "RosettaIssueCodes.typeError", new String[0]);
                                            }
                                        }
                                    }
                                    if (!_matched) {
                                        StringConcatenation _builder_8 = new StringConcatenation();
                                        _builder_8.append("Target of an address must be an attribute");
                                        this.error(_builder_8.toString(), (EObject)it_1, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH, "RosettaIssueCodes.typeError", new String[0]);
                                    }
                                }
                            };
                            it.getQualifiers().forEach(_function_3);
                            break;
                        }
                        StringConcatenation _builder_8 = new StringConcatenation();
                        _builder_8.append("[metadata address] annotation only allowed on an attribute.");
                        this.error(_builder_8.toString(), (EObject)it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    }
                }
            }
        };
        metadatas.forEach(_function);
    }

    public void checkForLocation(Attribute attribute, AnnotationQualifier checked) {
        boolean locationFound;
        Functions.Function1 _function = it -> {
            Attribute _attribute = it.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"location");
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(this._rosettaFunctionExtensions.getMetadataAnnotations(attribute), (Functions.Function1)_function));
        boolean bl = locationFound = !_isEmpty;
        if (!locationFound) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Target of address must be annotated with metadata location");
            this.error(_builder.toString(), checked, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH);
        }
    }

    @Check
    public void checkCreationAnnotation(Annotated ele) {
        boolean _greaterThan;
        List<AnnotationRef> annotations = this._rosettaFunctionExtensions.getCreationAnnotations(ele);
        boolean _isEmpty = annotations.isEmpty();
        if (_isEmpty) {
            return;
        }
        if (!(ele instanceof com.regnosys.rosetta.rosetta.simple.Function)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Creation annotation only allowed on a function.");
            this.error(_builder.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        int _size = annotations.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Only 1 creation annotation allowed.");
            this.error(_builder_1.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        com.regnosys.rosetta.rosetta.simple.Function func = (com.regnosys.rosetta.rosetta.simple.Function)ele;
        RosettaType annotationType = ((AnnotationRef)IterableExtensions.head(annotations)).getAttribute().getTypeCall().getType();
        RosettaType funcOutputType = func.getOutput().getTypeCall().getType();
        if (annotationType instanceof Data && funcOutputType instanceof Data) {
            Data annotationDataType = (Data)annotationType;
            Data funcOutputDataType = (Data)funcOutputType;
            Set funcOutputSuperTypes = IterableExtensions.toSet(this._rosettaExtensions.getAllSuperTypes(funcOutputDataType.getSuperType()));
            Functions.Function1 _function = it -> it.getTypeCall().getType();
            List annotationAttributeTypes = IterableExtensions.toList((Iterable)ListExtensions.map(annotationDataType.getAttributes(), (Functions.Function1)_function));
            if (!(Objects.equal((Object)annotationDataType, (Object)funcOutputDataType) || funcOutputSuperTypes.contains(annotationDataType) || annotationAttributeTypes.contains(funcOutputDataType))) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Invalid output type for creation annotation.  The output type must match the type specified in the annotation '");
                String _name = annotationDataType.getName();
                _builder_2.append(_name);
                _builder_2.append("' (or extend the annotation type, or be a sub-type as part of a one-of condition).");
                this.warning(_builder_2.toString(), func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__OUTPUT);
            }
        }
    }

    @Check
    public void checkQualificationAnnotation(Annotated ele) {
        boolean _notEquals;
        RosettaType inputType;
        boolean _isResolved;
        boolean _not;
        boolean _greaterThan;
        List<AnnotationRef> annotations = this._rosettaFunctionExtensions.getQualifierAnnotations(ele);
        boolean _isEmpty = annotations.isEmpty();
        if (_isEmpty) {
            return;
        }
        if (!(ele instanceof com.regnosys.rosetta.rosetta.simple.Function)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Qualification annotation only allowed on a function.");
            this.error(_builder.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        com.regnosys.rosetta.rosetta.simple.Function func = (com.regnosys.rosetta.rosetta.simple.Function)ele;
        int _size = annotations.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Only 1 qualification annotation allowed.");
            this.error(_builder_1.toString(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        List<Attribute> inputs = this._rosettaFunctionExtensions.getInputs(func);
        if (IterableExtensions.isNullOrEmpty(inputs) || inputs.size() != 1) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Qualification functions must have exactly 1 input.");
            this.error(_builder_2.toString(), func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
            return;
        }
        TypeCall _typeCall = inputs.get(0).getTypeCall();
        RosettaType _type = null;
        if (_typeCall != null) {
            _type = _typeCall.getType();
        }
        boolean bl2 = _not = !(_isResolved = this._rosettaExtensions.isResolved(inputType = _type));
        if (_not) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Invalid input type for qualification function.");
            this.error(_builder_3.toString(), func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
        } else {
            boolean _not_1;
            boolean _isRootEventOrProduct = this.confExtensions.isRootEventOrProduct(inputType);
            boolean bl3 = _not_1 = !_isRootEventOrProduct;
            if (_not_1) {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("Input type does not match qualification root type.");
                this.warning(_builder_4.toString(), func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
            }
        }
        Attribute _output = func.getOutput();
        TypeCall _typeCall_1 = null;
        if (_output != null) {
            _typeCall_1 = _output.getTypeCall();
        }
        RType _typeCallToRType = null;
        if (_typeCall_1 != null) {
            _typeCallToRType = this._typeSystem.typeCallToRType(_typeCall_1);
        }
        boolean bl4 = _notEquals = !Objects.equal((Object)_typeCallToRType, (Object)this._rBuiltinTypeService.BOOLEAN);
        if (_notEquals) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("Qualification functions must output a boolean.");
            this.error(_builder_5.toString(), func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__OUTPUT);
        }
    }

    private Pair<Character, Boolean> checkPathChars(String str) {
        String[] segments;
        for (String segment : segments = str.split("->")) {
            boolean _not;
            boolean _greaterThan;
            int _length = segment.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            boolean _isJavaIdentifierStart = Character.isJavaIdentifierStart(segment.charAt(0));
            boolean bl2 = _not = !_isJavaIdentifierStart;
            if (_not) {
                char _charAt = segment.charAt(0);
                return Pair.of((Object)Character.valueOf(_charAt), (Object)true);
            }
            Functions.Function1 _function = it -> {
                boolean _isJavaIdentifierPart = Character.isJavaIdentifierPart(it.charValue());
                return !_isJavaIdentifierPart;
            };
            Character notValid = (Character)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)segment.toCharArray())), (Functions.Function1)_function);
            if (notValid == null) continue;
            return Pair.of((Object)notValid, (Object)false);
        }
        return null;
    }

    @Check
    public void checkOnlyExistsPathsHaveCommonParent(RosettaOnlyExistsExpression e) {
        RosettaExpression first = (RosettaExpression)IterableExtensions.head(e.getArgs());
        RosettaExpression parent = this.exprHelper.getParentExpression(first);
        for (int i = 1; i < e.getArgs().size(); ++i) {
            RosettaExpression other = (RosettaExpression)e.getArgs().get(i);
            RosettaExpression otherParent = this.exprHelper.getParentExpression(other);
            if (Boolean.valueOf(parent == null) == Boolean.valueOf(otherParent == null) && (parent == null || otherParent == null || EcoreUtil2.equals((EObject)parent, (EObject)otherParent))) continue;
            if (otherParent != null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only exists paths must have a common parent.");
                this.error(_builder.toString(), otherParent, null);
                continue;
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Only exists paths must have a common parent.");
            this.error(_builder_1.toString(), other, null);
        }
    }

    @Check
    public void checkUnaryOperation(RosettaUnaryOperation e) {
        RosettaExpression receiver = e.getArgument();
        if (e instanceof ListOperation && this._rosettaExtensions.isResolved(receiver) && !this.cardinality.isMulti(receiver)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("List ");
            String _operator = e.getOperator();
            _builder.append(_operator);
            _builder.append(" operation cannot be used for single cardinality expressions.");
            this.warning(_builder.toString(), e, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
        if (!(e instanceof CanHandleListOfLists) && receiver != null && this.cardinality.isOutputListOfLists(receiver)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("List must be flattened before ");
            String _operator_1 = e.getOperator();
            _builder_1.append(_operator_1);
            _builder_1.append(" operation.");
            this.error(_builder_1.toString(), e, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkInlineFunction(InlineFunction f) {
        boolean _tripleEquals;
        RosettaExpression _body = f.getBody();
        boolean bl = _tripleEquals = _body == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Missing function body.");
            this.error(_builder.toString(), f, null);
        }
    }

    @Check
    public void checkMandatoryFunctionalOperation(MandatoryFunctionalOperation e) {
        this.checkBodyExists(e);
    }

    @Check
    public void checkUnaryFunctionalOperation(UnaryFunctionalOperation e) {
        this.checkOptionalNamedParameter(e.getFunction());
    }

    @Check
    public void checkFilterOperation(FilterOperation o) {
        this.checkBodyType(o.getFunction(), this._rBuiltinTypeService.BOOLEAN);
        this.checkBodyIsSingleCardinality(o.getFunction());
    }

    @Check
    public void checkMapOperation(MapOperation o) {
        boolean _isOutputListOfListOfLists = this.cardinality.isOutputListOfListOfLists(o);
        if (_isOutputListOfListOfLists) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Each list item is already a list, mapping the item into a list of lists is not allowed. List map item expression must maintain existing cardinality (e.g. list to list), or reduce to single cardinality (e.g. list to single using expression such as count, sum etc).");
            this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FUNCTIONAL_OPERATION__FUNCTION);
        }
    }

    @Check
    public void checkFlattenOperation(FlattenOperation o) {
        boolean _not;
        boolean _isOutputListOfLists = this.cardinality.isOutputListOfLists(o.getArgument());
        boolean bl = _not = !_isOutputListOfLists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("List flatten only allowed for list of lists.");
            this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkReduceOperation(ReduceOperation o) {
        boolean _notEquals;
        this.checkNumberOfMandatoryNamedParameters(o.getFunction(), 2);
        RType _rType = this._rosettaTypeProvider.getRType(o.getArgument());
        RType _rType_1 = this._rosettaTypeProvider.getRType(o.getFunction().getBody());
        boolean bl = _notEquals = !Objects.equal((Object)_rType, (Object)_rType_1);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("List reduce expression must evaluate to the same type as the input. Found types ");
            RType _rType_2 = this._rosettaTypeProvider.getRType(o.getArgument());
            _builder.append((Object)_rType_2);
            _builder.append(" and ");
            RType _rType_3 = this._rosettaTypeProvider.getRType(o.getFunction().getBody());
            _builder.append((Object)_rType_3);
            _builder.append(".");
            this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FUNCTIONAL_OPERATION__FUNCTION);
        }
        this.checkBodyIsSingleCardinality(o.getFunction());
    }

    @Check
    public void checkNumberReducerOperation(SumOperation o) {
        this.checkInputType(o, this._rBuiltinTypeService.UNCONSTRAINED_NUMBER);
    }

    @Check
    public void checkComparingFunctionalOperation(ComparingFunctionalOperation o) {
        boolean _tripleEquals;
        this.checkBodyIsSingleCardinality(o.getFunction());
        this.checkBodyIsComparable(o);
        InlineFunction _function = o.getFunction();
        boolean bl = _tripleEquals = _function == null;
        if (_tripleEquals) {
            this.checkInputIsComparable(o);
        }
    }

    @Check
    public void checkAsKeyOperation(AsKeyOperation o) {
        EObject container = o.eContainer();
        if (container instanceof Operation) {
            Attribute attr;
            boolean _hasReferenceAnnotation;
            boolean _not;
            boolean _tripleEquals;
            Segment _path = ((Operation)container).getPath();
            boolean bl = _tripleEquals = _path == null;
            if (_tripleEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'");
                String _operator = o.getOperator();
                _builder.append(_operator);
                _builder.append("' can only be used when assigning an attribute. Example: \"set out -> attribute: value as-key\"");
                this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
                return;
            }
            EList<Segment> segments = ((Operation)container).getPath().asSegmentList(((Operation)container).getPath());
            Segment _last = null;
            if (segments != null) {
                _last = (Segment)IterableExtensions.last(segments);
            }
            Attribute _attribute = null;
            if (_last != null) {
                _attribute = _last.getAttribute();
            }
            boolean bl2 = _not = !(_hasReferenceAnnotation = this._rosettaExtensions.hasReferenceAnnotation(attr = _attribute));
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("'");
                String _operator_1 = o.getOperator();
                _builder_1.append(_operator_1);
                _builder_1.append("' can only be used with attributes annotated with [metadata reference] annotation.");
                this.error(_builder_1.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        } else if (container instanceof ConstructorKeyValuePair) {
            RosettaFeature attr_1 = ((ConstructorKeyValuePair)container).getKey();
            if (!(attr_1 instanceof Attribute) || !this._rosettaExtensions.hasReferenceAnnotation((Attribute)attr_1)) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("'");
                String _operator_2 = o.getOperator();
                _builder_2.append(_operator_2);
                _builder_2.append("' can only be used with attributes annotated with [metadata reference] annotation.");
                this.error(_builder_2.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        } else {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("'");
            String _operator_3 = o.getOperator();
            _builder_3.append(_operator_3);
            _builder_3.append("' may only be used in context of an attribute.\"");
            this.error(_builder_3.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkImport(RosettaModel model) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> this._rosettaExtensions.isResolved((EObject)it_1);
            return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.eCrossReferences(), RosettaRootElement.class), (Functions.Function1)_function_1).iterator();
        };
        Functions.Function1 _function_1 = it -> this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it);
        List usedNames = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.flatMap((Iterator)model.eAllContents(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        EList<Import> _imports = model.getImports();
        for (Import ns : _imports) {
            boolean isUsed;
            String _importedNamespace = ns.getImportedNamespace();
            boolean _tripleNotEquals = _importedNamespace != null;
            if (!_tripleNotEquals) continue;
            QualifiedName qn = QualifiedName.create((String[])ns.getImportedNamespace().split("\\."));
            boolean _xifexpression = false;
            boolean _equals = qn.getLastSegment().equals("*");
            if (_equals) {
                Predicate<QualifiedName> _function_2 = it -> it.startsWith(qn.skipLast(1)) && it.getSegmentCount() == qn.getSegmentCount();
                _xifexpression = usedNames.stream().anyMatch(_function_2);
            } else {
                _xifexpression = usedNames.contains(qn);
            }
            if (isUsed = _xifexpression) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unused import ");
            String _importedNamespace_1 = ns.getImportedNamespace();
            _builder.append(_importedNamespace_1);
            this.warning(_builder.toString(), ns, (EStructuralFeature)RosettaPackage.Literals.IMPORT__IMPORTED_NAMESPACE, "RosettaIssueCodes.unusedImport", new String[0]);
        }
    }

    private void checkBodyExists(RosettaFunctionalOperation operation) {
        boolean _tripleEquals;
        InlineFunction _function = operation.getFunction();
        boolean bl = _tripleEquals = _function == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Missing an expression.");
            this.error(_builder.toString(), operation, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkOptionalNamedParameter(InlineFunction ref) {
        if (ref != null && ref.getParameters() != null && ref.getParameters().size() != 0 && ref.getParameters().size() != 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Function must have 1 named parameter.");
            this.error(_builder.toString(), ref, (EStructuralFeature)ExpressionPackage.Literals.INLINE_FUNCTION__PARAMETERS);
        }
    }

    private void checkNumberOfMandatoryNamedParameters(InlineFunction ref, int max) {
        if (ref != null && ref.getParameters() == null || ref.getParameters().size() != max) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Function must have ");
            _builder.append((Object)max);
            _builder.append(" named parameter");
            if (max > 1) {
                _builder.append("s");
            }
            _builder.append(".");
            this.error(_builder.toString(), ref, (EStructuralFeature)ExpressionPackage.Literals.INLINE_FUNCTION__PARAMETERS);
        }
    }

    private void checkInputType(RosettaUnaryOperation o, RType type) {
        boolean _not;
        boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(this._rosettaTypeProvider.getRType(o.getArgument()), type);
        boolean bl = _not = !_isSubtypeOf;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Input type must be a ");
            _builder.append((Object)type);
            _builder.append(".");
            this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkInputIsComparable(RosettaUnaryOperation o) {
        boolean _not;
        RType inputRType = this._rosettaTypeProvider.getRType(o.getArgument());
        boolean _hasNaturalOrder = inputRType.hasNaturalOrder();
        boolean bl = _not = !_hasNaturalOrder;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Operation ");
            String _operator = o.getOperator();
            _builder.append(_operator);
            _builder.append(" only supports comparable types (string, int, string, date). Found type ");
            String _name = inputRType.getName();
            _builder.append(_name);
            _builder.append(".");
            this.error(_builder.toString(), o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkBodyIsSingleCardinality(InlineFunction ref) {
        if (ref != null && this.cardinality.isBodyExpressionMulti(ref)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Operation only supports single cardinality expressions.");
            this.error(_builder.toString(), ref, null);
        }
    }

    private void checkBodyType(InlineFunction ref, RType type) {
        RosettaExpression _body = null;
        if (ref != null) {
            _body = ref.getBody();
        }
        RType _rType = null;
        if (_body != null) {
            _rType = this._rosettaTypeProvider.getRType(_body);
        }
        RType bodyType = _rType;
        if (ref != null && bodyType != null && !Objects.equal((Object)bodyType, (Object)this._rBuiltinTypeService.MISSING) && !Objects.equal((Object)bodyType, (Object)type)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Expression must evaluate to a ");
            String _name = type.getName();
            _builder.append(_name);
            _builder.append(".");
            this.error(_builder.toString(), ref, null);
        }
    }

    private void checkBodyIsComparable(RosettaFunctionalOperation op) {
        InlineFunction ref = op.getFunction();
        if (ref != null) {
            boolean _not;
            RType bodyRType = this._rosettaTypeProvider.getRType(ref.getBody());
            boolean _hasNaturalOrder = bodyRType.hasNaturalOrder();
            boolean bl = _not = !_hasNaturalOrder;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Operation ");
                String _operator = op.getOperator();
                _builder.append(_operator);
                _builder.append(" only supports comparable types (string, int, string, date). Found type ");
                String _name = bodyRType.getName();
                _builder.append(_name);
                _builder.append(".");
                this.error(_builder.toString(), ref, null);
            }
        }
    }

    @Check
    public void checkOutputOperation(Operation o) {
        RosettaExpression expr;
        RosettaExpression _expression = null;
        if (o != null) {
            _expression = o.getExpression();
        }
        if ((expr = _expression) != null && this.cardinality.isOutputListOfLists(expr)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Assign expression contains a list of lists, use flatten to create a list.");
            this.error(_builder.toString(), o, (EStructuralFeature)SimplePackage.Literals.OPERATION__EXPRESSION);
        }
        AssignPathRoot _xifexpression = null;
        Segment _path = o.getPath();
        boolean _tripleNotEquals = _path != null;
        _xifexpression = _tripleNotEquals ? ((Segment)IterableExtensions.last(o.pathAsSegmentList())).getAttribute() : o.getAssignRoot();
        boolean isList = this.cardinality.isSymbolMulti(_xifexpression);
        if (o.isAdd() && !isList) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Add must be used with a list.");
            this.error(_builder_1.toString(), o, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
        if (!o.isAdd() && isList) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Set used with a list. Any existing list items will be overwritten.  Use Add to append items to existing list.");
            this.info(_builder_2.toString(), o, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
        if (!isList && this.cardinality.isMulti(o.getExpression())) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Cardinality mismatch - cannot assign list to a single value.");
            this.error(_builder_3.toString(), o, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
    }

    @Check
    public void checkAlias(ShortcutDeclaration o) {
        RosettaExpression expr;
        RosettaExpression _expression = null;
        if (o != null) {
            _expression = o.getExpression();
        }
        if ((expr = _expression) != null && this.cardinality.isOutputListOfLists(expr)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Alias expression contains a list of lists, use flatten to create a list.");
            this.error(_builder.toString(), o, (EStructuralFeature)SimplePackage.Literals.SHORTCUT_DECLARATION__EXPRESSION);
        }
    }

    protected static class RosettaMethodWrapper
    extends AbstractDeclarativeValidator.MethodWrapper {
        protected RosettaMethodWrapper(AbstractDeclarativeValidator instance, Method m) {
            super(instance, m);
        }

        public void invoke(AbstractDeclarativeValidator.State state) {
            try {
                super.invoke(state);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    String _name = this.getMethod().getName();
                    String message = "Unexpected validation failure running " + _name;
                    log.error(message, (Throwable)e);
                    state.hasErrors = true;
                    state.chain.add(this.createDiagnostic(message, state));
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        public Diagnostic createDiagnostic(String message, AbstractDeclarativeValidator.State state) {
            return new FeatureBasedDiagnostic(4, message, state.currentObject, null, -1, state.currentCheckType, null, null);
        }
    }

    private static class CollectRuleErrorVisitor
    implements ExternalAnnotationUtil.CollectRuleVisitor {
        private final Map<RosettaFeature, RosettaRuleReference> ruleMap = CollectionLiterals.newHashMap();
        private final Map<RosettaExternalRegularAttribute, String> errorMap = CollectionLiterals.newHashMap();
        private final Set<Data> collectedTypes = CollectionLiterals.newHashSet();

        private CollectRuleErrorVisitor() {
        }

        @Override
        public void add(RosettaFeature attr, RosettaRuleReference rule) {
            this.ruleMap.put(attr, rule);
        }

        @Override
        public void add(RosettaExternalRegularAttribute extAttr, RosettaRuleReference rule) {
            boolean _not;
            RosettaFeature attr = extAttr.getAttributeRef();
            boolean _containsKey = this.ruleMap.containsKey(attr);
            boolean bl = _not = !_containsKey;
            if (_not) {
                this.ruleMap.put(attr, rule);
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("There is already a mapping defined for `");
                String _name = attr.getName();
                _builder.append(_name);
                _builder.append("`. Try removing the mapping first with `- ");
                String _name_1 = attr.getName();
                _builder.append(_name_1);
                _builder.append("`.");
                this.errorMap.put(extAttr, _builder.toString());
            }
        }

        @Override
        public void remove(RosettaExternalRegularAttribute extAttr) {
            RosettaFeature attr = extAttr.getAttributeRef();
            boolean _containsKey = this.ruleMap.containsKey(attr);
            if (_containsKey) {
                this.ruleMap.remove(attr);
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("You cannot remove this mapping because `");
                String _name = attr.getName();
                _builder.append(_name);
                _builder.append("` did not have a mapping defined before.");
                this.errorMap.put(extAttr, _builder.toString());
            }
        }
    }
}

