/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.typing.validation.RosettaTypingCheckingValidator;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class StandaloneRosettaTypingValidator
extends RosettaTypingCheckingValidator {
    @Inject
    private TypeSystem ts;
    @Inject
    private TypeFactory tf;
    @Inject
    private TypeValidationUtil tu;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private ExternalAnnotationUtil annotationUtil;

    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/Rosetta"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaSimple"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaExpression"));
        return result;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkOnlyElement(RosettaOnlyElement e) {
        RosettaCardinality minimalConstraint;
        RListType t = this.ts.inferType(e.getArgument());
        if (t != null && !(minimalConstraint = this.tf.createConstraint(1, 2)).isSubconstraintOf(t.getConstraint())) {
            this.warning(this.tu.notLooserConstraintMessage(minimalConstraint, t), e, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
        }
    }

    @Check
    public void checkChoiceOperationHasNoDuplicateAttributes(ChoiceOperation e) {
        for (int i = 1; i < e.getAttributes().size(); ++i) {
            Attribute attr = (Attribute)e.getAttributes().get(i);
            for (int j = 0; j < i; ++j) {
                if (!attr.equals(e.getAttributes().get(j))) continue;
                this.error("Duplicate attribute.", e, (EStructuralFeature)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES, i);
            }
        }
    }

    @Check
    public void checkReport(RosettaReport report) {
        RType inputType = this.ts.typeCallToRType(report.getInputType());
        EList<RosettaRule> eligibilityRules = report.getEligibilityRules();
        for (int i = 0; i < eligibilityRules.size(); ++i) {
            RType ruleInputType;
            RosettaRule eligibilityRule = (RosettaRule)eligibilityRules.get(i);
            if (!eligibilityRule.isEligibility()) {
                this.error("Rule " + eligibilityRule.getName() + " is not an eligibility rule.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
            }
            if (this.ts.isSubtypeOf(ruleInputType = this.ts.typeCallToRType(eligibilityRule.getInput()), inputType)) continue;
            this.error("Eligibility rule " + eligibilityRule.getName() + " expects a `" + ruleInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
        }
        RType reportTypeInputType = this.ts.getRulesInputType(report.getReportType(), Optional.ofNullable(report.getRuleSource()));
        if (reportTypeInputType != this.builtins.ANY && !this.ts.isSubtypeOf(reportTypeInputType, inputType)) {
            if (report.getRuleSource() != null) {
                this.error("Rule source " + report.getRuleSource().getName() + " expects a `" + reportTypeInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__RULE_SOURCE);
            } else {
                this.error("Report type " + report.getReportType().getName() + " expects a `" + reportTypeInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__REPORT_TYPE);
            }
        }
    }

    @Check
    public void checkReportType(Data data) {
        RType current;
        if (data.getSuperType() != null) {
            current = this.ts.getRulesInputType(data.getSuperType(), Optional.empty());
            if (current.equals(this.builtins.NOTHING)) {
                return;
            }
        } else {
            current = this.builtins.ANY;
        }
        for (Attribute attr : data.getAttributes()) {
            Data attrData;
            RType inputType;
            RosettaRuleReference ref = attr.getRuleReference();
            if (ref != null) {
                RosettaRule rule = ref.getReportingRule();
                RType inputType2 = this.ts.typeCallToRType(rule.getInput());
                RType newCurrent = this.ts.meet(current, inputType2);
                if (newCurrent.equals(this.builtins.NOTHING)) {
                    this.error("Rule `" + rule.getName() + "` expects an input of type `" + inputType2 + "`, while previous rules expect an input of type `" + current + "`.", ref, (EStructuralFeature)SimplePackage.Literals.ROSETTA_RULE_REFERENCE__REPORTING_RULE);
                    continue;
                }
                current = newCurrent;
                continue;
            }
            RType attrType = this.ts.stripFromTypeAliases(this.ts.typeCallToRType(attr.getTypeCall()));
            if (!(attrType instanceof RDataType) || (inputType = this.ts.getRulesInputType(attrData = ((RDataType)attrType).getData(), Optional.empty())).equals(this.builtins.NOTHING)) continue;
            RType newCurrent = this.ts.meet(current, inputType);
            if (newCurrent.equals(this.builtins.NOTHING)) {
                this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while previous rules expect an input of type `" + current + "`.", attr, null);
                continue;
            }
            current = newCurrent;
        }
    }

    @Check
    public void checkExternalRuleSource(RosettaExternalRuleSource source) {
        for (RosettaExternalClass externalClass : source.getExternalClasses()) {
            Data data = externalClass.getData();
            Map<RosettaFeature, RosettaRuleReference> ruleReferences = this.annotationUtil.getAllRuleReferencesForType(Optional.of(source), data);
            RType current = this.builtins.ANY;
            for (Attribute attr : data.getAttributes()) {
                Data attrData;
                RType inputType;
                Optional<RosettaExternalRegularAttribute> maybeExtAttr = externalClass.getRegularAttributes().stream().filter(ext -> ext.getOperator() == ExternalValueOperator.PLUS).filter(ext -> ext.getAttributeRef().equals(attr)).findAny();
                RosettaRuleReference ref = ruleReferences.get(attr);
                if (ref != null) {
                    RosettaRule rule = ref.getReportingRule();
                    RType inputType2 = this.ts.typeCallToRType(rule.getInput());
                    RType newCurrent = this.ts.meet(current, inputType2);
                    if (newCurrent.equals(this.builtins.NOTHING)) {
                        if (!maybeExtAttr.isPresent()) continue;
                        RosettaExternalRegularAttribute extAttr = maybeExtAttr.get();
                        this.error("Attribute `" + attr.getName() + "` has a rule that expects an input of type `" + inputType2 + "`, while other rules expect an input of type `" + current + "`.", extAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF);
                        continue;
                    }
                    current = newCurrent;
                    continue;
                }
                RType attrType = this.ts.stripFromTypeAliases(this.ts.typeCallToRType(attr.getTypeCall()));
                if (!(attrType instanceof RDataType) || (inputType = this.ts.getRulesInputType(attrData = ((RDataType)attrType).getData(), Optional.of(source))).equals(this.builtins.NOTHING)) continue;
                RType newCurrent = this.ts.meet(current, inputType);
                if (newCurrent.equals(this.builtins.NOTHING)) {
                    if (maybeExtAttr.isPresent()) {
                        RosettaExternalRegularAttribute extAttr = maybeExtAttr.get();
                        this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while other rules expect an input of type `" + current + "`.", extAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF);
                        continue;
                    }
                    this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while other rules expect an input of type `" + current + "`.", externalClass, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_CLASS__DATA);
                    continue;
                }
                current = newCurrent;
            }
        }
    }
}

