/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.derivedstate;

import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.HasGeneratedInput;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import jakarta.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;

public class RosettaDerivedStateComputer
implements IDerivedStateComputer {
    @Inject
    ImplicitVariableUtil implicitVariableUtil;

    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            this.setAllDerivedState((TreeIterator<EObject>)resource.getAllContents());
        }
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        this.removeAllDerivedState((TreeIterator<EObject>)resource.getAllContents());
    }

    public void setDerivedState(EObject obj) {
        if (obj instanceof RosettaConditionalExpression) {
            this.setDefaultElseToEmpty((RosettaConditionalExpression)obj);
        } else if (obj instanceof JoinOperation) {
            this.setDefaultJoinSeparator((JoinOperation)obj);
        } else if (obj instanceof RosettaSymbolReference) {
            this.setImplicitVariableInContextOfSymbolReference((RosettaSymbolReference)obj);
        }
        if (obj instanceof HasGeneratedInput) {
            this.setDefaultInput((HasGeneratedInput)obj);
        }
    }

    public void setAllDerivedState(TreeIterator<EObject> tree) {
        tree.forEachRemaining(obj -> this.setDerivedState((EObject)obj));
    }

    public void setAllDerivedState(EObject root) {
        this.setAllDerivedState((TreeIterator<EObject>)root.eAllContents());
    }

    public void removeDerivedState(EObject obj) {
        if (obj instanceof RosettaConditionalExpression) {
            this.discardDefaultElse((RosettaConditionalExpression)obj);
        } else if (obj instanceof JoinOperation) {
            this.discardDefaultJoinSeparator((JoinOperation)obj);
        } else if (obj instanceof RosettaSymbolReference) {
            this.discardImplicitVariableInContextOfSymbolReference((RosettaSymbolReference)obj);
        }
        if (obj instanceof HasGeneratedInput) {
            this.discardDefaultInput((HasGeneratedInput)obj);
        }
    }

    public void removeAllDerivedState(TreeIterator<EObject> tree) {
        tree.forEachRemaining(obj -> this.removeDerivedState((EObject)obj));
    }

    public void removeAllDerivedState(EObject root) {
        this.removeAllDerivedState((TreeIterator<EObject>)root.eAllContents());
    }

    private void setDefaultInput(HasGeneratedInput expr) {
        if (expr.needsGeneratedInput() && this.implicitVariableUtil.implicitVariableExistsInContext(expr)) {
            expr.setGeneratedInputIfAbsent(this.implicitVariableUtil.getDefaultImplicitVariable());
        }
    }

    private void discardDefaultInput(HasGeneratedInput expr) {
        expr.setGeneratedInputIfAbsent(null);
    }

    private void setDefaultElseToEmpty(RosettaConditionalExpression expr) {
        if (!expr.isFull()) {
            ListLiteral lit = ExpressionFactory.eINSTANCE.createListLiteral();
            lit.setGenerated(true);
            expr.setElsethen(lit);
        }
    }

    private void discardDefaultElse(RosettaConditionalExpression expr) {
        if (!expr.isFull()) {
            expr.setElsethen(null);
        }
    }

    private void setDefaultJoinSeparator(JoinOperation expr) {
        if (expr.getRight() == null) {
            RosettaStringLiteral lit = ExpressionFactory.eINSTANCE.createRosettaStringLiteral();
            lit.setGenerated(true);
            lit.setValue("");
            expr.setRight(lit);
            expr.setExplicitSeparator(false);
        } else {
            expr.setExplicitSeparator(true);
        }
    }

    private void discardDefaultJoinSeparator(JoinOperation expr) {
        if (!expr.isExplicitSeparator() && expr.getRight() != null && expr.getRight().isGenerated()) {
            expr.setRight(null);
        }
    }

    private void setImplicitVariableInContextOfSymbolReference(RosettaSymbolReference expr) {
        if (this.implicitVariableUtil.implicitVariableExistsInContext(expr)) {
            expr.setImplicitVariableIsInContext(true);
        }
    }

    private void discardImplicitVariableInContextOfSymbolReference(RosettaSymbolReference expr) {
        if (expr.isImplicitVariableIsInContext()) {
            expr.setImplicitVariableIsInContext(false);
            expr.setImplicitArgument(null);
        }
    }
}

