/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.condition;

import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.ImplicitVariableRepresentation;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.expression.ExpressionGenerator;
import com.regnosys.rosetta.generator.java.expression.JavaDependencyProvider;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.types.JavaConditionInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.java.util.RosettaGrammarUtil;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ConditionGenerator {
    @Inject
    private ExpressionGenerator expressionHandler;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    private JavaDependencyProvider dependencies;
    @Inject
    @Extension
    private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private ModelGeneratorUtil _modelGeneratorUtil;

    public void generate(IFileSystemAccess2 fsa, Condition ele, String version) {
        JavaConditionInterface clazz = this._javaTypeTranslator.toConditionJavaClass(ele);
        DottedPath _packageName = clazz.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        StringConcatenationClient classBody = this.conditionClassBody(ele, clazz, topScope, version);
        String content = this._importManagerExtension.buildClass(clazz.getPackageName(), classBody, topScope);
        StringConcatenation _builder = new StringConcatenation();
        String _withForwardSlashes = clazz.getCanonicalName().withForwardSlashes();
        _builder.append(_withForwardSlashes);
        _builder.append(".java");
        fsa.generateFile(_builder.toString(), (CharSequence)content);
    }

    private StringConcatenationClient conditionClassBody(final Condition condition, final JavaConditionInterface conditionClass, JavaScope scope, final String version) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final String definition = RosettaGrammarUtil.quote(RosettaGrammarUtil.extractNodeText(condition, (EStructuralFeature)SimplePackage.Literals.CONDITION__EXPRESSION));
        final List<JavaClass<?>> deps = this.dependencies.javaDependencies(condition.getExpression());
        final ImplicitVariableRepresentation implicitVarRepr = this._javaIdentifierRepresentationService.getImplicitVarInContext(condition.getExpression());
        Functions.Function1 _function = entry -> {
            RosettaTypeWithConditions _enclosingType = condition.getEnclosingType();
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                String _key = (String)entry.getKey();
                return Objects.equals(_name, _key);
            };
            return (TypeParameter)IterableExtensions.findFirst(((ParametrizedRosettaType)((Object)_enclosingType)).getParameters(), (Functions.Function1)_function_1);
        };
        Functions.Function1 _function_1 = entry -> (JavaType)entry.getValue();
        final Map params = IterableExtensions.toMap(conditionClass.getParameters().entrySet(), (Functions.Function1)_function, (Functions.Function1)_function_1);
        JavaScope classScope = scope.classScope(conditionClass.getSimpleName());
        final JavaScope validateScope = classScope.methodScope("validate");
        final GeneratedIdentifier pathId = validateScope.createUniqueIdentifier("path");
        final GeneratedIdentifier instanceId = validateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower((String)conditionClass.getInstanceType().getName()));
        BiConsumer<TypeParameter, JavaType> _function_2 = (param, type) -> validateScope.createIdentifier((RosettaNamed)param);
        params.forEach(_function_2);
        final JavaScope defaultClassScope = classScope.classScope("Default");
        final GeneratedIdentifier defaultClassName = defaultClassScope.createUniqueIdentifier("Default");
        Consumer<JavaClass> _function_3 = it -> defaultClassScope.createIdentifier(this._javaIdentifierRepresentationService.toDependencyInstance((JavaClass<?>)it), StringExtensions.toFirstLower((String)it.getSimpleName()));
        deps.forEach(_function_3);
        final JavaScope defaultClassValidateScope = defaultClassScope.methodScope("validate");
        final GeneratedIdentifier defaultClassPathId = defaultClassValidateScope.createUniqueIdentifier("path");
        final GeneratedIdentifier defaultClassInstanceId = defaultClassValidateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower((String)conditionClass.getInstanceType().getName()));
        BiConsumer<TypeParameter, JavaType> _function_4 = (param, type) -> defaultClassValidateScope.createIdentifier((RosettaNamed)param);
        params.forEach(_function_4);
        final GeneratedIdentifier defaultClassResultId = defaultClassValidateScope.createUniqueIdentifier("result");
        final GeneratedIdentifier defaultClassFailureMessageId = defaultClassValidateScope.createUniqueIdentifier("failureMessage");
        final JavaScope defaultClassExecuteScope = defaultClassScope.methodScope("execute");
        final GeneratedIdentifier defaultClassExecuteInstanceId = defaultClassExecuteScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower((String)conditionClass.getInstanceType().getName()));
        BiConsumer<TypeParameter, JavaType> _function_5 = (param, type) -> defaultClassExecuteScope.createIdentifier((RosettaNamed)param);
        params.forEach(_function_5);
        final GeneratedIdentifier defaultClassExecuteExceptionId = defaultClassExecuteScope.createUniqueIdentifier("ex");
        JavaScope noOpClassScope = classScope.classScope("NoOp");
        final GeneratedIdentifier noOpClassName = noOpClassScope.createUniqueIdentifier("NoOp");
        final JavaScope noOpClassValidateScope = noOpClassScope.methodScope("validate");
        final GeneratedIdentifier noOpClassPathId = noOpClassValidateScope.createUniqueIdentifier("path");
        final GeneratedIdentifier noOpInstanceId = noOpClassValidateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower((String)conditionClass.getInstanceType().getName()));
        BiConsumer<TypeParameter, JavaType> _function_6 = (param, type) -> noOpClassValidateScope.createIdentifier((RosettaNamed)param);
        params.forEach(_function_6);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                CharSequence _emptyJavadocWithVersion = ConditionGenerator.this._modelGeneratorUtil.emptyJavadocWithVersion(version);
                _builder.append((Object)_emptyJavadocWithVersion);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RosettaDataRule.class);
                _builder.append((Object)"(\"");
                String _simpleName = conditionClass.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(ImplementedBy.class);
                _builder.append((Object)"(");
                _builder.append((Object)conditionClass);
                _builder.append((Object)".Default.class)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public interface ");
                _builder.append((Object)conditionClass);
                boolean _implementsValidatorInterface = conditionClass.implementsValidatorInterface();
                if (_implementsValidatorInterface) {
                    _builder.append((Object)" extends ");
                    JavaParameterizedType<Validator<?>> _validatorInterface = conditionClass.getValidatorInterface();
                    _builder.append(_validatorInterface);
                }
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"String NAME = \"");
                String _simpleName_1 = conditionClass.getSimpleName();
                _builder.append((Object)_simpleName_1, "\t");
                _builder.append((Object)"\";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"String DEFINITION = ");
                _builder.append((Object)definition, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                boolean _implementsValidatorInterface_1 = conditionClass.implementsValidatorInterface();
                boolean bl = _not = !_implementsValidatorInterface_1;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(ValidationResult.class, "\t");
                    _builder.append((Object)"<?>> getValidationResults(");
                    _builder.append(RosettaPath.class, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)pathId, "\t");
                    _builder.append((Object)", ");
                    JavaReferenceType _instanceClass = conditionClass.getInstanceClass();
                    _builder.append((Object)_instanceClass, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)instanceId, "\t");
                    Set _keySet = params.keySet();
                    for (TypeParameter param : _keySet) {
                        _builder.append((Object)", ");
                        JavaType _get = (JavaType)params.get(param);
                        _builder.append((Object)_get, "\t");
                        _builder.append((Object)" ");
                        GeneratedIdentifier _identifierOrThrow = validateScope.getIdentifierOrThrow(param);
                        _builder.append((Object)_identifierOrThrow, "\t");
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"class ");
                _builder.append((Object)defaultClassName, "\t");
                _builder.append((Object)" implements ");
                _builder.append((Object)conditionClass, "\t");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                for (JavaClass dep : deps) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"@");
                    _builder.append(javax.inject.Inject.class, "\t\t");
                    _builder.append((Object)" protected ");
                    _builder.append((Object)dep, "\t\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_1 = defaultClassScope.getIdentifierOrThrow(ConditionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dep));
                    _builder.append((Object)_identifierOrThrow_1, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)defaultClassPathId, "\t\t");
                _builder.append((Object)", ");
                JavaReferenceType _instanceClass_1 = conditionClass.getInstanceClass();
                _builder.append((Object)_instanceClass_1, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)defaultClassInstanceId, "\t\t");
                Set _keySet_1 = params.keySet();
                for (Object param_1 : _keySet_1) {
                    _builder.append((Object)", ");
                    JavaType _get_1 = (JavaType)params.get(param_1);
                    _builder.append((Object)_get_1, "\t\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_2 = defaultClassValidateScope.getIdentifierOrThrow(param_1);
                    _builder.append((Object)_identifierOrThrow_2, "\t\t");
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append(ComparisonResult.class, "\t\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)defaultClassResultId, "\t\t\t");
                _builder.append((Object)" = executeDataRule(");
                GeneratedIdentifier _identifierOrThrow_3 = defaultClassValidateScope.getIdentifierOrThrow(implicitVarRepr);
                _builder.append((Object)_identifierOrThrow_3, "\t\t\t");
                Set _keySet_2 = params.keySet();
                for (TypeParameter param_2 : _keySet_2) {
                    _builder.append((Object)", ");
                    GeneratedIdentifier _identifierOrThrow_4 = defaultClassValidateScope.getIdentifierOrThrow(param_2);
                    _builder.append((Object)_identifierOrThrow_4, "\t\t\t");
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (result.get()) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                _builder.append(Arrays.class, "\t\t\t\t");
                _builder.append((Object)".asList(");
                _builder.append(ValidationResult.class, "\t\t\t\t");
                _builder.append((Object)".success(NAME, ValidationResult.ValidationType.DATA_RULE, \"");
                String _name = conditionClass.getInstanceType().getName();
                _builder.append((Object)_name, "\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append((Object)defaultClassPathId, "\t\t\t\t");
                _builder.append((Object)", DEFINITION));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"String ");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t");
                _builder.append((Object)" = ");
                _builder.append((Object)defaultClassResultId, "\t\t\t");
                _builder.append((Object)".getError();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t");
                _builder.append((Object)" == null || ");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t");
                _builder.append((Object)".contains(\"Null\") || ");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t");
                _builder.append((Object)" == \"\") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t\t");
                _builder.append((Object)" = \"Condition has failed.\";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                _builder.append(Arrays.class, "\t\t\t");
                _builder.append((Object)".asList(");
                _builder.append(ValidationResult.class, "\t\t\t");
                _builder.append((Object)".failure(NAME, ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".DATA_RULE, \"");
                String _name_1 = conditionClass.getInstanceType().getName();
                _builder.append((Object)_name_1, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append((Object)defaultClassPathId, "\t\t\t");
                _builder.append((Object)", DEFINITION, ");
                _builder.append((Object)defaultClassFailureMessageId, "\t\t\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"private ");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)" executeDataRule(");
                JavaReferenceType _instanceClass_2 = conditionClass.getInstanceClass();
                _builder.append((Object)_instanceClass_2, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)defaultClassExecuteInstanceId, "\t\t");
                Set _keySet_3 = params.keySet();
                for (TypeParameter param_3 : _keySet_3) {
                    _builder.append((Object)", ");
                    JavaType _get_2 = (JavaType)params.get(param_3);
                    _builder.append((Object)_get_2, "\t\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_5 = defaultClassExecuteScope.getIdentifierOrThrow(param_3);
                    _builder.append((Object)_identifierOrThrow_5, "\t\t");
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"try ");
                JavaBlock _block = ConditionGenerator.this.expressionHandler.javaCode(condition.getExpression(), (JavaType)ConditionGenerator.this._javaTypeUtil.COMPARISON_RESULT, defaultClassExecuteScope).completeAsReturn().toBlock();
                _builder.append((Object)_block, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"catch (");
                _builder.append(Exception.class, "\t\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)defaultClassExecuteExceptionId, "\t\t\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                _builder.append(ComparisonResult.class, "\t\t\t\t");
                _builder.append((Object)".failure(");
                _builder.append((Object)defaultClassExecuteExceptionId, "\t\t\t\t");
                _builder.append((Object)".getMessage());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@SuppressWarnings(\"unused\")");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"class ");
                _builder.append((Object)noOpClassName, "\t");
                _builder.append((Object)" implements ");
                _builder.append((Object)conditionClass, "\t");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)noOpClassPathId, "\t\t");
                _builder.append((Object)", ");
                JavaReferenceType _instanceClass_3 = conditionClass.getInstanceClass();
                _builder.append((Object)_instanceClass_3, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)noOpInstanceId, "\t\t");
                Set _keySet_4 = params.keySet();
                for (TypeParameter param_4 : _keySet_4) {
                    _builder.append((Object)", ");
                    JavaType _get_3 = (JavaType)params.get(param_4);
                    _builder.append((Object)_get_3, "\t\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_6 = noOpClassValidateScope.getIdentifierOrThrow(param_4);
                    _builder.append((Object)_identifierOrThrow_6, "\t\t");
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                _builder.append(Collections.class, "\t\t\t");
                _builder.append((Object)".emptyList();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }
}

