/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.expression;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.builder.JavaConditionalExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaIfThenElseBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaLiteral;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TypeCoercionService {
    @Inject
    @Extension
    private JavaTypeUtil typeUtil;

    public JavaStatementBuilder addCoercions(JavaStatementBuilder expr, JavaType expected, JavaScope scope) {
        return this.addCoercions(expr, expected, true, scope);
    }

    public JavaStatementBuilder addCoercions(JavaStatementBuilder expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        if (Objects.equals(this.typeUtil.getItemType(actual), JavaReferenceType.NULL_TYPE) || this.typeUtil.isVoid(this.typeUtil.getItemType(actual))) {
            return this.empty(expected);
        }
        Function<JavaExpression, JavaStatementBuilder> _function = it -> this.addCoercions((JavaExpression)it, expected, throwOnFail, scope);
        _xblockexpression = expr.mapExpression(_function);
        return _xblockexpression;
    }

    public JavaStatementBuilder addCoercions(JavaExpression expr, JavaType expected, JavaScope scope) {
        return this.addCoercions(expr, expected, true, scope);
    }

    public JavaStatementBuilder addCoercions(JavaExpression expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        if (Objects.equals(this.typeUtil.getItemType(actual), JavaReferenceType.NULL_TYPE) || this.typeUtil.isVoid(this.typeUtil.getItemType(actual))) {
            return this.empty(expected);
        }
        boolean _equals = Objects.equals(actual, expected);
        if (_equals) {
            return expr;
        }
        boolean _equals_1 = Objects.equals(actual, JavaPrimitiveType.VOID);
        if (_equals_1) {
            throw new IllegalArgumentException("Cannot coerce from primitive type `void`.");
        }
        JavaStatementBuilder _xifexpression = null;
        if (this.typeUtil.isWrapper(actual) && this.typeUtil.isWrapper(expected)) {
            _xifexpression = this.wrapperToWrapper(expr, expected, throwOnFail, scope);
        } else {
            JavaStatementBuilder _xifexpression_1 = null;
            boolean _isWrapper = this.typeUtil.isWrapper(actual);
            if (_isWrapper) {
                _xifexpression_1 = this.wrapperToItem(expr, expected, throwOnFail, scope);
            } else {
                JavaStatementBuilder _xifexpression_2 = null;
                boolean _isWrapper_1 = this.typeUtil.isWrapper(expected);
                _xifexpression_2 = _isWrapper_1 ? this.itemToWrapper(expr, expected, throwOnFail, scope) : this.itemToItem(expr, expected, throwOnFail, scope);
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JavaStatementBuilder itemToItem(JavaExpression expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        Function<Function, JavaStatementBuilder> _function = itemConversion -> this.convertNullSafe(expr, (Function<JavaExpression, ? extends JavaStatementBuilder>)itemConversion, expected, scope);
        _xblockexpression = this.getItemConversion(actual, expected, throwOnFail, scope).map(_function).orElse(expr);
        return _xblockexpression;
    }

    private JavaStatementBuilder itemToWrapper(JavaExpression expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        JavaType expectedItemType = this.typeUtil.getItemType(expected);
        Function<JavaExpression, JavaExpression> wrapConversion = this.getWrapConversion(expected);
        JavaStatementBuilder _xifexpression = null;
        boolean _extendsMapper = this.typeUtil.extendsMapper(expected);
        if (_extendsMapper) {
            Function<Function, JavaStatementBuilder> _function = itemConversion -> {
                Function<JavaStatementBuilder, JavaStatementBuilder> _function_1 = it -> it.mapExpression(wrapConversion);
                return this.convertNullSafe(expr, itemConversion.andThen(_function_1), expected, scope);
            };
            _xifexpression = this.getItemConversion(actual, expectedItemType, throwOnFail, scope).map(_function).orElse(expr.mapExpression(wrapConversion));
        } else {
            JavaStatementBuilder _xblockexpression_1 = null;
            Function<Function, Function> _function_1 = itemConversion -> {
                Function<JavaStatementBuilder, JavaStatementBuilder> _function_2 = it -> it.mapExpression(wrapConversion);
                Function _andThen = itemConversion.andThen(_function_2);
                return _andThen;
            };
            Function<JavaExpression, JavaExpression> totalConversion = this.getItemConversion(actual, expectedItemType, throwOnFail, scope).map(_function_1).orElse(wrapConversion);
            _xifexpression = _xblockexpression_1 = this.convertNullSafe(expr, totalConversion, expected, scope);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JavaStatementBuilder wrapperToItem(JavaExpression expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        if (this.typeUtil.extendsMapper(actual) && expected instanceof JavaPrimitiveType) {
            Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, expected){
                    final /* synthetic */ JavaExpression val$it;
                    final /* synthetic */ JavaType val$expected;
                    {
                        this.val$it = javaExpression;
                        this.val$expected = javaType;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)".getOrDefault(");
                        JavaExpression _empty = TypeCoercionService.this.empty(this.val$expected);
                        _builder.append((Object)_empty);
                        _builder.append((Object)")");
                    }
                };
                return JavaExpression.from(_client, expected);
            };
            return expr.mapExpression(_function);
        }
        JavaExpression unwrappedExpr = this.getUnwrapConversion(actual).apply(expr);
        _xblockexpression = this.itemToItem(unwrappedExpr, expected, throwOnFail, scope);
        return _xblockexpression;
    }

    private JavaExpression wrapperToWrapper(JavaExpression expr, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaType actual = expr.getExpressionType();
        JavaType expectedItemType = this.typeUtil.getItemType(expected);
        Optional<Function<JavaExpression, JavaExpression>> optionalWrappedItemConversion = this.getWrappedItemConversion(actual, expectedItemType, throwOnFail, scope);
        JavaType _xifexpression = null;
        boolean _isEmpty = optionalWrappedItemConversion.isEmpty();
        _xifexpression = _isEmpty ? actual : this.typeUtil.changeItemType(actual, expectedItemType);
        Optional<Function<JavaExpression, JavaExpression>> optionalWrapperConversion = this.getWrapperConversion(_xifexpression, expected);
        if (optionalWrappedItemConversion.isEmpty() && optionalWrapperConversion.isEmpty()) {
            return expr;
        }
        Function<JavaExpression, JavaExpression> _xifexpression_1 = null;
        boolean _isEmpty_1 = optionalWrappedItemConversion.isEmpty();
        if (_isEmpty_1) {
            _xifexpression_1 = optionalWrapperConversion.orElseThrow();
        } else {
            Function<JavaExpression, JavaExpression> _xifexpression_2 = null;
            boolean _isEmpty_2 = optionalWrapperConversion.isEmpty();
            _xifexpression_2 = _isEmpty_2 ? optionalWrappedItemConversion.orElseThrow() : optionalWrapperConversion.orElseThrow().compose(optionalWrappedItemConversion.orElseThrow());
            _xifexpression_1 = _xifexpression_2;
        }
        Function<JavaExpression, JavaExpression> totalConversion = _xifexpression_1;
        return totalConversion.apply(expr);
    }

    private Optional<Function<JavaExpression, ? extends JavaStatementBuilder>> getItemConversion(JavaType actual, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaReferenceType _referenceType_1;
        boolean _equals = Objects.equals(actual, expected);
        if (_equals) {
            return Optional.empty();
        }
        JavaReferenceType _referenceType = actual.toReferenceType();
        boolean _equals_1 = Objects.equals(_referenceType, _referenceType_1 = expected.toReferenceType());
        if (_equals_1) {
            Function<JavaExpression, JavaExpression> _function = it -> it;
            return Optional.of(_function);
        }
        if (this.typeUtil.extendsNumber((JavaType)actual.toReferenceType()) && this.typeUtil.extendsNumber((JavaType)expected.toReferenceType())) {
            Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> this.getNumberConversionExpression((JavaExpression)it, expected, throwOnFail, scope);
            return Optional.of(_function_1);
        }
        if (actual instanceof RJavaWithMetaValue) {
            Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> this.metaToItemConversionExpression((JavaExpression)it, expected, throwOnFail, scope);
            return Optional.of(_function_2);
        }
        if (expected instanceof RJavaWithMetaValue) {
            Function<JavaExpression, JavaStatementBuilder> _function_3 = it -> this.itemToMetaConversionExpression((JavaExpression)it, (RJavaWithMetaValue)expected, throwOnFail, scope);
            return Optional.of(_function_3);
        }
        if (expected instanceof JavaPojoInterface && expected.isSubtypeOf(actual)) {
            Function<JavaExpression, JavaStatementBuilder> _function_4 = it -> this.downCastConversionExpression((JavaExpression)it, (JavaPojoInterface)expected, throwOnFail, scope);
            return Optional.of(_function_4);
        }
        return Optional.empty();
    }

    private Function<JavaExpression, JavaExpression> getWrapConversion(JavaType wrapperType) {
        Function<JavaExpression, JavaExpression> _xifexpression = null;
        boolean _isList = this.typeUtil.isList(wrapperType);
        if (_isList) {
            Function<JavaExpression, JavaExpression> _function;
            _xifexpression = _function = it -> this.getItemToListConversionExpression((JavaExpression)it);
        } else {
            Function<JavaExpression, JavaExpression> _xifexpression_1 = null;
            if (this.typeUtil.isMapperS(wrapperType) || this.typeUtil.isMapper(wrapperType)) {
                Function<JavaExpression, JavaExpression> _function_1;
                _xifexpression_1 = _function_1 = it -> this.getItemToMapperSConversionExpression((JavaExpression)it);
            } else {
                Function<JavaExpression, JavaExpression> _xifexpression_2 = null;
                boolean _isMapperC = this.typeUtil.isMapperC(wrapperType);
                if (_isMapperC) {
                    Function<JavaExpression, JavaExpression> _function_2;
                    _xifexpression_2 = _function_2 = it -> this.getItemToMapperCConversionExpression((JavaExpression)it);
                } else {
                    Function<JavaExpression, JavaExpression> _function_3;
                    Function<JavaExpression, JavaExpression> _xifexpression_3 = null;
                    boolean _isComparisonResult = this.typeUtil.isComparisonResult(wrapperType);
                    if (!_isComparisonResult) {
                        throw this.unexpectedWrapperException(wrapperType);
                    }
                    _xifexpression_3 = _function_3 = it -> this.getItemToComparisonResultConversionExpression((JavaExpression)it);
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private Function<JavaExpression, JavaExpression> getUnwrapConversion(JavaType wrapperType) {
        Function<JavaExpression, JavaExpression> _xifexpression = null;
        boolean _isList = this.typeUtil.isList(wrapperType);
        if (_isList) {
            Function<JavaExpression, JavaExpression> _function;
            _xifexpression = _function = it -> this.getListToItemConversionExpression((JavaExpression)it);
        } else {
            Function<JavaExpression, JavaExpression> _function_1;
            Function<JavaExpression, JavaExpression> _xifexpression_1 = null;
            boolean _extendsMapper = this.typeUtil.extendsMapper(wrapperType);
            if (!_extendsMapper) {
                throw this.unexpectedWrapperException(wrapperType);
            }
            _xifexpression_1 = _function_1 = it -> this.getMapperToItemConversionExpression((JavaExpression)it);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private Optional<Function<JavaExpression, JavaExpression>> getWrappedItemConversion(JavaType actual, JavaType expectedItemType, boolean throwOnFail, JavaScope scope) {
        Optional<Function<JavaExpression, JavaExpression>> _xblockexpression = null;
        JavaType actualItemType = this.typeUtil.getItemType(actual);
        Function<Function, Function> _function = itemConversion -> {
            Function<JavaExpression, JavaExpression> _xifexpression = null;
            boolean _isList = this.typeUtil.isList(actual);
            if (_isList) {
                Function<JavaExpression, JavaExpression> _function_1;
                _xifexpression = _function_1 = it -> this.getListItemConversionExpression((JavaExpression)it, (Function<JavaExpression, ? extends JavaStatementBuilder>)itemConversion, expectedItemType.toReferenceType(), scope);
            } else {
                Function<JavaExpression, JavaExpression> _xifexpression_1 = null;
                boolean _isMapperS = this.typeUtil.isMapperS(actual);
                if (_isMapperS) {
                    Function<JavaExpression, JavaExpression> _function_2;
                    _xifexpression_1 = _function_2 = it -> this.getMapperSItemConversionExpression((JavaExpression)it, (Function<JavaExpression, ? extends JavaStatementBuilder>)itemConversion, expectedItemType.toReferenceType(), scope);
                } else {
                    Function<JavaExpression, JavaExpression> _xifexpression_2 = null;
                    boolean _isMapperC = this.typeUtil.isMapperC(actual);
                    if (_isMapperC) {
                        Function<JavaExpression, JavaExpression> _function_3;
                        _xifexpression_2 = _function_3 = it -> this.getMapperCItemConversionExpression((JavaExpression)it, (Function<JavaExpression, ? extends JavaStatementBuilder>)itemConversion, expectedItemType.toReferenceType(), scope);
                    } else {
                        Function<JavaExpression, JavaExpression> _function_4;
                        Function<JavaExpression, JavaExpression> _xifexpression_3 = null;
                        boolean _isMapperListOfLists = this.typeUtil.isMapperListOfLists(actual);
                        if (!_isMapperListOfLists) {
                            throw this.unexpectedWrapperException(actual);
                        }
                        _xifexpression_3 = _function_4 = it -> this.getMapperListOfListsItemConversionExpression((JavaExpression)it, (Function<JavaExpression, ? extends JavaStatementBuilder>)itemConversion, expectedItemType.toReferenceType(), scope);
                        _xifexpression_2 = _xifexpression_3;
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        };
        _xblockexpression = this.getItemConversion(actualItemType, expectedItemType, throwOnFail, scope).map(_function);
        return _xblockexpression;
    }

    private Optional<Function<JavaExpression, JavaExpression>> getWrapperConversion(JavaType actual, final JavaType expected) {
        Function<JavaExpression, JavaExpression> _xifexpression = null;
        boolean _isComparisonResult = this.typeUtil.isComparisonResult(actual);
        if (_isComparisonResult) {
            Function<JavaExpression, JavaExpression> _xifexpression_1 = null;
            boolean _isMapperS = this.typeUtil.isMapperS(expected);
            if (_isMapperS) {
                Function<JavaExpression, JavaExpression> _function;
                _xifexpression_1 = _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                        final /* synthetic */ JavaExpression val$it;
                        {
                            this.val$it = javaExpression;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)".asMapper()");
                        }
                    };
                    return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)this.typeUtil.BOOLEAN));
                };
            } else {
                Function<JavaExpression, JavaExpression> _xifexpression_2 = null;
                boolean _isMapperC = this.typeUtil.isMapperC(expected);
                if (_isMapperC) {
                    _xifexpression_2 = null;
                } else {
                    Function<JavaExpression, JavaExpression> _xifexpression_3 = null;
                    boolean _isMapperListOfLists = this.typeUtil.isMapperListOfLists(expected);
                    if (_isMapperListOfLists) {
                        _xifexpression_3 = null;
                    } else {
                        Function<JavaExpression, JavaExpression> _xifexpression_4 = null;
                        boolean _isList = this.typeUtil.isList(expected);
                        if (_isList) {
                            Function<JavaExpression, JavaExpression> _function_1;
                            _xifexpression_4 = _function_1 = it -> {
                                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                    final /* synthetic */ JavaExpression val$it;
                                    {
                                        this.val$it = javaExpression;
                                    }

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)".getMulti()");
                                    }
                                };
                                return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.typeUtil.BOOLEAN));
                            };
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            Function<JavaExpression, JavaExpression> _xifexpression_5 = null;
            boolean _extendsMapper = this.typeUtil.extendsMapper(actual);
            if (_extendsMapper) {
                Function<JavaExpression, JavaExpression> _xifexpression_6 = null;
                boolean _isComparisonResult_1 = this.typeUtil.isComparisonResult(expected);
                if (_isComparisonResult_1) {
                    Function<JavaExpression, JavaExpression> _function_2;
                    _xifexpression_6 = _function_2 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                            final /* synthetic */ JavaExpression val$it;
                            {
                                this.val$it = javaExpression;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(ComparisonResult.class);
                                _builder.append((Object)".of(");
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
                    };
                } else {
                    Function<JavaExpression, JavaExpression> _xifexpression_7 = null;
                    boolean _extendsMapper_1 = this.typeUtil.extendsMapper(expected);
                    if (_extendsMapper_1) {
                        Function<JavaExpression, JavaExpression> _xifexpression_8 = null;
                        if (this.typeUtil.isMapperS(actual) && this.typeUtil.hasWildcardArgument(actual) && this.typeUtil.isMapperS(expected) && !this.typeUtil.hasWildcardArgument(expected)) {
                            Function<JavaExpression, JavaExpression> _function_3;
                            _xifexpression_8 = _function_3 = it -> {
                                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                    final /* synthetic */ JavaExpression val$it;
                                    {
                                        this.val$it = javaExpression;
                                    }

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)".map(\"Make mutable\", ");
                                        _builder.append(Function.class);
                                        _builder.append((Object)".identity())");
                                    }
                                };
                                return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(expected)));
                            };
                        } else {
                            Function<JavaExpression, JavaExpression> _xifexpression_9 = null;
                            if (this.typeUtil.isMapperC(actual) && this.typeUtil.hasWildcardArgument(actual) && this.typeUtil.isMapperC(expected) && !this.typeUtil.hasWildcardArgument(expected)) {
                                Function<JavaExpression, JavaExpression> _function_4 = it -> {
                                    StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".map(\"Make mutable\", ");
                                            _builder.append(Function.class);
                                            _builder.append((Object)".identity())");
                                        }
                                    };
                                    return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_C, this.typeUtil.getItemType(expected)));
                                };
                                _xifexpression_9 = _function_4;
                            } else {
                                Function<JavaExpression, JavaExpression> _xifexpression_10 = null;
                                if (this.typeUtil.isMapperS(actual) && this.typeUtil.isMapperC(expected)) {
                                    Function<JavaExpression, JavaExpression> _function_5;
                                    _xifexpression_10 = _function_5 = it -> {
                                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append(MapperC.class);
                                                _builder.append((Object)".of(");
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)")");
                                            }
                                        };
                                        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_C, this.typeUtil.getItemType(expected)));
                                    };
                                } else {
                                    Function<JavaExpression, JavaExpression> _xifexpression_11 = null;
                                    if (this.typeUtil.isMapperC(actual) && this.typeUtil.isMapperS(expected)) {
                                        Function<JavaExpression, JavaExpression> _function_6 = it -> {
                                            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                                final /* synthetic */ JavaExpression val$it;
                                                {
                                                    this.val$it = javaExpression;
                                                }

                                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                    _builder.append(MapperS.class);
                                                    _builder.append((Object)".of(");
                                                    _builder.append((Object)this.val$it);
                                                    _builder.append((Object)".get())");
                                                }
                                            };
                                            return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(expected)));
                                        };
                                        _xifexpression_11 = _function_6;
                                    }
                                    _xifexpression_10 = _xifexpression_11;
                                }
                                _xifexpression_9 = _xifexpression_10;
                            }
                            _xifexpression_8 = _xifexpression_9;
                        }
                        _xifexpression_7 = _xifexpression_8;
                    } else {
                        Function<JavaExpression, JavaExpression> _xifexpression_12 = null;
                        boolean _isMapperListOfLists_1 = this.typeUtil.isMapperListOfLists(expected);
                        if (_isMapperListOfLists_1) {
                            _xifexpression_12 = null;
                        } else {
                            Function<JavaExpression, JavaExpression> _xifexpression_13 = null;
                            boolean _isList_1 = this.typeUtil.isList(expected);
                            if (_isList_1) {
                                Function<JavaExpression, JavaExpression> _xifexpression_14 = null;
                                if (this.typeUtil.hasWildcardArgument(actual) && !this.typeUtil.hasWildcardArgument(expected)) {
                                    Function<JavaExpression, JavaExpression> _function_7 = it -> {
                                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append((Object)"new ");
                                                _builder.append(ArrayList.class);
                                                _builder.append((Object)"<>(");
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)".getMulti())");
                                            }
                                        };
                                        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, this.typeUtil.getItemType(expected)));
                                    };
                                    _xifexpression_14 = _function_7;
                                } else {
                                    Function<JavaExpression, JavaExpression> _function_8;
                                    _xifexpression_14 = _function_8 = it -> {
                                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)".getMulti()");
                                            }
                                        };
                                        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, this.typeUtil.getItemType(expected)));
                                    };
                                }
                                _xifexpression_13 = _xifexpression_14;
                            }
                            _xifexpression_12 = _xifexpression_13;
                        }
                        _xifexpression_7 = _xifexpression_12;
                    }
                    _xifexpression_6 = _xifexpression_7;
                }
                _xifexpression_5 = _xifexpression_6;
            } else {
                Function<JavaExpression, JavaExpression> _xifexpression_15 = null;
                boolean _isMapperListOfLists_2 = this.typeUtil.isMapperListOfLists(actual);
                if (_isMapperListOfLists_2) {
                    _xifexpression_15 = null;
                } else {
                    Function<JavaExpression, JavaExpression> _xifexpression_16 = null;
                    boolean _isList_2 = this.typeUtil.isList(actual);
                    if (_isList_2) {
                        Function<JavaExpression, JavaExpression> _xifexpression_17 = null;
                        boolean _isComparisonResult_2 = this.typeUtil.isComparisonResult(expected);
                        if (_isComparisonResult_2) {
                            Function<JavaExpression, JavaExpression> _function_9;
                            _xifexpression_17 = _function_9 = it -> {
                                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                    final /* synthetic */ JavaExpression val$it;
                                    {
                                        this.val$it = javaExpression;
                                    }

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append(ComparisonResult.class);
                                        _builder.append((Object)".of(");
                                        _builder.append(MapperC.class);
                                        _builder.append((Object)".of(");
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)"))");
                                    }
                                };
                                return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
                            };
                        } else {
                            Function<JavaExpression, JavaExpression> _xifexpression_18 = null;
                            boolean _isMapperS_1 = this.typeUtil.isMapperS(expected);
                            if (_isMapperS_1) {
                                Function<JavaExpression, JavaExpression> _function_10;
                                _xifexpression_18 = _function_10 = it -> {
                                    StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append(MapperS.class);
                                            _builder.append((Object)".of(");
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".get(0))");
                                        }
                                    };
                                    return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(expected)));
                                };
                            } else {
                                Function<JavaExpression, JavaExpression> _xifexpression_19 = null;
                                if (this.typeUtil.isMapperC(expected) || this.typeUtil.isMapper(expected)) {
                                    Function<JavaExpression, JavaExpression> _function_11;
                                    _xifexpression_19 = _function_11 = it -> {
                                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append(MapperC.class);
                                                _builder.append((Object)".<");
                                                JavaType _itemType = TypeCoercionService.this.typeUtil.getItemType(expected);
                                                _builder.append((Object)_itemType);
                                                _builder.append((Object)">of(");
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)")");
                                            }
                                        };
                                        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_C, this.typeUtil.getItemType(expected)));
                                    };
                                } else {
                                    Function<JavaExpression, JavaExpression> _xifexpression_20 = null;
                                    boolean _isMapperListOfLists_3 = this.typeUtil.isMapperListOfLists(expected);
                                    if (_isMapperListOfLists_3) {
                                        _xifexpression_20 = null;
                                    } else {
                                        Function<JavaExpression, JavaExpression> _xifexpression_21 = null;
                                        if (this.typeUtil.isList(expected) && this.typeUtil.hasWildcardArgument(actual) && !this.typeUtil.hasWildcardArgument(expected)) {
                                            Function<JavaExpression, JavaExpression> _function_12;
                                            _xifexpression_21 = _function_12 = it -> {
                                                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                                                    final /* synthetic */ JavaExpression val$it;
                                                    {
                                                        this.val$it = javaExpression;
                                                    }

                                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                        _builder.append((Object)"new ");
                                                        _builder.append(ArrayList.class);
                                                        _builder.append((Object)"(");
                                                        _builder.append((Object)this.val$it);
                                                        _builder.append((Object)")");
                                                    }
                                                };
                                                return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, this.typeUtil.getItemType(expected)));
                                            };
                                        }
                                        _xifexpression_20 = _xifexpression_21;
                                    }
                                    _xifexpression_19 = _xifexpression_20;
                                }
                                _xifexpression_18 = _xifexpression_19;
                            }
                            _xifexpression_17 = _xifexpression_18;
                        }
                        _xifexpression_16 = _xifexpression_17;
                    }
                    _xifexpression_15 = _xifexpression_16;
                }
                _xifexpression_5 = _xifexpression_15;
            }
            _xifexpression = _xifexpression_5;
        }
        return Optional.ofNullable(_xifexpression);
    }

    private JavaStatementBuilder convertNullSafe(JavaExpression expr, Function<JavaExpression, ? extends JavaStatementBuilder> conversion, JavaType expected, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaType actual = expr.getExpressionType();
        if (actual instanceof JavaPrimitiveType) {
            return expr.mapExpression(conversion);
        }
        Function<JavaExpression, JavaStatementBuilder> _function = varExpr -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)varExpr){
                final /* synthetic */ JavaExpression val$varExpr;
                {
                    this.val$varExpr = javaExpression;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$varExpr);
                    _builder.append((Object)" == null");
                }
            };
            JavaExpression conditionExpr = JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
            JavaStatementBuilder converted = (JavaStatementBuilder)conversion.apply((JavaExpression)varExpr);
            if (converted instanceof JavaExpression) {
                JavaExpression _empty = this.empty(expected);
                return new JavaConditionalExpression(conditionExpr, _empty, (JavaExpression)converted, this.typeUtil);
            }
            JavaExpression _empty_1 = this.empty(expected);
            return new JavaIfThenElseBuilder(conditionExpr, _empty_1, converted, this.typeUtil);
        };
        _xblockexpression = expr.declareAsVariable(true, StringExtensions.toFirstLower((String)actual.getSimpleName()), scope).mapExpression(_function);
        return _xblockexpression;
    }

    private JavaExpression empty(final JavaType expected) {
        JavaExpression _xblockexpression = null;
        final JavaType itemType = this.typeUtil.getItemType(expected);
        JavaExpression _xifexpression = null;
        boolean _isList = this.typeUtil.isList(expected);
        if (_isList) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(Collections.class);
                    _builder.append((Object)".<");
                    _builder.append((Object)itemType);
                    _builder.append((Object)">emptyList()");
                }
            };
            _xifexpression = JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, itemType));
        } else {
            JavaExpression _xifexpression_1 = null;
            if (this.typeUtil.isMapperS(expected) || this.typeUtil.isMapper(expected)) {
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(MapperS.class);
                        _builder.append((Object)".<");
                        _builder.append((Object)itemType);
                        _builder.append((Object)">ofNull()");
                    }
                };
                _xifexpression_1 = JavaExpression.from(_client_1, this.typeUtil.wrap(this.typeUtil.MAPPER_S, itemType));
            } else {
                JavaExpression _xifexpression_2 = null;
                boolean _isMapperC = this.typeUtil.isMapperC(expected);
                if (_isMapperC) {
                    StringConcatenationClient _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append(MapperC.class);
                            _builder.append((Object)".<");
                            _builder.append((Object)itemType);
                            _builder.append((Object)">ofNull()");
                        }
                    };
                    _xifexpression_2 = JavaExpression.from(_client_2, this.typeUtil.wrap(this.typeUtil.MAPPER_C, itemType));
                } else {
                    JavaExpression _xifexpression_3 = null;
                    boolean _isComparisonResult = this.typeUtil.isComparisonResult(expected);
                    if (_isComparisonResult) {
                        StringConcatenationClient _client_3 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(ComparisonResult.class);
                                _builder.append((Object)".successEmptyOperand(\"\")");
                            }
                        };
                        _xifexpression_3 = JavaExpression.from(_client_3, this.typeUtil.COMPARISON_RESULT);
                    } else {
                        JavaExpression _xifexpression_4 = null;
                        boolean _equals = Objects.equals(expected, JavaPrimitiveType.BOOLEAN);
                        if (_equals) {
                            StringConcatenationClient _client_4 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"false");
                                }
                            };
                            _xifexpression_4 = JavaExpression.from(_client_4, (JavaType)JavaPrimitiveType.BOOLEAN);
                        } else {
                            JavaExpression _xifexpression_5 = null;
                            if (expected instanceof RJavaWithMetaValue) {
                                StringConcatenationClient _client_5 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)((RJavaWithMetaValue)expected));
                                        _builder.append((Object)".builder().build()");
                                    }
                                };
                                _xifexpression_5 = JavaExpression.from(_client_5, itemType);
                            } else {
                                JavaLiteral _xifexpression_6 = null;
                                if (expected instanceof JavaPrimitiveType) {
                                    throw new IllegalArgumentException("No empty representation for primitive type `" + String.valueOf(expected) + "`.");
                                }
                                _xifexpression_5 = _xifexpression_6 = JavaLiteral.NULL;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JavaStatementBuilder metaToItemConversionExpression(final JavaExpression expression, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaLiteral _xblockexpression = null;
        JavaType actual = expression.getExpressionType();
        JavaStatementBuilder _xifexpression = null;
        if (actual instanceof RJavaWithMetaValue) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)expression);
                    _builder.append((Object)".getValue()");
                }
            };
            Function<JavaExpression, JavaStatementBuilder> _function = it -> this.itemToItem((JavaExpression)it, expected, throwOnFail, scope);
            _xifexpression = JavaExpression.from(_client, (JavaType)((RJavaWithMetaValue)actual).getValueType()).mapExpression(_function);
        } else {
            _xifexpression = JavaLiteral.NULL;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JavaStatementBuilder itemToMetaConversionExpression(final JavaExpression expression, final RJavaWithMetaValue expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaReferenceType expectedValueType = expected.getValueType();
        Function<Function, JavaStatementBuilder> _function = itemConversion -> {
            Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                    final /* synthetic */ JavaExpression val$it;
                    {
                        this.val$it = javaExpression;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)expected);
                        _builder.append((Object)".builder().setValue(");
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)").build()");
                    }
                };
                return JavaExpression.from(_client, (JavaType)expected);
            };
            return ((JavaStatementBuilder)itemConversion.apply(expression)).mapExpression(_function_1);
        };
        Supplier<JavaStatementBuilder> _function_1 = () -> {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)expected);
                    _builder.append((Object)".builder().setValue(");
                    _builder.append((Object)expression);
                    _builder.append((Object)").build()");
                }
            };
            return JavaExpression.from(_client, (JavaType)expected);
        };
        _xblockexpression = this.getItemConversion(expression.getExpressionType(), (JavaType)expectedValueType, throwOnFail, scope).map(_function).orElseGet(_function_1);
        return _xblockexpression;
    }

    private JavaStatementBuilder downCastConversionExpression(final JavaExpression expression, final JavaPojoInterface expected, boolean throwOnFail, JavaScope scope) {
        JavaStatementBuilder _xifexpression = null;
        if (throwOnFail) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)expected);
                    _builder.append((Object)".class.cast(");
                    _builder.append((Object)expression);
                    _builder.append((Object)")");
                }
            };
            _xifexpression = JavaExpression.from(_client, (JavaType)expected);
        } else {
            Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                StringConcatenationClient _client_1 = new StringConcatenationClient((JavaExpression)it, expected){
                    final /* synthetic */ JavaExpression val$it;
                    final /* synthetic */ JavaPojoInterface val$expected;
                    {
                        this.val$it = javaExpression;
                        this.val$expected = javaPojoInterface;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)" instanceof ");
                        _builder.append((Object)this.val$expected);
                    }
                };
                JavaExpression _from = JavaExpression.from(_client_1, (JavaType)JavaPrimitiveType.BOOLEAN);
                StringConcatenationClient _client_2 = new StringConcatenationClient((JavaExpression)it){
                    final /* synthetic */ JavaExpression val$it;
                    {
                        this.val$it = javaExpression;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)expected);
                        _builder.append((Object)".class.cast(");
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)")");
                    }
                };
                JavaExpression _from_1 = JavaExpression.from(_client_2, (JavaType)expected);
                return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
            };
            _xifexpression = expression.declareAsVariable(true, StringExtensions.toFirstLower((String)expression.getExpressionType().getSimpleName()), scope).mapExpression(_function);
        }
        return _xifexpression;
    }

    private JavaStatementBuilder getNumberConversionExpression(final JavaExpression expression, JavaType expected, boolean throwOnFail, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actual = expression.getExpressionType();
        JavaExpression _xifexpression = null;
        boolean _isInteger = this.typeUtil.isInteger((JavaType)actual.toReferenceType());
        if (_isInteger) {
            JavaExpression _xifexpression_1 = null;
            boolean _isLong = this.typeUtil.isLong((JavaType)expected.toReferenceType());
            if (_isLong) {
                StringConcatenationClient _xifexpression_2 = null;
                boolean _equals = Objects.equals(actual, JavaPrimitiveType.INT);
                if (_equals) {
                    StringConcatenationClient _client_1;
                    StringConcatenationClient _client;
                    StringConcatenationClient _xifexpression_3 = null;
                    boolean _equals_1 = Objects.equals(expected, JavaPrimitiveType.LONG);
                    _xifexpression_3 = _equals_1 ? (_client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)expression);
                        }
                    }) : (_client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"(long) ");
                            _builder.append((Object)expression);
                        }
                    });
                    _xifexpression_2 = _xifexpression_3;
                } else {
                    StringConcatenationClient _client_2;
                    _xifexpression_2 = _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)expression);
                            _builder.append((Object)".longValue()");
                        }
                    };
                }
                _xifexpression_1 = JavaExpression.from(_xifexpression_2, (JavaType)JavaPrimitiveType.LONG);
            } else {
                JavaExpression _xifexpression_4 = null;
                boolean _isBigInteger = this.typeUtil.isBigInteger(expected);
                if (_isBigInteger) {
                    StringConcatenationClient _client_3 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append(BigInteger.class);
                            _builder.append((Object)".valueOf(");
                            _builder.append((Object)expression);
                            _builder.append((Object)")");
                        }
                    };
                    _xifexpression_4 = JavaExpression.from(_client_3, this.typeUtil.BIG_INTEGER);
                } else {
                    JavaExpression _xifexpression_5 = null;
                    boolean _isBigDecimal = this.typeUtil.isBigDecimal(expected);
                    if (!_isBigDecimal) {
                        throw this.unexpectedCaseException(actual, expected);
                    }
                    StringConcatenationClient _client_4 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append(BigDecimal.class);
                            _builder.append((Object)".valueOf(");
                            _builder.append((Object)expression);
                            _builder.append((Object)")");
                        }
                    };
                    _xifexpression_5 = JavaExpression.from(_client_4, this.typeUtil.BIG_DECIMAL);
                    _xifexpression_4 = _xifexpression_5;
                }
                _xifexpression_1 = _xifexpression_4;
            }
            _xifexpression = _xifexpression_1;
        } else {
            JavaStatementBuilder _xifexpression_6 = null;
            boolean _isLong_1 = this.typeUtil.isLong((JavaType)actual.toReferenceType());
            if (_isLong_1) {
                JavaStatementBuilder _xifexpression_7 = null;
                boolean _isInteger_1 = this.typeUtil.isInteger((JavaType)expected.toReferenceType());
                if (_isInteger_1) {
                    JavaStatementBuilder _xifexpression_8 = null;
                    if (throwOnFail) {
                        StringConcatenationClient _client_5 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(Math.class);
                                _builder.append((Object)".toIntExact(");
                                _builder.append((Object)expression);
                                _builder.append((Object)")");
                            }
                        };
                        _xifexpression_8 = JavaExpression.from(_client_5, (JavaType)JavaPrimitiveType.INT);
                    } else {
                        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                            StringConcatenationClient _client_6 = new StringConcatenationClient((JavaExpression)it){
                                final /* synthetic */ JavaExpression val$it;
                                {
                                    this.val$it = javaExpression;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)this.val$it);
                                    _builder.append((Object)" <= ");
                                    _builder.append(Integer.class);
                                    _builder.append((Object)".MAX_VALUE && ");
                                    _builder.append((Object)this.val$it);
                                    _builder.append((Object)" >= ");
                                    _builder.append(Integer.class);
                                    _builder.append((Object)".MIN_VALUE");
                                }
                            };
                            JavaExpression _from = JavaExpression.from(_client_6, (JavaType)JavaPrimitiveType.BOOLEAN);
                            StringConcatenationClient _client_7 = new StringConcatenationClient((JavaExpression)it){
                                final /* synthetic */ JavaExpression val$it;
                                {
                                    this.val$it = javaExpression;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"(int) ");
                                    _builder.append((Object)this.val$it);
                                }
                            };
                            JavaExpression _from_1 = JavaExpression.from(_client_7, (JavaType)JavaPrimitiveType.INT);
                            return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                        };
                        _xifexpression_8 = expression.declareAsVariable(true, "i", scope).mapExpression(_function);
                    }
                    _xifexpression_7 = _xifexpression_8;
                } else {
                    JavaExpression _xifexpression_9 = null;
                    boolean _isBigInteger_1 = this.typeUtil.isBigInteger(expected);
                    if (_isBigInteger_1) {
                        StringConcatenationClient _client_6 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(BigInteger.class);
                                _builder.append((Object)".valueOf(");
                                _builder.append((Object)expression);
                                _builder.append((Object)")");
                            }
                        };
                        _xifexpression_9 = JavaExpression.from(_client_6, this.typeUtil.BIG_INTEGER);
                    } else {
                        JavaExpression _xifexpression_10 = null;
                        boolean _isBigDecimal_1 = this.typeUtil.isBigDecimal(expected);
                        if (!_isBigDecimal_1) {
                            throw this.unexpectedCaseException(actual, expected);
                        }
                        StringConcatenationClient _client_7 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(BigDecimal.class);
                                _builder.append((Object)".valueOf(");
                                _builder.append((Object)expression);
                                _builder.append((Object)")");
                            }
                        };
                        _xifexpression_10 = JavaExpression.from(_client_7, this.typeUtil.BIG_DECIMAL);
                        _xifexpression_9 = _xifexpression_10;
                    }
                    _xifexpression_7 = _xifexpression_9;
                }
                _xifexpression_6 = _xifexpression_7;
            } else {
                JavaStatementBuilder _xifexpression_11 = null;
                boolean _isBigInteger_2 = this.typeUtil.isBigInteger(actual);
                if (_isBigInteger_2) {
                    JavaStatementBuilder _xifexpression_12 = null;
                    boolean _isInteger_2 = this.typeUtil.isInteger((JavaType)expected.toReferenceType());
                    if (_isInteger_2) {
                        JavaStatementBuilder _xifexpression_13 = null;
                        if (throwOnFail) {
                            StringConcatenationClient _client_8 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)expression);
                                    _builder.append((Object)".intValueExact()");
                                }
                            };
                            _xifexpression_13 = JavaExpression.from(_client_8, (JavaType)JavaPrimitiveType.INT);
                        } else {
                            Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                                StringConcatenationClient _client_9 = new StringConcatenationClient((JavaExpression)it){
                                    final /* synthetic */ JavaExpression val$it;
                                    {
                                        this.val$it = javaExpression;
                                    }

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append(BigInteger.class);
                                        _builder.append((Object)".valueOf(");
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)".intValue()).equals(");
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)")");
                                    }
                                };
                                JavaExpression _from = JavaExpression.from(_client_9, (JavaType)JavaPrimitiveType.BOOLEAN);
                                StringConcatenationClient _client_10 = new StringConcatenationClient((JavaExpression)it){
                                    final /* synthetic */ JavaExpression val$it;
                                    {
                                        this.val$it = javaExpression;
                                    }

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)this.val$it);
                                        _builder.append((Object)".intValue()");
                                    }
                                };
                                JavaExpression _from_1 = JavaExpression.from(_client_10, (JavaType)JavaPrimitiveType.INT);
                                return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                            };
                            _xifexpression_13 = expression.declareAsVariable(true, "i", scope).mapExpression(_function_1);
                        }
                        _xifexpression_12 = _xifexpression_13;
                    } else {
                        JavaStatementBuilder _xifexpression_14 = null;
                        boolean _isLong_2 = this.typeUtil.isLong((JavaType)expected.toReferenceType());
                        if (_isLong_2) {
                            JavaStatementBuilder _xifexpression_15 = null;
                            if (throwOnFail) {
                                StringConcatenationClient _client_9 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)expression);
                                        _builder.append((Object)".longValueExact()");
                                    }
                                };
                                _xifexpression_15 = JavaExpression.from(_client_9, (JavaType)JavaPrimitiveType.LONG);
                            } else {
                                Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> {
                                    StringConcatenationClient _client_10 = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append(BigInteger.class);
                                            _builder.append((Object)".valueOf(");
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".longValue()).equals(");
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)")");
                                        }
                                    };
                                    JavaExpression _from = JavaExpression.from(_client_10, (JavaType)JavaPrimitiveType.BOOLEAN);
                                    StringConcatenationClient _client_11 = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".longValue()");
                                        }
                                    };
                                    JavaExpression _from_1 = JavaExpression.from(_client_11, (JavaType)JavaPrimitiveType.LONG);
                                    return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                                };
                                _xifexpression_15 = expression.declareAsVariable(true, "i", scope).mapExpression(_function_2);
                            }
                            _xifexpression_14 = _xifexpression_15;
                        } else {
                            JavaExpression _xifexpression_16 = null;
                            boolean _isBigDecimal_2 = this.typeUtil.isBigDecimal(expected);
                            if (!_isBigDecimal_2) {
                                throw this.unexpectedCaseException(actual, expected);
                            }
                            StringConcatenationClient _client_10 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"new ");
                                    _builder.append(BigDecimal.class);
                                    _builder.append((Object)"(");
                                    _builder.append((Object)expression);
                                    _builder.append((Object)")");
                                }
                            };
                            _xifexpression_16 = JavaExpression.from(_client_10, this.typeUtil.BIG_DECIMAL);
                            _xifexpression_14 = _xifexpression_16;
                        }
                        _xifexpression_12 = _xifexpression_14;
                    }
                    _xifexpression_11 = _xifexpression_12;
                } else {
                    JavaStatementBuilder _xifexpression_18;
                    JavaStatementBuilder _xifexpression_17 = null;
                    boolean _isBigDecimal_3 = this.typeUtil.isBigDecimal(actual);
                    if (_isBigDecimal_3) {
                        _xifexpression_18 = null;
                        boolean _isInteger_3 = this.typeUtil.isInteger((JavaType)expected.toReferenceType());
                        if (_isInteger_3) {
                            JavaStatementBuilder _xifexpression_19 = null;
                            if (throwOnFail) {
                                StringConcatenationClient _client_11 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)expression);
                                        _builder.append((Object)".intValueExact()");
                                    }
                                };
                                _xifexpression_19 = JavaExpression.from(_client_11, (JavaType)JavaPrimitiveType.INT);
                            } else {
                                Function<JavaExpression, JavaStatementBuilder> _function_3 = it -> {
                                    StringConcatenationClient _client_12 = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append(BigDecimal.class);
                                            _builder.append((Object)".valueOf(");
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".intValue()).compareTo(");
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)") == 0");
                                        }
                                    };
                                    JavaExpression _from = JavaExpression.from(_client_12, (JavaType)JavaPrimitiveType.BOOLEAN);
                                    StringConcatenationClient _client_13 = new StringConcatenationClient((JavaExpression)it){
                                        final /* synthetic */ JavaExpression val$it;
                                        {
                                            this.val$it = javaExpression;
                                        }

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)this.val$it);
                                            _builder.append((Object)".intValue()");
                                        }
                                    };
                                    JavaExpression _from_1 = JavaExpression.from(_client_13, (JavaType)JavaPrimitiveType.INT);
                                    return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                                };
                                _xifexpression_19 = expression.declareAsVariable(true, "d", scope).mapExpression(_function_3);
                            }
                            _xifexpression_18 = _xifexpression_19;
                        } else {
                            JavaStatementBuilder _xifexpression_20 = null;
                            boolean _isLong_3 = this.typeUtil.isLong((JavaType)expected.toReferenceType());
                            if (_isLong_3) {
                                JavaStatementBuilder _xifexpression_21 = null;
                                if (throwOnFail) {
                                    StringConcatenationClient _client_12 = new StringConcatenationClient(){

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)expression);
                                            _builder.append((Object)".longValueExact()");
                                        }
                                    };
                                    _xifexpression_21 = JavaExpression.from(_client_12, (JavaType)JavaPrimitiveType.LONG);
                                } else {
                                    Function<JavaExpression, JavaStatementBuilder> _function_4 = it -> {
                                        StringConcatenationClient _client_13 = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append(BigDecimal.class);
                                                _builder.append((Object)".valueOf(");
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)".longValue()).compareTo(");
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)") == 0");
                                            }
                                        };
                                        JavaExpression _from = JavaExpression.from(_client_13, (JavaType)JavaPrimitiveType.BOOLEAN);
                                        StringConcatenationClient _client_14 = new StringConcatenationClient((JavaExpression)it){
                                            final /* synthetic */ JavaExpression val$it;
                                            {
                                                this.val$it = javaExpression;
                                            }

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append((Object)this.val$it);
                                                _builder.append((Object)".longValue()");
                                            }
                                        };
                                        JavaExpression _from_1 = JavaExpression.from(_client_14, (JavaType)JavaPrimitiveType.LONG);
                                        return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                                    };
                                    _xifexpression_21 = expression.declareAsVariable(true, "d", scope).mapExpression(_function_4);
                                }
                                _xifexpression_20 = _xifexpression_21;
                            } else {
                                JavaStatementBuilder _xifexpression_23;
                                JavaStatementBuilder _xifexpression_22 = null;
                                boolean _isBigInteger_3 = this.typeUtil.isBigInteger(expected);
                                if (_isBigInteger_3) {
                                    _xifexpression_23 = null;
                                    if (throwOnFail) {
                                        StringConcatenationClient _client_13 = new StringConcatenationClient(){

                                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                _builder.append((Object)expression);
                                                _builder.append((Object)".toBigIntegerExact()");
                                            }
                                        };
                                        _xifexpression_23 = JavaExpression.from(_client_13, this.typeUtil.BIG_INTEGER);
                                    } else {
                                        Function<JavaExpression, JavaStatementBuilder> _function_5 = it -> {
                                            StringConcatenationClient _client_14 = new StringConcatenationClient((JavaExpression)it){
                                                final /* synthetic */ JavaExpression val$it;
                                                {
                                                    this.val$it = javaExpression;
                                                }

                                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                    _builder.append((Object)"new ");
                                                    _builder.append(BigDecimal.class);
                                                    _builder.append((Object)"(");
                                                    _builder.append((Object)this.val$it);
                                                    _builder.append((Object)".toBigInteger()).compareTo(");
                                                    _builder.append((Object)this.val$it);
                                                    _builder.append((Object)") == 0");
                                                }
                                            };
                                            JavaExpression _from = JavaExpression.from(_client_14, (JavaType)JavaPrimitiveType.BOOLEAN);
                                            StringConcatenationClient _client_15 = new StringConcatenationClient((JavaExpression)it){
                                                final /* synthetic */ JavaExpression val$it;
                                                {
                                                    this.val$it = javaExpression;
                                                }

                                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                                    _builder.append((Object)this.val$it);
                                                    _builder.append((Object)".toBigInteger()");
                                                }
                                            };
                                            JavaExpression _from_1 = JavaExpression.from(_client_15, this.typeUtil.BIG_INTEGER);
                                            return new JavaConditionalExpression(_from, _from_1, JavaLiteral.NULL, this.typeUtil);
                                        };
                                        _xifexpression_23 = expression.declareAsVariable(true, "d", scope).mapExpression(_function_5);
                                    }
                                } else {
                                    throw this.unexpectedCaseException(actual, expected);
                                }
                                _xifexpression_22 = _xifexpression_23;
                                _xifexpression_20 = _xifexpression_22;
                            }
                            _xifexpression_18 = _xifexpression_20;
                        }
                    } else {
                        throw this.unexpectedCaseException(actual, expected);
                    }
                    _xifexpression_17 = _xifexpression_18;
                    _xifexpression_11 = _xifexpression_17;
                }
                _xifexpression_6 = _xifexpression_11;
            }
            _xifexpression = _xifexpression_6;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JavaExpression getItemToListConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Collections.class);
                _builder.append((Object)".singletonList(");
                _builder.append((Object)expression);
                _builder.append((Object)")");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, expression.getExpressionType()));
    }

    private JavaExpression getItemToMapperSConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(MapperS.class);
                _builder.append((Object)".of(");
                _builder.append((Object)expression);
                _builder.append((Object)")");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, expression.getExpressionType()));
    }

    private JavaExpression getItemToMapperCConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(MapperC.class);
                _builder.append((Object)".of(");
                _builder.append(Collections.class);
                _builder.append((Object)".singletonList(");
                _builder.append((Object)expression);
                _builder.append((Object)"))");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_C, expression.getExpressionType()));
    }

    private JavaExpression getItemToComparisonResultConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(ComparisonResult.class);
                _builder.append((Object)".of(");
                _builder.append(MapperS.class);
                _builder.append((Object)".of(");
                _builder.append((Object)expression);
                _builder.append((Object)"))");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
    }

    private JavaExpression getListToItemConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(MapperC.class);
                _builder.append((Object)".of(");
                _builder.append((Object)expression);
                _builder.append((Object)").get()");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.getItemType(expression.getExpressionType()));
    }

    private JavaExpression getMapperToItemConversionExpression(final JavaExpression expression) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)expression);
                _builder.append((Object)".get()");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.getItemType(expression.getExpressionType()));
    }

    private JavaExpression getListItemConversionExpression(final JavaExpression expression, Function<JavaExpression, ? extends JavaStatementBuilder> itemConversion, final JavaReferenceType expectedItemType, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actualItemType = this.typeUtil.getItemType(expression.getExpressionType());
        JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier(StringExtensions.toFirstLower((String)actualItemType.getSimpleName()));
        JavaVariable _javaVariable = new JavaVariable(lambdaParam, actualItemType);
        final JavaStatementBuilder resultItem = itemConversion.apply(_javaVariable);
        JavaParameterizedType<List<?>> resultType = this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)expectedItemType);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)expression);
                _builder.append((Object)".stream()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".<");
                _builder.append((Object)expectedItemType, "\t");
                _builder.append((Object)">map(");
                _builder.append((Object)lambdaParam, "\t");
                _builder.append((Object)" -> ");
                JavaLambdaBody _lambdaBody = resultItem.toLambdaBody();
                _builder.append((Object)_lambdaBody, "\t");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".collect(");
                _builder.append(Collectors.class, "\t");
                _builder.append((Object)".toList())");
                _builder.newLineIfNotEmpty();
            }
        };
        _xblockexpression = JavaExpression.from(_client, resultType);
        return _xblockexpression;
    }

    private JavaExpression getMapperSItemConversionExpression(final JavaExpression expression, Function<JavaExpression, ? extends JavaStatementBuilder> itemConversion, JavaReferenceType expectedItemType, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actualItemType = this.typeUtil.getItemType(expression.getExpressionType());
        JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier(StringExtensions.toFirstLower((String)actualItemType.getSimpleName()));
        JavaVariable inputToItem = new JavaVariable(lambdaParam, actualItemType);
        final JavaParameterizedType<MapperS<?>> resultType = this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)expectedItemType);
        final JavaStatementBuilder resultItemNullSafe = this.convertNullSafe(inputToItem, itemConversion, (JavaType)expectedItemType, scope);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)expression);
                _builder.append((Object)".<");
                JavaType _itemType = TypeCoercionService.this.typeUtil.getItemType((JavaType)resultType);
                _builder.append((Object)_itemType);
                _builder.append((Object)">map(\"Type coercion\", ");
                _builder.append((Object)lambdaParam);
                _builder.append((Object)" -> ");
                JavaLambdaBody _lambdaBody = resultItemNullSafe.toLambdaBody();
                _builder.append((Object)_lambdaBody);
                _builder.append((Object)")");
            }
        };
        _xblockexpression = JavaExpression.from(_client, resultType);
        return _xblockexpression;
    }

    private JavaExpression getMapperCItemConversionExpression(final JavaExpression expression, Function<JavaExpression, ? extends JavaStatementBuilder> itemConversion, final JavaReferenceType expectedItemType, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actualItemType = this.typeUtil.getItemType(expression.getExpressionType());
        JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier(StringExtensions.toFirstLower((String)actualItemType.getSimpleName()));
        JavaVariable _javaVariable = new JavaVariable(lambdaParam, actualItemType);
        final JavaStatementBuilder resultItem = itemConversion.apply(_javaVariable);
        JavaParameterizedType<MapperC<?>> resultType = this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)expectedItemType);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)expression);
                _builder.append((Object)".<");
                _builder.append((Object)expectedItemType);
                _builder.append((Object)">map(\"Type coercion\", ");
                _builder.append((Object)lambdaParam);
                _builder.append((Object)" -> ");
                JavaLambdaBody _lambdaBody = resultItem.toLambdaBody();
                _builder.append((Object)_lambdaBody);
                _builder.append((Object)")");
            }
        };
        _xblockexpression = JavaExpression.from(_client, resultType);
        return _xblockexpression;
    }

    private JavaExpression getMapperListOfListsItemConversionExpression(final JavaExpression expression, Function<JavaExpression, ? extends JavaStatementBuilder> itemConversion, final JavaReferenceType expectedItemType, JavaScope scope) {
        JavaExpression _xblockexpression = null;
        JavaType actualItemType = this.typeUtil.getItemType(expression.getExpressionType());
        JavaScope listToListLambdaScope = scope.lambdaScope();
        final GeneratedIdentifier mapperCParam = listToListLambdaScope.createUniqueIdentifier("mapperC");
        JavaParameterizedType<MapperC<?>> _wrap = this.typeUtil.wrap(this.typeUtil.MAPPER_C, actualItemType);
        JavaVariable _javaVariable = new JavaVariable(mapperCParam, (JavaType)_wrap);
        final JavaExpression resultMapperC = this.getMapperCItemConversionExpression(_javaVariable, itemConversion, expectedItemType, listToListLambdaScope);
        JavaParameterizedType<MapperListOfLists<?>> resultType = this.typeUtil.wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)expectedItemType);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)expression);
                _builder.append((Object)".<");
                _builder.append((Object)expectedItemType);
                _builder.append((Object)">mapListToList(");
                _builder.append((Object)mapperCParam);
                _builder.append((Object)" -> ");
                JavaLambdaBody _lambdaBody = resultMapperC.toLambdaBody();
                _builder.append((Object)_lambdaBody);
                _builder.append((Object)")");
            }
        };
        _xblockexpression = JavaExpression.from(_client, resultType);
        return _xblockexpression;
    }

    private IllegalArgumentException unexpectedCaseException(JavaType actual, JavaType expected) {
        return new IllegalArgumentException("Cannot coerce from " + String.valueOf(actual) + " to " + String.valueOf(expected) + ".");
    }

    private IllegalArgumentException unexpectedWrapperException(JavaType expectedWrapper) {
        return new IllegalArgumentException("Cannot wrap to " + String.valueOf(expectedWrapper) + ".");
    }
}

