/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.function;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.function.LabelProviderGeneratorUtil;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.AnnotationDeepPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPathExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.LabelAnnotation;
import com.regnosys.rosetta.rosetta.simple.RuleReferenceAnnotation;
import com.regnosys.rosetta.rules.RuleReferenceService;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.AnnotationPathExpressionUtil;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import com.rosetta.model.lib.functions.LabelProvider;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class LabelProviderGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private JavaTypeTranslator typeTranslator;
    @Inject
    private DeepFeatureCallUtil deepPathUtil;
    @Inject
    private LabelProviderGeneratorUtil util;
    @Inject
    private RuleReferenceService ruleService;
    @Inject
    private AnnotationPathExpressionUtil annotationPathUtil;

    public void generateForFunctionIfApplicable(IFileSystemAccess2 fsa, com.regnosys.rosetta.rosetta.simple.Function func) {
        boolean _shouldGenerateLabelProvider = this.util.shouldGenerateLabelProvider(func);
        if (_shouldGenerateLabelProvider) {
            RFunction rFunction = this.rObjectFactory.buildRFunction(func);
            this.generate(fsa, rFunction, CollectionLiterals.emptyMap());
        }
    }

    public void generateForReport(IFileSystemAccess2 fsa, RosettaReport report) {
        RFunction rFunction = this.rObjectFactory.buildRFunction(report);
        RType _rType = rFunction.getOutput().getRMetaAnnotatedType().getRType();
        BiFunction<HashMap, RuleReferenceService.RuleReferenceContext, HashMap> _function = (map, context) -> {
            EObject origin;
            HashMap _xblockexpression = null;
            if (context.getRule() != null && context.getRule().getIdentifier() != null && (origin = context.getRuleOrigin()) instanceof RuleReferenceAnnotation) {
                boolean _tripleEquals;
                AnnotationPathExpression _path = ((RuleReferenceAnnotation)origin).getPath();
                boolean bl = _tripleEquals = _path == null;
                if (_tripleEquals) {
                    map.put(context.getTargetAttribute(), context.getRule());
                }
            }
            _xblockexpression = map;
            return _xblockexpression;
        };
        HashMap attributeToRuleMap = this.ruleService.traverse(report.getRuleSource(), (RDataType)_rType, CollectionLiterals.newHashMap(), _function);
        this.generate(fsa, rFunction, attributeToRuleMap);
    }

    private void generate(IFileSystemAccess2 fsa, RFunction f, Map<RAttribute, RosettaRule> attributeToRuleMap) {
        GeneratedJavaClass<LabelProvider> javaClass = this.typeTranslator.toLabelProviderJavaClass(f);
        String _withForwardSlashes = javaClass.getCanonicalName().withForwardSlashes();
        String fileName = _withForwardSlashes + ".java";
        DottedPath _packageName = javaClass.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        StringConcatenationClient classBody = this.classBody(f, attributeToRuleMap, (JavaClass<LabelProvider>)javaClass, topScope);
        String content = this._importManagerExtension.buildClass(javaClass.getPackageName(), classBody, topScope);
        fsa.generateFile(fileName, (CharSequence)content);
    }

    private StringConcatenationClient classBody(RFunction function, Map<RAttribute, RosettaRule> attributeToRuleMap, JavaClass<LabelProvider> javaClass, JavaScope topScope) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final GeneratedIdentifier className = topScope.createIdentifier(function, javaClass.getSimpleName());
        JavaScope classScope = topScope.classScope(javaClass.getSimpleName());
        final JavaScope constructorScope = classScope.methodScope("constructor");
        final LinkedHashMap labelsPerNode = CollectionLiterals.newLinkedHashMap();
        final LinkedHashMap edgesPerNode = CollectionLiterals.newLinkedHashMap();
        RType outputType = function.getOutput().getRMetaAnnotatedType().getRType();
        RType _xifexpression = null;
        _xifexpression = outputType instanceof RChoiceType ? ((RChoiceType)outputType).asRDataType() : outputType;
        final RType startNode = _xifexpression;
        if (startNode instanceof RDataType) {
            this.buildLabelGraph((RDataType)startNode, labelsPerNode, edgesPerNode, attributeToRuleMap);
            this.pruneLabelGraph(labelsPerNode, edgesPerNode);
        }
        constructorScope.createIdentifier(startNode, "startNode");
        Consumer<RDataType> _function = node -> {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equals(node, startNode);
            if (_notEquals) {
                String _firstLower = StringExtensions.toFirstLower((String)node.getName());
                String _plus = _firstLower + "Node";
                constructorScope.createIdentifier(node, _plus);
            }
        };
        labelsPerNode.keySet().forEach(_function);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                _builder.append((Object)className);
                _builder.append((Object)" extends ");
                _builder.append(GraphBasedLabelProvider.class);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append((Object)className, "\t");
                _builder.append((Object)"() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"super(new ");
                _builder.append(LabelNode.class, "\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                Set _keySet = labelsPerNode.keySet();
                for (RDataType node : _keySet) {
                    boolean _notEquals;
                    _builder.append((Object)"\t\t");
                    GeneratedIdentifier nodeVarName = constructorScope.getIdentifierOrThrow(node);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    Map labels = (Map)labelsPerNode.get(node);
                    _builder.newLineIfNotEmpty();
                    boolean bl = _notEquals = !Objects.equals(node, startNode);
                    if (_notEquals) {
                        _builder.append((Object)"\t\t");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append(LabelNode.class, "\t\t");
                        _builder.append((Object)" ");
                        _builder.append((Object)nodeVarName, "\t\t");
                        _builder.append((Object)" = new ");
                        _builder.append(LabelNode.class, "\t\t");
                        _builder.append((Object)"();");
                        _builder.newLineIfNotEmpty();
                    }
                    Set _keySet_1 = labels.keySet();
                    for (DottedPath path : _keySet_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)nodeVarName, "\t\t");
                        _builder.append((Object)".addLabel(");
                        StringConcatenationClient _representAsList = LabelProviderGenerator.this.representAsList(path);
                        _builder.append((Object)_representAsList, "\t\t");
                        _builder.append((Object)", \"");
                        String _escapeJava = StringEscapeUtils.escapeJava((String)((String)labels.get(path)));
                        _builder.append((Object)_escapeJava, "\t\t");
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                    }
                }
                Set _keySet_2 = edgesPerNode.keySet();
                for (RDataType node_1 : _keySet_2) {
                    _builder.append((Object)"\t\t");
                    GeneratedIdentifier nodeVarName_1 = constructorScope.getIdentifierOrThrow(node_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    Map edges = (Map)edgesPerNode.get(node_1);
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = edges.isEmpty();
                    boolean _not = !_isEmpty;
                    if (!_not) continue;
                    _builder.append((Object)"\t\t");
                    _builder.newLine();
                    Set _keySet_3 = edges.keySet();
                    for (String pathElement : _keySet_3) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)nodeVarName_1, "\t\t");
                        _builder.append((Object)".addOutgoingEdge(\"");
                        String _escapeJava_1 = StringEscapeUtils.escapeJava((String)pathElement);
                        _builder.append((Object)_escapeJava_1, "\t\t");
                        _builder.append((Object)"\", ");
                        GeneratedIdentifier _identifierOrThrow = constructorScope.getIdentifierOrThrow(edges.get(pathElement));
                        _builder.append((Object)_identifierOrThrow, "\t\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient representAsList(final DottedPath path) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Arrays.class);
                _builder.append((Object)".asList(");
                Function<String, String> _function = it -> StringEscapeUtils.escapeJava((String)it);
                String _collect = path.stream().map(_function).collect(Collectors.joining("\", \"", "\"", "\""));
                _builder.append((Object)_collect);
                _builder.append((Object)")");
            }
        };
        return _client;
    }

    private void buildLabelGraph(RDataType currentNode, Map<RDataType, Map<DottedPath, String>> labelsPerNode, Map<RDataType, Map<String, RDataType>> edgesPerNode, Map<RAttribute, RosettaRule> attributeToRuleMap) {
        boolean _containsKey = labelsPerNode.containsKey(currentNode);
        if (_containsKey) {
            return;
        }
        LinkedHashMap labels = CollectionLiterals.newLinkedHashMap();
        labelsPerNode.put(currentNode, labels);
        LinkedHashMap edges = CollectionLiterals.newLinkedHashMap();
        edgesPerNode.put(currentNode, edges);
        Collection<RAttribute> _allAttributes = currentNode.getAllAttributes();
        for (RAttribute attr : _allAttributes) {
            RosettaRule ruleRef;
            DottedPath attrPath = DottedPath.of((String[])new String[]{attr.getName()});
            RType attrType = attr.getRMetaAnnotatedType().getRType();
            RType _xifexpression = null;
            _xifexpression = attrType instanceof RChoiceType ? ((RChoiceType)attrType).asRDataType() : attrType;
            RType t = _xifexpression;
            if (t instanceof RDataType) {
                edges.put(attr.getName(), (RDataType)t);
                this.buildLabelGraph((RDataType)t, labelsPerNode, edgesPerNode, attributeToRuleMap);
            }
            if ((ruleRef = attributeToRuleMap.get(attr)) != null) {
                this.registerLegacyRuleAsLabel(ruleRef, attrPath, labels);
            }
            Consumer<LabelAnnotation> _function = it -> this.registerLabelAnnotation((LabelAnnotation)it, attrPath, labels);
            attr.getAllLabelAnnotations().forEach(_function);
        }
    }

    private void pruneLabelGraph(Map<RDataType, Map<DottedPath, String>> labelsPerNode, Map<RDataType, Map<String, RDataType>> edgesPerNode) {
        Object _function_1;
        boolean _not;
        boolean _contains;
        Set<RDataType> _keySet = labelsPerNode.keySet();
        HashSet<RDataType> nodes = new HashSet<RDataType>(_keySet);
        HashSet nodesWithReachableLabels = CollectionLiterals.newHashSet();
        Functions.Function1 _function = it -> {
            boolean _isEmpty = ((Map)labelsPerNode.get(it)).isEmpty();
            return !_isEmpty;
        };
        Iterables.addAll((Collection)nodesWithReachableLabels, (Iterable)IterableExtensions.filter(nodes, (Functions.Function1)_function));
        boolean anyReachableNodesFoundInIteration = true;
        while (anyReachableNodesFoundInIteration) {
            anyReachableNodesFoundInIteration = false;
            for (RDataType node : nodes) {
                _contains = nodesWithReachableLabels.contains(node);
                _not = !_contains;
                if (!_not) continue;
                _function_1 = it -> nodesWithReachableLabels.contains(it);
                boolean hasEdgeToNodeWithReachableLabel = IterableExtensions.exists(edgesPerNode.get(node).values(), (Functions.Function1)_function_1);
                if (!hasEdgeToNodeWithReachableLabel) continue;
                nodesWithReachableLabels.add(node);
                anyReachableNodesFoundInIteration = true;
            }
        }
        for (RDataType node : nodes) {
            _contains = nodesWithReachableLabels.contains(node);
            _not = !_contains;
            if (!_not) continue;
            labelsPerNode.remove(node);
            edgesPerNode.remove(node);
            _function_1 = it -> {
                Predicate<Map.Entry> _function_2 = it_1 -> {
                    RDataType _value = (RDataType)it_1.getValue();
                    return Objects.equals(_value, node);
                };
                it.entrySet().removeIf(_function_2);
            };
            edgesPerNode.values().forEach(_function_1);
        }
    }

    private void registerLabelAnnotation(LabelAnnotation ann, DottedPath attrPath, Map<DottedPath, String> labels) {
        Consumer<DottedPath> _function = it -> labels.put((DottedPath)it, ann.getLabel());
        this.evaluateAnnotationPathExpression(attrPath, ann.getPath()).forEach(_function);
    }

    private void registerLegacyRuleAsLabel(RosettaRule rule, DottedPath attrPath, Map<DottedPath, String> labels) {
        boolean _tripleNotEquals;
        String _identifier = rule.getIdentifier();
        boolean bl = _tripleNotEquals = _identifier != null;
        if (_tripleNotEquals) {
            labels.put(attrPath, rule.getIdentifier());
        }
    }

    private List<DottedPath> evaluateAnnotationPathExpression(DottedPath root, AnnotationPathExpression expr) {
        List _xifexpression = null;
        if (expr == null) {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DottedPath[]{root}));
        } else {
            Function<Attribute, List> _function = a -> {
                DottedPath _child = root.child(a.getName());
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DottedPath[]{_child}));
            };
            Function<Attribute, List> _function_1 = a -> Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DottedPath[]{root}));
            BiFunction<List, AnnotationPath, List> _function_2 = (r, p) -> {
                Functions.Function1 _function_3 = it -> it.child(p.getAttribute().getName());
                return ListExtensions.map((List)r, (Functions.Function1)_function_3);
            };
            BiFunction<List, AnnotationDeepPath, List> _function_3 = (r, dp) -> {
                List _xblockexpression = null;
                RType rawType = this.typeProvider.getRMetaAnnotatedType(dp.getReceiver()).getRType();
                RType _xifexpression_1 = null;
                _xifexpression_1 = rawType instanceof RChoiceType ? ((RChoiceType)rawType).asRDataType() : rawType;
                RType t = _xifexpression_1;
                List _xifexpression_2 = null;
                if (t instanceof RDataType) {
                    Functions.Function1 _function_4 = p -> {
                        Functions.Function1 _function_5 = deepPath -> {
                            Functions.Function1 _function_6 = it -> it.getName();
                            return p.concat(DottedPath.of((String[])((String[])Conversions.unwrapArray((Object)ListExtensions.map((List)deepPath, (Functions.Function1)_function_6), String.class))));
                        };
                        return ListExtensions.map(this.deepPathUtil.findDeepFeaturePaths((RDataType)t, this.rObjectFactory.buildRAttribute(dp.getAttribute())), (Functions.Function1)_function_5);
                    };
                    _xifexpression_2 = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)r, (Functions.Function1)_function_4));
                } else {
                    _xifexpression_2 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                _xblockexpression = _xifexpression_2;
                return _xblockexpression;
            };
            _xifexpression = this.annotationPathUtil.fold(expr, _function, _function_1, _function_2, _function_3);
        }
        return _xifexpression;
    }
}

