/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.object.ModelObjectGenerator;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RJavaFieldWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaReferenceWithMeta;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MetaFieldGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private ModelObjectGenerator _modelObjectGenerator;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    public void generate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext ctx) {
        boolean _isNullOrEmpty;
        RosettaModel model = (RosettaModel)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), RosettaModel.class));
        String _name = null;
        if (model != null) {
            _name = model.getName();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
            return;
        }
        boolean _isCanceled = ctx.getCancelIndicator().isCanceled();
        if (_isCanceled) {
            return;
        }
        Functions.Function1 _function = it -> this._rObjectFactory.buildRAttribute((Attribute)it);
        Functions.Function1 _function_1 = it -> it.getRMetaAnnotatedType().hasMeta();
        Iterable _filter = IterableExtensions.filter((Iterable)ListExtensions.map((List)EcoreUtil2.eAllOfType((EObject)model, Attribute.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (RAttribute attr : _filter) {
            DottedPath targetModel = attr.getRMetaAnnotatedType().getRType().getNamespace();
            RosettaJavaPackages.RootPackage targetPackage = new RosettaJavaPackages.RootPackage(targetModel);
            JavaClass<?> metaJt = this._javaTypeTranslator.toForcedMetaItemJavaType(attr);
            boolean _isCanceled_1 = ctx.getCancelIndicator().isCanceled();
            if (_isCanceled_1) {
                return;
            }
            if (metaJt instanceof RJavaReferenceWithMeta) {
                StringConcatenation _builder = new StringConcatenation();
                String _withForwardSlashes = ((RJavaReferenceWithMeta)metaJt).getCanonicalName().withForwardSlashes();
                _builder.append(_withForwardSlashes);
                _builder.append(".java");
                fsa.generateFile(_builder.toString(), (CharSequence)this.referenceWithMeta(targetPackage, (RJavaReferenceWithMeta)metaJt, attr.getRMetaAnnotatedType().getRType()));
                continue;
            }
            if (metaJt instanceof RJavaFieldWithMeta) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _withForwardSlashes_1 = ((RJavaFieldWithMeta)metaJt).getCanonicalName().withForwardSlashes();
                _builder_1.append(_withForwardSlashes_1);
                _builder_1.append(".java");
                fsa.generateFile(_builder_1.toString(), this.fieldWithMeta(targetPackage, (RJavaFieldWithMeta)metaJt, attr.getRMetaAnnotatedType().getRType()));
                continue;
            }
            throw new UnsupportedOperationException("Invalid JavaType: " + String.valueOf(metaJt));
        }
    }

    private CharSequence fieldWithMeta(RosettaJavaPackages.RootPackage root, final RJavaFieldWithMeta metaJavaType, RType valueType) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        DottedPath _packageName = metaJavaType.getPackageName();
        final JavaScope scope = new JavaScope(_packageName);
        StringConcatenationClient body = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                DottedPath _packageName = metaJavaType.getPackageName();
                String _simpleName = metaJavaType.getSimpleName();
                String _plus = _simpleName + "Meta";
                GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_packageName, _plus, Object.class);
                StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(metaJavaType, scope, (JavaClass<?>)_generatedJavaClass, "1");
                _builder.append((Object)_classBody);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"class ");
                String _simpleName_1 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_1);
                _builder.append((Object)"Meta extends ");
                _builder.append(BasicRosettaMetaData.class);
                _builder.append((Object)"<");
                String _simpleName_2 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_2);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(metaJavaType.getPackageName(), body, scope);
        return _xblockexpression;
    }

    private String referenceWithMeta(final RosettaJavaPackages.RootPackage root, final RJavaReferenceWithMeta metaJavaType, RType valueType) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        DottedPath _metaField = root.metaField();
        final JavaScope scope = new JavaScope(_metaField);
        StringConcatenationClient body = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                DottedPath _metaField = root.metaField();
                String _simpleName = metaJavaType.getSimpleName();
                String _plus = _simpleName + "Meta";
                GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_metaField, _plus, Object.class);
                StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(metaJavaType, scope, (JavaClass<?>)_generatedJavaClass, "1");
                _builder.append((Object)_classBody);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"class ");
                String _simpleName_1 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_1);
                _builder.append((Object)"Meta extends ");
                _builder.append(BasicRosettaMetaData.class);
                _builder.append((Object)"<");
                String _simpleName_2 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_2);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(root.metaField(), body, scope);
        return _xblockexpression;
    }

    private static class MarkerAdapterFactory
    extends AdapterFactoryImpl {
        private final String namespace;

        public MarkerAdapterFactory(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

