/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.expression.TypeCoercionService;
import com.regnosys.rosetta.generator.java.object.ModelObjectBoilerPlate;
import com.regnosys.rosetta.generator.java.object.ModelObjectBuilderGenerator;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.types.RDataType;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeKey;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ModelObjectGenerator {
    @Inject
    @Extension
    private ModelObjectBoilerPlate _modelObjectBoilerPlate;
    @Inject
    @Extension
    private ModelObjectBuilderGenerator _modelObjectBuilderGenerator;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private TypeCoercionService _typeCoercionService;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, RDataType t, String version) {
        String _name = t.getName();
        String _plus = _name + ".java";
        fsa.generateFile(root.child(_plus).withForwardSlashes(), (CharSequence)this.generateRosettaClass(root, t, version));
    }

    private String generateRosettaClass(RosettaJavaPackages.RootPackage root, RDataType t, String version) {
        String _xblockexpression = null;
        JavaScope scope = new JavaScope(root);
        JavaPojoInterface javaType = this._javaTypeTranslator.toJavaReferenceType(t);
        DottedPath _meta = root.meta();
        String _name = t.getName();
        String _plus = _name + "Meta";
        GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_meta, _plus, Object.class);
        _xblockexpression = this._importManagerExtension.buildClass(root, this.classBody(javaType, scope, (JavaClass<?>)_generatedJavaClass, version), scope);
        return _xblockexpression;
    }

    public StringConcatenationClient classBody(final JavaPojoInterface javaType, JavaScope scope, final JavaClass<?> metaType, String version) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaPojoInterface superInterface = javaType.getSuperPojo();
        final boolean extendSuperImpl = superInterface != null && IterableExtensions.forall(javaType.getOwnProperties(), it -> it.isCompatibleWithParent());
        final JavaScope interfaceScope = scope.classScope(javaType.toString());
        final GeneratedIdentifier metaDataIdentifier = interfaceScope.createUniqueIdentifier("metaData");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)javaType);
        _builder.append("Builder");
        final JavaScope builderScope = interfaceScope.classScope(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)javaType);
        _builder_1.append("Impl");
        final JavaScope implScope = interfaceScope.classScope(_builder_1.toString());
        final String modelShortName = javaType.getPackageName().first();
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _javadoc = javaType.getJavadoc();
                _builder.append((Object)_javadoc);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RosettaDataType.class);
                _builder.append((Object)"(value=\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName);
                _builder.append((Object)"\", builder=");
                JavaClass<?> _builderImplType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderImplType(javaType);
                _builder.append(_builderImplType);
                _builder.append((Object)".class, version=\"");
                String _version = javaType.getVersion();
                _builder.append((Object)_version);
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RuneDataType.class);
                _builder.append((Object)"(value=\"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1);
                _builder.append((Object)"\", model=\"");
                _builder.append((Object)modelShortName);
                _builder.append((Object)"\", builder=");
                JavaClass<?> _builderImplType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderImplType(javaType);
                _builder.append(_builderImplType_1);
                _builder.append((Object)".class, version=\"");
                String _version_1 = javaType.getVersion();
                _builder.append((Object)_version_1);
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public interface ");
                _builder.append((Object)javaType);
                _builder.append((Object)" extends ");
                StringConcatenationClient _implementsClause = ModelObjectGenerator.this._modelObjectBoilerPlate.implementsClause(javaType);
                _builder.append((Object)_implementsClause);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)metaType, "\t");
                _builder.append((Object)" ");
                _builder.append((Object)metaDataIdentifier, "\t");
                _builder.append((Object)" = new ");
                _builder.append((Object)metaType, "\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenationClient _startComment = ModelObjectGenerator.this.startComment("Getter Methods");
                _builder.append((Object)_startComment, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                StringConcatenationClient _pojoInterfaceGetterMethods = ModelObjectGenerator.this.pojoInterfaceGetterMethods(javaType);
                _builder.append((Object)_pojoInterfaceGetterMethods, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenationClient _startComment_1 = ModelObjectGenerator.this.startComment("Build Methods");
                _builder.append((Object)_startComment_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                StringConcatenationClient _pojoInterfaceBuilderMethods = ModelObjectGenerator.this.pojoInterfaceBuilderMethods(javaType);
                _builder.append((Object)_pojoInterfaceBuilderMethods, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenationClient _startComment_2 = ModelObjectGenerator.this.startComment("Utility Methods");
                _builder.append((Object)_startComment_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                StringConcatenationClient _pojoInterfaceDefaultOverridenMethods = ModelObjectGenerator.this.pojoInterfaceDefaultOverridenMethods(javaType, metaDataIdentifier);
                _builder.append((Object)_pojoInterfaceDefaultOverridenMethods, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenationClient _startComment_3 = ModelObjectGenerator.this.startComment("Builder Interface");
                _builder.append((Object)_startComment_3, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"interface ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"Builder extends ");
                _builder.append((Object)javaType, "\t");
                List _interfaces = javaType.getInterfaces();
                boolean _hasElements = false;
                for (JavaClass inter : _interfaces) {
                    if (!_hasElements) {
                        _hasElements = true;
                        _builder.append((Object)", ", "\t");
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(inter);
                    _builder.append(_builderType, "\t");
                }
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _pojoBuilderInterfaceGetterMethods = ModelObjectGenerator.this.pojoBuilderInterfaceGetterMethods(javaType, builderScope);
                _builder.append((Object)_pojoBuilderInterfaceGetterMethods, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _pojoBuilderInterfaceSetterMethods = ModelObjectGenerator.this.pojoBuilderInterfaceSetterMethods(javaType, javaType, builderScope);
                _builder.append((Object)_pojoBuilderInterfaceSetterMethods, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _builderProcessMethod = ModelObjectGenerator.this._modelObjectBoilerPlate.builderProcessMethod(javaType);
                _builder.append((Object)_builderProcessMethod, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_1, "\t\t");
                _builder.append((Object)" prune();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Immutable Implementation of ");
                String _simpleName = javaType.getSimpleName();
                _builder_1.append(_simpleName);
                StringConcatenationClient _startComment_4 = ModelObjectGenerator.this.startComment(_builder_1.toString());
                _builder.append((Object)_startComment_4, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"class ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"Impl ");
                if (extendSuperImpl) {
                    _builder.append((Object)"extends ");
                    JavaClass<?> _implType = ModelObjectGenerator.this._javaTypeTranslator.toImplType(superInterface);
                    _builder.append(_implType, "\t");
                    _builder.append((Object)" ");
                }
                _builder.append((Object)"implements ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _rosettaClass = ModelObjectGenerator.this.rosettaClass(javaType, extendSuperImpl, implScope);
                _builder.append((Object)_rosettaClass, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _boilerPlate = ModelObjectGenerator.this._modelObjectBoilerPlate.boilerPlate(javaType, extendSuperImpl, implScope);
                _builder.append((Object)_boilerPlate, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Builder Implementation of ");
                String _simpleName_1 = javaType.getSimpleName();
                _builder_2.append(_simpleName_1);
                StringConcatenationClient _startComment_5 = ModelObjectGenerator.this.startComment(_builder_2.toString());
                _builder.append((Object)_startComment_5, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                StringConcatenationClient _builderClass = ModelObjectGenerator.this._modelObjectBuilderGenerator.builderClass(javaType, interfaceScope);
                _builder.append((Object)_builderClass, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    protected StringConcatenationClient pojoBuilderInterfaceGetterMethods(final JavaPojoInterface javaType, JavaScope builderScope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Collection<JavaPojoProperty> _ownProperties = javaType.getOwnProperties();
                for (JavaPojoProperty prop : _ownProperties) {
                    boolean _not;
                    boolean _isRosettaModelObject = ModelObjectGenerator.this._javaTypeTranslator.isRosettaModelObject(prop.getType());
                    if (!_isRosettaModelObject) continue;
                    boolean _isList = ModelObjectGenerator.this._javaTypeUtil.isList(prop.getType());
                    boolean bl = _not = !_isList;
                    if (_not) {
                        JavaType _builderTypeSingle = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(prop);
                        _builder.append((Object)_builderTypeSingle);
                        _builder.append((Object)" ");
                        String _getOrCreateName = prop.getGetOrCreateName();
                        _builder.append((Object)_getOrCreateName);
                        _builder.append((Object)"();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"@Override");
                        _builder.newLine();
                        JavaType _builderTypeSingle_1 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(prop);
                        _builder.append((Object)_builderTypeSingle_1);
                        _builder.append((Object)" ");
                        String _getterName = prop.getGetterName();
                        _builder.append((Object)_getterName);
                        _builder.append((Object)"();");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    JavaType _builderTypeSingle_2 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(prop);
                    _builder.append((Object)_builderTypeSingle_2);
                    _builder.append((Object)" ");
                    String _getOrCreateName_1 = prop.getGetOrCreateName();
                    _builder.append((Object)_getOrCreateName_1);
                    _builder.append((Object)"(int _index);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append(List.class);
                    _builder.append((Object)"<? extends ");
                    JavaType _builderTypeSingle_3 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(prop);
                    _builder.append((Object)_builderTypeSingle_3);
                    _builder.append((Object)"> ");
                    String _getterName_1 = prop.getGetterName();
                    _builder.append((Object)_getterName_1);
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    protected StringConcatenationClient pojoBuilderInterfaceSetterMethods(final JavaPojoInterface mainType, final JavaPojoInterface currentType, final JavaScope builderScope) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final boolean isMainPojo = Objects.equals((Object)mainType, (Object)currentType);
        final JavaClass<?> builderType = this._javaTypeTranslator.toBuilderType(mainType);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _tripleNotEquals;
                JavaPojoInterface _superPojo = currentType.getSuperPojo();
                boolean bl = _tripleNotEquals = _superPojo != null;
                if (_tripleNotEquals) {
                    StringConcatenationClient _pojoBuilderInterfaceSetterMethods = ModelObjectGenerator.this.pojoBuilderInterfaceSetterMethods(mainType, currentType.getSuperPojo(), builderScope);
                    _builder.append((Object)_pojoBuilderInterfaceSetterMethods);
                }
                _builder.newLineIfNotEmpty();
                Collection<JavaPojoProperty> _ownProperties = currentType.getOwnProperties();
                for (JavaPojoProperty prop : _ownProperties) {
                    boolean _not;
                    String _firstUpper = StringExtensions.toFirstUpper((String)prop.getName());
                    String setMethodName = "set" + _firstUpper;
                    _builder.newLineIfNotEmpty();
                    String setValueMethodName = setMethodName + "Value";
                    _builder.newLineIfNotEmpty();
                    JavaType propType = prop.getType();
                    _builder.newLineIfNotEmpty();
                    boolean _isList = ModelObjectGenerator.this._javaTypeUtil.isList(propType);
                    boolean bl2 = _not = !_isList;
                    if (_not) {
                        if (!isMainPojo) {
                            _builder.append((Object)"@Override");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)builderType);
                        _builder.append((Object)" ");
                        _builder.append((Object)setMethodName);
                        _builder.append((Object)"(");
                        _builder.append((Object)propType);
                        _builder.append((Object)" ");
                        GeneratedIdentifier _createUniqueIdentifier = builderScope.methodScope(setMethodName).createUniqueIdentifier(prop.getName());
                        _builder.append((Object)_createUniqueIdentifier);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        if (!(propType instanceof RJavaWithMetaValue)) continue;
                        if (!isMainPojo) {
                            _builder.append((Object)"@Override");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)builderType);
                        _builder.append((Object)" ");
                        _builder.append((Object)setValueMethodName);
                        _builder.append((Object)"(");
                        JavaReferenceType _valueType = ((RJavaWithMetaValue)propType).getValueType();
                        _builder.append((Object)_valueType);
                        _builder.append((Object)" ");
                        GeneratedIdentifier _createUniqueIdentifier_1 = builderScope.methodScope(setValueMethodName).createUniqueIdentifier(prop.getName());
                        _builder.append((Object)_createUniqueIdentifier_1);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String setMultiMethodName = prop.getSetterName();
                    _builder.newLineIfNotEmpty();
                    String setMultiValueMethodName = prop.getValueSetterName();
                    _builder.newLineIfNotEmpty();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)prop.getName());
                    String addMethodName = "add" + _firstUpper_1;
                    _builder.newLineIfNotEmpty();
                    String addValueMethodName = addMethodName + "Value";
                    _builder.newLineIfNotEmpty();
                    String addMultiMethodName = prop.getAdderName();
                    _builder.newLineIfNotEmpty();
                    String addMultiValueMethodName = prop.getValueAdderName();
                    _builder.newLineIfNotEmpty();
                    JavaType itemType = ModelObjectGenerator.this._javaTypeUtil.getItemType(propType);
                    _builder.newLineIfNotEmpty();
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)addMethodName);
                    _builder.append((Object)"(");
                    _builder.append((Object)itemType);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_2 = builderScope.methodScope(addMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_2);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)addMethodName);
                    _builder.append((Object)"(");
                    _builder.append((Object)itemType);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_3 = builderScope.methodScope(addMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_3);
                    _builder.append((Object)", int _idx);");
                    _builder.newLineIfNotEmpty();
                    if (itemType instanceof RJavaWithMetaValue) {
                        if (!isMainPojo) {
                            _builder.append((Object)"@Override");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)builderType);
                        _builder.append((Object)" ");
                        _builder.append((Object)addValueMethodName);
                        _builder.append((Object)"(");
                        JavaReferenceType _valueType_1 = ((RJavaWithMetaValue)itemType).getValueType();
                        _builder.append((Object)_valueType_1);
                        _builder.append((Object)" ");
                        GeneratedIdentifier _createUniqueIdentifier_4 = builderScope.methodScope(addValueMethodName).createUniqueIdentifier(prop.getName());
                        _builder.append((Object)_createUniqueIdentifier_4);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        if (!isMainPojo) {
                            _builder.append((Object)"@Override");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)builderType);
                        _builder.append((Object)" ");
                        _builder.append((Object)addValueMethodName);
                        _builder.append((Object)"(");
                        JavaReferenceType _valueType_2 = ((RJavaWithMetaValue)itemType).getValueType();
                        _builder.append((Object)_valueType_2);
                        _builder.append((Object)" ");
                        GeneratedIdentifier _createUniqueIdentifier_5 = builderScope.methodScope(addValueMethodName).createUniqueIdentifier(prop.getName());
                        _builder.append((Object)_createUniqueIdentifier_5);
                        _builder.append((Object)", int _idx);");
                        _builder.newLineIfNotEmpty();
                    }
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)addMultiMethodName);
                    _builder.append((Object)"(");
                    _builder.append((Object)propType);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_6 = builderScope.methodScope(addMultiMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_6);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)setMultiMethodName);
                    _builder.append((Object)"(");
                    _builder.append((Object)propType);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_7 = builderScope.methodScope(setMultiMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_7);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    if (!(itemType instanceof RJavaWithMetaValue)) continue;
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)addMultiValueMethodName);
                    _builder.append((Object)"(");
                    JavaParameterizedType<List<?>> _wrapExtends = ModelObjectGenerator.this._javaTypeUtil.wrapExtends(ModelObjectGenerator.this._javaTypeUtil.LIST, (JavaType)((RJavaWithMetaValue)itemType).getValueType());
                    _builder.append(_wrapExtends);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_8 = builderScope.methodScope(addMultiValueMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_8);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    if (!isMainPojo) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)builderType);
                    _builder.append((Object)" ");
                    _builder.append((Object)setMultiValueMethodName);
                    _builder.append((Object)"(");
                    JavaParameterizedType<List<?>> _wrapExtends_1 = ModelObjectGenerator.this._javaTypeUtil.wrapExtends(ModelObjectGenerator.this._javaTypeUtil.LIST, (JavaType)((RJavaWithMetaValue)itemType).getValueType());
                    _builder.append(_wrapExtends_1);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createUniqueIdentifier_9 = builderScope.methodScope(setMultiValueMethodName).createUniqueIdentifier(prop.getName());
                    _builder.append((Object)_createUniqueIdentifier_9);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _xblockexpression;
    }

    protected StringConcatenationClient pojoInterfaceDefaultOverridenMethods(final JavaPojoInterface javaType, final GeneratedIdentifier metaDataIdentifier) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"default ");
                _builder.append(RosettaMetaData.class);
                _builder.append((Object)"<? extends ");
                _builder.append((Object)javaType);
                _builder.append((Object)"> metaData() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                _builder.append((Object)metaDataIdentifier, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"@");
                _builder.append(RuneAttribute.class);
                _builder.append((Object)"(\"@type\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"default Class<? extends ");
                _builder.append((Object)javaType);
                _builder.append((Object)"> getType() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)".class;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                if (javaType instanceof RJavaWithMetaValue) {
                    _builder.newLine();
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"default Class<");
                    JavaReferenceType _valueType = ((RJavaWithMetaValue)javaType).getValueType();
                    _builder.append((Object)_valueType);
                    _builder.append((Object)"> getValueType() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    JavaReferenceType _valueType_1 = ((RJavaWithMetaValue)javaType).getValueType();
                    _builder.append((Object)_valueType_1, "\t");
                    _builder.append((Object)".class;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.newLine();
                StringConcatenationClient _processMethod = ModelObjectGenerator.this._modelObjectBoilerPlate.processMethod(javaType);
                _builder.append((Object)_processMethod);
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }

    protected StringConcatenationClient pojoInterfaceGetterMethods(final JavaPojoInterface javaType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Collection<JavaPojoProperty> _ownProperties = javaType.getOwnProperties();
                for (JavaPojoProperty prop : _ownProperties) {
                    String _javadoc = prop.getJavadoc();
                    _builder.append((Object)_javadoc);
                    _builder.newLineIfNotEmpty();
                    if (prop.getParentProperty() != null && Objects.equals(prop.getGetterName(), prop.getParentProperty().getGetterName())) {
                        _builder.append((Object)"@Override");
                    }
                    _builder.newLineIfNotEmpty();
                    JavaType _type = prop.getType();
                    _builder.append((Object)_type);
                    _builder.append((Object)" ");
                    String _getterName = prop.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    protected StringConcatenationClient pojoInterfaceBuilderMethods(final JavaClass<?> javaType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)javaType);
                _builder.append((Object)" build();");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType);
                _builder.append((Object)" toBuilder();");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"static ");
                JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_1);
                _builder.append((Object)" builder() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return new ");
                JavaClass<?> _builderImplType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderImplType(javaType);
                _builder.append(_builderImplType, "\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public boolean globalKeyRecursive(RDataType class1) {
        boolean _hasMetaAttribute = class1.hasMetaAttribute("key");
        if (_hasMetaAttribute) {
            return true;
        }
        RDataType s = class1.getSuperType();
        if (s != null) {
            return this.globalKeyRecursive(s);
        }
        return false;
    }

    private StringConcatenationClient rosettaClass(final JavaPojoInterface javaType, final boolean extended, final JavaScope scope) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        Collection<JavaPojoProperty> _xifexpression = null;
        _xifexpression = extended ? javaType.getOwnProperties() : javaType.getAllProperties();
        final Collection<JavaPojoProperty> properties = _xifexpression;
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                for (Iterator prop : properties) {
                    _builder.append((Object)"private final ");
                    JavaType _type = ((JavaPojoProperty)((Object)prop)).getType();
                    _builder.append((Object)_type);
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createIdentifier = scope.createIdentifier(prop, StringExtensions.toFirstLower((String)((JavaPojoProperty)((Object)prop)).getName()));
                    _builder.append((Object)_createIdentifier);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)"protected ");
                _builder.append((Object)javaType);
                _builder.append((Object)"Impl(");
                JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType);
                _builder.append((Object)" builder) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                if (extended) {
                    _builder.append((Object)"super(builder);");
                }
                _builder.newLineIfNotEmpty();
                for (JavaPojoProperty prop_1 : properties) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"this.");
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(prop_1);
                    _builder.append((Object)_identifierOrThrow, "\t");
                    _builder.append((Object)" = ");
                    StringConcatenationClient _propertyFromBuilder = ModelObjectGenerator.this.propertyFromBuilder(prop_1);
                    _builder.append((Object)_propertyFromBuilder, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                for (JavaPojoProperty prop_2 : properties) {
                    GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(prop_2);
                    JavaType _type_1 = prop_2.getType();
                    JavaVariable field = new JavaVariable(_identifierOrThrow_1, _type_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"@");
                    _builder.append(RosettaAttribute.class);
                    _builder.append((Object)"(\"");
                    String _javaAnnotation = ModelObjectGenerator.this._modelObjectBoilerPlate.javaAnnotation(prop_2);
                    _builder.append((Object)_javaAnnotation);
                    _builder.append((Object)"\")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"@");
                    _builder.append(RuneAttribute.class);
                    _builder.append((Object)"(\"");
                    String _javaRuneAnnotation = ModelObjectGenerator.this._modelObjectBoilerPlate.javaRuneAnnotation(prop_2);
                    _builder.append((Object)_javaRuneAnnotation);
                    _builder.append((Object)"\")");
                    _builder.newLineIfNotEmpty();
                    boolean _isScopedReference = ModelObjectGenerator.this._modelObjectBoilerPlate.isScopedReference(prop_2);
                    if (_isScopedReference) {
                        _builder.append((Object)"@");
                        _builder.append(RuneScopedAttributeReference.class);
                    }
                    _builder.newLineIfNotEmpty();
                    boolean _isScopedKey = ModelObjectGenerator.this._modelObjectBoilerPlate.isScopedKey(prop_2);
                    if (_isScopedKey) {
                        _builder.append((Object)"@");
                        _builder.append(RuneScopedAttributeKey.class);
                    }
                    _builder.newLineIfNotEmpty();
                    boolean _addRuneMetaAnnotation = ModelObjectGenerator.this._modelObjectBoilerPlate.addRuneMetaAnnotation(prop_2);
                    if (_addRuneMetaAnnotation) {
                        _builder.append((Object)"@");
                        _builder.append(RuneMetaType.class);
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"public ");
                    JavaType _type_2 = prop_2.getType();
                    _builder.append((Object)_type_2);
                    _builder.append((Object)" ");
                    String _getterName = prop_2.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"() ");
                    JavaBlock _block = field.completeAsReturn().toBlock();
                    _builder.append((Object)_block);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    if (!extended) {
                        StringConcatenationClient _derivedIncompatibleGettersForProperty = ModelObjectGenerator.this.derivedIncompatibleGettersForProperty(field, prop_2, scope);
                        _builder.append((Object)_derivedIncompatibleGettersForProperty);
                    }
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"public ");
                _builder.append((Object)javaType);
                _builder.append((Object)" build() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return this;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"public ");
                JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_1);
                _builder.append((Object)" toBuilder() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                JavaClass<?> _builderType_2 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_2, "\t");
                _builder.append((Object)" builder = builder();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"setBuilderFields(builder);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return builder;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"protected void setBuilderFields(");
                JavaClass<?> _builderType_3 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_3);
                _builder.append((Object)" builder) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                if (extended) {
                    _builder.append((Object)"super.setBuilderFields(builder);");
                }
                _builder.newLineIfNotEmpty();
                for (JavaPojoProperty prop_3 : properties) {
                    _builder.append((Object)"\t");
                    Method _method = ModelObjectGenerator.this._importManagerExtension.method(Optional.class, "ofNullable");
                    _builder.append((Object)_method, "\t");
                    _builder.append((Object)"(");
                    String _getterName_1 = prop_3.getGetterName();
                    _builder.append((Object)_getterName_1, "\t");
                    _builder.append((Object)"()).ifPresent(builder::");
                    String _setterName = prop_3.getSetterName();
                    _builder.append((Object)_setterName, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient derivedIncompatibleGettersForProperty(final JavaExpression originalField, JavaPojoProperty prop, final JavaScope scope) {
        StringConcatenationClient _client;
        String _getterName_1;
        StringConcatenationClient _xblockexpression = null;
        final JavaPojoProperty parent = prop.getParentProperty();
        if (parent == null) {
            return null;
        }
        String _getterName = parent.getGetterName();
        boolean _equals = Objects.equals(_getterName, _getterName_1 = prop.getGetterName());
        if (_equals) {
            return this.derivedIncompatibleGettersForProperty(originalField, parent, scope);
        }
        final JavaScope getterScope = scope.methodScope(parent.getGetterName());
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"@");
                _builder.append(RosettaIgnore.class);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public ");
                JavaType _type = parent.getType();
                _builder.append((Object)_type);
                _builder.append((Object)" ");
                String _getterName = parent.getGetterName();
                _builder.append((Object)_getterName);
                _builder.append((Object)"() ");
                JavaBlock _block = ModelObjectGenerator.this._typeCoercionService.addCoercions(originalField, parent.getType(), getterScope).completeAsReturn().toBlock();
                _builder.append((Object)_block);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                StringConcatenationClient _derivedIncompatibleGettersForProperty = ModelObjectGenerator.this.derivedIncompatibleGettersForProperty(originalField, parent, scope);
                _builder.append((Object)_derivedIncompatibleGettersForProperty);
                _builder.newLineIfNotEmpty();
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient propertyFromBuilder(final JavaPojoProperty prop) {
        StringConcatenationClient _xifexpression = null;
        boolean _isRosettaModelObject = this._javaTypeTranslator.isRosettaModelObject(prop.getType());
        if (_isRosettaModelObject) {
            StringConcatenationClient _client_1;
            StringConcatenationClient _client;
            StringConcatenationClient _xifexpression_1 = null;
            boolean _isList = this._javaTypeUtil.isList(prop.getType());
            _xifexpression_1 = _isList ? (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"ofNullable(builder.");
                    String _getterName = prop.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"()).filter(_l->!_l.isEmpty()).map(");
                    StringConcatenationClient _buildRosettaObjectList = ModelObjectGenerator.this.buildRosettaObjectList(prop);
                    _builder.append((Object)_buildRosettaObjectList);
                    _builder.append((Object)").orElse(null)");
                }
            }) : (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"ofNullable(builder.");
                    String _getterName = prop.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"()).map(f->f.build()).orElse(null)");
                }
            });
            _xifexpression = _xifexpression_1;
        } else {
            StringConcatenationClient _client_3;
            StringConcatenationClient _client_2;
            StringConcatenationClient _xifexpression_2 = null;
            boolean _isList_1 = this._javaTypeUtil.isList(prop.getType());
            boolean _not = !_isList_1;
            _xifexpression_2 = _not ? (_client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"builder.");
                    String _getterName = prop.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"()");
                }
            }) : (_client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"ofNullable(builder.");
                    String _getterName = prop.getGetterName();
                    _builder.append((Object)_getterName);
                    _builder.append((Object)"()).filter(_l->!_l.isEmpty()).map(");
                    _builder.append(ImmutableList.class);
                    _builder.append((Object)"::copyOf).orElse(null)");
                }
            });
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    private StringConcatenationClient buildRosettaObjectList(JavaPojoProperty prop) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"list -> list.stream().filter(");
                _builder.append(Objects.class);
                _builder.append((Object)"::nonNull).map(f->f.build()).filter(");
                _builder.append(Objects.class);
                _builder.append((Object)"::nonNull).collect(");
                _builder.append(ImmutableList.class);
                _builder.append((Object)".toImmutableList())");
            }
        };
        return _client;
    }

    private StringConcatenationClient startComment(final String msg) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/*********************** ");
                _builder.append((Object)msg);
                _builder.append((Object)"  ***********************/");
            }
        };
        return _client;
    }
}

