/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.expression.InterpreterValueJavaConverter;
import com.regnosys.rosetta.generator.java.expression.TypeCoercionService;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.statement.JavaForLoop;
import com.regnosys.rosetta.generator.java.statement.JavaLocalVariableDeclarationStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatementList;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaConditionInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.types.AliasHierarchy;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ValidatorsGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    @Extension
    private RBuiltinTypeService _rBuiltinTypeService;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;
    @Inject
    @Extension
    private InterpreterValueJavaConverter _interpreterValueJavaConverter;
    @Inject
    @Extension
    private TypeCoercionService _typeCoercionService;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, RDataType type, String version) {
        JavaPojoInterface javaType = this._javaTypeTranslator.toJavaReferenceType(type);
        Collection<RAttribute> attrs = type.getAllAttributes();
        String _withForwardSlashes = this._javaTypeTranslator.toValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)this.generateClass(root, javaType, attrs, version));
        String _withForwardSlashes_1 = this._javaTypeTranslator.toTypeFormatValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus_1 = _withForwardSlashes_1 + ".java";
        fsa.generateFile(_plus_1, (CharSequence)this.generateTypeFormatValidator(root, javaType, attrs, version));
        String _withForwardSlashes_2 = this._javaTypeTranslator.toOnlyExistsValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus_2 = _withForwardSlashes_2 + ".java";
        fsa.generateFile(_plus_2, (CharSequence)this.generateOnlyExistsValidator(root, javaType, attrs, version));
    }

    private String generateClass(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _typeValidation = root.typeValidation();
        JavaScope scope = new JavaScope(_typeValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.classBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private String generateTypeFormatValidator(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _typeValidation = root.typeValidation();
        JavaScope scope = new JavaScope(_typeValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.typeFormatClassBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private String generateOnlyExistsValidator(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _existsValidation = root.existsValidation();
        JavaScope scope = new JavaScope(_existsValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.existsValidation(), this.onlyExistsClassBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private StringConcatenationClient classBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                JavaClass<?> _validatorClass = ValidatorsGenerator.this._javaTypeTranslator.toValidatorClass(javaType);
                _builder.append(_validatorClass);
                _builder.append((Object)" implements ");
                _builder.append(Validator.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ComparisonResult.class, "\t");
                _builder.append((Object)"> getComparisonResults(");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Lists.class, "\t\t");
                _builder.append((Object)".<");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)">newArrayList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> ValidatorsGenerator.this.checkCardinality(javaType, (RAttribute)it);
                Functions.Function1 _function_1 = it -> it != null;
                Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)attributes, (Functions.Function1)_function), (Functions.Function1)_function_1);
                boolean _hasElements = false;
                for (StringConcatenationClient attrCheck : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)attrCheck, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"if (!");
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method, "\t\t\t\t");
                _builder.append((Object)"(res.getError())) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_1, "\t\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t\t\t");
                _builder.append((Object)"\", path, \"\", res.getError());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_2, "\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"})");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                _builder.append((Object)_method_3, "\t\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient typeFormatClassBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaClass<?> validatorClass = this._javaTypeTranslator.toTypeFormatValidatorClass(javaType);
        DottedPath _packageName = validatorClass.getPackageName();
        JavaScope packageScope = new JavaScope(_packageName);
        final JavaScope classScope = packageScope.classScope(validatorClass.getSimpleName());
        final GeneratedIdentifier pathId = classScope.createUniqueIdentifier("path");
        Functions.Function1 _function = it -> {
            AliasHierarchy _computeAliasHierarchy = this._typeSystem.computeAliasHierarchy(it.getRMetaAnnotatedType().getRType());
            return Pair.of((Object)it, (Object)_computeAliasHierarchy);
        };
        Functions.Function1 _function_1 = it -> (RAttribute)it.getKey();
        Functions.Function1 _function_2 = it -> (AliasHierarchy)it.getValue();
        final Map aliasHierarchyPerAttribute = IterableExtensions.toMap((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function), (Functions.Function1)_function_1, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.getAliases();
        Functions.Function1 _function_4 = it -> it.getConditions();
        Functions.Function1 _function_5 = it -> this._javaTypeTranslator.toConditionJavaClass((Condition)it);
        final Set conditionDependencies = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap(aliasHierarchyPerAttribute.values(), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        JavaScope runConditionsScope = classScope.methodScope("runConditions");
        final GeneratedIdentifier instanceId = runConditionsScope.createUniqueIdentifier("o");
        final JavaVariable instanceVar = new JavaVariable(instanceId, (JavaType)javaType);
        final GeneratedIdentifier resultsId = runConditionsScope.createUniqueIdentifier("results");
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                _builder.append((Object)"public class ");
                _builder.append((Object)validatorClass);
                _builder.append((Object)" implements ");
                _builder.append(Validator.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                for (JavaConditionInterface dep : conditionDependencies) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(javax.inject.Inject.class, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"protected ");
                    _builder.append((Object)dep, "\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _createIdentifier = classScope.createIdentifier(ValidatorsGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dep), StringExtensions.toFirstLower((String)dep.getSimpleName()));
                    _builder.append((Object)_createIdentifier, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ComparisonResult.class, "\t");
                _builder.append((Object)"> getComparisonResults(");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Lists.class, "\t\t");
                _builder.append((Object)".<");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)">newArrayList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> ValidatorsGenerator.this.checkTypeFormat(javaType, (RAttribute)it);
                Iterable _flatMap = IterableExtensions.flatMap((Iterable)attributes, (Functions.Function1)_function);
                boolean _hasElements = false;
                for (Object attrCheck : _flatMap) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append(attrCheck, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                boolean _isEmpty = conditionDependencies.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"private ");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(ValidationResult.class, "\t");
                    _builder.append((Object)"<?>> runConditions(");
                    _builder.append(RosettaPath.class, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)pathId, "\t");
                    _builder.append((Object)", ");
                    _builder.append((Object)javaType, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)instanceId, "\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append(List.class, "\t\t");
                    _builder.append((Object)"<");
                    _builder.append(ValidationResult.class, "\t\t");
                    _builder.append((Object)"<?>> ");
                    _builder.append((Object)resultsId, "\t\t");
                    _builder.append((Object)" = new ");
                    _builder.append(ArrayList.class, "\t\t");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_1 = it -> ValidatorsGenerator.this.checkTypeConditions(javaType, (RAttribute)it, (AliasHierarchy)aliasHierarchyPerAttribute.get(it), pathId, instanceVar, resultsId, classScope);
                    Iterable _map = IterableExtensions.map((Iterable)attributes, (Functions.Function1)_function_1);
                    for (JavaStatement condCheck : _map) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        JavaStatementList _asStatementList = condCheck.asStatementList();
                        _builder.append((Object)_asStatementList, "\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    _builder.append((Object)resultsId, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" ");
                _builder.append((Object)pathId, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = conditionDependencies.isEmpty();
                if (_isEmpty_1) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return getComparisonResults(o)");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)".stream()");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)".map(res -> {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"if (!");
                    Method _method = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                    _builder.append((Object)_method, "\t\t\t\t");
                    _builder.append((Object)"(res.getError())) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"return ");
                    Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                    _builder.append((Object)_method_1, "\t\t\t\t\t");
                    _builder.append((Object)"(\"");
                    String _rosettaName = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName, "\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                    _builder.append((Object)".TYPE_FORMAT, \"");
                    String _rosettaName_1 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_1, "\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append((Object)pathId, "\t\t\t\t\t");
                    _builder.append((Object)", \"\", res.getError());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                    _builder.append((Object)_method_2, "\t\t\t\t");
                    _builder.append((Object)"(\"");
                    String _rosettaName_2 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_2, "\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
                    _builder.append((Object)".TYPE_FORMAT, \"");
                    String _rosettaName_3 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_3, "\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append((Object)pathId, "\t\t\t\t");
                    _builder.append((Object)", \"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"})");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)".collect(");
                    Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                    _builder.append((Object)_method_3, "\t\t\t");
                    _builder.append((Object)"());");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append(Streams.class, "\t\t");
                    _builder.append((Object)".concat(getComparisonResults(o)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)".stream()");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)".map(res -> {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"if (!");
                    Method _method_4 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                    _builder.append((Object)_method_4, "\t\t\t\t\t");
                    _builder.append((Object)"(res.getError())) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)"return ");
                    Method _method_5 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                    _builder.append((Object)_method_5, "\t\t\t\t\t\t");
                    _builder.append((Object)"(\"");
                    String _rosettaName_4 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_4, "\t\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t\t");
                    _builder.append((Object)".TYPE_FORMAT, \"");
                    String _rosettaName_5 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_5, "\t\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append((Object)pathId, "\t\t\t\t\t\t");
                    _builder.append((Object)", \"\", res.getError());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"return ");
                    Method _method_6 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                    _builder.append((Object)_method_6, "\t\t\t\t\t");
                    _builder.append((Object)"(\"");
                    String _rosettaName_6 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_6, "\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                    _builder.append((Object)".TYPE_FORMAT, \"");
                    String _rosettaName_7 = javaType.getRosettaName();
                    _builder.append((Object)_rosettaName_7, "\t\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append((Object)pathId, "\t\t\t\t\t");
                    _builder.append((Object)", \"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}),");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"runConditions(");
                    _builder.append((Object)pathId, "\t\t\t\t");
                    _builder.append((Object)", o).stream()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)")");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)".collect(");
                    Method _method_7 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                    _builder.append((Object)_method_7, "\t\t\t");
                    _builder.append((Object)"());");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient onlyExistsClassBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                JavaClass<?> _onlyExistsValidatorClass = ValidatorsGenerator.this._javaTypeTranslator.toOnlyExistsValidatorClass(javaType);
                _builder.append(_onlyExistsValidatorClass);
                _builder.append((Object)" implements ");
                _builder.append(ValidatorWithArg.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)", ");
                _builder.append(Set.class);
                _builder.append((Object)"<String>> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"/* Casting is required to ensure types are output to ensure recompilation in Rosetta */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public <T2 extends ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> ");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, T2 o, ");
                _builder.append(Set.class, "\t");
                _builder.append((Object)"<String> fields) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(Map.class, "\t\t");
                _builder.append((Object)"<String, Boolean> fieldExistenceMap = ");
                _builder.append(ImmutableMap.class, "\t\t");
                _builder.append((Object)".<String, Boolean>builder()");
                _builder.newLineIfNotEmpty();
                for (RAttribute attr : attributes) {
                    _builder.append((Object)"\t\t\t\t");
                    JavaPojoProperty prop = javaType.findProperty(attr.getName());
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"o");
                        }
                    };
                    JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)".put(\"");
                    String _name = prop.getName();
                    _builder.append((Object)_name, "\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ExistenceChecker.class, "\t\t\t\t");
                    _builder.append((Object)".isSet((");
                    JavaType _type = prop.getType();
                    _builder.append((Object)_type, "\t\t\t\t");
                    _builder.append((Object)") ");
                    _builder.append((Object)propCode, "\t\t\t\t");
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".build();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Find the fields that are set");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(Set.class, "\t\t");
                _builder.append((Object)"<String> setFields = fieldExistenceMap.entrySet().stream()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".filter(Map.Entry::getValue)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".map(Map.Entry::getKey)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".collect(");
                _builder.append(Collectors.class, "\t\t\t\t");
                _builder.append((Object)".toSet());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (setFields.equals(fields)) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method, "\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_1, "\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t");
                _builder.append((Object)"\", path, \"\",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"String.format(\"[%s] should only be set.  Set fields: %s\", fields, setFields));");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient checkCardinality(JavaPojoInterface javaType, final RAttribute attr) {
        StringConcatenationClient _xifexpression = null;
        RCardinality _cardinality = attr.getCardinality();
        boolean _equals = Objects.equals(_cardinality, RCardinality.UNBOUNDED);
        if (_equals) {
            _xifexpression = null;
        } else {
            StringConcatenationClient _client_1;
            StringConcatenationClient _xblockexpression = null;
            final JavaPojoProperty prop = javaType.findProperty(attr.getName());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"o");
                }
            };
            final JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
            _xifexpression = _xblockexpression = (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isMulti = attr.isMulti();
                    if (_isMulti) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", (");
                        JavaType _type = prop.getType();
                        _builder.append((Object)_type);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" == null ? 0 : ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)".size(), ");
                        int _min = attr.getCardinality().getMin();
                        _builder.append((Object)_min);
                        _builder.append((Object)", ");
                        Integer _orElse = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
                        _builder.append((Object)_method_1);
                        _builder.append((Object)"(\"");
                        String _name_1 = attr.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)"\", (");
                        JavaType _type_1 = prop.getType();
                        _builder.append((Object)_type_1);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" != null ? 1 : 0, ");
                        int _min_1 = attr.getCardinality().getMin();
                        _builder.append((Object)_min_1);
                        _builder.append((Object)", ");
                        Integer _orElse_1 = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse_1);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                }
            });
        }
        return _xifexpression;
    }

    private List<StringConcatenationClient> checkTypeFormat(final JavaPojoInterface javaType, final RAttribute attr) {
        ArrayList checks = CollectionLiterals.newArrayList();
        RType t = this._typeSystem.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
        if (t instanceof RStringType) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equals(t, this._rBuiltinTypeService.UNCONSTRAINED_STRING);
            if (_notEquals) {
                final int min = ((RStringType)t).getInterval().getMinBound();
                final StringConcatenationClient max = this.optional(((RStringType)t).getInterval().getMax());
                final StringConcatenationClient pattern = this.optionalPattern(((RStringType)t).getPattern());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkString");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        JavaExpression _attributeValue = ValidatorsGenerator.this.getAttributeValue(javaType, attr);
                        _builder.append((Object)_attributeValue);
                        _builder.append((Object)", ");
                        _builder.append((Object)min);
                        _builder.append((Object)", ");
                        _builder.append((Object)max);
                        _builder.append((Object)", ");
                        _builder.append((Object)pattern);
                        _builder.append((Object)")");
                    }
                };
                checks.add(_client);
            }
        } else if (t instanceof RNumberType) {
            boolean _notEquals_1;
            boolean bl = _notEquals_1 = !Objects.equals(t, this._rBuiltinTypeService.UNCONSTRAINED_NUMBER);
            if (_notEquals_1) {
                final StringConcatenationClient digits = this.optional(((RNumberType)t).getDigits());
                final StringConcatenationClient fractionalDigits = this.optional(((RNumberType)t).getFractionalDigits());
                final StringConcatenationClient min_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMin());
                final StringConcatenationClient max_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMax());
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkNumber");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        JavaExpression _attributeValue = ValidatorsGenerator.this.getAttributeValue(javaType, attr);
                        _builder.append((Object)_attributeValue);
                        _builder.append((Object)", ");
                        _builder.append((Object)digits);
                        _builder.append((Object)", ");
                        _builder.append((Object)fractionalDigits);
                        _builder.append((Object)", ");
                        _builder.append((Object)min_1);
                        _builder.append((Object)", ");
                        _builder.append((Object)max_1);
                        _builder.append((Object)")");
                    }
                };
                checks.add(_client_1);
            }
        }
        return checks;
    }

    private JavaStatement checkTypeConditions(JavaPojoInterface javaType, final RAttribute attr, AliasHierarchy hierarchy, final GeneratedIdentifier pathId, JavaVariable instanceVar, GeneratedIdentifier resultsId, JavaScope scope) {
        boolean _not_1;
        boolean _not;
        boolean _isMulti = attr.isMulti();
        boolean bl = _not = !_isMulti;
        if (_not) {
            JavaBlock conditionCalls = JavaBlock.EMPTY;
            List<RAliasType> _aliases = hierarchy.getAliases();
            for (RAliasType alias : _aliases) {
                List<Condition> _conditions = alias.getConditions();
                for (Condition condition : _conditions) {
                    JavaConditionInterface conditionClass = this._javaTypeTranslator.toConditionJavaClass(condition);
                    JavaPojoProperty prop = javaType.findProperty(attr.getName(), (JavaType)conditionClass.getInstanceClass());
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)pathId);
                            _builder.append((Object)".newSubPath(\"");
                            String _name = attr.getName();
                            _builder.append((Object)_name);
                            _builder.append((Object)"\")");
                        }
                    };
                    StringConcatenationClient _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"o");
                        }
                    };
                    conditionCalls = conditionCalls.append(this.addConditionValidationResultsCode(resultsId, _client, prop.applyGetter(JavaExpression.from(_client_1, (JavaType)javaType)), alias, conditionClass, scope));
                }
            }
            return conditionCalls;
        }
        Functions.Function1 _function = it -> it.getConditions();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.flatMap(hierarchy.getAliases(), (Functions.Function1)_function));
        boolean bl2 = _not_1 = !_isEmpty;
        if (_not_1) {
            JavaPojoProperty prop = javaType.findProperty(attr.getName());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"o");
                }
            };
            JavaExpression attrVarExpr = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
            final GeneratedIdentifier forIndex = scope.createUniqueIdentifier("i");
            Function<JavaExpression, JavaStatement> _function_1 = attrVar -> {
                JavaForLoop _xblockexpression = null;
                JavaBlock forBody = JavaBlock.EMPTY;
                List<RAliasType> _aliases_1 = hierarchy.getAliases();
                for (RAliasType alias_1 : _aliases_1) {
                    List<Condition> _conditions_1 = alias_1.getConditions();
                    for (Condition condition_1 : _conditions_1) {
                        StringConcatenationClient _client_1 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)pathId);
                                _builder.append((Object)".newSubPath(\"");
                                String _name = attr.getName();
                                _builder.append((Object)_name);
                                _builder.append((Object)"\").withIndex(");
                                _builder.append((Object)forIndex);
                                _builder.append((Object)")");
                            }
                        };
                        StringConcatenationClient _client_2 = new StringConcatenationClient((JavaExpression)attrVar, forIndex){
                            final /* synthetic */ JavaExpression val$attrVar;
                            final /* synthetic */ GeneratedIdentifier val$forIndex;
                            {
                                this.val$attrVar = javaExpression;
                                this.val$forIndex = generatedIdentifier;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$attrVar);
                                _builder.append((Object)".get(");
                                _builder.append((Object)this.val$forIndex);
                                _builder.append((Object)")");
                            }
                        };
                        forBody = forBody.append(this.addConditionValidationResultsCode(resultsId, _client_1, JavaExpression.from(_client_2, this._javaTypeUtil.getItemType(attrVar.getExpressionType())), alias_1, this._javaTypeTranslator.toConditionJavaClass(condition_1), scope));
                    }
                }
                StringConcatenationClient _client_3 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"0");
                    }
                };
                JavaExpression _from = JavaExpression.from(_client_3, (JavaType)JavaPrimitiveType.INT);
                JavaLocalVariableDeclarationStatement _javaLocalVariableDeclarationStatement = new JavaLocalVariableDeclarationStatement(false, (JavaType)JavaPrimitiveType.INT, forIndex, _from);
                StringConcatenationClient _client_4 = new StringConcatenationClient((JavaExpression)attrVar){
                    final /* synthetic */ JavaExpression val$attrVar;
                    {
                        this.val$attrVar = javaExpression;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)forIndex);
                        _builder.append((Object)" < ");
                        _builder.append((Object)this.val$attrVar);
                        _builder.append((Object)".size()");
                    }
                };
                JavaExpression _from_1 = JavaExpression.from(_client_4, (JavaType)JavaPrimitiveType.BOOLEAN);
                StringConcatenationClient _client_5 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)forIndex);
                        _builder.append((Object)"++");
                    }
                };
                JavaExpression _from_2 = JavaExpression.from(_client_5, (JavaType)JavaPrimitiveType.INT);
                _xblockexpression = new JavaForLoop(_javaLocalVariableDeclarationStatement, _from_1, _from_2, forBody);
                return _xblockexpression;
            };
            return attrVarExpr.declareAsVariable(true, attr.getName(), scope).complete(_function_1);
        }
        return JavaBlock.EMPTY;
    }

    private JavaStatement addConditionValidationResultsCode(final GeneratedIdentifier resultsId, StringConcatenationClient pathCode, JavaExpression attributeItemCode, RAliasType alias, JavaConditionInterface conditionClass, JavaScope scope) {
        final GeneratedIdentifier conditionVar = scope.getIdentifierOrThrow(this._javaIdentifierRepresentationService.toDependencyInstance(conditionClass));
        ArrayList arguments = CollectionLiterals.newArrayList();
        arguments.add(JavaExpression.from(pathCode, JavaType.from(RosettaPath.class)));
        arguments.add(this._typeCoercionService.addCoercions(attributeItemCode, (JavaType)conditionClass.getInstanceClass(), scope));
        BiConsumer<String, JavaType> _function = (param, type) -> arguments.add(this._typeCoercionService.addCoercions(this._interpreterValueJavaConverter.convertValueToJava(alias.getArguments().get(param)), (JavaType)type, scope));
        conditionClass.getParameters().forEach(_function);
        Function<JavaExpression, JavaStatementBuilder> _function_1 = args -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)args){
                final /* synthetic */ JavaExpression val$args;
                {
                    this.val$args = javaExpression;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultsId);
                    _builder.append((Object)".addAll(");
                    _builder.append((Object)conditionVar);
                    _builder.append((Object)".getValidationResults(");
                    _builder.append((Object)this.val$args);
                    _builder.append((Object)"))");
                }
            };
            return JavaExpression.from(_client, (JavaType)JavaPrimitiveType.VOID);
        };
        return JavaStatementBuilder.invokeMethod(arguments, _function_1, scope).completeAsExpressionStatement();
    }

    private JavaExpression getAttributeValue(JavaPojoInterface javaType, RAttribute attr) {
        JavaExpression _xblockexpression = null;
        JavaPojoProperty prop = javaType.findProperty(attr.getName());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"o");
            }
        };
        final JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
        JavaType propType = propCode.getExpressionType();
        final JavaType propItemType = this._javaTypeUtil.getItemType(propType);
        JavaExpression _xifexpression = null;
        if (propItemType instanceof RJavaWithMetaValue) {
            JavaExpression _xifexpression_1 = null;
            boolean _isList = this._javaTypeUtil.isList(propType);
            if (_isList) {
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)propCode);
                        _builder.append((Object)".stream().map(");
                        _builder.append((Object)((RJavaWithMetaValue)propItemType));
                        _builder.append((Object)"::getValue).collect(");
                        _builder.append(Collectors.class);
                        _builder.append((Object)".toList())");
                    }
                };
                _xifexpression_1 = JavaExpression.from(_client_1, this._javaTypeUtil.wrap(this._javaTypeUtil.LIST, (JavaType)((RJavaWithMetaValue)propItemType).getValueType()));
            } else {
                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)propCode);
                        _builder.append((Object)".getValue()");
                    }
                };
                _xifexpression_1 = JavaExpression.from(_client_2, (JavaType)((RJavaWithMetaValue)propItemType).getValueType());
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = propCode;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private StringConcatenationClient optional(final Optional<?> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                Object _get = v.get();
                _builder.append(_get);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalPattern(final Optional<Pattern> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                _builder.append(Pattern.class);
                _builder.append((Object)".compile(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((Pattern)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalBigDecimal(final Optional<BigDecimal> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(new ");
                _builder.append(BigDecimal.class);
                _builder.append((Object)"(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((BigDecimal)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }
}

