/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.statement.builder;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.statement.JavaIfThenElseStatement;
import com.regnosys.rosetta.generator.java.statement.JavaIfThenStatement;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.JavaLocalVariableDeclarationStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatementList;
import com.regnosys.rosetta.generator.java.statement.builder.JavaBlockBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaLiteral;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.rosetta.util.types.JavaType;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.xtend2.lib.StringConcatenation;

public class JavaIfThenElseBuilder
extends JavaStatementBuilder {
    private final JavaExpression condition;
    private final JavaStatementBuilder thenBranch;
    private final JavaStatementBuilder elseBranch;
    private final JavaType commonType;
    private final JavaTypeUtil typeUtil;

    public JavaIfThenElseBuilder(JavaExpression condition, JavaStatementBuilder thenBranch, JavaStatementBuilder elseBranch, JavaType commonType, JavaTypeUtil typeUtil) {
        this.condition = condition;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
        this.commonType = commonType;
        this.typeUtil = typeUtil;
    }

    public JavaIfThenElseBuilder(JavaExpression condition, JavaStatementBuilder thenBranch, JavaStatementBuilder elseBranch, JavaTypeUtil typeUtil) {
        this(condition, thenBranch, elseBranch, typeUtil.join(thenBranch.getExpressionType(), elseBranch.getExpressionType()), typeUtil);
    }

    @Override
    public JavaType getExpressionType() {
        return this.commonType;
    }

    @Override
    public JavaIfThenElseBuilder mapExpression(Function<JavaExpression, ? extends JavaStatementBuilder> mapper) {
        JavaStatementBuilder mappedThenBranch = this.thenBranch.mapExpression(mapper);
        JavaStatementBuilder mappedElseBranch = this.elseBranch.mapExpression(mapper);
        return new JavaIfThenElseBuilder(this.condition, mappedThenBranch, mappedElseBranch, this.typeUtil);
    }

    @Override
    public JavaStatementBuilder then(JavaStatementBuilder after, BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> combineExpressions, JavaScope scope) {
        return this.collapseToSingleExpression(scope).then(after, combineExpressions, scope);
    }

    private JavaIfThenElseStatement completeBranches(Function<JavaStatementBuilder, JavaStatement> mapper) {
        return new JavaIfThenElseStatement(this.condition, mapper.apply(this.thenBranch), mapper.apply(this.elseBranch));
    }

    @Override
    public JavaIfThenElseStatement complete(Function<JavaExpression, JavaStatement> completer) {
        return this.completeBranches(b -> b.complete(completer));
    }

    @Override
    public JavaBlock completeAsReturn() {
        return new JavaIfThenStatement(this.condition, this.thenBranch.completeAsReturn()).append(this.elseBranch.completeAsReturn());
    }

    @Override
    public JavaIfThenElseStatement completeAsExpressionStatement() {
        return this.completeBranches(b -> b.completeAsExpressionStatement());
    }

    @Override
    public JavaIfThenElseStatement completeAsAssignment(GeneratedIdentifier variableId) {
        return this.completeBranches(b -> b.completeAsAssignment(variableId));
    }

    @Override
    public JavaBlockBuilder declareAsVariable(boolean isFinal, String variableId, JavaScope scope) {
        GeneratedIdentifier id = scope.createIdentifier(this, variableId);
        if (this.elseBranch instanceof JavaLiteral) {
            return new JavaBlockBuilder(JavaStatementList.of(new JavaStatement[]{new JavaLocalVariableDeclarationStatement(false, this.commonType, id, (JavaLiteral)this.elseBranch), new JavaIfThenStatement(this.condition, this.thenBranch.completeAsAssignment(id))}), new JavaVariable(id, this.commonType));
        }
        return new JavaBlockBuilder(JavaStatementList.of(new JavaStatement[]{new JavaLocalVariableDeclarationStatement(isFinal, this.commonType, id), this.completeAsAssignment(id)}), new JavaVariable(id, this.commonType));
    }

    @Override
    public JavaStatementBuilder collapseToSingleExpression(JavaScope scope) {
        return this.declareAsVariable(true, "ifThenElseResult", scope);
    }

    @Override
    public JavaLambdaBody toLambdaBody() {
        return new JavaBlockBuilder(this).toLambdaBody();
    }

    public String toString() {
        StringConcatenation result = new StringConcatenation();
        result.append("if (");
        result.append((Object)this.condition);
        result.append(") ");
        result.append((Object)this.toBlock(this.thenBranch));
        result.append(" else ");
        if (this.elseBranch instanceof JavaIfThenElseBuilder) {
            result.append((Object)this.elseBranch);
        } else {
            result.append((Object)this.toBlock(this.elseBranch));
        }
        return result.toString();
    }

    private JavaBlockBuilder toBlock(JavaStatementBuilder stat) {
        if (stat instanceof JavaBlockBuilder) {
            return (JavaBlockBuilder)stat;
        }
        return new JavaBlockBuilder(stat);
    }
}

