/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class JavaConditionInterface
extends JavaClass<Object> {
    private final Condition condition;
    private final String simpleName;
    private final RType instanceType;
    private final JavaReferenceType instanceClass;
    private Map<String, JavaType> parameters = null;
    private final ModelIdProvider modelIdProvider;
    private final RosettaTypeProvider typeProvider;
    private final JavaTypeUtil typeUtil;
    private final JavaTypeTranslator typeTranslator;

    public JavaConditionInterface(Condition condition, ModelIdProvider modelIdProvider, RosettaTypeProvider typeProvider, TypeSystem typeSystem, JavaTypeUtil typeUtil, JavaTypeTranslator typeTranslator) {
        this.condition = condition;
        this.simpleName = JavaConditionInterface.computeConditionClassName(condition);
        this.instanceType = typeSystem.typeWithUnknownArgumentsToRType(condition.getEnclosingType());
        this.instanceClass = typeTranslator.toJavaReferenceType(this.instanceType);
        this.modelIdProvider = modelIdProvider;
        this.typeProvider = typeProvider;
        this.typeUtil = typeUtil;
        this.typeTranslator = typeTranslator;
    }

    public Map<String, JavaType> getParameters() {
        if (this.parameters == null) {
            RosettaTypeWithConditions enclosingType = this.condition.getEnclosingType();
            if (enclosingType instanceof ParametrizedRosettaType) {
                Set usedSymbols = EcoreUtil2.eAllOfType((EObject)this.condition.getExpression(), RosettaSymbolReference.class).stream().map(ref -> ref.getSymbol()).collect(Collectors.toSet());
                this.parameters = new LinkedHashMap<String, JavaType>();
                ((ParametrizedRosettaType)((Object)enclosingType)).getParameters().forEach(param -> {
                    if (usedSymbols.contains(param)) {
                        JavaClass<?> paramType = this.typeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol((TypeParameter)param));
                        this.parameters.put(param.getName(), (JavaType)paramType);
                    }
                });
            } else {
                this.parameters = Collections.emptyMap();
            }
        }
        return this.parameters;
    }

    public RType getInstanceType() {
        return this.instanceType;
    }

    public JavaReferenceType getInstanceClass() {
        return this.instanceClass;
    }

    private static String computeConditionClassName(Condition cond) {
        Object conditionName;
        if (cond.getName() != null) {
            conditionName = cond.getName();
        } else {
            long index = cond.getEnclosingType().getConditions().stream().filter(c -> c.getName() != null).takeWhile(c -> c != cond).count();
            String type = JavaConditionInterface.isOneOf(cond) ? "OneOf" : (JavaConditionInterface.isChoice(cond) ? "Choice" : "DataRule");
            conditionName = type + index;
        }
        return cond.getEnclosingType().getName() + (String)conditionName;
    }

    private static boolean isOneOf(Condition cond) {
        return cond.getExpression() instanceof OneOfOperation;
    }

    private static boolean isChoice(Condition cond) {
        return cond.getExpression() instanceof ChoiceOperation;
    }

    public boolean implementsValidatorInterface() {
        return this.getParameters().isEmpty();
    }

    public JavaParameterizedType<Validator<?>> getValidatorInterface() {
        return JavaParameterizedType.from(this.typeUtil.VALIDATOR, (JavaTypeArgument[])new JavaTypeArgument[]{this.instanceClass});
    }

    public boolean isSubtypeOf(JavaType other) {
        if (this.implementsValidatorInterface() && this.getValidatorInterface().isSubtypeOf(other)) {
            return true;
        }
        if (other instanceof JavaConditionInterface) {
            return this.condition.equals(((JavaConditionInterface)other).condition);
        }
        return false;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<? extends JavaGenericTypeDeclaration<?>> getInterfaceDeclarations() {
        if (this.implementsValidatorInterface()) {
            return Collections.singletonList(this.typeUtil.VALIDATOR);
        }
        return Collections.emptyList();
    }

    public List<JavaClass<?>> getInterfaces() {
        if (this.implementsValidatorInterface()) {
            return Collections.singletonList(this.getValidatorInterface());
        }
        return Collections.emptyList();
    }

    public DottedPath getPackageName() {
        return this.modelIdProvider.toDottedPath(this.condition.getEnclosingType().getModel()).child("validation").child("datarule");
    }

    public JavaClass<? super Object> getSuperclassDeclaration() {
        return JavaClass.OBJECT;
    }

    public JavaClass<? super Object> getSuperclass() {
        return this.getSuperclassDeclaration();
    }

    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        if (other instanceof JavaType) {
            return this.isSubtypeOf((JavaType)other);
        }
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public Class<?> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(this.getCanonicalName().toString(), true, classLoader);
    }
}

