/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.util.ImportingStringConcatenation;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportClass;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportMethod;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImportManagerExtension {
    public Method method(Class<?> clazz, String methodName) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, methodName);
        };
        return (Method)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)clazz.getMethods())), (Functions.Function1)_function);
    }

    public PreferWildcardImportClass importWildcard(Class<?> clazz) {
        return this.importWildcard(JavaClass.from(clazz));
    }

    public PreferWildcardImportClass importWildcard(JavaClass<?> t) {
        return new PreferWildcardImportClass(t);
    }

    public PreferWildcardImportMethod importWildcard(Method method) {
        return new PreferWildcardImportMethod(method);
    }

    public String buildClass(final DottedPath packageName, StringConcatenationClient classCode, JavaScope topScope) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        boolean _isClosed = topScope.isClosed();
        if (_isClosed) {
            throw new IllegalStateException("The top scope may not be closed, as imports will be added to it.");
        }
        final ImportingStringConcatenation isc = new ImportingStringConcatenation(topScope);
        final StringConcatenationClient resolvedCode = isc.preprocess(classCode);
        StringConcatenationClient fullClass = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"package ");
                _builder.append((Object)packageName);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                List<DottedPath> _imports = isc.getImports();
                for (DottedPath imp : _imports) {
                    _builder.append((Object)"import ");
                    _builder.append((Object)imp);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                List<DottedPath> _staticImports = isc.getStaticImports();
                for (DottedPath imp_1 : _staticImports) {
                    _builder.append((Object)"import static ");
                    _builder.append((Object)imp_1);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)resolvedCode);
                _builder.newLineIfNotEmpty();
            }
        };
        isc.append(fullClass);
        _xblockexpression = isc.toString();
        return _xblockexpression;
    }
}

