/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.util;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class RosettaFunctionExtensions {
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private RosettaTypeProvider typeProvider;

    public Boolean handleAsSpecFunction(Function function) {
        return IterableExtensions.isNullOrEmpty(function.getOperations()) && this.isDispatchingFunction(function) == false && this.handleAsEnumFunction(function) == false;
    }

    public Boolean handleAsEnumFunction(Function function) {
        return IterableExtensions.isNullOrEmpty(function.getOperations()) && !IterableExtensions.isEmpty(this.getDispatchingFunctions(function));
    }

    public Boolean isDispatchingFunction(Function function) {
        return function instanceof FunctionDispatch;
    }

    public Iterable<FunctionDispatch> getDispatchingFunctions(Function function) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _name_1 = function.getName();
            return Objects.equals(_name, _name_1);
        };
        return IterableExtensions.filter((Iterable)EcoreUtil2.getSiblingsOfType((EObject)function, FunctionDispatch.class), (Functions.Function1)_function);
    }

    public Function getMainFunction(Function function) {
        Boolean _isDispatchingFunction = this.isDispatchingFunction(function);
        if (_isDispatchingFunction.booleanValue()) {
            Functions.Function1 _function = it -> Objects.equals(it.getName(), function.getName()) && IterableExtensions.isNullOrEmpty(it.getOperations());
            return (Function)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.getSiblingsOfType((EObject)function, Function.class), (Functions.Function1)_function));
        }
        return null;
    }

    protected Attribute _getOutput(Function function) {
        return function.getOutput();
    }

    protected Attribute _getOutput(FunctionDispatch function) {
        Function mainFunction = this.getMainFunction(function);
        if (mainFunction != null) {
            return mainFunction.getOutput();
        }
        return null;
    }

    protected List<Attribute> _getInputs(Function function) {
        return function.getInputs();
    }

    protected List<Attribute> _getInputs(FunctionDispatch function) {
        List _xblockexpression = null;
        Function mainFunction = this.getMainFunction(function);
        if (mainFunction != null) {
            return mainFunction.getInputs();
        }
        _xblockexpression = CollectionLiterals.emptyList();
        return _xblockexpression;
    }

    public String inputsAsArgs(ShortcutDeclaration alias) {
        String _xblockexpression = null;
        Function func = (Function)EcoreUtil2.getContainerOfType((EObject)alias, Function.class);
        Functions.Function1 _function = it -> it.getName();
        _xblockexpression = IterableExtensions.join(this.getInputs(func), (CharSequence)", ", (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected boolean _needsBuilder(Void ele) {
        return false;
    }

    protected boolean _needsBuilder(RAttribute rAttribute) {
        return this.needsBuilder(rAttribute.getRMetaAnnotatedType().getRType());
    }

    protected boolean _needsBuilder(RosettaTyped ele) {
        return this.needsBuilder(ele.getTypeCall().getType());
    }

    protected boolean _needsBuilder(RosettaExpression expr) {
        return this.needsBuilder(this.typeProvider.getRMetaAnnotatedType(expr).getRType());
    }

    protected boolean _needsBuilder(AssignPathRoot root) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (root instanceof Attribute) {
            _matched = true;
            _switchResult = this.needsBuilder(((Attribute)root).getTypeCall().getType());
        }
        if (!_matched && root instanceof ShortcutDeclaration) {
            _matched = true;
            _switchResult = this.needsBuilder(((ShortcutDeclaration)root).getExpression());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected boolean _needsBuilder(RAssignedRoot root) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (root instanceof RAttribute) {
            _matched = true;
            _switchResult = this.needsBuilder(((RAttribute)root).getRMetaAnnotatedType().getRType());
        }
        if (!_matched && root instanceof RShortcut) {
            _matched = true;
            _switchResult = this.needsBuilder(((RShortcut)root).getExpression());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected boolean _needsBuilder(RosettaType type) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (type instanceof Data) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected boolean _needsBuilder(TypeCall typeCall) {
        return this.needsBuilder(typeCall.getType());
    }

    protected boolean _needsBuilder(RType type) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (type instanceof RDataType) {
            _matched = true;
        }
        if (!_matched && type instanceof RChoiceType) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isOutput(Attribute attr) {
        EStructuralFeature _eContainingFeature = attr.eContainingFeature();
        return _eContainingFeature == SimplePackage.Literals.FUNCTION__OUTPUT;
    }

    public boolean isQualifierFunctionFor(Function function, Data type) {
        return this.isQualifierFunction(function) && Objects.equals(this.getInputs(function).get(0).getTypeCall().getType(), type);
    }

    public boolean isQualifierFunction(Function function) {
        boolean _isEmpty = this.getQualifierAnnotations(function).isEmpty();
        return !_isEmpty;
    }

    public boolean isQualifierFunction(RFunction function) {
        boolean _isEmpty = this.getQualifierAnnotations(function.getAnnotations()).isEmpty();
        return !_isEmpty;
    }

    public List<AnnotationRef> getMetadataAnnotations(Annotated element) {
        Functions.Function1 _function = it -> {
            String _name = it.getAnnotation().getName();
            return Objects.equals("metadata", _name);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(element.getAnnotations(), (Functions.Function1)_function));
    }

    public List<AnnotationRef> getQualifierAnnotations(Annotated element) {
        return this.getQualifierAnnotations((List<AnnotationRef>)element.getAnnotations());
    }

    public List<AnnotationRef> getQualifierAnnotations(List<AnnotationRef> annotations) {
        Functions.Function1 _function = it -> {
            String _name = it.getAnnotation().getName();
            return Objects.equals("qualification", _name);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(annotations, (Functions.Function1)_function));
    }

    public List<AnnotationRef> getCreationAnnotations(Annotated element) {
        Functions.Function1 _function = it -> {
            String _name = it.getAnnotation().getName();
            return Objects.equals("creation", _name);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(element.getAnnotations(), (Functions.Function1)_function));
    }

    public List<AnnotationRef> getTransformAnnotations(Annotated element) {
        Functions.Function1 _function = it -> this.ecoreUtil.isResolved(it.getAnnotation());
        Functions.Function1 _function_1 = it -> {
            String _name = it.getAnnotation().getModel().getName();
            return Objects.equals("com.rosetta.model", _name);
        };
        Functions.Function1 _function_2 = it -> Objects.equals("ingest", it.getAnnotation().getName()) || Objects.equals("enrich", it.getAnnotation().getName()) || Objects.equals("projection", it.getAnnotation().getName());
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getAnnotations(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    @XbaseGenerated
    public Attribute getOutput(Function function) {
        if (function instanceof FunctionDispatch) {
            return this._getOutput((FunctionDispatch)function);
        }
        if (function != null) {
            return this._getOutput(function);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(function).toString());
    }

    @XbaseGenerated
    public List<Attribute> getInputs(Function function) {
        if (function instanceof FunctionDispatch) {
            return this._getInputs((FunctionDispatch)function);
        }
        if (function != null) {
            return this._getInputs(function);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(function).toString());
    }

    @XbaseGenerated
    public boolean needsBuilder(Object root) {
        if (root instanceof AssignPathRoot) {
            return this._needsBuilder((AssignPathRoot)root);
        }
        if (root instanceof RosettaType) {
            return this._needsBuilder((RosettaType)root);
        }
        if (root instanceof RosettaTyped) {
            return this._needsBuilder((RosettaTyped)root);
        }
        if (root instanceof TypeCall) {
            return this._needsBuilder((TypeCall)root);
        }
        if (root instanceof RosettaExpression) {
            return this._needsBuilder((RosettaExpression)root);
        }
        if (root instanceof RAttribute) {
            return this._needsBuilder((RAttribute)root);
        }
        if (root instanceof RAssignedRoot) {
            return this._needsBuilder((RAssignedRoot)root);
        }
        if (root instanceof RType) {
            return this._needsBuilder((RType)root);
        }
        if (root == null) {
            return this._needsBuilder((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(root).toString());
    }
}

