/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.rules;

import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.AnnotationPathExpression;
import com.regnosys.rosetta.rosetta.simple.RuleReferenceAnnotation;
import com.regnosys.rosetta.rules.RulePathMap;
import com.regnosys.rosetta.rules.RuleResult;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.utils.AnnotationPathExpressionUtil;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleReferenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleReferenceService.class);
    @Inject
    private AnnotationPathExpressionUtil pathExpressionUtil;

    public <T> T traverse(RosettaExternalRuleSource source, RDataType type, T initialState, BiFunction<T, RuleReferenceContext, T> updateState) {
        return this.traverse(source, type, initialState, updateState, new HashMap<List<String>, RuleResult>(), new ArrayList<RAttribute>(), new HashSet<RDataType>());
    }

    private <T> T traverse(RosettaExternalRuleSource source, RDataType type, T initialState, BiFunction<T, RuleReferenceContext, T> updateState, Map<List<String>, RuleResult> nestedRuleContext, List<RAttribute> path, Set<RDataType> visited) {
        boolean isCycle;
        boolean bl = isCycle = !visited.add(type);
        if (isCycle && nestedRuleContext.isEmpty()) {
            return initialState;
        }
        T currentState = initialState;
        for (RAttribute attr : type.getAllAttributes()) {
            String attrName = attr.getName();
            ArrayList<RAttribute> attrPath = new ArrayList<RAttribute>(path);
            attrPath.add(attr);
            RuleResult ruleResult = nestedRuleContext.get(List.of(attrName));
            if (ruleResult != null) {
                currentState = updateState.apply(currentState, new RuleReferenceContext(attrPath, ruleResult));
                continue;
            }
            RulePathMap pathMap = this.computeRulePathMapInContext(source, type, attr);
            ruleResult = pathMap.get(List.of());
            if (ruleResult != null) {
                currentState = updateState.apply(currentState, new RuleReferenceContext(attrPath, ruleResult));
                continue;
            }
            if (attr.isMulti()) continue;
            RType attrType = attr.getRMetaAnnotatedType().getRType();
            if (attrType instanceof RChoiceType) {
                attrType = ((RChoiceType)attrType).asRDataType();
            }
            if (!(attrType instanceof RDataType)) continue;
            Map<List<String>, RuleResult> subcontext = this.getSubcontextForAttribute(attr, nestedRuleContext);
            if (!isCycle) {
                pathMap.addRulesToMapIfNotPresent(subcontext);
            }
            currentState = this.traverse(source, (RDataType)attrType, currentState, updateState, subcontext, attrPath, new HashSet<RDataType>(visited));
        }
        return currentState;
    }

    private Map<List<String>, RuleResult> getSubcontextForAttribute(RAttribute attribute, Map<List<String>, RuleResult> context) {
        String attributeName = attribute.getName();
        return context.entrySet().stream().filter(e -> ((List)e.getKey()).size() > 0 && ((String)((List)e.getKey()).get(0)).equals(attributeName)).collect(Collectors.toMap(e -> ((List)e.getKey()).subList(1, ((List)e.getKey()).size()), e -> (RuleResult)e.getValue()));
    }

    public RulePathMap computeRulePathMap(RAttribute attribute) {
        return this.computeRulePathMapInContext(null, attribute.getEnclosingType(), attribute);
    }

    public RulePathMap computeRulePathMapInContext(RosettaExternalRuleSource source, RDataType type, RAttribute attribute) {
        RulePathMap parentInSameContext = null;
        ArrayList<RulePathMap> parentsInDescendingPriority = new ArrayList<RulePathMap>();
        if (source != null) {
            RAttribute attrInSuperType;
            RDataType superType = type.getSuperType();
            if (superType != null && (attrInSuperType = superType.getAttributeByName(attribute.getName())) != null) {
                parentInSameContext = this.computeRulePathMapInContext(source, superType, attrInSuperType);
            }
            if (source.getSuperRuleSources().isEmpty()) {
                RulePathMap parentMap2 = this.computeRulePathMapInContext(null, type, attribute);
                parentsInDescendingPriority.add(parentMap2);
            } else {
                source.getSuperRuleSources().stream().map(superSource -> this.computeRulePathMapInContext((RosettaExternalRuleSource)superSource, type, attribute)).forEach(parentMap -> parentsInDescendingPriority.add((RulePathMap)parentMap));
            }
        } else {
            RAttribute parentAttribute = attribute.getParentAttribute();
            if (parentAttribute != null) {
                parentInSameContext = this.computeRulePathMapInContext(null, parentAttribute.getEnclosingType(), parentAttribute);
            }
        }
        String ruleSourceName = Optional.ofNullable(source).map(RosettaNamed::getName).orElse("no-source");
        String typeName = type.getName();
        String attributeName = attribute.getName();
        RulePathMap pathMap = new RulePathMap(String.join((CharSequence)"-", ruleSourceName, typeName, attributeName), parentInSameContext, parentsInDescendingPriority);
        if (source == null) {
            this.addRuleReferenceAnnotationsToMap(attribute.getOwnRuleReferences(), pathMap);
        } else {
            this.findAttributesInSource(source, type, attribute).forEach(annotatedAttr -> {
                if (annotatedAttr.getOperator() == ExternalValueOperator.MINUS) {
                    RuleResult minusResult = RuleResult.explicitlyEmptyFromMinusInRuleSource(annotatedAttr);
                    Map<List<String>, RuleResult> existingRules = pathMap.getAsMap();
                    if (!existingRules.isEmpty()) {
                        for (List<String> path : existingRules.keySet()) {
                            pathMap.add(path, minusResult);
                        }
                    } else {
                        pathMap.add(List.of(), minusResult);
                    }
                } else if (annotatedAttr.getOperator() == ExternalValueOperator.PLUS) {
                    this.addRuleReferenceAnnotationsToMap((List<RuleReferenceAnnotation>)annotatedAttr.getExternalRuleReferences(), pathMap);
                }
            });
        }
        return pathMap;
    }

    private void addRuleReferenceAnnotationsToMap(List<RuleReferenceAnnotation> annotations, RulePathMap map) {
        for (RuleReferenceAnnotation ruleRef : annotations) {
            List<String> path = this.toList(ruleRef.getPath());
            if (path == null) continue;
            map.add(path, RuleResult.fromAnnotation(ruleRef));
        }
    }

    private Stream<RosettaExternalRegularAttribute> findAttributesInSource(RosettaExternalRuleSource source, RDataType type, RAttribute attribute) {
        return source.getExternalClasses().stream().filter(t -> t.getData().equals(type.getEObject())).findAny().stream().flatMap(t -> t.getRegularAttributes().stream().filter(a -> a.getAttributeRef().equals(attribute.getEObject())));
    }

    public RAttribute getTargetAttribute(RAttribute start, List<String> path) {
        RAttribute result = start;
        for (String next : path) {
            RType attrType = result.getRMetaAnnotatedType().getRType();
            if (attrType instanceof RChoiceType) {
                attrType = ((RChoiceType)attrType).asRDataType();
            }
            try {
                RDataType attrDataType = (RDataType)attrType;
                result = Objects.requireNonNull(attrDataType.getAttributeByName(next));
            }
            catch (ClassCastException | NullPointerException e) {
                LOGGER.error("Error while following attribute `" + next + "` path " + String.valueOf(path) + " from " + String.valueOf(start) + ".", (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private List<String> toList(AnnotationPathExpression path) {
        if (path == null) {
            return List.of();
        }
        return this.pathExpressionUtil.fold(path, attr -> {
            String name = attr.getName();
            if (name == null) {
                return null;
            }
            ArrayList<String> acc = new ArrayList<String>();
            acc.add(name);
            return acc;
        }, attr -> new ArrayList(), (acc, pathExpr) -> {
            if (acc == null) {
                return null;
            }
            String name = pathExpr.getAttribute().getName();
            if (name == null) {
                return null;
            }
            acc.add(pathExpr.getAttribute().getName());
            return acc;
        }, (acc, deepPathExpr) -> null);
    }

    public static class RuleReferenceContext {
        private final List<RAttribute> path;
        private final RuleResult ruleResult;

        public RuleReferenceContext(List<RAttribute> path, RuleResult ruleResult) {
            this.path = path;
            this.ruleResult = ruleResult;
        }

        public List<RAttribute> getPath() {
            return this.path;
        }

        public RAttribute getRootAttribute() {
            return this.path.get(0);
        }

        public RAttribute getTargetAttribute() {
            return this.path.get(this.path.size() - 1);
        }

        public boolean isExplicitlyEmpty() {
            return this.ruleResult.isExplicitlyEmpty();
        }

        public RosettaRule getRule() {
            return this.ruleResult.getRule();
        }

        public EObject getRuleOrigin() {
            return this.ruleResult.getOrigin();
        }
    }
}

