/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.LabelAnnotation;
import com.regnosys.rosetta.rosetta.simple.RuleReferenceAnnotation;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFeature;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class RAttribute
implements RAssignedRoot,
RFeature {
    private final RDataType enclosingType;
    private final boolean isOverride;
    private final String name;
    private final String definition;
    private final List<RosettaDocReference> docReferences;
    private final RMetaAnnotatedType rMetaAnnotatedType;
    private final RCardinality cardinality;
    private final List<RuleReferenceAnnotation> ruleReferences;
    private final List<LabelAnnotation> labelAnnotations;
    private final Attribute origin;
    private RAttribute parentAttribute = null;

    public RAttribute(RDataType enclosingType, boolean isOverride, String name, String definition, List<RosettaDocReference> docReferences, RMetaAnnotatedType rMetaAnnotatedType, RCardinality cardinality, List<RuleReferenceAnnotation> ruleReferences, List<LabelAnnotation> labelAnnotations, Attribute origin) {
        this.enclosingType = enclosingType;
        this.isOverride = isOverride;
        this.name = name;
        this.definition = definition;
        this.docReferences = docReferences;
        this.rMetaAnnotatedType = rMetaAnnotatedType;
        this.cardinality = cardinality;
        this.ruleReferences = ruleReferences;
        this.labelAnnotations = labelAnnotations;
        this.origin = origin;
    }

    public RDataType getEnclosingType() {
        return this.enclosingType;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Attribute getEObject() {
        return this.origin;
    }

    public RMetaAnnotatedType getRMetaAnnotatedType() {
        return this.rMetaAnnotatedType;
    }

    @Override
    public boolean isMulti() {
        return this.cardinality.isMulti();
    }

    public RCardinality getCardinality() {
        return this.cardinality;
    }

    public String getDefinition() {
        return this.definition;
    }

    public List<RosettaDocReference> getOwnDocReferences() {
        return this.docReferences;
    }

    public List<RosettaDocReference> getAllDocReferences() {
        return this.inheritAnnotationsFromParent(RAttribute::getAllDocReferences, this.docReferences);
    }

    public List<RuleReferenceAnnotation> getOwnRuleReferences() {
        return this.ruleReferences;
    }

    public List<RuleReferenceAnnotation> getAllRuleReferences() {
        return this.inheritAnnotationsFromParent(RAttribute::getAllRuleReferences, this.ruleReferences);
    }

    public List<LabelAnnotation> getOwnLabelAnnotations() {
        return this.labelAnnotations;
    }

    public List<LabelAnnotation> getAllLabelAnnotations() {
        return this.inheritAnnotationsFromParent(RAttribute::getAllLabelAnnotations, this.labelAnnotations);
    }

    private <T> List<T> inheritAnnotationsFromParent(Function<RAttribute, List<T>> getter, List<T> ownAnnotations) {
        List<T> parentAnnotations;
        RAttribute p = this.getParentAttribute();
        if (p == null || (parentAnnotations = getter.apply(p)).isEmpty()) {
            return ownAnnotations;
        }
        ArrayList<T> allAnnotations = new ArrayList<T>(ownAnnotations.size() + parentAnnotations.size());
        allAnnotations.addAll(parentAnnotations);
        allAnnotations.addAll(ownAnnotations);
        return allAnnotations;
    }

    public RAttribute getParentAttribute() {
        if (this.parentAttribute == null && this.isOverride && this.enclosingType != null) {
            for (RDataType currentEnclosingType = this.enclosingType.getSuperType(); currentEnclosingType != null; currentEnclosingType = currentEnclosingType.getSuperType()) {
                RAttribute foundParentAttr = currentEnclosingType.getOwnAttributeByName(this.name);
                if (foundParentAttr == null) continue;
                this.parentAttribute = foundParentAttr;
                break;
            }
        }
        return this.parentAttribute;
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.cardinality, this.name, this.rMetaAnnotatedType, this.origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAttribute other = (RAttribute)obj;
        return Objects.equals(this.definition, other.definition) && Objects.equals(this.cardinality, other.cardinality) && Objects.equals(this.name, other.name) && Objects.equals(this.rMetaAnnotatedType, other.rMetaAnnotatedType) && Objects.equals(this.origin, other.origin);
    }

    public String toString() {
        return String.format("RAttribute[name=%s, type=%s, cardinality=%s]", this.name, this.rMetaAnnotatedType, this.cardinality);
    }
}

