/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunctionOrigin;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.RShortcut;
import com.rosetta.model.lib.ModelId;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.DottedPath;
import java.util.List;
import java.util.Objects;

public class RFunction {
    private ModelSymbolId symbolId;
    private ModelReportId reportId;
    private String definition;
    private List<RAttribute> inputs;
    private RAttribute output;
    private RFunctionOrigin origin;
    private List<Condition> preConditions;
    private List<Condition> postConditions;
    private List<RShortcut> shortcuts;
    private List<ROperation> operations;
    private List<AnnotationRef> annotations;

    private RFunction(String definition, List<RAttribute> inputs, RAttribute output, RFunctionOrigin origin, List<Condition> preConditions, List<Condition> postConditions, List<RShortcut> shortcuts, List<ROperation> operations, List<AnnotationRef> annotations) {
        this.definition = definition;
        this.inputs = inputs;
        this.output = output;
        this.origin = origin;
        this.preConditions = preConditions;
        this.postConditions = postConditions;
        this.shortcuts = shortcuts;
        this.operations = operations;
        this.annotations = annotations;
    }

    public RFunction(ModelSymbolId symbolId, String definition, List<RAttribute> inputs, RAttribute output, RFunctionOrigin origin, List<Condition> preConditions, List<Condition> postConditions, List<RShortcut> shortcuts, List<ROperation> operations, List<AnnotationRef> annotations) {
        this(definition, inputs, output, origin, preConditions, postConditions, shortcuts, operations, annotations);
        this.symbolId = symbolId;
    }

    public RFunction(ModelReportId reportId, String definition, List<RAttribute> inputs, RAttribute output, RFunctionOrigin origin, List<Condition> preConditions, List<Condition> postConditions, List<RShortcut> shortcuts, List<ROperation> operations, List<AnnotationRef> annotations) {
        this(definition, inputs, output, origin, preConditions, postConditions, shortcuts, operations, annotations);
        this.reportId = reportId;
    }

    public ModelId getId() {
        if (this.symbolId != null) {
            return this.symbolId;
        }
        return this.reportId;
    }

    public ModelSymbolId getSymbolId() {
        return this.symbolId;
    }

    public ModelReportId getReportId() {
        return this.reportId;
    }

    public DottedPath getNamespace() {
        return this.getId().getNamespace();
    }

    public String getAlphanumericName() {
        return this.getId().getAlphanumericName();
    }

    public String getDefinition() {
        return this.definition;
    }

    public List<RAttribute> getInputs() {
        return this.inputs;
    }

    public RAttribute getOutput() {
        return this.output;
    }

    public RFunctionOrigin getOrigin() {
        return this.origin;
    }

    public List<Condition> getPreConditions() {
        return this.preConditions;
    }

    public List<Condition> getPostConditions() {
        return this.postConditions;
    }

    public List<RShortcut> getShortcuts() {
        return this.shortcuts;
    }

    public List<ROperation> getOperations() {
        return this.operations;
    }

    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbolId, this.reportId, this.annotations, this.definition, this.inputs, this.operations, this.origin, this.output, this.postConditions, this.preConditions, this.shortcuts});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RFunction other = (RFunction)obj;
        return Objects.equals(this.reportId, other.reportId) && Objects.equals(this.annotations, other.annotations) && Objects.equals(this.definition, other.definition) && Objects.equals(this.inputs, other.inputs) && Objects.equals(this.symbolId, other.symbolId) && Objects.equals(this.operations, other.operations) && this.origin == other.origin && Objects.equals(this.output, other.output) && Objects.equals(this.postConditions, other.postConditions) && Objects.equals(this.preConditions, other.preConditions) && Objects.equals(this.shortcuts, other.shortcuts);
    }
}

