/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.types.RType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class RParametrizedType
extends RType {
    private final LinkedHashMap<String, RosettaValue> arguments;

    public RParametrizedType(LinkedHashMap<String, RosettaValue> arguments) {
        this.arguments = arguments;
    }

    public Map<String, RosettaValue> getArguments() {
        return this.arguments;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.arguments);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RParametrizedType other = (RParametrizedType)object;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        String joinedArguments = this.arguments.entrySet().stream().filter(e -> ((RosettaValue)e.getValue()).getSingle().isPresent()).map(e -> (String)e.getKey() + ": " + String.valueOf(((RosettaValue)e.getValue()).getSingle().get())).collect(Collectors.joining(", "));
        if (joinedArguments.length() > 0) {
            builder.append("(").append(joinedArguments).append(")");
        }
        return builder.toString();
    }
}

