/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class FunctionValidator
extends AbstractDeclarativeRosettaValidator {
    @Check
    public void warnWhenEmptyFunctionsDontHaveCodeImplementationAnnotation(Function function) {
        if (function.getOutput() != null && function.getOutput().getName() != null) {
            Function annotated = function;
            boolean hasCodeImplementationAnnotation = annotated.getAnnotations().stream().map(aRef -> aRef.getAnnotation()).anyMatch(a -> "codeImplementation".equals(a.getName()));
            if (function.getOperations().isEmpty() && !hasCodeImplementationAnnotation) {
                this.warning("A function should specify an implementation, or they should be annotated with codeImplementation", function, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
            }
            if (!function.getOperations().isEmpty() && hasCodeImplementationAnnotation) {
                this.warning("Functions annotated with codeImplementation should not have any setter operations as they will be overriden", function, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
            }
        }
    }
}

