/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExistsModifier;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.WithMetaEntry;
import com.regnosys.rosetta.rosetta.expression.WithMetaOperation;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.validation.expression.AbstractExpressionValidator;
import com.regnosys.rosetta.validation.expression.ConstructorValidator;
import com.regnosys.rosetta.validation.expression.SwitchValidator;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;

@ComposedChecks(validators={ConstructorValidator.class, SwitchValidator.class})
public class ExpressionValidator
extends AbstractExpressionValidator {
    @Inject
    private ExpressionHelper exprHelper;
    @Inject
    private ImplicitVariableUtil implicitVarUtil;
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private RosettaFunctionExtensions functionExtensions;

    @Check
    public void checkWithMetaOperation(WithMetaOperation operation) {
        RosettaExpression argument = operation.getArgument();
        this.isSingleCheckError(argument, operation, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "The with-meta operator can only be used with single cardinality arguments");
    }

    @Check
    public void checkWithMetaEntry(WithMetaEntry entry) {
        RosettaFeature metaType = entry.getKey();
        RMetaAnnotatedType expectedType = this.typeProvider.getRTypeOfFeature(metaType, null);
        this.isSingleCheckError(entry.getValue(), entry, (EStructuralFeature)ExpressionPackage.Literals.WITH_META_ENTRY__VALUE, String.format("Meta attribute '%s' was multi cardinality", metaType.getName()));
        this.subtypeCheck(expectedType, entry.getValue(), (EObject)entry, (EStructuralFeature)ExpressionPackage.Literals.WITH_META_ENTRY__VALUE, (String actual) -> String.format("Meta attribute '%s' should be of type '%s'", metaType.getName(), expectedType.getRType().getName()));
    }

    @Check
    public void checkCondition(Condition c) {
        this.isSingleCheck(c.getExpression(), (EObject)c, (EStructuralFeature)SimplePackage.Literals.CONDITION__EXPRESSION, "A condition should be single cardinality");
        this.subtypeCheck(this.builtins.BOOLEAN_WITH_NO_META, c.getExpression(), (EObject)c, (EStructuralFeature)SimplePackage.Literals.CONDITION__EXPRESSION, (String actual) -> "A condition must be a boolean");
    }

    @Check
    public void checkFunctionOperation(Operation op) {
        RosettaExpression expr = op.getExpression();
        if (expr != null && this.cardinalityProvider.isOutputListOfLists(expr)) {
            this.error("Assign expression contains a list of lists, use flatten to create a list", op, (EStructuralFeature)SimplePackage.Literals.OPERATION__EXPRESSION);
        }
        List segmentsAsSymbols = op.pathAsSegmentList().stream().map(s -> s.getFeature()).filter(f -> f instanceof RosettaSymbol).map(f -> (RosettaSymbol)((Object)f)).collect(Collectors.toList());
        AssignPathRoot attr = op.getPath() != null && !segmentsAsSymbols.isEmpty() ? (RosettaSymbol)segmentsAsSymbols.get(segmentsAsSymbols.size() - 1) : op.getAssignRoot();
        this.subtypeCheck(this.typeProvider.getRTypeOfSymbol(attr, null), expr, (EObject)op, (EStructuralFeature)SimplePackage.Literals.OPERATION__EXPRESSION, (String actual) -> "Cannot assign `" + actual + "` to output `" + attr.getName() + "`");
        boolean isList = this.cardinalityProvider.isSymbolMulti(attr);
        if (op.isAdd() && !isList) {
            this.error("`add` must be used with a list", op, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
        if (!op.isAdd() && isList) {
            this.info("`set` used with a list. Any existing list items will be overwritten. Use `add` to append items to existing list", op, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
        if (!isList) {
            this.isSingleCheck(expr, (EObject)op, (EStructuralFeature)SimplePackage.Literals.OPERATION__EXPRESSION, "Cannot assign a list to a single value");
        }
    }

    @Check
    public void checkArithmeticOperation(ArithmeticOperation op) {
        RosettaExpression left = op.getLeft();
        RosettaExpression right = op.getRight();
        String operator = op.getOperator();
        RMetaAnnotatedType leftType = this.typeProvider.getRMetaAnnotatedType(left);
        RMetaAnnotatedType rightType = this.typeProvider.getRMetaAnnotatedType(right);
        this.isSingleCheck(left, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, op);
        this.isSingleCheck(right, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, op);
        if (operator.equals("+")) {
            if (!this.typeSystem.isSubtypeOf(leftType, this.builtins.NOTHING_WITH_ANY_META)) {
                if (this.typeSystem.isSubtypeOf(leftType, this.builtins.DATE_WITH_NO_META)) {
                    this.subtypeCheck(this.builtins.TIME_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot add `" + actual + "` to a `date`");
                } else if (this.typeSystem.isSubtypeOf(leftType, this.builtins.UNCONSTRAINED_STRING_WITH_NO_META)) {
                    this.subtypeCheck(this.builtins.UNCONSTRAINED_STRING_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot add `" + actual + "` to a `string`");
                } else if (this.typeSystem.isSubtypeOf(leftType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
                    this.subtypeCheck(this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot add `" + actual + "` to a `number`");
                } else {
                    this.unsupportedTypeError(leftType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.UNCONSTRAINED_STRING, this.builtins.DATE);
                    if (!(this.typeSystem.isSubtypeOf(rightType, this.builtins.TIME_WITH_NO_META) || this.typeSystem.isSubtypeOf(rightType, this.builtins.UNCONSTRAINED_STRING_WITH_NO_META) || this.typeSystem.isSubtypeOf(rightType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META))) {
                        this.unsupportedTypeError(rightType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.UNCONSTRAINED_STRING, this.builtins.TIME);
                    }
                }
            }
        } else if (operator.equals("-")) {
            if (!this.typeSystem.isSubtypeOf(leftType, this.builtins.NOTHING_WITH_ANY_META)) {
                if (this.typeSystem.isSubtypeOf(leftType, this.builtins.DATE_WITH_NO_META)) {
                    this.subtypeCheck(this.builtins.DATE_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot subtract `" + actual + "` from a `date`");
                } else if (this.typeSystem.isSubtypeOf(leftType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
                    this.subtypeCheck(this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot subtract `" + actual + "` from a `number`");
                } else {
                    this.unsupportedTypeError(leftType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.DATE, new RType[0]);
                    if (!this.typeSystem.isSubtypeOf(rightType, this.builtins.DATE_WITH_NO_META) && !this.typeSystem.isSubtypeOf(rightType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
                        this.unsupportedTypeError(rightType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.DATE, new RType[0]);
                    }
                }
            }
        } else {
            this.subtypeCheck(this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META, leftType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, (RosettaOperation)op);
            this.subtypeCheck(this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (RosettaOperation)op);
        }
    }

    private void checkModifiedBinaryOperation(ModifiableBinaryOperation op) {
        RosettaExpression left = op.getLeft();
        RosettaExpression right = op.getRight();
        String removeModifierSuggestion = "Did you mean to remove the `" + op.getCardMod().getLiteral() + "` modifier on the `" + op.getOperator() + "` operator?";
        String flipOperandsSuggestion = "Did you mean to flip around the operands of the `" + op.getOperator() + "` operator?";
        String leftSuggestion = this.cardinalityProvider.isMulti(right) ? flipOperandsSuggestion : removeModifierSuggestion;
        String rightSuggestion = this.cardinalityProvider.isMulti(left) ? null : flipOperandsSuggestion;
        this.isMultiCheck(left, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, leftSuggestion);
        this.isSingleCheck(right, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, rightSuggestion);
    }

    @Check
    public void checkEqualityOperation(EqualityOperation op) {
        this.comparableTypeCheck(op);
        if (op.getCardMod() != CardinalityModifier.NONE) {
            this.checkModifiedBinaryOperation(op);
        } else {
            boolean rightIsMulti;
            boolean leftIsMulti = this.cardinalityProvider.isMulti(op.getLeft());
            if (leftIsMulti != (rightIsMulti = this.cardinalityProvider.isMulti(op.getRight()))) {
                this.error("Operator `" + op.getOperator() + "` should specify `all` or `any` when comparing a list to a single value", op, null);
            }
        }
    }

    @Check
    public void checkLogicalOperation(LogicalOperation op) {
        RosettaExpression left = op.getLeft();
        RosettaExpression right = op.getRight();
        RMetaAnnotatedType leftType = this.typeProvider.getRMetaAnnotatedType(left);
        RMetaAnnotatedType rightType = this.typeProvider.getRMetaAnnotatedType(right);
        this.isSingleCheck(left, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, op);
        this.isSingleCheck(right, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, op);
        this.subtypeCheck(this.builtins.BOOLEAN_WITH_NO_META, leftType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, (RosettaOperation)op);
        this.subtypeCheck(this.builtins.BOOLEAN_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (RosettaOperation)op);
    }

    @Check
    public void checkComparisonOperation(ComparisonOperation op) {
        RosettaExpression left = op.getLeft();
        RosettaExpression right = op.getRight();
        RMetaAnnotatedType leftType = this.typeProvider.getRMetaAnnotatedType(left);
        RMetaAnnotatedType rightType = this.typeProvider.getRMetaAnnotatedType(right);
        if (op.getCardMod() != CardinalityModifier.NONE) {
            this.checkModifiedBinaryOperation(op);
        } else {
            this.isSingleCheck(left, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, "Did you mean to use `all` or `any` in front of the `" + op.getOperator() + "` operator?");
            this.isSingleCheck(right, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, "Did you mean to use `all` or `any` in front of the `" + op.getOperator() + "` operator?");
        }
        if (!this.typeSystem.isSubtypeOf(leftType, this.builtins.NOTHING_WITH_ANY_META)) {
            if (this.typeSystem.isSubtypeOf(leftType, this.builtins.ZONED_DATE_TIME_WITH_NO_META)) {
                this.subtypeCheck(this.builtins.ZONED_DATE_TIME_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot compare a `" + actual + "` to a `zonedDateTime`");
            } else if (this.typeSystem.isSubtypeOf(leftType, this.builtins.DATE_WITH_NO_META)) {
                this.subtypeCheck(this.builtins.DATE_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot compare a `" + actual + "` to a `date`");
            } else if (this.typeSystem.isSubtypeOf(leftType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
                this.subtypeCheck(this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META, rightType, (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (String actual) -> "Cannot compare a `" + actual + "` to a `number`");
            } else {
                this.unsupportedTypeError(leftType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.DATE, this.builtins.ZONED_DATE_TIME);
                if (!(this.typeSystem.isSubtypeOf(rightType, this.builtins.ZONED_DATE_TIME_WITH_NO_META) || this.typeSystem.isSubtypeOf(rightType, this.builtins.DATE_WITH_NO_META) || this.typeSystem.isSubtypeOf(rightType, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META))) {
                    this.unsupportedTypeError(rightType, op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, this.builtins.UNCONSTRAINED_NUMBER, this.builtins.DATE, this.builtins.ZONED_DATE_TIME);
                }
            }
        }
    }

    @Check
    public void checkContainsExpression(RosettaContainsExpression expr) {
        this.isMultiCheck(expr.getLeft(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, "Did you mean to use the `=` operator instead?");
        this.comparableTypeCheck(expr);
    }

    @Check
    public void checkDisjointExpression(RosettaDisjointExpression expr) {
        this.isMultiCheck(expr.getLeft(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, expr);
        this.isMultiCheck(expr.getRight(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, expr);
        this.comparableTypeCheck(expr);
    }

    @Check
    public void checkConditionalExpression(RosettaConditionalExpression expr) {
        this.isSingleCheck(expr.getIf(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__IF, "The condition of an if-then-else expression should be single cardinality");
        this.subtypeCheck(this.builtins.BOOLEAN_WITH_NO_META, expr.getIf(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__IF, (String actual) -> "The condition of an if-then-else expression must be a boolean");
        this.commonTypeCheck(expr.getIfthen(), expr.getElsethen(), expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__ELSETHEN);
    }

    @Check
    public void checkListLiteral(ListLiteral expr) {
        this.commonTypeCheck((List<RosettaExpression>)expr.getElements(), expr, (EStructuralFeature)ExpressionPackage.Literals.LIST_LITERAL__ELEMENTS);
    }

    @Check
    public void checkDefaultOperation(DefaultOperation op) {
        this.commonTypeCheck(op.getLeft(), op.getRight(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT);
    }

    @Check
    public void checkSymbolReference(RosettaSymbolReference expr) {
        RosettaSymbol s = expr.getSymbol();
        if (this.ecoreUtil.isResolved(s)) {
            if (s instanceof RosettaCallableWithArgs) {
                int argCount;
                RosettaCallableWithArgs callable = (RosettaCallableWithArgs)s;
                int paramCount = callable.numberOfParameters();
                if (paramCount != (argCount = expr.getArgs().size())) {
                    this.error("Expected " + paramCount + " argument" + (paramCount == 1 ? "" : "s") + ", but got " + argCount + " instead", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
                }
                int minCount = Math.min(paramCount, argCount);
                if (callable instanceof RosettaExternalFunction) {
                    RosettaExternalFunction f2 = (RosettaExternalFunction)callable;
                    for (int i = 0; i < minCount; ++i) {
                        RosettaParameter param = (RosettaParameter)f2.getParameters().get(i);
                        RMetaAnnotatedType paramType = this.typeProvider.getRTypeOfSymbol(param, null);
                        RosettaExpression arg = (RosettaExpression)expr.getArgs().get(i);
                        this.isSingleCheck(arg, expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, i, null);
                        this.subtypeCheck(paramType, arg, (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, i, (String actual) -> "Cannot assign `" + actual + "` to parameter `" + param.getName() + "`");
                    }
                } else if (callable instanceof Function) {
                    Function f3 = (Function)callable;
                    for (int i = 0; i < minCount; ++i) {
                        Attribute param = (Attribute)f3.getInputs().get(i);
                        RMetaAnnotatedType paramType = this.typeProvider.getRTypeOfSymbol(param, null);
                        RosettaExpression arg = (RosettaExpression)expr.getArgs().get(i);
                        if (!this.cardinalityProvider.isSymbolMulti((RosettaSymbol)f3.getInputs().get(i))) {
                            this.isSingleCheck(arg, expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, i, null);
                        }
                        this.subtypeCheck(paramType, arg, (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, i, (String actual) -> "Cannot assign `" + actual + "` to input `" + param.getName() + "`");
                    }
                } else if (callable instanceof RosettaRule) {
                    RosettaRule f4 = (RosettaRule)callable;
                    if (minCount >= 1) {
                        RMetaAnnotatedType paramType = RMetaAnnotatedType.withNoMeta(this.typeSystem.getRuleInputType(f4));
                        RosettaExpression arg = (RosettaExpression)expr.getArgs().get(0);
                        this.isSingleCheck(arg, expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, 0, null);
                        this.subtypeCheck(paramType, arg, (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS, 0, (String actual) -> "Rule `" + f4.getName() + "` cannot be called with type `" + actual + "`");
                    }
                }
            } else {
                RMetaAnnotatedType implicitType;
                Iterable<? extends RosettaFeature> implicitFeatures;
                if (s instanceof Attribute && this.functionExtensions.isOutput((Attribute)s) && Iterables.any(implicitFeatures = this.ecoreUtil.allFeatures(implicitType = this.typeProvider.typeOfImplicitVariable(expr), (EObject)expr), f -> f.getName().equals(s.getName()))) {
                    this.error("Ambiguous reference. `" + s.getName() + "` may either refer to `item -> " + s.getName() + "` or to the output variable.", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
                }
                if (s instanceof RosettaEnumeration && !(expr.eContainer() instanceof RosettaFeatureCall)) {
                    String enumValues = ((RosettaEnumeration)s).getEnumValues().stream().map(v -> v.getName()).collect(Collectors.joining(", "));
                    this.error("Enum type `" + s.getName() + "` must be followed by ` -> <enum value>`. Possible values are: " + enumValues, expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
                }
                if (expr.isExplicitArguments()) {
                    this.error("A variable may not be called", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS);
                }
            }
        }
    }

    @Check
    public void checkExistsExpression(RosettaExistsExpression expr) {
        if (expr.getModifier() == ExistsModifier.MULTIPLE || expr.getModifier() == ExistsModifier.SINGLE) {
            this.isMultiCheck(expr.getArgument(), (EObject)expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, expr);
        }
    }

    private boolean mayBeEmpty(RType t) {
        return t instanceof RDataType && ((RDataType)t).getAllAttributes().stream().allMatch(a -> a.getCardinality().isOptional()) || t instanceof RChoiceType;
    }

    @Check
    public void checkOnlyExistsExpression(RosettaOnlyExistsExpression expr) {
        if (expr.getArgs().size() > 0) {
            for (RosettaExpression input : expr.getArgs()) {
                RosettaNamed invalidMetaFeature = null;
                EReference structFeature = null;
                if (input instanceof RosettaFeatureCall && ((RosettaFeatureCall)input).getFeature() instanceof RosettaMetaType) {
                    invalidMetaFeature = ((RosettaFeatureCall)input).getFeature();
                    structFeature = ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE;
                } else if (input instanceof RosettaSymbolReference && ((RosettaSymbolReference)input).getSymbol() instanceof RosettaMetaType) {
                    invalidMetaFeature = ((RosettaSymbolReference)input).getSymbol();
                    structFeature = ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL;
                }
                if (invalidMetaFeature == null) continue;
                this.error("Invalid use of `only exists` on meta feature " + invalidMetaFeature.getName(), input, (EStructuralFeature)structFeature);
            }
            RosettaExpression first = (RosettaExpression)expr.getArgs().get(0);
            RosettaExpression parent = this.exprHelper.getParentExpression(first);
            for (int i = 1; i < expr.getArgs().size(); ++i) {
                RosettaExpression otherParent;
                RosettaExpression other = (RosettaExpression)expr.getArgs().get(i);
                for (int j = 0; j < i; ++j) {
                    if (!EcoreUtil2.equals((EObject)((EObject)expr.getArgs().get(j)), (EObject)other)) continue;
                    this.error("Duplicate attribute", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS, i);
                }
                if (parent == null == ((otherParent = this.exprHelper.getParentExpression(other)) == null) && (parent == null || otherParent == null || EcoreUtil2.equals((EObject)parent, (EObject)otherParent))) continue;
                if (otherParent != null) {
                    this.error("All parent paths must be equal", otherParent, null);
                    continue;
                }
                this.error("All parent paths must be equal", other, null);
            }
            if (parent == null && !this.implicitVarUtil.implicitVariableExistsInContext(expr)) {
                this.error("Object must have a parent object", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS, 0);
            }
            RMetaAnnotatedType parentType = null;
            if (parent != null) {
                this.isSingleCheck(parent, (EObject)parent, null, "The `only exists` operator requires a single cardinality input");
                parentType = this.typeProvider.getRMetaAnnotatedType(parent);
            } else {
                if (this.cardinalityProvider.isImplicitVariableMulti(expr)) {
                    this.error("Expecting single cardinality input", expr, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS, 0);
                }
                parentType = this.typeProvider.typeOfImplicitVariable(expr);
            }
            RType parentData = parentType.getRType();
            if (!this.mayBeEmpty(parentData)) {
                this.unsupportedTypeError(parentType, "only exists", first, null, "All attributes of input type should be optional");
            }
        }
    }

    @Check
    public void checkOneOfOperation(OneOfOperation op) {
        this.isSingleCheck(op.getArgument(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, op);
        RMetaAnnotatedType argType = this.typeProvider.getRMetaAnnotatedType(op.getArgument());
        if (!this.mayBeEmpty(argType.getRType())) {
            this.unsupportedTypeError(argType, op.getOperator(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "All attributes of input type should be optional");
        }
    }

    @Check
    public void checkChoiceOperation(ChoiceOperation op) {
        this.isSingleCheck(op.getArgument(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, op);
        RMetaAnnotatedType argType = this.typeProvider.getRMetaAnnotatedType(op.getArgument());
        if (!(argType.getRType() instanceof RDataType)) {
            this.unsupportedTypeError(argType, op.getOperator(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "Input should be a complex type");
        }
        if (op.getAttributes().size() < 2) {
            this.error("At least two attributes must be passed to a choice rule", op, (EStructuralFeature)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES);
        }
        HashSet<Attribute> seen = new HashSet<Attribute>();
        for (int i = 0; i < op.getAttributes().size(); ++i) {
            Attribute attr = (Attribute)op.getAttributes().get(i);
            if (seen.add(attr)) continue;
            this.error("Duplicate attribute.", op, (EStructuralFeature)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES, i);
        }
    }

    @Check
    public void checkJoinOperation(JoinOperation op) {
        this.isMultiCheck(op.getLeft(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, op);
        this.isSingleCheck(op.getRight(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, op);
        this.subtypeCheck(this.builtins.UNCONSTRAINED_STRING_WITH_NO_META, op.getLeft(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__LEFT, (RosettaOperation)op);
        this.subtypeCheck(this.builtins.UNCONSTRAINED_STRING_WITH_NO_META, op.getRight(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT, (RosettaOperation)op);
    }

    @Check
    public void checkOnlyElement(RosettaOnlyElement e) {
    }
}

