/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.validation.expression.ExpressionValidator;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class SwitchValidator
extends ExpressionValidator {
    @Inject
    private RosettaInterpreter interpreter;
    @Inject
    private RosettaGrammarAccess grammar;

    @Check
    public void checkSwitch(SwitchOperation op) {
        this.isSingleCheck(op.getArgument(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, op);
        for (int i = 0; i < op.getCases().size() - 1; ++i) {
            SwitchCaseOrDefault caseStatement = (SwitchCaseOrDefault)op.getCases().get(i);
            if (!caseStatement.isDefault()) continue;
            this.errorKeyword("A default case is only allowed at the end", (EObject)caseStatement, this.grammar.getSwitchCaseOrDefaultAccess().getDefaultKeyword_0_0());
        }
        RMetaAnnotatedType argumentType = this.typeProvider.getRMetaAnnotatedType(op.getArgument());
        RType rType = this.typeSystem.stripFromTypeAliases(argumentType.getRType());
        if (rType.equals(this.builtins.NOTHING)) {
            return;
        }
        if (rType instanceof REnumType) {
            this.checkEnumSwitch((REnumType)rType, op);
        } else if (rType instanceof RBasicType) {
            this.checkBasicTypeSwitch((RBasicType)rType, op);
        } else if (rType instanceof RChoiceType) {
            this.checkChoiceSwitch((RChoiceType)rType, op);
        } else {
            this.unsupportedTypeError(argumentType, op.getOperator(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "Supported argument types are basic types, enumerations, and choice types");
        }
    }

    private void checkEnumSwitch(REnumType argumentType, SwitchOperation op) {
        HashSet<RosettaEnumValue> seenValues = new HashSet<RosettaEnumValue>();
        for (SwitchCaseOrDefault caseStatement : op.getCases()) {
            if (caseStatement.isDefault()) continue;
            RosettaEnumValue guard = caseStatement.getGuard().getEnumGuard();
            if (guard == null) {
                this.error("Case should match an enum value of " + String.valueOf(argumentType), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
                continue;
            }
            if (seenValues.add(guard)) continue;
            this.error("Duplicate case " + guard.getName(), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
        }
        if (op.getDefault() == null) {
            ArrayList<RosettaEnumValue> missingEnumValues = new ArrayList<RosettaEnumValue>(argumentType.getAllEnumValues());
            missingEnumValues.removeAll(seenValues);
            if (!missingEnumValues.isEmpty()) {
                String missingValuesMsg = missingEnumValues.stream().map(v -> v.getName()).collect(Collectors.joining(", "));
                this.error("Missing the following cases: " + missingValuesMsg + ". Either provide all or add a default.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }

    private void checkBasicTypeSwitch(RBasicType argumentType, SwitchOperation op) {
        HashSet<RosettaValue> seenValues = new HashSet<RosettaValue>();
        RMetaAnnotatedType argumentTypeWithoutMeta = RMetaAnnotatedType.withNoMeta(argumentType);
        for (SwitchCaseOrDefault caseStatement : op.getCases()) {
            RMetaAnnotatedType conditionType;
            if (caseStatement.isDefault()) continue;
            RosettaLiteral guard = caseStatement.getGuard().getLiteralGuard();
            if (guard == null) {
                this.error("Case should match a literal of type " + String.valueOf(argumentType), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
                continue;
            }
            if (!seenValues.add(this.interpreter.interpret(guard))) {
                this.error("Duplicate case", caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
            }
            if (this.typeSystem.isComparable(conditionType = this.typeProvider.getRMetaAnnotatedType(guard), argumentTypeWithoutMeta)) continue;
            this.error("Invalid case: " + this.notComparableMessage(conditionType, argumentTypeWithoutMeta), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
        }
    }

    private void checkChoiceSwitch(RChoiceType argumentType, SwitchOperation op) {
        HashMap<Object, RMetaAnnotatedType> includedOptions = new HashMap<Object, RMetaAnnotatedType>();
        for (Object caseStatement : op.getCases()) {
            if (caseStatement.isDefault()) continue;
            Object guard = caseStatement.getGuard().getChoiceOptionGuard();
            if (guard == null) {
                this.error("Case should match a choice option of type " + String.valueOf(argumentType), (EObject)caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
                continue;
            }
            RMetaAnnotatedType alreadyCovered = (RMetaAnnotatedType)includedOptions.get(guard);
            if (alreadyCovered != null) {
                this.error("Case already covered by " + String.valueOf(alreadyCovered), (EObject)caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__GUARD);
                continue;
            }
            RMetaAnnotatedType guardType = this.typeProvider.getRTypeOfSymbol((AssignPathRoot)guard);
            includedOptions.put(guard, guardType);
            RType valueType = guardType.getRType();
            if (!(valueType instanceof RChoiceType)) continue;
            ((RChoiceType)valueType).getAllOptions().forEach(it -> includedOptions.put(it.getEObject(), guardType));
        }
        if (op.getDefault() == null) {
            ArrayList missingOptions = new ArrayList();
            argumentType.getOwnOptions().forEach(opt -> missingOptions.add(opt.getType()));
            for (Object guard : new LinkedHashSet(includedOptions.values())) {
                for (int i = 0; i < missingOptions.size(); ++i) {
                    RMetaAnnotatedType opt2 = (RMetaAnnotatedType)missingOptions.get(i);
                    RType optValueType = opt2.getRType();
                    if (this.typeSystem.isSubtypeOf(opt2, (RMetaAnnotatedType)guard, false)) {
                        missingOptions.remove(i);
                        --i;
                        continue;
                    }
                    if (!(optValueType instanceof RChoiceType) || !this.typeSystem.isSubtypeOf((RMetaAnnotatedType)guard, opt2, false)) continue;
                    missingOptions.remove(i);
                    --i;
                    ((RChoiceType)optValueType).getOwnOptions().forEach(o -> missingOptions.add(o.getType()));
                }
            }
            if (!missingOptions.isEmpty()) {
                String missingOptsMsg = missingOptions.stream().map(opt -> opt.toString()).collect(Collectors.joining(", "));
                this.error("Missing the following cases: " + missingOptsMsg + ". Either provide all or add a default.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }
}

