/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsClientHandler;
import com.relayrides.pushy.apns.ApnsClientMetricsListener;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.ApnsServerException;
import com.relayrides.pushy.apns.AuthenticationTokenSupplier;
import com.relayrides.pushy.apns.ClientNotConnectedException;
import com.relayrides.pushy.apns.NoKeyForTopicException;
import com.relayrides.pushy.apns.NoopMetricsListener;
import com.relayrides.pushy.apns.PushNotificationResponse;
import com.relayrides.pushy.apns.SocketChannelClassUtil;
import com.relayrides.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SucceededFuture;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClient {
    private final Bootstrap bootstrap;
    private volatile ProxyHandlerFactory proxyHandlerFactory;
    private final boolean shouldShutDownEventLoopGroup;
    private long writeTimeoutMillis = 20000L;
    private Long gracefulShutdownTimeoutMillis;
    private volatile ChannelPromise connectionReadyPromise;
    private volatile ChannelPromise reconnectionPromise;
    private ScheduledFuture scheduledReconnectFuture;
    private long reconnectDelaySeconds = 1L;
    private final Map<ApnsPushNotification, Promise<PushNotificationResponse<ApnsPushNotification>>> responsePromises = new IdentityHashMap<ApnsPushNotification, Promise<PushNotificationResponse<ApnsPushNotification>>>();
    private ApnsClientMetricsListener metricsListener = new NoopMetricsListener();
    private final AtomicLong nextNotificationId = new AtomicLong(0L);
    private final boolean useTokenAuthentication;
    private final Map<String, Set<String>> topicsByTeamId = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, AuthenticationTokenSupplier> authenticationTokenSuppliersByTopic = new ConcurrentHashMap<String, AuthenticationTokenSupplier>();
    public static final long DEFAULT_WRITE_TIMEOUT_MILLIS = 20000L;
    public static final String PRODUCTION_APNS_HOST = "api.push.apple.com";
    public static final String DEVELOPMENT_APNS_HOST = "api.development.push.apple.com";
    public static final int DEFAULT_APNS_PORT = 443;
    public static final int ALTERNATE_APNS_PORT = 2197;
    private static final ClientNotConnectedException NOT_CONNECTED_EXCEPTION = new ClientNotConnectedException();
    private static final long INITIAL_RECONNECT_DELAY_SECONDS = 1L;
    private static final long MAX_RECONNECT_DELAY_SECONDS = 60L;
    static final int PING_IDLE_TIME_MILLIS = 60000;
    static final String EXPIRED_AUTH_TOKEN_REASON = "ExpiredProviderToken";
    private static final Logger log = LoggerFactory.getLogger(ApnsClient.class);

    protected ApnsClient(final SslContext sslContext, boolean useTokenAuthentication, EventLoopGroup eventLoopGroup) {
        this.useTokenAuthentication = useTokenAuthentication;
        this.bootstrap = new Bootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(SocketChannelClassUtil.getSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                ProxyHandlerFactory proxyHandlerFactory = ApnsClient.this.proxyHandlerFactory;
                if (proxyHandlerFactory != null) {
                    pipeline.addFirst(new ChannelHandler[]{proxyHandlerFactory.createProxyHandler()});
                }
                if (ApnsClient.this.writeTimeoutMillis > 0L) {
                    pipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(ApnsClient.this.writeTimeoutMillis, TimeUnit.MILLISECONDS)});
                }
                pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(""){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void configurePipeline(ChannelHandlerContext context, String protocol) {
                        if ("h2".equals(protocol)) {
                            ApnsClientHandler apnsClientHandler = new ApnsClientHandler.ApnsClientHandlerBuilder().server(false).apnsClient(ApnsClient.this).authority(((InetSocketAddress)context.channel().remoteAddress()).getHostName()).useTokenAuthentication(ApnsClient.this.useTokenAuthentication).encoderEnforceMaxConcurrentStreams(true).build();
                            Bootstrap bootstrap = ApnsClient.this.bootstrap;
                            synchronized (bootstrap) {
                                if (ApnsClient.this.gracefulShutdownTimeoutMillis != null) {
                                    apnsClientHandler.gracefulShutdownTimeoutMillis(ApnsClient.this.gracefulShutdownTimeoutMillis);
                                }
                            }
                            context.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 60000L, TimeUnit.MILLISECONDS)});
                            context.pipeline().addLast(new ChannelHandler[]{apnsClientHandler});
                            context.channel().eventLoop().submit(new Runnable(){

                                @Override
                                public void run() {
                                    ChannelPromise connectionReadyPromise = ApnsClient.this.connectionReadyPromise;
                                    if (connectionReadyPromise != null) {
                                        connectionReadyPromise.trySuccess();
                                    }
                                }
                            });
                        } else {
                            log.error("Unexpected protocol: {}", (Object)protocol);
                            context.close();
                        }
                    }

                    protected void handshakeFailure(ChannelHandlerContext context, Throwable cause) throws Exception {
                        ChannelPromise connectionReadyPromise = ApnsClient.this.connectionReadyPromise;
                        if (connectionReadyPromise != null) {
                            connectionReadyPromise.tryFailure(cause);
                        }
                        super.handshakeFailure(context, cause);
                    }
                }});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionTimeout(int timeoutMillis) {
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChannelWriteBufferWatermark(WriteBufferWaterMark writeBufferWaterMark) {
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark);
        }
    }

    protected void setMetricsListener(ApnsClientMetricsListener metricsListener) {
        this.metricsListener = metricsListener != null ? metricsListener : new NoopMetricsListener();
    }

    protected void setProxyHandlerFactory(ProxyHandlerFactory proxyHandlerFactory) {
        this.proxyHandlerFactory = proxyHandlerFactory;
        this.bootstrap.resolver((AddressResolverGroup)(proxyHandlerFactory == null ? DefaultAddressResolverGroup.INSTANCE : NoopAddressResolverGroup.INSTANCE));
    }

    protected void setWriteTimeout(long writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGracefulShutdownTimeout(long timeoutMillis) {
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            ApnsClientHandler handler;
            this.gracefulShutdownTimeoutMillis = timeoutMillis;
            if (this.connectionReadyPromise != null && (handler = (ApnsClientHandler)this.connectionReadyPromise.channel().pipeline().get(ApnsClientHandler.class)) != null) {
                handler.gracefulShutdownTimeoutMillis(timeoutMillis);
            }
        }
    }

    public Future<Void> connect(String host) {
        return this.connect(host, 443);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> connect(final String host, final int port) {
        FailedFuture connectionReadyFuture;
        if (this.bootstrap.config().group().isShuttingDown() || this.bootstrap.config().group().isShutdown()) {
            connectionReadyFuture = new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)new IllegalStateException("Client's event loop group has been shut down and cannot be restarted."));
        } else {
            Bootstrap bootstrap = this.bootstrap;
            synchronized (bootstrap) {
                if (this.connectionReadyPromise == null) {
                    this.metricsListener.handleConnectionAttemptStarted(this);
                    ChannelFuture connectFuture = this.bootstrap.connect(host, port);
                    this.connectionReadyPromise = connectFuture.channel().newPromise();
                    connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ChannelPromise connectionReadyPromise;
                            if (!future.isSuccess() && (connectionReadyPromise = ApnsClient.this.connectionReadyPromise) != null) {
                                connectionReadyPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    connectFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            Bootstrap bootstrap = ApnsClient.this.bootstrap;
                            synchronized (bootstrap) {
                                if (ApnsClient.this.connectionReadyPromise != null) {
                                    ApnsClient.this.connectionReadyPromise.tryFailure((Throwable)new IllegalStateException("Channel closed before HTTP/2 preface completed."));
                                    ApnsClient.this.connectionReadyPromise = null;
                                }
                                if (ApnsClient.this.reconnectionPromise != null) {
                                    log.debug("Disconnected. Next automatic reconnection attempt in {} seconds.", (Object)ApnsClient.this.reconnectDelaySeconds);
                                    ApnsClient.this.scheduledReconnectFuture = future.channel().eventLoop().schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            log.debug("Attempting to reconnect.");
                                            ApnsClient.this.connect(host, port);
                                        }
                                    }, ApnsClient.this.reconnectDelaySeconds, TimeUnit.SECONDS);
                                    ApnsClient.this.reconnectDelaySeconds = Math.min(ApnsClient.this.reconnectDelaySeconds, 60L);
                                }
                            }
                            future.channel().eventLoop().submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (Promise responsePromise : ApnsClient.this.responsePromises.values()) {
                                        responsePromise.tryFailure((Throwable)new ClientNotConnectedException("Client disconnected unexpectedly."));
                                    }
                                    ApnsClient.this.responsePromises.clear();
                                }
                            });
                        }
                    });
                    this.connectionReadyPromise.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                Bootstrap bootstrap = ApnsClient.this.bootstrap;
                                synchronized (bootstrap) {
                                    if (ApnsClient.this.reconnectionPromise != null) {
                                        log.info("Connection to {} restored.", (Object)future.channel().remoteAddress());
                                        ApnsClient.this.reconnectionPromise.trySuccess();
                                    } else {
                                        log.info("Connected to {}.", (Object)future.channel().remoteAddress());
                                    }
                                    ApnsClient.this.reconnectDelaySeconds = 1L;
                                    ApnsClient.this.reconnectionPromise = future.channel().newPromise();
                                }
                                ApnsClient.this.metricsListener.handleConnectionAttemptSucceeded(ApnsClient.this);
                            } else {
                                log.info("Failed to connect.", future.cause());
                                ApnsClient.this.metricsListener.handleConnectionAttemptFailed(ApnsClient.this);
                            }
                        }
                    });
                }
                connectionReadyFuture = this.connectionReadyPromise;
            }
        }
        return connectionReadyFuture;
    }

    public boolean isConnected() {
        ChannelPromise connectionReadyPromise = this.connectionReadyPromise;
        return connectionReadyPromise != null && connectionReadyPromise.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> getReconnectionFuture() {
        Object reconnectionFuture;
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            reconnectionFuture = this.isConnected() ? this.connectionReadyPromise.channel().newSucceededFuture() : (this.reconnectionPromise != null ? this.reconnectionPromise : new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)new IllegalStateException("Client was not previously connected.")));
        }
        return reconnectionFuture;
    }

    public void registerSigningKey(File signingKeyPemFile, String teamId, String keyId, Collection<String> topics) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        this.registerSigningKey(signingKeyPemFile, teamId, keyId, topics.toArray(new String[0]));
    }

    public void registerSigningKey(File signingKeyPemFile, String teamId, String keyId, String ... topics) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        try (FileInputStream signingKeyInputStream = new FileInputStream(signingKeyPemFile);){
            this.registerSigningKey((InputStream)signingKeyInputStream, teamId, keyId, topics);
        }
    }

    public void registerSigningKey(InputStream signingKeyInputStream, String teamId, String keyId, Collection<String> topics) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        this.registerSigningKey(signingKeyInputStream, teamId, keyId, topics.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSigningKey(InputStream signingKeyInputStream, String teamId, String keyId, String ... topics) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        ECPrivateKey signingKey;
        String line;
        StringBuilder privateKeyBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(signingKeyInputStream));
        boolean haveReadHeader = false;
        boolean haveReadFooter = false;
        while ((line = reader.readLine()) != null) {
            if (!haveReadHeader) {
                if (!line.contains("BEGIN PRIVATE KEY")) continue;
                haveReadHeader = true;
                continue;
            }
            if (line.contains("END PRIVATE KEY")) {
                haveReadFooter = true;
                break;
            }
            privateKeyBuilder.append(line);
        }
        if (!haveReadHeader || !haveReadFooter) {
            throw new IOException("Could not find private key header/footer");
        }
        String base64EncodedPrivateKey = privateKeyBuilder.toString();
        ByteBuf wrappedEncodedPrivateKey = Unpooled.wrappedBuffer((byte[])base64EncodedPrivateKey.getBytes(StandardCharsets.US_ASCII));
        try {
            ByteBuf decodedPrivateKey = Base64.decode((ByteBuf)wrappedEncodedPrivateKey);
            try {
                byte[] keyBytes = new byte[decodedPrivateKey.readableBytes()];
                decodedPrivateKey.readBytes(keyBytes);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                signingKey = (ECPrivateKey)keyFactory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e);
            }
            finally {
                decodedPrivateKey.release();
            }
        }
        finally {
            wrappedEncodedPrivateKey.release();
        }
        this.registerSigningKey(signingKey, teamId, keyId, topics);
    }

    public void registerSigningKey(ECPrivateKey signingKey, String teamId, String keyId, Collection<String> topics) throws InvalidKeyException, NoSuchAlgorithmException {
        this.registerSigningKey(signingKey, teamId, keyId, topics.toArray(new String[0]));
    }

    public void registerSigningKey(ECPrivateKey signingKey, String teamId, String keyId, String ... topics) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.useTokenAuthentication) {
            throw new IllegalStateException("Cannot register signing keys with clients that use TLS-based authentication.");
        }
        this.removeKeyForTeam(teamId);
        AuthenticationTokenSupplier tokenSupplier = new AuthenticationTokenSupplier(teamId, keyId, signingKey);
        HashSet<String> topicSet = new HashSet<String>();
        for (String topic : topics) {
            topicSet.add(topic);
            this.authenticationTokenSuppliersByTopic.put(topic, tokenSupplier);
        }
        this.topicsByTeamId.put(teamId, topicSet);
    }

    public void removeKeyForTeam(String teamId) {
        Set<String> oldTopics = this.topicsByTeamId.remove(teamId);
        if (oldTopics != null) {
            for (String topic : oldTopics) {
                this.authenticationTokenSuppliersByTopic.remove(topic);
            }
        }
    }

    protected AuthenticationTokenSupplier getAuthenticationTokenSupplierForTopic(String topic) throws NoKeyForTopicException {
        AuthenticationTokenSupplier supplier = this.authenticationTokenSuppliersByTopic.get(topic);
        if (supplier == null) {
            throw new NoKeyForTopicException("No signing key found for topic " + topic);
        }
        return supplier;
    }

    public <T extends ApnsPushNotification> Future<PushNotificationResponse<T>> sendNotification(T notification) {
        return this.sendNotification(notification, null);
    }

    private <T extends ApnsPushNotification> Future<PushNotificationResponse<T>> sendNotification(final T notification, Promise<PushNotificationResponse<ApnsPushNotification>> promise) {
        FailedFuture responseFuture;
        final long notificationId = this.nextNotificationId.getAndIncrement();
        ChannelPromise connectionReadyPromise = this.connectionReadyPromise;
        if (connectionReadyPromise != null && connectionReadyPromise.isSuccess() && connectionReadyPromise.channel().isActive()) {
            DefaultPromise responsePromise = promise != null ? promise : new DefaultPromise((EventExecutor)connectionReadyPromise.channel().eventLoop());
            connectionReadyPromise.channel().eventLoop().submit(new Runnable((Promise)responsePromise){
                final /* synthetic */ Promise val$responsePromise;
                {
                    this.val$responsePromise = promise;
                }

                @Override
                public void run() {
                    if (ApnsClient.this.responsePromises.containsKey(notification)) {
                        this.val$responsePromise.setFailure((Throwable)new IllegalStateException("The given notification has already been sent and not yet resolved."));
                    } else {
                        ApnsClient.this.responsePromises.put(notification, this.val$responsePromise);
                    }
                }
            });
            connectionReadyPromise.channel().writeAndFlush(notification).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>((Promise)responsePromise){
                final /* synthetic */ Promise val$responsePromise;
                {
                    this.val$responsePromise = promise;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ApnsClient.this.metricsListener.handleNotificationSent(ApnsClient.this, notificationId);
                    } else {
                        log.debug("Failed to write push notification: {}", (Object)notification, (Object)future.cause());
                        ApnsClient.this.responsePromises.remove(notification);
                        this.val$responsePromise.tryFailure(future.cause());
                    }
                }
            });
            responseFuture = responsePromise;
        } else {
            log.debug("Failed to send push notification because client is not connected: {}", notification);
            responseFuture = new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)NOT_CONNECTED_EXCEPTION);
        }
        responseFuture.addListener(new GenericFutureListener<Future<PushNotificationResponse<T>>>(){

            public void operationComplete(Future<PushNotificationResponse<T>> future) throws Exception {
                if (future.isSuccess()) {
                    PushNotificationResponse response = (PushNotificationResponse)future.getNow();
                    if (response.isAccepted()) {
                        ApnsClient.this.metricsListener.handleNotificationAccepted(ApnsClient.this, notificationId);
                    } else {
                        ApnsClient.this.metricsListener.handleNotificationRejected(ApnsClient.this, notificationId);
                    }
                } else {
                    ApnsClient.this.metricsListener.handleWriteFailure(ApnsClient.this, notificationId);
                }
            }
        });
        return responseFuture;
    }

    protected void handlePushNotificationResponse(PushNotificationResponse<ApnsPushNotification> response) {
        log.debug("Received response from APNs gateway: {}", response);
        Promise<PushNotificationResponse<ApnsPushNotification>> responsePromise = this.responsePromises.remove(response.getPushNotification());
        if (EXPIRED_AUTH_TOKEN_REASON.equals(response.getRejectionReason())) {
            this.sendNotification(response.getPushNotification(), responsePromise);
        } else {
            responsePromise.setSuccess(response);
        }
    }

    protected void handleServerError(ApnsPushNotification pushNotification, String message) {
        log.warn("APNs server reported an internal error when sending {}.", (Object)pushNotification);
        this.responsePromises.remove(pushNotification).tryFailure((Throwable)new ApnsServerException(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> disconnect() {
        ChannelFuture disconnectFuture;
        log.info("Disconnecting.");
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            this.reconnectionPromise = null;
            if (this.scheduledReconnectFuture != null) {
                this.scheduledReconnectFuture.cancel(true);
            }
            Object channelCloseFuture = this.connectionReadyPromise != null ? this.connectionReadyPromise.channel().close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
            if (this.shouldShutDownEventLoopGroup) {
                channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        ApnsClient.this.bootstrap.config().group().shutdownGracefully();
                    }
                });
                disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
                this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                    final /* synthetic */ Future val$disconnectFuture;
                    {
                        this.val$disconnectFuture = future;
                    }

                    public void operationComplete(Future future) throws Exception {
                        assert (this.val$disconnectFuture instanceof DefaultPromise);
                        ((DefaultPromise)this.val$disconnectFuture).trySuccess(null);
                    }
                });
            } else {
                disconnectFuture = channelCloseFuture;
            }
        }
        return disconnectFuture;
    }
}

