/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.relayrides.pushy.apns.ApnsClient;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import com.relayrides.pushy.apns.ErrorResponse;
import com.relayrides.pushy.apns.NoKeyForTopicException;
import com.relayrides.pushy.apns.SimplePushNotificationResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.ScheduledFuture;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsClientHandler
extends Http2ConnectionHandler {
    private long nextStreamId = 1L;
    private final Map<Integer, ApnsPushNotification> pushNotificationsByStreamId = new HashMap<Integer, ApnsPushNotification>();
    private final Map<Integer, String> authenticationTokensByStreamId = new HashMap<Integer, String>();
    private final Map<Integer, Http2Headers> headersByStreamId = new HashMap<Integer, Http2Headers>();
    private final ApnsClient apnsClient;
    private final String authority;
    private final boolean useTokenAuthentication;
    private long nextPingId = new Random().nextLong();
    private ScheduledFuture<?> pingTimeoutFuture;
    private static final int PING_TIMEOUT = 30;
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_EXPIRATION_HEADER = new AsciiString((CharSequence)"apns-expiration");
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_COLLAPSE_ID_HEADER = new AsciiString((CharSequence)"apns-collapse-id");
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final long STREAM_ID_RESET_THRESHOLD = 0x7FFFFFFEL;
    private static final int INITIAL_PAYLOAD_BUFFER_CAPACITY = 4096;
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.MILLISECONDS)).create();
    private static final Logger log = LoggerFactory.getLogger(ApnsClientHandler.class);

    protected ApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ApnsClient apnsClient, String authority, boolean useTokenAuthentication) {
        super(decoder, encoder, initialSettings);
        this.apnsClient = apnsClient;
        this.authority = authority;
        this.useTokenAuthentication = useTokenAuthentication;
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) throws Http2Exception {
        try {
            try {
                String authenticationToken;
                final ApnsPushNotification pushNotification = (ApnsPushNotification)message;
                final int streamId = (int)this.nextStreamId;
                Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)HttpMethod.POST.asciiName()).authority((CharSequence)this.authority).path((CharSequence)(APNS_PATH_PREFIX + pushNotification.getToken())).addInt((Object)APNS_EXPIRATION_HEADER, pushNotification.getExpiration() == null ? 0 : (int)(pushNotification.getExpiration().getTime() / 1000L));
                if (this.useTokenAuthentication) {
                    authenticationToken = this.apnsClient.getAuthenticationTokenSupplierForTopic(pushNotification.getTopic()).getToken();
                    headers.add((Object)APNS_AUTHORIZATION_HEADER, (Object)("bearer " + authenticationToken));
                } else {
                    authenticationToken = null;
                }
                if (pushNotification.getCollapseId() != null) {
                    headers.add((Object)APNS_COLLAPSE_ID_HEADER, (Object)pushNotification.getCollapseId());
                }
                if (pushNotification.getPriority() != null) {
                    headers.addInt((Object)APNS_PRIORITY_HEADER, pushNotification.getPriority().getCode());
                }
                if (pushNotification.getTopic() != null) {
                    headers.add((Object)APNS_TOPIC_HEADER, (Object)pushNotification.getTopic());
                }
                ChannelPromise headersPromise = context.newPromise();
                this.encoder().writeHeaders(context, streamId, headers, 0, false, headersPromise);
                log.trace("Wrote headers on stream {}: {}", (Object)streamId, (Object)headers);
                ByteBuf payloadBuffer = context.alloc().ioBuffer(4096);
                payloadBuffer.writeBytes(pushNotification.getPayload().getBytes(StandardCharsets.UTF_8));
                ChannelPromise dataPromise = context.newPromise();
                this.encoder().writeData(context, streamId, payloadBuffer, 0, true, dataPromise);
                log.trace("Wrote payload on stream {}: {}", (Object)streamId, (Object)pushNotification.getPayload());
                PromiseCombiner promiseCombiner = new PromiseCombiner();
                promiseCombiner.addAll(new Promise[]{headersPromise, dataPromise});
                promiseCombiner.finish((Promise)writePromise);
                writePromise.addListener((GenericFutureListener)new GenericFutureListener<ChannelPromise>(){

                    public void operationComplete(ChannelPromise future) throws Exception {
                        if (future.isSuccess()) {
                            ApnsClientHandler.this.pushNotificationsByStreamId.put(streamId, pushNotification);
                            if (ApnsClientHandler.this.useTokenAuthentication) {
                                ApnsClientHandler.this.authenticationTokensByStreamId.put(streamId, authenticationToken);
                            }
                        } else {
                            log.trace("Failed to write push notification on stream {}.", (Object)streamId, (Object)future.cause());
                        }
                    }
                });
                this.nextStreamId += 2L;
                if (this.nextStreamId >= 0x7FFFFFFEL) {
                    context.close();
                }
            }
            catch (NoKeyForTopicException | SignatureException e) {
                writePromise.tryFailure((Throwable)e);
            }
        }
        catch (ClassCastException e) {
            log.error("Unexpected object in pipeline: {}", message);
            context.write(message, writePromise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            log.trace("Sending ping due to inactivity.");
            ByteBuf pingDataBuffer = context.alloc().ioBuffer(8, 8);
            pingDataBuffer.writeLong(this.nextPingId++);
            this.encoder().writePing(context, false, pingDataBuffer, context.newPromise()).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(final ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ApnsClientHandler.this.pingTimeoutFuture = future.channel().eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                log.debug("Closing channel due to ping timeout.");
                                future.channel().close();
                            }
                        }, 30L, TimeUnit.SECONDS);
                    } else {
                        log.debug("Failed to write PING frame.", future.cause());
                        future.channel().close();
                    }
                }
            });
            this.flush(context);
        }
        super.userEventTriggered(context, event);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        if (cause instanceof WriteTimeoutException) {
            log.debug("Closing connection due to write timeout.");
            context.close();
        } else {
            log.warn("APNs client pipeline caught an exception.", cause);
        }
    }

    private class ApnsClientHandlerFrameAdapter
    extends Http2FrameAdapter {
        private ApnsClientHandlerFrameAdapter() {
        }

        public void onSettingsRead(ChannelHandlerContext context, Http2Settings settings) {
            log.trace("Received settings from APNs gateway: {}", (Object)settings);
        }

        public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            log.trace("Received data from APNs gateway on stream {}: {}", (Object)streamId, (Object)data.toString(StandardCharsets.UTF_8));
            int bytesProcessed = data.readableBytes() + padding;
            if (endOfStream) {
                Http2Headers headers = (Http2Headers)ApnsClientHandler.this.headersByStreamId.remove(streamId);
                String authenticationToken = (String)ApnsClientHandler.this.authenticationTokensByStreamId.remove(streamId);
                ApnsPushNotification pushNotification = (ApnsPushNotification)ApnsClientHandler.this.pushNotificationsByStreamId.remove(streamId);
                HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
                String responseBody = data.toString(StandardCharsets.UTF_8);
                if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
                    ApnsClientHandler.this.apnsClient.handleServerError(pushNotification, responseBody);
                } else {
                    ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(responseBody, ErrorResponse.class);
                    if ("ExpiredProviderToken".equals(errorResponse.getReason())) {
                        try {
                            ApnsClientHandler.this.apnsClient.getAuthenticationTokenSupplierForTopic(pushNotification.getTopic()).invalidateToken(authenticationToken);
                        }
                        catch (NoKeyForTopicException e) {
                            log.warn("Authentication token expired, but no key registered for topic {}", (Object)pushNotification.getTopic());
                        }
                    }
                    ApnsClientHandler.this.apnsClient.handlePushNotificationResponse(new SimplePushNotificationResponse<ApnsPushNotification>(pushNotification, HttpResponseStatus.OK.equals((Object)status), errorResponse.getReason(), errorResponse.getTimestamp()));
                }
            } else {
                log.error("Gateway sent a DATA frame that was not the end of a stream.");
            }
            return bytesProcessed;
        }

        public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            this.onHeadersRead(context, streamId, headers, padding, endOfStream);
        }

        public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            log.trace("Received headers from APNs gateway on stream {}: {}", (Object)streamId, (Object)headers);
            if (endOfStream) {
                HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
                boolean success = HttpResponseStatus.OK.equals((Object)status);
                if (!success) {
                    log.warn("Gateway sent an end-of-stream HEADERS frame for an unsuccessful notification.");
                }
                ApnsPushNotification pushNotification = (ApnsPushNotification)ApnsClientHandler.this.pushNotificationsByStreamId.remove(streamId);
                ApnsClientHandler.this.authenticationTokensByStreamId.remove(streamId);
                if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
                    ApnsClientHandler.this.apnsClient.handleServerError(pushNotification, null);
                } else {
                    ApnsClientHandler.this.apnsClient.handlePushNotificationResponse(new SimplePushNotificationResponse<ApnsPushNotification>(pushNotification, success, null, null));
                }
            } else {
                ApnsClientHandler.this.headersByStreamId.put(streamId, headers);
            }
        }

        public void onPingAckRead(ChannelHandlerContext context, ByteBuf data) {
            if (ApnsClientHandler.this.pingTimeoutFuture != null) {
                log.trace("Received reply to ping.");
                ApnsClientHandler.this.pingTimeoutFuture.cancel(false);
            } else {
                log.error("Received PING ACK, but no corresponding outbound PING found.");
            }
        }

        public void onGoAwayRead(ChannelHandlerContext context, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            log.info("Received GOAWAY from APNs server: {}", (Object)debugData.toString(StandardCharsets.UTF_8));
        }
    }

    public static class ApnsClientHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<ApnsClientHandler, ApnsClientHandlerBuilder> {
        private ApnsClient apnsClient;
        private String authority;
        private boolean useTokenAuthentication;

        public ApnsClientHandlerBuilder apnsClient(ApnsClient apnsClient) {
            this.apnsClient = apnsClient;
            return this;
        }

        public ApnsClient apnsClient() {
            return this.apnsClient;
        }

        public ApnsClientHandlerBuilder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public String authority() {
            return this.authority;
        }

        public ApnsClientHandlerBuilder useTokenAuthentication(boolean useTokenAuthentication) {
            this.useTokenAuthentication = useTokenAuthentication;
            return this;
        }

        public boolean useTokenAuthentication() {
            return this.useTokenAuthentication;
        }

        public ApnsClientHandlerBuilder server(boolean isServer) {
            return (ApnsClientHandlerBuilder)super.server(isServer);
        }

        public ApnsClientHandlerBuilder encoderEnforceMaxConcurrentStreams(boolean enforceMaxConcurrentStreams) {
            return (ApnsClientHandlerBuilder)super.encoderEnforceMaxConcurrentStreams(enforceMaxConcurrentStreams);
        }

        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            ApnsClientHandler handler;
            Objects.requireNonNull(this.authority(), "Authority must be set before building an ApnsClientHandler.");
            ApnsClientHandler apnsClientHandler = handler = new ApnsClientHandler(decoder, encoder, initialSettings, this.apnsClient(), this.authority(), this.useTokenAuthentication());
            ((Object)((Object)apnsClientHandler)).getClass();
            this.frameListener((Http2FrameListener)apnsClientHandler.new ApnsClientHandlerFrameAdapter());
            return handler;
        }

        public ApnsClientHandler build() {
            return (ApnsClientHandler)super.build();
        }
    }
}

