/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class DateAsTimeSinceEpochTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final TimeUnit timeUnit;

    public DateAsTimeSinceEpochTypeAdapter(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        this.timeUnit = timeUnit;
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Date date;
        if (json.isJsonPrimitive()) {
            date = new Date(this.timeUnit.toMillis(json.getAsLong()));
        } else if (json.isJsonNull()) {
            date = null;
        } else {
            throw new JsonParseException("Dates represented as time since the epoch must either be numbers or null.");
        }
        return date;
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        Object element = src != null ? new JsonPrimitive((Number)this.timeUnit.convert(src.getTime(), TimeUnit.MILLISECONDS)) : JsonNull.INSTANCE;
        return element;
    }
}

