/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.relayrides.pushy.apns.AuthenticationTokenClaims;
import com.relayrides.pushy.apns.AuthenticationTokenHeader;
import com.relayrides.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import com.relayrides.pushy.apns.DeliveryPriority;
import com.relayrides.pushy.apns.ErrorResponse;
import com.relayrides.pushy.apns.MockApnsServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MockApnsServerHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private final MockApnsServer apnsServer;
    private final boolean useTokenAuthentication;
    private final Set<String> topicsFromClientCertificate;
    private final Map<Integer, UUID> requestsWaitingForDataFrame = new HashMap<Integer, UUID>();
    private final Map<String, Date> authenticationTokenExpirationTimes = new HashMap<String, Date>();
    private final Map<String, Set<String>> verifiedAuthenticationTokensByTopic = new HashMap<String, Set<String>>();
    private static final Http2Headers SUCCESS_HEADERS = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_ID_HEADER = new AsciiString((CharSequence)"apns-id");
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final int MAX_CONTENT_LENGTH = 4096;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[0-9a-fA-F]{64}");
    private static final long AUTH_TOKEN_EXPIRATION_MILLIS = TimeUnit.HOURS.toMillis(1L);
    private static final Gson PAYLOAD_GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.MILLISECONDS)).create();
    private static final Gson AUTH_GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.SECONDS)).create();

    protected MockApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, MockApnsServer apnsServer, boolean useTokenAuthentication, String baseTopicFromCertificate) {
        super(decoder, encoder, initialSettings);
        this.apnsServer = apnsServer;
        this.useTokenAuthentication = useTokenAuthentication;
        this.topicsFromClientCertificate = new HashSet<String>();
        if (baseTopicFromCertificate != null) {
            this.topicsFromClientCertificate.add(baseTopicFromCertificate);
            this.topicsFromClientCertificate.add(baseTopicFromCertificate + ".voip");
            this.topicsFromClientCertificate.add(baseTopicFromCertificate + ".complication");
        }
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        int bytesProcessed = data.readableBytes() + padding;
        if (endOfStream && this.requestsWaitingForDataFrame.containsKey(streamId)) {
            UUID apnsId = this.requestsWaitingForDataFrame.remove(streamId);
            if (data.readableBytes() <= 4096) {
                context.channel().writeAndFlush((Object)new AcceptNotificationResponse(streamId));
            } else {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.PAYLOAD_TOO_LARGE));
            }
        }
        return bytesProcessed;
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        CharSequence pathSequence;
        Integer priorityCode;
        String topic;
        String authorizationString;
        UUID apnsId;
        if (this.apnsServer.shouldEmulateInternalErrors()) {
            context.channel().writeAndFlush((Object)new InternalServerErrorResponse(streamId));
        }
        if (!HttpMethod.POST.asciiName().contentEquals((CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.METHOD.value()))) {
            context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, null, ErrorReason.METHOD_NOT_ALLOWED));
            return;
        }
        CharSequence apnsIdSequence = (CharSequence)headers.get((Object)APNS_ID_HEADER);
        if (apnsIdSequence != null) {
            try {
                apnsId = UUID.fromString(apnsIdSequence.toString());
            }
            catch (IllegalArgumentException e) {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, null, ErrorReason.BAD_MESSAGE_ID));
                return;
            }
        } else {
            apnsId = UUID.randomUUID();
        }
        if (endOfStream) {
            context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.PAYLOAD_EMPTY));
            return;
        }
        CharSequence authorizationSequence = (CharSequence)headers.get((Object)APNS_AUTHORIZATION_HEADER);
        String authenticationToken = authorizationSequence != null ? ((authorizationString = authorizationSequence.toString()).startsWith("bearer") ? authorizationString.substring("bearer".length()).trim() : null) : null;
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String string = topic = topicSequence != null ? topicSequence.toString() : null;
        if (this.useTokenAuthentication) {
            Set<String> verifiedTokensForTopic = this.verifiedAuthenticationTokensByTopic.get(topic);
            if (verifiedTokensForTopic != null && verifiedTokensForTopic.contains(authenticationToken)) {
                Date now = new Date();
                Date tokenExpiration = this.authenticationTokenExpirationTimes.get(authenticationToken);
                if (now.after(tokenExpiration)) {
                    verifiedTokensForTopic.remove(authenticationToken);
                    this.authenticationTokenExpirationTimes.remove(authenticationToken);
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.EXPIRED_PROVIDER_TOKEN));
                    return;
                }
            } else {
                try {
                    AuthenticationTokenClaims claims = this.getVerifiedClaimsFromAuthenticationToken(authenticationToken);
                    Set<String> topics = this.apnsServer.getTopicsForTeamId(claims.getIssuer());
                    if (topics == null || !topics.contains(topic)) {
                        context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.DEVICE_TOKEN_NOT_FOR_TOPIC));
                        return;
                    }
                    if (!this.verifiedAuthenticationTokensByTopic.containsKey(topic)) {
                        this.verifiedAuthenticationTokensByTopic.put(topic, new HashSet());
                    }
                    this.verifiedAuthenticationTokensByTopic.get(topic).add(authenticationToken);
                    this.authenticationTokenExpirationTimes.put(authenticationToken, new Date(System.currentTimeMillis() + AUTH_TOKEN_EXPIRATION_MILLIS));
                }
                catch (InvalidAuthenticationTokenException e) {
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.INVALID_PROVIDER_TOKEN));
                    return;
                }
                catch (ExpiredAuthenticationTokenException e) {
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.EXPIRED_PROVIDER_TOKEN));
                    return;
                }
            }
        } else if (topic != null) {
            if (!this.topicsFromClientCertificate.contains(topic)) {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.BAD_TOPIC));
                return;
            }
        } else {
            context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.MISSING_TOPIC));
            return;
        }
        if ((priorityCode = headers.getInt((Object)APNS_PRIORITY_HEADER)) != null) {
            try {
                DeliveryPriority.getFromCode(priorityCode);
            }
            catch (IllegalArgumentException e) {
                context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.BAD_PRIORITY));
                return;
            }
        }
        if ((pathSequence = (CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value())) != null) {
            String pathString = pathSequence.toString();
            if (pathString.startsWith(APNS_PATH_PREFIX)) {
                String tokenString = pathString.substring(APNS_PATH_PREFIX.length());
                Matcher tokenMatcher = TOKEN_PATTERN.matcher(tokenString);
                if (!tokenMatcher.matches()) {
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.BAD_DEVICE_TOKEN));
                    return;
                }
                Date expirationTimestamp = this.apnsServer.getExpirationTimestampForTokenInTopic(tokenString, topic);
                if (expirationTimestamp != null) {
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.UNREGISTERED, expirationTimestamp));
                    return;
                }
                if (!this.apnsServer.isTokenRegisteredForTopic(tokenString, topic)) {
                    context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.DEVICE_TOKEN_NOT_FOR_TOPIC));
                    return;
                }
            }
        } else {
            context.channel().writeAndFlush((Object)new RejectNotificationResponse(streamId, apnsId, ErrorReason.BAD_PATH));
            return;
        }
        this.requestsWaitingForDataFrame.put(streamId, apnsId);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
    }

    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) throws Exception {
        if (message instanceof AcceptNotificationResponse) {
            AcceptNotificationResponse acceptNotificationResponse = (AcceptNotificationResponse)message;
            this.encoder().writeHeaders(context, acceptNotificationResponse.getStreamId(), SUCCESS_HEADERS, 0, true, writePromise);
        } else if (message instanceof RejectNotificationResponse) {
            RejectNotificationResponse rejectNotificationResponse = (RejectNotificationResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)rejectNotificationResponse.getErrorReason().getHttpResponseStatus().codeAsText());
            headers.add((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            if (rejectNotificationResponse.getApnsId() != null) {
                headers.add((Object)APNS_ID_HEADER, (Object)rejectNotificationResponse.getApnsId().toString());
            }
            ErrorResponse errorResponse = new ErrorResponse(rejectNotificationResponse.getErrorReason().getReasonText(), rejectNotificationResponse.getTimestamp());
            byte[] payloadBytes = PAYLOAD_GSON.toJson((Object)errorResponse).getBytes();
            ChannelPromise headersPromise = context.newPromise();
            this.encoder().writeHeaders(context, rejectNotificationResponse.getStreamId(), (Http2Headers)headers, 0, false, headersPromise);
            ChannelPromise dataPromise = context.newPromise();
            this.encoder().writeData(context, rejectNotificationResponse.getStreamId(), Unpooled.wrappedBuffer((byte[])payloadBytes), 0, true, dataPromise);
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            promiseCombiner.addAll(new Promise[]{headersPromise, dataPromise});
            promiseCombiner.finish((Promise)writePromise);
        } else if (message instanceof InternalServerErrorResponse) {
            InternalServerErrorResponse internalServerErrorResponse = (InternalServerErrorResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText());
            this.encoder().writeHeaders(context, internalServerErrorResponse.getStreamId(), (Http2Headers)headers, 0, true, writePromise);
        } else {
            context.write(message, writePromise);
        }
    }

    protected AuthenticationTokenClaims getVerifiedClaimsFromAuthenticationToken(String authenticationToken) throws InvalidAuthenticationTokenException, ExpiredAuthenticationTokenException {
        byte[] expectedSignature;
        byte[] headerAndClaimsBytes;
        AuthenticationTokenClaims claims;
        AuthenticationTokenHeader header;
        if (authenticationToken == null) {
            throw new InvalidAuthenticationTokenException();
        }
        ByteBuf tokenBuffer = Unpooled.wrappedBuffer((byte[])authenticationToken.getBytes(StandardCharsets.US_ASCII));
        try {
            ByteBuf decodedHeaderBuffer = this.padAndBase64Decode(tokenBuffer.readSlice(tokenBuffer.bytesBefore((byte)46)));
            header = (AuthenticationTokenHeader)AUTH_GSON.fromJson(decodedHeaderBuffer.toString(StandardCharsets.US_ASCII), AuthenticationTokenHeader.class);
            decodedHeaderBuffer.release();
            tokenBuffer.skipBytes(1);
            ByteBuf decodedClaimsBuffer = this.padAndBase64Decode(tokenBuffer.readSlice(tokenBuffer.bytesBefore((byte)46)));
            claims = (AuthenticationTokenClaims)AUTH_GSON.fromJson(decodedClaimsBuffer.toString(StandardCharsets.US_ASCII), AuthenticationTokenClaims.class);
            decodedClaimsBuffer.release();
            headerAndClaimsBytes = new byte[tokenBuffer.readerIndex()];
            tokenBuffer.getBytes(0, headerAndClaimsBytes, 0, tokenBuffer.readerIndex());
            tokenBuffer.skipBytes(1);
            ByteBuf decodedSignatureBuffer = this.padAndBase64Decode(tokenBuffer);
            expectedSignature = new byte[decodedSignatureBuffer.readableBytes()];
            decodedSignatureBuffer.readBytes(expectedSignature);
            decodedSignatureBuffer.release();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new InvalidAuthenticationTokenException(e);
        }
        finally {
            tokenBuffer.release();
        }
        Date oldestAllowableIssueDate = new Date(System.currentTimeMillis() - AUTH_TOKEN_EXPIRATION_MILLIS);
        if (claims.getIssuedAt().before(oldestAllowableIssueDate)) {
            throw new ExpiredAuthenticationTokenException();
        }
        Signature signature = this.apnsServer.getSignatureForKeyId(header.getKeyId());
        if (signature == null) {
            throw new InvalidAuthenticationTokenException();
        }
        try {
            signature.update(headerAndClaimsBytes);
            if (!signature.verify(expectedSignature)) {
                throw new InvalidAuthenticationTokenException();
            }
        }
        catch (SignatureException e) {
            throw new InvalidAuthenticationTokenException(e);
        }
        String teamId = this.apnsServer.getTeamIdForKeyId(header.getKeyId());
        if (!claims.getIssuer().equals(teamId)) {
            throw new InvalidAuthenticationTokenException();
        }
        return claims;
    }

    private ByteBuf padAndBase64Decode(ByteBuf source) {
        int paddedLength = source.readableBytes() + 2;
        ByteBuf paddedSource = source.alloc().heapBuffer(paddedLength, paddedLength);
        source.getBytes(source.readerIndex(), paddedSource, source.readableBytes());
        switch (source.readableBytes() % 4) {
            case 2: {
                paddedSource.writeByte(61);
                paddedSource.writeByte(61);
                break;
            }
            case 3: {
                paddedSource.writeByte(61);
            }
        }
        ByteBuf decoded = Base64.decode((ByteBuf)paddedSource, (Base64Dialect)Base64Dialect.URL_SAFE);
        paddedSource.release();
        return decoded;
    }

    private static class InternalServerErrorResponse {
        private final int streamId;

        public InternalServerErrorResponse(int streamId) {
            this.streamId = streamId;
        }

        public int getStreamId() {
            return this.streamId;
        }
    }

    private static class RejectNotificationResponse {
        private final int streamId;
        private final UUID apnsId;
        private final ErrorReason errorReason;
        private final Date timestamp;

        public RejectNotificationResponse(int streamId, UUID apnsId, ErrorReason errorReason) {
            this(streamId, apnsId, errorReason, null);
        }

        public RejectNotificationResponse(int streamId, UUID apnsId, ErrorReason errorReason, Date timestamp) {
            this.streamId = streamId;
            this.apnsId = apnsId;
            this.errorReason = errorReason;
            this.timestamp = timestamp;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public UUID getApnsId() {
            return this.apnsId;
        }

        public ErrorReason getErrorReason() {
            return this.errorReason;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }

    private static class AcceptNotificationResponse {
        private final int streamId;

        public AcceptNotificationResponse(int streamId) {
            this.streamId = streamId;
        }

        public int getStreamId() {
            return this.streamId;
        }
    }

    public static final class MockApnsServerHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<MockApnsServerHandler, MockApnsServerHandlerBuilder> {
        private MockApnsServer apnsServer;
        private boolean useTokenAuthentication;
        private String baseTopicFromCertificate;

        public MockApnsServerHandlerBuilder apnsServer(MockApnsServer apnsServer) {
            this.apnsServer = apnsServer;
            return this;
        }

        public MockApnsServer apnsServer() {
            return this.apnsServer;
        }

        public MockApnsServerHandlerBuilder useTokenAuthentication(boolean useTokenAuthentication) {
            this.useTokenAuthentication = useTokenAuthentication;
            return this;
        }

        public boolean useTokenAuthentication() {
            return this.useTokenAuthentication;
        }

        public MockApnsServerHandlerBuilder baseTopicFromCertificate(String baseTopicFromCertificate) {
            this.baseTopicFromCertificate = baseTopicFromCertificate;
            return this;
        }

        public String baseTopicFromCertificate() {
            return this.baseTopicFromCertificate;
        }

        public MockApnsServerHandlerBuilder initialSettings(Http2Settings initialSettings) {
            return (MockApnsServerHandlerBuilder)super.initialSettings(initialSettings);
        }

        public MockApnsServerHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            MockApnsServerHandler handler = new MockApnsServerHandler(decoder, encoder, initialSettings, this.apnsServer(), this.useTokenAuthentication(), this.baseTopicFromCertificate());
            this.frameListener(handler);
            return handler;
        }

        public MockApnsServerHandler build() {
            return (MockApnsServerHandler)super.build();
        }
    }

    private static class InvalidAuthenticationTokenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidAuthenticationTokenException() {
        }

        public InvalidAuthenticationTokenException(Throwable cause) {
            super(cause);
        }
    }

    private static class ExpiredAuthenticationTokenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ExpiredAuthenticationTokenException() {
        }
    }

    private static enum ErrorReason {
        BAD_COLLAPSE_ID("BadCollapseId", HttpResponseStatus.BAD_REQUEST),
        BAD_DEVICE_TOKEN("BadDeviceToken", HttpResponseStatus.BAD_REQUEST),
        BAD_EXPIRATION_DATE("BadExpirationDate", HttpResponseStatus.BAD_REQUEST),
        BAD_MESSAGE_ID("BadMessageId", HttpResponseStatus.BAD_REQUEST),
        BAD_PRIORITY("BadPriority", HttpResponseStatus.BAD_REQUEST),
        BAD_TOPIC("BadTopic", HttpResponseStatus.BAD_REQUEST),
        DEVICE_TOKEN_NOT_FOR_TOPIC("DeviceTokenNotForTopic", HttpResponseStatus.BAD_REQUEST),
        DUPLICATE_HEADERS("DuplicateHeaders", HttpResponseStatus.BAD_REQUEST),
        IDLE_TIMEOUT("IdleTimeout", HttpResponseStatus.BAD_REQUEST),
        MISSING_DEVICE_TOKEN("MissingDeviceToken", HttpResponseStatus.BAD_REQUEST),
        MISSING_TOPIC("MissingTopic", HttpResponseStatus.BAD_REQUEST),
        PAYLOAD_EMPTY("PayloadEmpty", HttpResponseStatus.BAD_REQUEST),
        TOPIC_DISALLOWED("TopicDisallowed", HttpResponseStatus.BAD_REQUEST),
        BAD_CERTIFICATE("BadCertificate", HttpResponseStatus.FORBIDDEN),
        BAD_CERTIFICATE_ENVIRONMENT("BadCertificateEnvironment", HttpResponseStatus.FORBIDDEN),
        EXPIRED_PROVIDER_TOKEN("ExpiredProviderToken", HttpResponseStatus.FORBIDDEN),
        FORBIDDEN("Forbidden", HttpResponseStatus.FORBIDDEN),
        INVALID_PROVIDER_TOKEN("InvalidProviderToken", HttpResponseStatus.FORBIDDEN),
        MISSING_PROVIDER_TOKEN("MissingProviderToken", HttpResponseStatus.FORBIDDEN),
        BAD_PATH("BadPath", HttpResponseStatus.NOT_FOUND),
        METHOD_NOT_ALLOWED("MethodNotAllowed", HttpResponseStatus.METHOD_NOT_ALLOWED),
        UNREGISTERED("Unregistered", HttpResponseStatus.GONE),
        PAYLOAD_TOO_LARGE("PayloadTooLarge", HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE),
        TOO_MANY_PROVIDER_TOKEN_UPDATES("TooManyProviderTokenUpdates", HttpResponseStatus.TOO_MANY_REQUESTS),
        TOO_MANY_REQUESTS("TooManyRequests", HttpResponseStatus.TOO_MANY_REQUESTS),
        INTERNAL_SERVER_ERROR("InternalServerError", HttpResponseStatus.INTERNAL_SERVER_ERROR),
        SERVICE_UNAVAILABLE("ServiceUnavailable", HttpResponseStatus.SERVICE_UNAVAILABLE),
        SHUTDOWN("Shutdown", HttpResponseStatus.SERVICE_UNAVAILABLE);

        private final String reasonText;
        private final HttpResponseStatus httpResponseStatus;

        private ErrorReason(String reasonText, HttpResponseStatus httpResponseStatus) {
            this.reasonText = reasonText;
            this.httpResponseStatus = httpResponseStatus;
        }

        public String getReasonText() {
            return this.reasonText;
        }

        public HttpResponseStatus getHttpResponseStatus() {
            return this.httpResponseStatus;
        }
    }
}

