/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketChannelClassUtil {
    private static final String EPOLL_EVENT_LOOP_GROUP_CLASS = "io.netty.channel.epoll.EpollEventLoopGroup";
    private static final String EPOLL_SOCKET_CHANNEL_CLASS = "io.netty.channel.epoll.EpollSocketChannel";
    private static final String EPOLL_SERVER_SOCKET_CHANNEL_CLASS = "io.netty.channel.epoll.EpollServerSocketChannel";
    private static final Logger log = LoggerFactory.getLogger(SocketChannelClassUtil.class);

    SocketChannelClassUtil() {
    }

    public static Class<? extends Channel> getSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Class<NioSocketChannel> socketChannelClass;
        Objects.requireNonNull(eventLoopGroup);
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            socketChannelClass = NioSocketChannel.class;
        } else if (eventLoopGroup instanceof OioEventLoopGroup) {
            socketChannelClass = OioSocketChannel.class;
        } else if (EPOLL_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            socketChannelClass = SocketChannelClassUtil.loadSocketChannelClass(EPOLL_SOCKET_CHANNEL_CLASS);
        } else {
            throw new IllegalArgumentException("Could not find socket class for event loop group class: " + eventLoopGroup.getClass().getName());
        }
        return socketChannelClass;
    }

    public static Class<? extends ServerChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Class<NioServerSocketChannel> serverSocketChannelClass;
        Objects.requireNonNull(eventLoopGroup);
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            serverSocketChannelClass = NioServerSocketChannel.class;
        } else if (eventLoopGroup instanceof OioEventLoopGroup) {
            serverSocketChannelClass = OioServerSocketChannel.class;
        } else if (EPOLL_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            serverSocketChannelClass = SocketChannelClassUtil.loadSocketChannelClass(EPOLL_SERVER_SOCKET_CHANNEL_CLASS);
        } else {
            throw new IllegalArgumentException("Could not find server socket class for event loop group class: " + eventLoopGroup.getClass().getName());
        }
        return serverSocketChannelClass;
    }

    private static Class<? extends Channel> loadSocketChannelClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            log.debug("Loaded socket channel class: {}", clazz);
            return clazz.asSubclass(Channel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

