/* Copyright (c) 2013-2016 RelayRides
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

package com.relayrides.pushy.apns;

/**
 * An exception thrown to indicate that a notification could not be sent because the client was busy. This is intended
 * to signal backpressure from the channel associated with this client
 *
 * @author <a href="https://github.com/stepheno">Oskar Stephens</a>
 *
 * @since 0.8.2
 */
public class ClientBusyException extends IllegalStateException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new exception with no message.
     */
    public ClientBusyException() {
        super();
    }

    /**
     * Constructs a new exception with the given message.
     *
     * @param message a short, human-readable explanation of the cause of this exception
     */
    public ClientBusyException(final String message) {
        super(message);
    }
}
