/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.relayrides.pushy.apns.AuthenticationTokenClaims;
import com.relayrides.pushy.apns.AuthenticationTokenHeader;
import com.relayrides.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class AuthenticationTokenSupplier {
    private final Signature signature;
    private final String issuer;
    private final String keyId;
    private String token;
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.SECONDS)).create();

    public AuthenticationTokenSupplier(String issuer, String keyId, ECPrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Objects.requireNonNull(issuer);
        Objects.requireNonNull(keyId);
        Objects.requireNonNull(privateKey);
        this.signature = Signature.getInstance("SHA256withECDSA");
        this.signature.initSign(privateKey);
        this.issuer = issuer;
        this.keyId = keyId;
    }

    public String getToken() throws SignatureException {
        return this.getToken(new Date());
    }

    protected String getToken(Date issuedAt) throws SignatureException {
        if (this.token == null) {
            String header = gson.toJson((Object)new AuthenticationTokenHeader(this.keyId));
            String claims = gson.toJson((Object)new AuthenticationTokenClaims(this.issuer, issuedAt));
            StringBuilder payloadBuilder = new StringBuilder();
            payloadBuilder.append(AuthenticationTokenSupplier.base64UrlEncodeWithoutPadding(header.getBytes(StandardCharsets.US_ASCII)));
            payloadBuilder.append('.');
            payloadBuilder.append(AuthenticationTokenSupplier.base64UrlEncodeWithoutPadding(claims.getBytes(StandardCharsets.US_ASCII)));
            this.signature.update(payloadBuilder.toString().getBytes(StandardCharsets.US_ASCII));
            byte[] signatureBytes = this.signature.sign();
            payloadBuilder.append('.');
            payloadBuilder.append(AuthenticationTokenSupplier.base64UrlEncodeWithoutPadding(signatureBytes));
            this.token = payloadBuilder.toString();
        }
        return this.token;
    }

    public void invalidateToken(String invalidToken) {
        if (invalidToken != null && invalidToken.equals(this.token)) {
            this.token = null;
        }
    }

    private static String base64UrlEncodeWithoutPadding(byte[] bytes) {
        ByteBuf wrappedString = Unpooled.wrappedBuffer((byte[])bytes);
        ByteBuf encodedString = Base64.encode((ByteBuf)wrappedString, (Base64Dialect)Base64Dialect.URL_SAFE);
        String encodedUnpaddedString = encodedString.toString(StandardCharsets.US_ASCII).replace("=", "");
        wrappedString.release();
        encodedString.release();
        return encodedUnpaddedString;
    }
}

