/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.MockApnsServerHandler;
import com.relayrides.pushy.apns.SocketChannelClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.SucceededFuture;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class MockApnsServer {
    private final ServerBootstrap bootstrap;
    private final boolean shouldShutDownEventLoopGroup;
    private final Map<String, Map<String, Date>> tokenExpirationsByTopic = new HashMap<String, Map<String, Date>>();
    private final Map<String, Signature> signaturesByKeyId = new HashMap<String, Signature>();
    private final Map<String, String> teamIdsByKeyId = new HashMap<String, String>();
    private final Map<String, Set<String>> topicsByTeamId = new HashMap<String, Set<String>>();
    private ChannelGroup allChannels;
    private boolean emulateInternalErrors = false;

    protected MockApnsServer(final SslContext sslContext, EventLoopGroup eventLoopGroup) {
        this.bootstrap = new ServerBootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(SocketChannelClassUtil.getServerSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                final SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                channel.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

                    protected void configurePipeline(ChannelHandlerContext context, String protocol) throws Exception {
                        MockApnsServerHandler.MockApnsServerHandlerBuilder handlerBuilder;
                        if ("h2".equals(protocol)) {
                            handlerBuilder = new MockApnsServerHandler.MockApnsServerHandlerBuilder().apnsServer(MockApnsServer.this).initialSettings(new Http2Settings().maxConcurrentStreams(8L));
                            try {
                                SSLSession sslSession = sslHandler.engine().getSession();
                                String principalName = sslSession.getPeerPrincipal().getName();
                                Pattern pattern = Pattern.compile(".*UID=([^,]+).*");
                                Matcher matcher = pattern.matcher(principalName);
                                if (matcher.matches()) {
                                    handlerBuilder.baseTopicFromCertificate(matcher.group(1));
                                }
                                handlerBuilder.useTokenAuthentication(false);
                            }
                            catch (SSLPeerUnverifiedException e) {
                                handlerBuilder.useTokenAuthentication(true);
                            }
                        } else {
                            throw new IllegalStateException("Unexpected protocol: " + protocol);
                        }
                        context.pipeline().addLast(new ChannelHandler[]{handlerBuilder.build()});
                        MockApnsServer.this.allChannels.add((Object)context.channel());
                    }
                }});
            }
        });
    }

    public Future<Void> start(int port) {
        ChannelFuture channelFuture = this.bootstrap.bind(port);
        this.allChannels = new DefaultChannelGroup((EventExecutor)channelFuture.channel().eventLoop(), true);
        this.allChannels.add((Object)channelFuture.channel());
        return channelFuture;
    }

    public void registerPublicKey(ECPublicKey publicKey, String teamId, String keyId, Collection<String> topics) throws NoSuchAlgorithmException, InvalidKeyException {
        this.registerPublicKey(publicKey, teamId, keyId, topics.toArray(new String[0]));
    }

    public void registerPublicKey(ECPublicKey publicKey, String teamId, String keyId, String ... topics) throws NoSuchAlgorithmException, InvalidKeyException {
        HashSet<String> keyIdsToRemove = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.teamIdsByKeyId.entrySet()) {
            if (!entry.getValue().equals(teamId)) continue;
            keyIdsToRemove.add(entry.getKey());
        }
        for (String keyIdToRemove : keyIdsToRemove) {
            this.teamIdsByKeyId.remove(keyIdToRemove);
            this.signaturesByKeyId.remove(keyIdToRemove);
        }
        this.topicsByTeamId.remove(teamId);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(publicKey);
        this.signaturesByKeyId.put(keyId, signature);
        this.teamIdsByKeyId.put(keyId, teamId);
        HashSet<String> topicSet = new HashSet<String>();
        for (String topic : topics) {
            topicSet.add(topic);
        }
        this.topicsByTeamId.put(teamId, topicSet);
    }

    protected Signature getSignatureForKeyId(String keyId) {
        return this.signaturesByKeyId.get(keyId);
    }

    protected String getTeamIdForKeyId(String keyId) {
        return this.teamIdsByKeyId.get(keyId);
    }

    protected Set<String> getTopicsForTeamId(String teamId) {
        return this.topicsByTeamId.get(teamId);
    }

    public void clearPublicKeys() {
        this.signaturesByKeyId.clear();
        this.teamIdsByKeyId.clear();
        this.topicsByTeamId.clear();
    }

    public void registerDeviceTokenForTopic(String topic, String token, Date expiration) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(token);
        if (!this.tokenExpirationsByTopic.containsKey(topic)) {
            this.tokenExpirationsByTopic.put(topic, new HashMap());
        }
        this.tokenExpirationsByTopic.get(topic).put(token, expiration);
    }

    public void clearTokens() {
        this.tokenExpirationsByTopic.clear();
    }

    protected boolean isTokenRegisteredForTopic(String token, String topic) {
        Map<String, Date> tokensWithinTopic = this.tokenExpirationsByTopic.get(topic);
        return tokensWithinTopic != null && tokensWithinTopic.containsKey(token);
    }

    protected Date getExpirationTimestampForTokenInTopic(String token, String topic) {
        Map<String, Date> tokensWithinTopic = this.tokenExpirationsByTopic.get(topic);
        return tokensWithinTopic != null ? tokensWithinTopic.get(token) : null;
    }

    protected void setEmulateInternalErrors(boolean emulateInternalErrors) {
        this.emulateInternalErrors = emulateInternalErrors;
    }

    protected boolean shouldEmulateInternalErrors() {
        return this.emulateInternalErrors;
    }

    public Future<Void> shutdown() {
        SucceededFuture disconnectFuture;
        SucceededFuture channelCloseFuture;
        Object object = channelCloseFuture = this.allChannels != null ? this.allChannels.close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        if (this.shouldShutDownEventLoopGroup) {
            channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    MockApnsServer.this.bootstrap.config().group().shutdownGracefully();
                }
            });
            disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                final /* synthetic */ Future val$disconnectFuture;
                {
                    this.val$disconnectFuture = future;
                }

                public void operationComplete(Future future) throws Exception {
                    assert (this.val$disconnectFuture instanceof DefaultPromise);
                    ((DefaultPromise)this.val$disconnectFuture).trySuccess(null);
                }
            });
        } else {
            disconnectFuture = channelCloseFuture;
        }
        return disconnectFuture;
    }
}

