/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.ReportInstance;
import com.relevantcodes.extentreports.SystemInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentReports {
    private ReportInstance reportInstance = new ReportInstance();
    private SystemInfo systemInfo;
    private ReportInstance.ReportConfig reportConfig;

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        this.reportInstance.initialize(filePath, replaceExisting, displayOrder);
        this.systemInfo = new SystemInfo();
    }

    public ExtentReports(String filePath, Boolean replaceExisting) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST);
    }

    public ExtentTest startTest(String testName) {
        return new ExtentTest(testName, "");
    }

    public ExtentTest startTest(String testName, String description) {
        return new ExtentTest(testName, description);
    }

    public void endTest(ExtentTest test) {
        this.reportInstance.addTest(test.getTest());
    }

    public ReportInstance.ReportConfig config() {
        if (this.reportConfig == null) {
            this.reportConfig = new ReportInstance.ReportConfig(this.reportInstance);
        }
        return this.reportConfig;
    }

    public ExtentReports addSystemInfo(Map<String, String> info) {
        this.systemInfo.setInfo(info);
        return this;
    }

    public ExtentReports addSystemInfo(String param, String value) {
        this.systemInfo.setInfo(param, value);
        return this;
    }

    public void flush() {
        this.reportInstance.terminate(this.systemInfo);
    }
}

