/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.source.ImageHtml;
import com.relevantcodes.extentreports.source.ScreencastHtml;
import com.relevantcodes.extentreports.support.DateTimeHelper;
import java.util.Calendar;

public class ExtentTest {
    private Test test;
    private LogStatus runStatus = LogStatus.UNKNOWN;

    public ExtentTest(String testName, String description) {
        this.test = new Test();
        this.test.name = testName;
        this.test.description = description;
        this.test.startedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
    }

    public void log(LogStatus logStatus, String stepName, String details) {
        Log evt = new Log();
        evt.timestamp = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logTimeFormat);
        evt.logStatus = logStatus;
        evt.stepName = stepName;
        evt.details = details;
        this.test.log.add(evt);
        this.trackLastRunStatus(logStatus);
    }

    public void log(LogStatus logStatus, String details) {
        this.log(logStatus, "", details);
    }

    public String addScreenCapture(String imgPath) {
        String screenCaptureHtml = this.isPathRelative(imgPath) != false ? ImageHtml.getSource(imgPath).replace("file:///", "") : ImageHtml.getSource(imgPath);
        ScreenCapture img = new ScreenCapture();
        img.src = screenCaptureHtml;
        img.testName = this.test.name;
        this.test.screenCapture.add(img);
        return screenCaptureHtml;
    }

    public String addScreencast(String screencastPath) {
        String screencastHtml = this.isPathRelative(screencastPath) != false ? ScreencastHtml.getSource(screencastPath).replace("file:///", "") : ScreencastHtml.getSource(screencastPath);
        Screencast sc = new Screencast();
        sc.src = screencastHtml;
        sc.testName = this.test.name;
        this.test.screencast.add(sc);
        return screencastHtml;
    }

    private Boolean isPathRelative(String path) {
        if (path.indexOf("http") == 0 || path.indexOf(".") == 0 || path.indexOf("/") == 0) {
            return true;
        }
        return false;
    }

    private void trackLastRunStatus(LogStatus logStatus) {
        if (this.runStatus == LogStatus.UNKNOWN) {
            this.runStatus = logStatus == LogStatus.INFO ? LogStatus.PASS : logStatus;
            return;
        }
        if (this.runStatus == LogStatus.FATAL) {
            return;
        }
        if (logStatus == LogStatus.FATAL) {
            this.runStatus = logStatus;
            return;
        }
        if (this.runStatus == LogStatus.FAIL) {
            return;
        }
        if (logStatus == LogStatus.FAIL) {
            this.runStatus = logStatus;
            return;
        }
        if (this.runStatus == LogStatus.ERROR) {
            return;
        }
        if (logStatus == LogStatus.ERROR) {
            this.runStatus = logStatus;
            return;
        }
        if (this.runStatus == LogStatus.WARNING) {
            return;
        }
        if (logStatus == LogStatus.WARNING) {
            this.runStatus = logStatus;
            return;
        }
        if (this.runStatus == LogStatus.PASS || this.runStatus == LogStatus.INFO) {
            this.runStatus = LogStatus.PASS;
            return;
        }
        this.runStatus = LogStatus.SKIP;
    }

    public Test getTest() {
        this.test.status = this.runStatus;
        return this.test;
    }
}

