/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.MediaViewBuilder;
import com.relevantcodes.extentreports.SourceBuilder;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.TestBuilder;
import com.relevantcodes.extentreports.model.MediaList;
import com.relevantcodes.extentreports.model.RunInfo;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.source.ExtentFlag;
import com.relevantcodes.extentreports.support.DateTimeHelper;
import com.relevantcodes.extentreports.support.FileReaderEx;
import com.relevantcodes.extentreports.support.RegexMatcher;
import com.relevantcodes.extentreports.support.Resources;
import com.relevantcodes.extentreports.support.Writer;
import java.io.File;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportInstance
extends LogSettings {
    private DisplayOrder displayOrder;
    private String filePath;
    private volatile int infoWrite = 0;
    private final Object lock = new Object();
    private MediaList mediaList;
    private String quickSummarySrc = "";
    private RunInfo runInfo;
    private volatile String src = null;
    private volatile String testSrc = "";

    public void addTest(Test test) {
        test.endedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
        for (ScreenCapture screenCapture : test.screenCapture) {
            this.mediaList.screenCapture.add(screenCapture);
        }
        for (Screencast screencast : test.screencast) {
            this.mediaList.screencast.add(screencast);
        }
        String src = TestBuilder.getSource(test);
        this.addTest(src);
        src = TestBuilder.getQuickTestSummary(test);
        this.addQuickTestSummary(src);
    }

    private synchronized void addTest(String source) {
        this.testSrc = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.testSrc + source : source + this.testSrc;
    }

    private synchronized void addQuickTestSummary(String source) {
        this.quickSummarySrc = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.quickSummarySrc + source : source + this.quickSummarySrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String filePath, Boolean replace, DisplayOrder displayOrder) {
        this.displayOrder = displayOrder;
        this.filePath = filePath;
        Object object = this.lock;
        synchronized (object) {
            String sourceFile = "com/relevantcodes/extentreports/source/STANDARD.html";
            if (!new File(filePath).isFile()) {
                replace = true;
            }
            if (this.src != null) {
                return;
            }
            this.src = replace != false ? Resources.getText(sourceFile) : FileReaderEx.readAllText(filePath);
            this.runInfo = new RunInfo();
            this.runInfo.startedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
            this.mediaList = new MediaList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(SystemInfo systemInfo) {
        if (this.testSrc == "") {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.runInfo.endedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
            this.updateSystemInfo(systemInfo.getInfo());
            this.updateSuiteExecutionTime();
            this.updateMediaInfo();
            systemInfo.clear();
            this.src = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.src.replace(ExtentFlag.getPlaceHolder("test"), this.testSrc + ExtentFlag.getPlaceHolder("test")) : this.src.replace(ExtentFlag.getPlaceHolder("test"), ExtentFlag.getPlaceHolder("test") + this.testSrc);
            this.src = this.src.replace(ExtentFlag.getPlaceHolder("quickTestSummary"), this.quickSummarySrc + ExtentFlag.getPlaceHolder("quickTestSummary"));
            Writer.getInstance().write(new File(this.filePath), this.src);
            this.testSrc = "";
            this.quickSummarySrc = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSuiteExecutionTime() {
        String[] flags = new String[]{ExtentFlag.getPlaceHolder("suiteStartTime"), ExtentFlag.getPlaceHolder("suiteEndTime")};
        String[] values = new String[]{this.runInfo.startedAt, this.runInfo.endedAt};
        Object object = this.lock;
        synchronized (object) {
            this.src = SourceBuilder.build(this.src, flags, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemInfo(Map<String, String> info) {
        if (this.src.indexOf(ExtentFlag.getPlaceHolder("systemInfoApplied")) > 0) {
            return;
        }
        if (info.size() > 0) {
            String systemSrc = SourceBuilder.getSource(info) + ExtentFlag.getPlaceHolder("systemInfoApplied");
            String[] flags = new String[]{ExtentFlag.getPlaceHolder("systemInfoView")};
            String[] values = new String[]{systemSrc + ExtentFlag.getPlaceHolder("systemInfoView")};
            Object object = this.lock;
            synchronized (object) {
                this.src = SourceBuilder.build(this.src, flags, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMediaInfo() {
        String imageSrc = MediaViewBuilder.getSource(this.mediaList.screenCapture);
        String[] flags = new String[]{ExtentFlag.getPlaceHolder("imagesView")};
        String[] values = new String[]{imageSrc + ExtentFlag.getPlaceHolder("imagesView")};
        if (this.infoWrite < 1 || values[0].indexOf("No media") < 0) {
            Object object = this.lock;
            synchronized (object) {
                this.src = SourceBuilder.build(this.src, flags, values);
                this.mediaList.screenCapture.clear();
            }
        }
        String scSrc = MediaViewBuilder.getSource(this.mediaList.screencast);
        flags = new String[]{ExtentFlag.getPlaceHolder("videosView")};
        values = new String[]{scSrc + ExtentFlag.getPlaceHolder("videosView")};
        if (this.infoWrite < 1 || values[0].indexOf("No media") < 0) {
            Object object = this.lock;
            synchronized (object) {
                this.src = SourceBuilder.build(this.src, flags, values);
                this.mediaList.screencast.clear();
            }
        }
        ++this.infoWrite;
    }

    public class ReportConfig {
        public ReportConfig insertJs(String js) {
            js = "<script type='text/javascript'>" + js + "</script>";
            ReportInstance.this.src = ReportInstance.this.src.replace(ExtentFlag.getPlaceHolder("customscript"), js + ExtentFlag.getPlaceHolder("customscript"));
            return this;
        }

        public ReportConfig insertCustomStyles(String styles) {
            styles = "<style type='text/css'>" + styles + "</style>";
            ReportInstance.this.src = ReportInstance.this.src.replace(ExtentFlag.getPlaceHolder("customcss"), styles + ExtentFlag.getPlaceHolder("customcss"));
            return this;
        }

        public void addCustomStylesheet(String cssFilePath) {
            String link = "<link href='file:///" + cssFilePath + "' rel='stylesheet' type='text/css' />";
            if (cssFilePath.substring(0, 1).equals(new String(".")) || cssFilePath.substring(0, 1).equals(new String("/"))) {
                link = "<link href='" + cssFilePath + "' rel='stylesheet' type='text/css' />";
            }
            ReportInstance.this.src = ReportInstance.this.src.replace(ExtentFlag.getPlaceHolder("customcss"), link + ExtentFlag.getPlaceHolder("customcss"));
        }

        public ReportConfig reportHeadline(String headline) {
            Integer maxLength = 70;
            if (headline.length() > maxLength) {
                headline = headline.substring(0, maxLength - 1);
            }
            String html = ReportInstance.this.src;
            String pattern = ExtentFlag.getPlaceHolder("headline") + ".*" + ExtentFlag.getPlaceHolder("headline");
            headline = pattern.replace(".*", headline);
            String oldHeadline = RegexMatcher.getNthMatch(html, pattern, 0);
            ReportInstance.this.src = html.replace(oldHeadline, headline);
            return this;
        }

        public ReportConfig reportName(String name) {
            Integer maxLength = 20;
            if (name.length() > maxLength) {
                name = name.substring(0, maxLength - 1);
            }
            String html = ReportInstance.this.src;
            String pattern = ExtentFlag.getPlaceHolder("logo") + ".*" + ExtentFlag.getPlaceHolder("logo");
            name = pattern.replace(".*", name);
            String oldName = RegexMatcher.getNthMatch(html, pattern, 0);
            ReportInstance.this.src = html.replace(oldName, name);
            return this;
        }

        public ReportConfig documentTitle(String title) {
            String docTitle = "<title>.*</title>";
            String html = ReportInstance.this.src;
            ReportInstance.this.src = html.replace(RegexMatcher.getNthMatch(html, docTitle, 0), docTitle.replace(".*", title));
            return this;
        }
    }
}

