/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.source.ExtentFlag;
import com.relevantcodes.extentreports.source.Icon;
import com.relevantcodes.extentreports.source.StepHtml;
import com.relevantcodes.extentreports.source.TestHtml;
import com.relevantcodes.extentreports.support.DateTimeHelper;

class TestBuilder {
    TestBuilder() {
    }

    public static String getSource(Test test) {
        String testSource = TestHtml.getSource(3);
        if (test.log.size() > 0 && test.log.get((int)0).stepName != "") {
            testSource = TestHtml.getSource(4);
        }
        if (test.description == null || test.description == "") {
            testSource = testSource.replace(ExtentFlag.getPlaceHolder("descVis"), "style='display:none;'");
        }
        long diff = test.endedTime.getTime() - test.startedTime.getTime();
        long hours = diff / 3600000L % 24L;
        long mins = diff / 60000L % 60L;
        long secs = diff / 1000L % 60L;
        testSource = testSource.replace(ExtentFlag.getPlaceHolder("testName"), test.name).replace(ExtentFlag.getPlaceHolder("testStatus"), test.status.toString().toLowerCase()).replace(ExtentFlag.getPlaceHolder("testStartTime"), DateTimeHelper.getFormattedDateTime(test.startedTime, LogSettings.logDateTimeFormat)).replace(ExtentFlag.getPlaceHolder("testEndTime"), DateTimeHelper.getFormattedDateTime(test.endedTime, LogSettings.logDateTimeFormat)).replace(ExtentFlag.getPlaceHolder("testTimeTaken"), hours + "h " + mins + "m " + secs + "s").replace(ExtentFlag.getPlaceHolder("testStatus"), test.status.toString().toLowerCase()).replace(ExtentFlag.getPlaceHolder("testDescription"), test.description).replace(ExtentFlag.getPlaceHolder("descVis"), "").replace(ExtentFlag.getPlaceHolder("category"), "").replace(ExtentFlag.getPlaceHolder("testWarnings"), TestHtml.getWarningSource(test.internalWarning));
        for (TestAttribute t : test.categoryList) {
            testSource = testSource.replace(ExtentFlag.getPlaceHolder("testCategory"), TestHtml.getCategorySource() + ExtentFlag.getPlaceHolder("testCategory")).replace(ExtentFlag.getPlaceHolder("category"), t.getName());
        }
        String stepSrc = StepHtml.getSrc(2);
        if (test.log.size() > 0) {
            if (test.log.get((int)0).stepName != "") {
                stepSrc = StepHtml.getSrc(0);
            }
            for (int ix = 0; ix < test.log.size(); ++ix) {
                testSource = testSource.replace(ExtentFlag.getPlaceHolder("step"), stepSrc + ExtentFlag.getPlaceHolder("step")).replace(ExtentFlag.getPlaceHolder("timeStamp"), DateTimeHelper.getFormattedDateTime(test.log.get((int)ix).timestamp, LogSettings.logTimeFormat)).replace(ExtentFlag.getPlaceHolder("stepStatusU"), test.log.get((int)ix).logStatus.toString().toUpperCase()).replace(ExtentFlag.getPlaceHolder("stepStatus"), test.log.get((int)ix).logStatus.toString().toLowerCase()).replace(ExtentFlag.getPlaceHolder("statusIcon"), Icon.getIcon(test.log.get((int)ix).logStatus)).replace(ExtentFlag.getPlaceHolder("stepName"), test.log.get((int)ix).stepName).replace(ExtentFlag.getPlaceHolder("details"), test.log.get((int)ix).details);
            }
        }
        testSource = testSource.replace(ExtentFlag.getPlaceHolder("step"), "");
        return testSource;
    }

    public static String getQuickTestSummary(Test test) {
        Integer unknown;
        String src = TestHtml.getSourceQuickView();
        Integer skipped = unknown = Integer.valueOf(0);
        Integer info = unknown;
        Integer warning = unknown;
        Integer error = unknown;
        Integer fatal = unknown;
        Integer failed = unknown;
        Integer passed = unknown;
        for (int ix = 0; ix < test.log.size(); ++ix) {
            Integer n;
            Integer n2;
            if (test.log.get((int)ix).logStatus == LogStatus.PASS) {
                n2 = passed;
                n = passed = Integer.valueOf(passed + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.FAIL) {
                n2 = failed;
                n = failed = Integer.valueOf(failed + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.FATAL) {
                n2 = fatal;
                n = fatal = Integer.valueOf(fatal + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.ERROR) {
                n2 = error;
                n = error = Integer.valueOf(error + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.WARNING) {
                n2 = warning;
                n = warning = Integer.valueOf(warning + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.INFO) {
                n2 = info;
                n = info = Integer.valueOf(info + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus == LogStatus.SKIP) {
                n2 = skipped;
                n = skipped = Integer.valueOf(skipped + 1);
                continue;
            }
            if (test.log.get((int)ix).logStatus != LogStatus.UNKNOWN) continue;
            n2 = unknown;
            n = unknown = Integer.valueOf(unknown + 1);
        }
        src = src.replace(ExtentFlag.getPlaceHolder("testName"), test.name).replace(ExtentFlag.getPlaceHolder("testWarnings"), TestHtml.getWarningSource(test.internalWarning)).replace(ExtentFlag.getPlaceHolder("currentTestPassedCount"), "" + passed).replace(ExtentFlag.getPlaceHolder("currentTestFailedCount"), "" + failed).replace(ExtentFlag.getPlaceHolder("currentTestFatalCount"), "" + fatal).replace(ExtentFlag.getPlaceHolder("currentTestErrorCount"), "" + error).replace(ExtentFlag.getPlaceHolder("currentTestWarningCount"), "" + warning).replace(ExtentFlag.getPlaceHolder("currentTestInfoCount"), "" + info).replace(ExtentFlag.getPlaceHolder("currentTestSkippedCount"), "" + skipped).replace(ExtentFlag.getPlaceHolder("currentTestUnknownCount"), "" + unknown).replace(ExtentFlag.getPlaceHolder("currentTestRunStatus"), "" + test.status.toString().toLowerCase()).replace(ExtentFlag.getPlaceHolder("currentTestRunStatusU"), "" + test.status.toString());
        return src;
    }
}

