/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.CategorySourceBuilder;
import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.MediaViewBuilder;
import com.relevantcodes.extentreports.SourceBuilder;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.TestBuilder;
import com.relevantcodes.extentreports.model.CategoryList;
import com.relevantcodes.extentreports.model.MediaList;
import com.relevantcodes.extentreports.model.RunInfo;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.source.CategoryHtml;
import com.relevantcodes.extentreports.source.ExtentFlag;
import com.relevantcodes.extentreports.support.DateTimeHelper;
import com.relevantcodes.extentreports.support.FileReaderEx;
import com.relevantcodes.extentreports.support.RegexMatcher;
import com.relevantcodes.extentreports.support.Resources;
import com.relevantcodes.extentreports.support.Writer;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportInstance {
    private Boolean terminated = false;
    private CategoryList categoryList;
    private DisplayOrder displayOrder;
    private String filePath;
    private volatile int infoWrite = 0;
    private final Object lock = new Object();
    private MediaList mediaList;
    private String quickSummarySource = "";
    private RunInfo runInfo;
    private volatile String extentSource = null;
    private volatile String testSource = "";

    public void addTest(Test test) {
        if (test.endedTime == null) {
            test.endedTime = Calendar.getInstance().getTime();
        }
        for (ScreenCapture screenCapture : test.screenCapture) {
            this.mediaList.screenCapture.add(screenCapture);
        }
        for (Screencast screencast : test.screencast) {
            this.mediaList.screencast.add(screencast);
        }
        test.prepareFinalize();
        this.addTest(TestBuilder.getSource(test));
        this.addQuickTestSummary(TestBuilder.getQuickTestSummary(test));
        this.addCategories(test);
        this.updateCategoryView(test);
    }

    private synchronized void addTest(String source) {
        this.testSource = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.testSource + source : source + this.testSource;
    }

    private synchronized void addQuickTestSummary(String source) {
        this.quickSummarySource = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.quickSummarySource + source : source + this.quickSummarySource;
    }

    private void addCategories(Test test) {
        for (TestAttribute attr : test.categoryList) {
            if (this.categoryList.categories.contains(attr.getName())) continue;
            this.categoryList.categories.add(attr.getName());
        }
    }

    private synchronized void updateCategoryView(Test test) {
        if (test.isChildNode) {
            return;
        }
        String s = "";
        String testSource = "";
        String addedFlag = "";
        String[] sourceKeys = new String[]{ExtentFlag.getPlaceHolder("categoryViewName"), ExtentFlag.getPlaceHolder("categoryViewTestDetails")};
        String[] testKeys = new String[]{ExtentFlag.getPlaceHolder("categoryViewTestRunTime"), ExtentFlag.getPlaceHolder("categoryViewTestName"), ExtentFlag.getPlaceHolder("categoryViewTestStatus")};
        String[] testValues = new String[]{DateTimeHelper.getFormattedDateTime(test.startedTime, LogSettings.logDateTimeFormat), test.name, test.status.toString().toLowerCase()};
        for (TestAttribute attr : test.categoryList) {
            addedFlag = ExtentFlag.getPlaceHolder("categoryViewTestDetails" + attr.getName());
            if (this.extentSource.indexOf(addedFlag) == -1) {
                String[] sourceValues = new String[]{attr.getName(), addedFlag};
                s = s + SourceBuilder.build(CategoryHtml.getCategoryViewSource(), sourceKeys, sourceValues);
                testSource = SourceBuilder.build(CategoryHtml.getCategoryViewTestSource(), testKeys, testValues);
                s = SourceBuilder.build(s, new String[]{addedFlag}, new String[]{testSource + addedFlag});
                continue;
            }
            testSource = SourceBuilder.build(CategoryHtml.getCategoryViewTestSource(), testKeys, testValues);
            this.extentSource = SourceBuilder.build(this.extentSource, new String[]{addedFlag}, new String[]{testSource + addedFlag});
        }
        this.extentSource = this.extentSource.replace(ExtentFlag.getPlaceHolder("extentCategoryDetails"), s + ExtentFlag.getPlaceHolder("extentCategoryDetails"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String filePath, Boolean replace, DisplayOrder displayOrder) {
        this.displayOrder = displayOrder;
        this.filePath = filePath;
        if (this.extentSource != null) {
            return;
        }
        String sourceFile = "com/relevantcodes/extentreports/source/STANDARD.min.html";
        if (!new File(filePath).isFile()) {
            replace = true;
        }
        if (replace.booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                this.extentSource = Resources.getText(sourceFile);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.extentSource = FileReaderEx.readAllText(filePath);
        }
        this.runInfo = new RunInfo();
        this.runInfo.startedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
        this.categoryList = new CategoryList();
        this.mediaList = new MediaList();
    }

    public void terminate(List<ExtentTest> testList) {
        for (ExtentTest t : testList) {
            if (t.getTest().hasEnded) continue;
            t.getTest().internalWarning = t.getTest().internalWarning + "Test did not end safely because endTest() was not called. There may be errors which are not reported correctly.";
            this.addTest(t.getTest());
        }
        this.writeAllResources(null, null);
        this.extentSource = "";
        this.categoryList = null;
        this.runInfo = null;
        this.terminated = true;
    }

    public synchronized void writeAllResources(List<ExtentTest> testList, SystemInfo systemInfo) {
        if (this.terminated.booleanValue()) {
            try {
                throw new IOException("Stream closed");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (systemInfo != null && systemInfo.getInfo() != null) {
            this.updateSystemInfo(systemInfo.getInfo());
        }
        if (this.testSource == "") {
            return;
        }
        this.runInfo.endedAt = DateTimeHelper.getFormattedDateTime(Calendar.getInstance().getTime(), LogSettings.logDateTimeFormat);
        this.updateCategoryList();
        this.updateSuiteExecutionTime();
        this.updateMediaInfo();
        this.extentSource = this.displayOrder == DisplayOrder.OLDEST_FIRST ? this.extentSource.replace(ExtentFlag.getPlaceHolder("test"), this.testSource + ExtentFlag.getPlaceHolder("test")).replace(ExtentFlag.getPlaceHolder("quickTestSummary"), this.quickSummarySource + ExtentFlag.getPlaceHolder("quickTestSummary")) : this.extentSource.replace(ExtentFlag.getPlaceHolder("test"), ExtentFlag.getPlaceHolder("test") + this.testSource).replace(ExtentFlag.getPlaceHolder("quickTestSummary"), ExtentFlag.getPlaceHolder("quickTestSummary") + this.quickSummarySource);
        Writer.getInstance().write(new File(this.filePath), this.extentSource);
        this.testSource = "";
        this.quickSummarySource = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCategoryList() {
        String catsAdded = "";
        String c = "";
        Iterator<String> iter = this.categoryList.categories.iterator();
        while (iter.hasNext()) {
            c = iter.next();
            if (this.extentSource.indexOf(ExtentFlag.getPlaceHolder("categoryAdded" + c)) > 0) {
                iter.remove();
                continue;
            }
            catsAdded = catsAdded + ExtentFlag.getPlaceHolder("categoryAdded" + c);
        }
        String source = CategorySourceBuilder.buildOptions(this.categoryList.categories);
        if (source != "") {
            Object object = this.lock;
            synchronized (object) {
                this.extentSource = this.extentSource.replace(ExtentFlag.getPlaceHolder("categoryListOptions"), source + ExtentFlag.getPlaceHolder("categoryListOptions")).replace(ExtentFlag.getPlaceHolder("categoryAdded"), catsAdded + ExtentFlag.getPlaceHolder("categoryAdded"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSuiteExecutionTime() {
        String[] keys = new String[]{ExtentFlag.getPlaceHolder("suiteStartTime"), ExtentFlag.getPlaceHolder("suiteEndTime")};
        String[] values = new String[]{this.runInfo.startedAt, this.runInfo.endedAt};
        Object object = this.lock;
        synchronized (object) {
            this.extentSource = SourceBuilder.buildRegex(this.extentSource, keys, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemInfo(Map<String, String> info) {
        if (info == null) {
            return;
        }
        if (this.extentSource.indexOf(ExtentFlag.getPlaceHolder("systemInfoApplied")) > 0) {
            return;
        }
        if (info.size() > 0) {
            String systemSrc = SourceBuilder.getSource(info) + ExtentFlag.getPlaceHolder("systemInfoApplied");
            String[] keys = new String[]{ExtentFlag.getPlaceHolder("systemInfoView")};
            String[] values = new String[]{systemSrc + ExtentFlag.getPlaceHolder("systemInfoView")};
            Object object = this.lock;
            synchronized (object) {
                this.extentSource = SourceBuilder.buildRegex(this.extentSource, keys, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMediaInfo() {
        String imageSrc = MediaViewBuilder.getSource(this.mediaList.screenCapture, "img");
        String[] keys = new String[]{ExtentFlag.getPlaceHolder("imagesView")};
        String[] values = new String[]{imageSrc + ExtentFlag.getPlaceHolder("imagesView")};
        if (this.infoWrite < 1 || values[0].indexOf("No media") < 0) {
            Object object = this.lock;
            synchronized (object) {
                this.extentSource = SourceBuilder.buildRegex(this.extentSource, keys, values);
                if (this.mediaList.screenCapture.size() > 0) {
                    try {
                        String match = RegexMatcher.getNthMatch(this.extentSource, ExtentFlag.getPlaceHolder("objectViewNullImg") + ".*" + ExtentFlag.getPlaceHolder("objectViewNullImg"), 0);
                        this.extentSource = this.extentSource.replace(match, "");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.mediaList.screenCapture.clear();
        }
        String scSrc = MediaViewBuilder.getSource(this.mediaList.screencast, "vid");
        keys = new String[]{ExtentFlag.getPlaceHolder("videosView")};
        values = new String[]{scSrc + ExtentFlag.getPlaceHolder("videosView")};
        if (this.infoWrite < 1 || values[0].indexOf("No media") < 0) {
            Object object = this.lock;
            synchronized (object) {
                this.extentSource = SourceBuilder.buildRegex(this.extentSource, keys, values);
                if (this.mediaList.screencast.size() > 0) {
                    try {
                        String match = RegexMatcher.getNthMatch(this.extentSource, ExtentFlag.getPlaceHolder("objectViewNullVid") + ".*" + ExtentFlag.getPlaceHolder("objectViewNullVid"), 0);
                        this.extentSource = this.extentSource.replace(match, "");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.mediaList.screencast.clear();
        }
        ++this.infoWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSource(String source) {
        Object object = this.lock;
        synchronized (object) {
            this.extentSource = source;
        }
    }

    public class ReportConfig {
        private String extentSource;

        private void updateSource() {
            this.extentSource = ReportInstance.this.extentSource;
        }

        public ReportConfig insertJs(String js) {
            js = "<script type='text/javascript'>" + js + "</script>";
            this.updateSource();
            ReportInstance.this.updateSource(this.extentSource.replace(ExtentFlag.getPlaceHolder("customscript"), js + ExtentFlag.getPlaceHolder("customscript")));
            return this;
        }

        public ReportConfig insertCustomStyles(String styles) {
            styles = "<style type='text/css'>" + styles + "</style>";
            this.updateSource();
            ReportInstance.this.updateSource(this.extentSource.replace(ExtentFlag.getPlaceHolder("customcss"), styles + ExtentFlag.getPlaceHolder("customcss")));
            return this;
        }

        public ReportConfig addCustomStylesheet(String cssFilePath) {
            String link = "<link href='file:///" + cssFilePath + "' rel='stylesheet' type='text/css' />";
            if (cssFilePath.substring(0, 1).equals(new String(".")) || cssFilePath.substring(0, 1).equals(new String("/"))) {
                link = "<link href='" + cssFilePath + "' rel='stylesheet' type='text/css' />";
            }
            this.updateSource();
            ReportInstance.this.updateSource(this.extentSource.replace(ExtentFlag.getPlaceHolder("customcss"), link + ExtentFlag.getPlaceHolder("customcss")));
            return this;
        }

        public ReportConfig reportHeadline(String headline) {
            Integer maxLength = 70;
            if (headline.length() > maxLength) {
                headline = headline.substring(0, maxLength - 1);
            }
            this.updateSource();
            String html = this.extentSource;
            String pattern = ExtentFlag.getPlaceHolder("headline") + ".*" + ExtentFlag.getPlaceHolder("headline");
            headline = pattern.replace(".*", headline);
            String oldHeadline = RegexMatcher.getNthMatch(html, pattern, 0);
            ReportInstance.this.updateSource(html.replace(oldHeadline, headline));
            return this;
        }

        public ReportConfig reportName(String name) {
            Integer maxLength = 20;
            if (name.length() > maxLength) {
                name = name.substring(0, maxLength - 1);
            }
            this.updateSource();
            String html = this.extentSource;
            String pattern = ExtentFlag.getPlaceHolder("logo") + ".*" + ExtentFlag.getPlaceHolder("logo");
            name = pattern.replace(".*", name);
            String oldName = RegexMatcher.getNthMatch(html, pattern, 0);
            ReportInstance.this.updateSource(html.replace(oldName, name));
            return this;
        }

        public ReportConfig documentTitle(String title) {
            this.updateSource();
            String docTitle = "<title>.*</title>";
            String html = this.extentSource;
            ReportInstance.this.updateSource(html.replace(RegexMatcher.getNthMatch(html, docTitle, 0), docTitle.replace(".*", title)));
            return this;
        }
    }
}

